/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.services;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.service.ServiceRegistry;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.util.function.TriFunction;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TinkerServiceRegistry
extends ServiceRegistry {
    private final AbstractTinkerGraph graph;

    public TinkerServiceRegistry(AbstractTinkerGraph graph) {
        this.graph = graph;
    }

    public TinkerServiceFactory registerService(TinkerServiceFactory service) {
        super.registerService((Service.ServiceFactory)service);
        return service;
    }

    public <I, R> LambdaServiceFactory<I, R> registerLambdaService(String name) {
        return (LambdaServiceFactory)this.registerService(new LambdaServiceFactory(this.graph, name));
    }

    public static class LambdaBarrierService<I, R>
    extends TinkerService<I, R> {
        private final TriFunction<Service.ServiceCallContext, TraverserSet<I>, Map, Iterator<R>> lambda;
        private final int maxChunkSize;

        public LambdaBarrierService(LambdaServiceFactory<I, R> factory, TriFunction<Service.ServiceCallContext, TraverserSet<I>, Map, Iterator<R>> lambda) {
            this(factory, lambda, Integer.MAX_VALUE);
        }

        public LambdaBarrierService(LambdaServiceFactory<I, R> factory, TriFunction<Service.ServiceCallContext, TraverserSet<I>, Map, Iterator<R>> lambda, int maxChunkSize) {
            super(factory);
            this.lambda = lambda;
            this.maxChunkSize = maxChunkSize;
        }

        public LambdaBarrierService clone(int maxChunkSize) {
            return new LambdaBarrierService<I, R>((LambdaServiceFactory)this.serviceFactory, this.lambda, maxChunkSize);
        }

        public Service.Type getType() {
            return Service.Type.Barrier;
        }

        public int getMaxBarrierSize() {
            return this.maxChunkSize;
        }

        public CloseableIterator<R> execute(Service.ServiceCallContext ctx, TraverserSet<I> in, Map params) {
            Object result = this.lambda.apply((Object)ctx, in, (Object)params);
            return CloseableIterator.of((Iterator)(result instanceof Iterator ? (Iterator)result : IteratorUtils.of((Object)result)));
        }
    }

    public static class LambdaStreamingService<I, R>
    extends TinkerService<I, R> {
        private final TriFunction<Service.ServiceCallContext, Traverser.Admin<I>, Map, Iterator<R>> lambda;

        public LambdaStreamingService(LambdaServiceFactory<I, R> factory, TriFunction<Service.ServiceCallContext, Traverser.Admin<I>, Map, Iterator<R>> lambda) {
            super(factory);
            this.lambda = lambda;
        }

        public Service.Type getType() {
            return Service.Type.Streaming;
        }

        public CloseableIterator<R> execute(Service.ServiceCallContext ctx, Traverser.Admin<I> in, Map params) {
            Object result = this.lambda.apply((Object)ctx, in, (Object)params);
            return CloseableIterator.of((Iterator)(result instanceof Iterator ? (Iterator)result : IteratorUtils.of((Object)result)));
        }
    }

    public static class LambdaStartService<I, R>
    extends TinkerService<I, R> {
        private final BiFunction<Service.ServiceCallContext, Map, Iterator<R>> lambda;

        public LambdaStartService(LambdaServiceFactory<I, R> factory, BiFunction<Service.ServiceCallContext, Map, Iterator<R>> lambda) {
            super(factory);
            this.lambda = lambda;
        }

        public Service.Type getType() {
            return Service.Type.Start;
        }

        public CloseableIterator<R> execute(Service.ServiceCallContext ctx, Map params) {
            return CloseableIterator.of(this.lambda.apply(ctx, params));
        }
    }

    public static class LambdaServiceFactory<I, R>
    extends TinkerServiceFactory<I, R> {
        private Map<Service.Type, Service<I, R>> lambdas = new LinkedHashMap<Service.Type, Service<I, R>>();

        public LambdaServiceFactory(AbstractTinkerGraph graph, String name) {
            super(graph, name);
        }

        public Set<Service.Type> getSupportedTypes() {
            return this.lambdas.keySet();
        }

        @Override
        public LambdaServiceFactory addDescribeParams(Map describeParams) {
            return (LambdaServiceFactory)super.addDescribeParams(describeParams);
        }

        public LambdaStartService addStartLambda(BiFunction<Service.ServiceCallContext, Map, Iterator<R>> lambda) {
            LambdaStartService service = new LambdaStartService(this, lambda);
            this.lambdas.put(Service.Type.Start, service);
            return service;
        }

        public LambdaStreamingService addStreamingLambda(TriFunction<Service.ServiceCallContext, Traverser.Admin<I>, Map, Iterator<R>> lambda) {
            LambdaStreamingService<I, R> service = new LambdaStreamingService<I, R>(this, lambda);
            this.lambdas.put(Service.Type.Streaming, service);
            return service;
        }

        public LambdaBarrierService addBarrierLambda(TriFunction<Service.ServiceCallContext, TraverserSet<I>, Map, Iterator<R>> lambda) {
            LambdaBarrierService<I, R> service = new LambdaBarrierService<I, R>(this, lambda);
            this.lambdas.put(Service.Type.Barrier, service);
            return service;
        }

        public LambdaBarrierService addBarrierLambda(TriFunction<Service.ServiceCallContext, TraverserSet<I>, Map, Iterator<R>> lambda, int maxChunkSize) {
            LambdaBarrierService<I, R> service = new LambdaBarrierService<I, R>(this, lambda, maxChunkSize);
            this.lambdas.put(Service.Type.Barrier, service);
            return service;
        }

        public Service<I, R> createService(boolean isStart, Map params) {
            if (isStart) {
                if (this.supports(Service.Type.Start)) {
                    return this.getService(Service.Type.Start, params);
                }
                throw new UnsupportedOperationException("This service cannot be used to start a traversal.");
            }
            if (this.supports(Service.Type.Streaming, Service.Type.Barrier)) {
                Service.Type type = params.getOrDefault("Type", Options.DEFAULT_TYPE);
                return this.getService(type, params);
            }
            if (this.supports(Service.Type.Streaming)) {
                return this.getService(Service.Type.Streaming, params);
            }
            if (this.supports(Service.Type.Barrier)) {
                return this.getService(Service.Type.Barrier, params);
            }
            throw new UnsupportedOperationException("This service cannot be used mid-traversal.");
        }

        private Service<I, R> getService(Service.Type type, Map params) {
            if (type == Service.Type.Streaming || type == Service.Type.Start) {
                return this.lambdas.get(type);
            }
            LambdaBarrierService service = (LambdaBarrierService)this.lambdas.get(Service.Type.Barrier);
            if (params.containsKey("ChunkSize")) {
                return service.clone((Integer)params.get("ChunkSize"));
            }
            return service;
        }

        private boolean supports(Service.Type ... types) {
            for (Service.Type type : types) {
                if (this.lambdas.containsKey(type)) continue;
                return false;
            }
            return true;
        }

        public static interface Options {
            public static final String TYPE = "Type";
            public static final Service.Type DEFAULT_TYPE = Service.Type.Streaming;
            public static final String CHUNK_SIZE = "ChunkSize";
            public static final Integer DEFAULT_CHUNK_SIZE = Integer.MAX_VALUE;
        }
    }

    public static abstract class TinkerService<I, R>
    implements Service<I, R> {
        protected final TinkerServiceFactory<I, R> serviceFactory;

        protected TinkerService(TinkerServiceFactory<I, R> serviceFactory) {
            this.serviceFactory = serviceFactory;
        }

        public TinkerService addRequirements(TraverserRequirement ... requirements) {
            this.serviceFactory.addRequirements(this.getType(), requirements);
            return this;
        }

        public Set<TraverserRequirement> getRequirements() {
            return this.serviceFactory.getRequirements(this.getType());
        }
    }

    public static abstract class TinkerServiceFactory<I, R>
    implements Service.ServiceFactory<I, R> {
        protected final AbstractTinkerGraph graph;
        protected final String name;
        protected final Map describeParams = new LinkedHashMap();
        protected final Map<Service.Type, Set<TraverserRequirement>> requirements = new LinkedHashMap<Service.Type, Set<TraverserRequirement>>();

        protected TinkerServiceFactory(AbstractTinkerGraph graph, String name) {
            this.graph = graph;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public TinkerServiceFactory addDescribeParams(Map describeParams) {
            this.describeParams.putAll(describeParams);
            return this;
        }

        public TinkerServiceFactory addRequirements(Service.Type type, TraverserRequirement ... requirements) {
            Set typeRequirements = this.requirements.computeIfAbsent(type, x -> new LinkedHashSet());
            for (TraverserRequirement requirement : requirements) {
                typeRequirements.add(requirement);
            }
            return this;
        }

        public Set<TraverserRequirement> getRequirements(Service.Type type) {
            return this.requirements.getOrDefault(type, Collections.emptySet());
        }

        public Map describeParams() {
            return this.describeParams;
        }
    }
}

