/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Info;
import org.apache.tomcat.jakartaee.StringManager;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ManifestConverter
implements Converter {
    private static final String JAKARTA_SERVLET = "jakarta.servlet";
    private static final Pattern SERVLET_PATTERN = Pattern.compile("jakarta.servlet([^,]*);version=\"(.*?)\"");
    private static final Logger logger = Logger.getLogger(ManifestConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(ManifestConverter.class);

    @Override
    public boolean accepts(String filename) {
        return filename.equals("META-INF/MANIFEST.MF") || filename.endsWith("/META-INF/MANIFEST.MF");
    }

    @Override
    public boolean convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        byte[] srcBytes = IOUtils.toByteArray((InputStream)src);
        Manifest srcManifest = new Manifest(new ByteArrayInputStream(srcBytes));
        Manifest destManifest = new Manifest(srcManifest);
        boolean converted = this.updateValues(destManifest, profile);
        this.removeSignatures(destManifest);
        if (srcManifest.equals(destManifest)) {
            IOUtils.writeChunked((byte[])srcBytes, (OutputStream)dest);
            logger.log(Level.FINEST, sm.getString("manifestConverter.noConversion", path));
        } else {
            destManifest.write(dest);
            String key = converted ? "manifestConverter.converted" : "manifestConverter.updated";
            logger.log(Level.FINE, sm.getString(key, path));
        }
        return converted;
    }

    private void removeSignatures(Manifest manifest) {
        manifest.getMainAttributes().remove(Attributes.Name.SIGNATURE_VERSION);
        ArrayList<String> signatureEntries = new ArrayList<String>();
        Map<String, Attributes> manifestAttributeEntries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : manifestAttributeEntries.entrySet()) {
            if (!this.isCryptoSignatureEntry(entry.getValue())) continue;
            String entryName = entry.getKey();
            signatureEntries.add(entryName);
            logger.log(Level.FINE, sm.getString("manifestConverter.removeSignature", entryName));
        }
        for (String string : signatureEntries) {
            manifestAttributeEntries.remove(string);
        }
    }

    private boolean isCryptoSignatureEntry(Attributes attributes) {
        for (Object attributeKey : attributes.keySet()) {
            if (!attributeKey.toString().endsWith("-Digest")) continue;
            return true;
        }
        return false;
    }

    private boolean updateValues(Manifest manifest, EESpecProfile profile) {
        boolean converted = this.updateValues(manifest.getMainAttributes(), profile);
        for (Attributes attributes : manifest.getEntries().values()) {
            converted |= this.updateValues(attributes, profile);
        }
        return converted;
    }

    private boolean updateValues(Attributes attributes, EESpecProfile profile) {
        boolean converted = false;
        if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String newValue = attributes.get(Attributes.Name.IMPLEMENTATION_VERSION) + "-" + Info.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, newValue);
            logger.log(Level.FINE, sm.getString("manifestConverter.updatedVersion", newValue));
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String newValue = profile.convert((String)entry.getValue());
            String header = entry.getKey().toString();
            try {
                newValue = "Import-Package".equals(header) ? this.processImportPackage(newValue) : ("Export-Package".equals(header) ? this.processExportPackage(newValue) : this.replaceVersion(newValue));
            }
            catch (BundleException e) {
                newValue = this.replaceVersion(newValue, !"Export-Package".equals(header));
            }
            if (newValue.equals(entry.getValue())) continue;
            entry.setValue(newValue);
            converted = true;
        }
        return converted;
    }

    private String processExportPackage(String value) throws BundleException {
        return this.processOSGIHeader(value, "Export-Package", "5.0.0");
    }

    private String processImportPackage(String value) throws BundleException {
        return this.processOSGIHeader(value, "Import-Package", "[5.0.0,7.0.0)");
    }

    private String processOSGIHeader(String value, String header, String replacement) throws BundleException {
        ManifestElement[] elements;
        ArrayList<String> packages = new ArrayList<String>();
        for (ManifestElement element : elements = ManifestElement.parseHeader((String)header, (String)value)) {
            if (element.getValue().startsWith(JAKARTA_SERVLET)) {
                String oldVersion = element.getAttribute("version");
                if (oldVersion != null) {
                    packages.add(element.toString().replace(oldVersion, replacement));
                    continue;
                }
                packages.add(element.toString());
                continue;
            }
            packages.add(element.toString());
        }
        if (packages.isEmpty()) {
            return value;
        }
        return String.join((CharSequence)",", packages);
    }

    private String replaceVersion(String entryValue) {
        return this.replaceVersion(entryValue, true);
    }

    private String replaceVersion(String entryValue, boolean range) {
        if (entryValue.contains(JAKARTA_SERVLET)) {
            StringBuffer builder = new StringBuffer();
            Matcher matcher = SERVLET_PATTERN.matcher(entryValue);
            while (matcher.find()) {
                String version = range ? "[5.0.0,7.0.0)" : "5.0.0";
                matcher.appendReplacement(builder, "jakarta.servlet$1;version=\"" + version + "\"");
            }
            matcher.appendTail(builder);
            return builder.toString();
        }
        return entryValue;
    }
}

