/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.tomcat.jakartaee.CacheEntry;
import org.apache.tomcat.jakartaee.ClassConverter;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.GlobMatcher;
import org.apache.tomcat.jakartaee.ManifestConverter;
import org.apache.tomcat.jakartaee.MigrationCache;
import org.apache.tomcat.jakartaee.PassThroughConverter;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.TextConverter;
import org.apache.tomcat.jakartaee.Util;

public class Migration {
    private static final Logger logger = Logger.getLogger(Migration.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(Migration.class);
    private static final Set<String> DEFAULT_EXCLUDES = new HashSet<String>();
    private static final ZipShort EXTRA_FIELD_ZIP64 = new ZipShort(1);
    private static final long ZIP64_THRESHOLD_LENGTH = 0xFFFFFFFFL;
    private EESpecProfile profile = EESpecProfiles.TOMCAT;
    private boolean enableDefaultExcludes = true;
    private boolean matchExcludesAgainstPathName;
    private boolean zipInMemory;
    private boolean converted;
    private State state = State.NOT_STARTED;
    private File source;
    private File destination;
    private final List<Converter> converters;
    private final Set<String> excludes = new HashSet<String>();
    private MigrationCache cache;

    public Migration() {
        this.converters = new ArrayList<Converter>();
        this.converters.add(new TextConverter());
        this.converters.add(new ClassConverter());
        this.converters.add(new ManifestConverter());
        this.converters.add(new PassThroughConverter());
    }

    public void setEESpecProfile(EESpecProfile profile) {
        this.profile = profile;
    }

    public EESpecProfile getEESpecProfile() {
        return this.profile;
    }

    public void setEnableDefaultExcludes(boolean enableDefaultExcludes) {
        this.enableDefaultExcludes = enableDefaultExcludes;
    }

    public void setMatchExcludesAgainstPathName(boolean matchExcludesAgainstPathName) {
        this.matchExcludesAgainstPathName = matchExcludesAgainstPathName;
    }

    public void setZipInMemory(boolean zipInMemory) {
        this.zipInMemory = zipInMemory;
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void setSource(File source) {
        if (!source.canRead()) {
            throw new IllegalArgumentException(sm.getString("migration.cannotReadSource", source.getAbsolutePath()));
        }
        this.source = source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setCache(MigrationCache cache) {
        this.cache = cache;
    }

    public boolean hasConverted() {
        if (this.state != State.COMPLETE) {
            throw new IllegalStateException(sm.getString("migration.notCompleted"));
        }
        return this.converted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws IOException {
        if (this.state == State.RUNNING) {
            throw new IllegalStateException(sm.getString("migration.alreadyRunning"));
        }
        this.state = State.RUNNING;
        this.converted = false;
        logger.log(Level.INFO, sm.getString("migration.execute", this.source.getAbsolutePath(), this.destination.getAbsolutePath(), this.profile.toString()));
        long t1 = System.nanoTime();
        if (this.source.isDirectory()) {
            if ((!this.destination.exists() || !this.destination.isDirectory()) && !this.destination.mkdirs()) throw new IOException(sm.getString("migration.mkdirError", this.destination.getAbsolutePath()));
            this.migrateDirectory(this.source, this.destination);
        } else {
            File parentDestination = this.destination.getAbsoluteFile().getParentFile();
            if (!parentDestination.exists() && !parentDestination.mkdirs()) throw new IOException(sm.getString("migration.mkdirError", parentDestination.getAbsolutePath()));
            this.migrateFile(this.source, this.destination);
        }
        this.state = State.COMPLETE;
        if (this.cache != null) {
            this.cache.finalizeCacheOperations();
        }
        logger.log(Level.INFO, sm.getString("migration.done", TimeUnit.MILLISECONDS.convert(System.nanoTime() - t1, TimeUnit.NANOSECONDS)));
    }

    private void migrateDirectory(File src, File dest) throws IOException {
        String[] files;
        for (String file : files = src.list()) {
            File srcFile = new File(src, file);
            File destFile = new File(dest, this.profile.convert(file));
            if (srcFile.isDirectory()) {
                if (destFile.exists() && destFile.isDirectory() || destFile.mkdir()) {
                    this.migrateDirectory(srcFile, destFile);
                    continue;
                }
                throw new IOException(sm.getString("migration.mkdirError", destFile.getAbsolutePath()));
            }
            this.migrateFile(srcFile, destFile);
        }
    }

    private void migrateFile(File src, File dest) throws IOException {
        if (src.equals(dest)) {
            ByteArrayOutputStream buffer;
            block22: {
                buffer = new ByteArrayOutputStream((int)((double)src.length() * 1.05));
                try (FileInputStream is = new FileInputStream(src);){
                    if (this.migrateStream(src.getAbsolutePath(), is, buffer)) {
                        this.converted = true;
                        break block22;
                    }
                    return;
                }
            }
            try (FileOutputStream os = new FileOutputStream(dest);){
                ((OutputStream)os).write(buffer.toByteArray());
            }
        }
        try (FileInputStream is = new FileInputStream(src);
             FileOutputStream os = new FileOutputStream(dest);){
            this.converted = this.migrateStream(src.getAbsolutePath(), is, os);
        }
    }

    private boolean migrateArchiveStreaming(InputStream src, OutputStream dest) throws IOException {
        boolean convertedArchive = false;
        try (ZipArchiveInputStream srcZipStream = new ZipArchiveInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)src));
             ZipArchiveOutputStream destZipStream = new ZipArchiveOutputStream((OutputStream)CloseShieldOutputStream.wrap((OutputStream)dest));){
            ZipArchiveEntry srcZipEntry;
            CRC32 crc32 = new CRC32();
            while ((srcZipEntry = srcZipStream.getNextEntry()) != null) {
                boolean convertedStream = false;
                String srcName = srcZipEntry.getName();
                if (this.isSignatureFile(srcName)) {
                    logger.log(Level.WARNING, sm.getString("migration.skipSignatureFile", srcName));
                    continue;
                }
                if (srcZipEntry.getSize() > 0xFFFFFFFFL || srcZipEntry.getCompressedSize() > 0xFFFFFFFFL) {
                    logger.log(Level.WARNING, sm.getString("migration.jdk8303866", srcName));
                } else if (srcZipEntry.getExtraField(EXTRA_FIELD_ZIP64) != null) {
                    srcZipEntry.removeExtraField(EXTRA_FIELD_ZIP64);
                }
                String destName = this.profile.convert(srcName);
                if (srcZipEntry.getMethod() == 0) {
                    ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream((int)((double)srcZipEntry.getSize() * 1.05));
                    convertedStream = this.migrateStream(srcName, (InputStream)srcZipStream, tempBuffer);
                    crc32.update(tempBuffer.toByteArray(), 0, tempBuffer.size());
                    MigrationZipArchiveEntry destZipEntry = new MigrationZipArchiveEntry(srcZipEntry);
                    destZipEntry.setName(destName);
                    destZipEntry.setSize(tempBuffer.size());
                    destZipEntry.setCrc(crc32.getValue());
                    if (convertedStream) {
                        destZipEntry.setLastModifiedTime(FileTime.fromMillis(System.currentTimeMillis()));
                    }
                    destZipStream.putArchiveEntry((ZipArchiveEntry)destZipEntry);
                    tempBuffer.writeTo((OutputStream)destZipStream);
                    destZipStream.closeArchiveEntry();
                    crc32.reset();
                } else {
                    MigrationZipArchiveEntry destZipEntry = new MigrationZipArchiveEntry(srcZipEntry);
                    destZipEntry.setName(destName);
                    destZipStream.putArchiveEntry((ZipArchiveEntry)destZipEntry);
                    convertedStream = this.migrateStream(srcName, (InputStream)srcZipStream, (OutputStream)destZipStream);
                    if (convertedStream) {
                        destZipEntry.setLastModifiedTime(FileTime.fromMillis(System.currentTimeMillis()));
                    }
                    destZipStream.closeArchiveEntry();
                }
                convertedArchive = convertedArchive || convertedStream;
            }
        }
        return convertedArchive;
    }

    private boolean migrateArchiveInMemory(InputStream src, OutputStream dest) throws IOException {
        boolean convertedArchive = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)src, (OutputStream)baos);
        baos.flush();
        SeekableInMemoryByteChannel srcByteChannel = new SeekableInMemoryByteChannel(baos.toByteArray());
        SeekableInMemoryByteChannel destByteChannel = new SeekableInMemoryByteChannel();
        try (ZipFile srcZipFile = ZipFile.builder().setSeekableByteChannel((SeekableByteChannel)srcByteChannel).get();
             ZipArchiveOutputStream destZipStream = new ZipArchiveOutputStream((SeekableByteChannel)destByteChannel);){
            Enumeration entries = srcZipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry srcZipEntry = (ZipArchiveEntry)entries.nextElement();
                String srcName = srcZipEntry.getName();
                if (this.isSignatureFile(srcName)) {
                    logger.log(Level.WARNING, sm.getString("migration.skipSignatureFile", srcName));
                    continue;
                }
                String destName = this.profile.convert(srcName);
                MigrationZipArchiveEntry destZipEntry = new MigrationZipArchiveEntry(srcZipEntry);
                destZipEntry.setName(destName);
                destZipStream.putArchiveEntry((ZipArchiveEntry)destZipEntry);
                boolean convertedStream = this.migrateStream(srcName, srcZipFile.getInputStream(srcZipEntry), (OutputStream)destZipStream);
                if (convertedStream) {
                    destZipEntry.setLastModifiedTime(FileTime.fromMillis(System.currentTimeMillis()));
                }
                destZipStream.closeArchiveEntry();
                convertedArchive = convertedArchive || convertedStream;
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(destByteChannel.array(), 0, (int)destByteChannel.size());
        IOUtils.copy((InputStream)bais, (OutputStream)dest);
        return convertedArchive;
    }

    private boolean isSignatureFile(String sourceName) {
        return sourceName.startsWith("META-INF/") && (sourceName.endsWith(".SF") || sourceName.endsWith(".RSA") || sourceName.endsWith(".DSA") || sourceName.endsWith(".EC"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean migrateStream(String name, InputStream src, OutputStream dest) throws IOException {
        boolean convertedStream = false;
        if (this.isExcluded(name)) {
            Util.copy(src, dest);
            logger.log(Level.INFO, sm.getString("migration.skip", name));
            return convertedStream;
        } else if (this.isArchive(name)) {
            boolean isNestedArchive = !name.startsWith("/") && !name.startsWith("\\");
            CacheEntry cacheEntry = null;
            if (isNestedArchive && this.cache != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)src, (OutputStream)buffer);
                byte[] sourceBytes = buffer.toByteArray();
                cacheEntry = this.cache.getCacheEntry(sourceBytes, this.profile);
                if (cacheEntry.exists()) {
                    logger.log(Level.INFO, sm.getString("cache.hit", name, cacheEntry.getHash()));
                    cacheEntry.copyToDestination(dest);
                    return true;
                }
                logger.log(Level.FINE, sm.getString("cache.miss", name, cacheEntry.getHash()));
                src = new ByteArrayInputStream(sourceBytes);
            }
            OutputStream targetOutputStream = dest;
            if (cacheEntry != null) {
                targetOutputStream = new TeeOutputStream(dest, cacheEntry.beginStore());
            }
            try {
                if (this.zipInMemory) {
                    logger.log(Level.INFO, sm.getString("migration.archive.memory", name));
                    convertedStream = this.migrateArchiveInMemory(src, targetOutputStream);
                    logger.log(Level.INFO, sm.getString("migration.archive.complete", name));
                } else {
                    logger.log(Level.INFO, sm.getString("migration.archive.stream", name));
                    convertedStream = this.migrateArchiveStreaming(src, targetOutputStream);
                    logger.log(Level.INFO, sm.getString("migration.archive.complete", name));
                }
                if (cacheEntry == null) return convertedStream;
                cacheEntry.commitStore();
                logger.log(Level.FINE, sm.getString("cache.store", cacheEntry.getHash(), cacheEntry.getFileSize()));
                return convertedStream;
            }
            catch (IOException e) {
                if (cacheEntry == null) throw e;
                cacheEntry.rollbackStore();
                throw e;
            }
        } else {
            Converter converter;
            Iterator<Converter> iterator = this.converters.iterator();
            do {
                if (!iterator.hasNext()) return convertedStream;
            } while (!(converter = iterator.next()).accepts(name));
            return converter.convert(name, src, dest, this.profile);
        }
    }

    private boolean isArchive(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".ear") || fileName.endsWith(".zip");
    }

    private boolean isExcluded(String name) {
        File f = new File(name);
        String filename = f.getName();
        if (this.enableDefaultExcludes && GlobMatcher.matchName(DEFAULT_EXCLUDES, filename, true)) {
            return true;
        }
        if (!this.matchExcludesAgainstPathName && GlobMatcher.matchName(this.excludes, filename, true)) {
            return true;
        }
        return this.matchExcludesAgainstPathName && GlobMatcher.matchName(this.excludes, name, true);
    }

    static {
        DEFAULT_EXCLUDES.add("commons-codec-*.jar");
        DEFAULT_EXCLUDES.add("commons-lang-*.jar");
        DEFAULT_EXCLUDES.add("httpclient-*.jar");
        DEFAULT_EXCLUDES.add("httpcore-*.jar");
        DEFAULT_EXCLUDES.add("asm-*.jar");
        DEFAULT_EXCLUDES.add("aspectjweaver-*.jar");
        DEFAULT_EXCLUDES.add("bcprov*.jar");
        DEFAULT_EXCLUDES.add("bcpkix*.jar");
        DEFAULT_EXCLUDES.add("closure-compiler-*.jar");
        DEFAULT_EXCLUDES.add("ecj-*.jar");
        DEFAULT_EXCLUDES.add("hystrix-core-*.jar");
        DEFAULT_EXCLUDES.add("hystrix-serialization-*.jar");
        DEFAULT_EXCLUDES.add("jackson-annotations-*.jar");
        DEFAULT_EXCLUDES.add("jackson-core-*.jar");
        DEFAULT_EXCLUDES.add("jackson-module-afterburner-*.jar");
        DEFAULT_EXCLUDES.add("jul-to-slf4j-*.jar");
        DEFAULT_EXCLUDES.add("log4j-to-slf4j-*.jar");
        DEFAULT_EXCLUDES.add("slf4j-api-*.jar");
        DEFAULT_EXCLUDES.add("spring-aop-*.jar");
        DEFAULT_EXCLUDES.add("spring-expression-*.jar");
        DEFAULT_EXCLUDES.add("spring-security-crypto-*.jar");
        DEFAULT_EXCLUDES.add("spring-security-rsa-*.jar");
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        COMPLETE;

    }

    private static class MigrationZipArchiveEntry
    extends ZipArchiveEntry {
        MigrationZipArchiveEntry(ZipArchiveEntry entry) throws ZipException {
            super(entry);
        }

        public void setName(String name) {
            super.setName(name);
        }
    }
}

