/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.util.UUID;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.UUIDConverter;

public class UUIDMetadata
extends MetadataConverter {
    public UUIDMetadata() {
        super("<uuid>");
    }

    public UUIDMetadata(MetadataAnnotation uuid, MetadataAccessor accessor) {
        super(uuid, accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof UUIDMetadata;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static boolean isValidUUIDType(MetadataClass cls) {
        return cls.isClass(UUID.class);
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (!UUIDMetadata.isValidUUIDType(referenceClass)) {
            throw ValidationException.invalidTypeForSerializedAttribute(mapping.getAttributeName(), accessor.getReferenceClass(), accessor.getJavaClass());
        }
        this.setFieldClassification(mapping, UUID.class, isForMapKey);
        this.setConverter(mapping, new UUIDConverter(), isForMapKey);
    }
}

