/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.core.RutaLanguageToolkit;
import org.apache.uima.ruta.ide.core.codeassist.RutaReferenceDeclarationVisitor;
import org.apache.uima.ruta.ide.core.codeassist.RutaReferenceVisitor;
import org.apache.uima.ruta.ide.core.codeassist.RutaRuleIdVisitor;
import org.apache.uima.ruta.ide.core.codeassist.RutaSelectionParser;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.apache.uima.ruta.ide.ui.editor.ReferenceFinder;
import org.apache.uima.ruta.ide.ui.editor.RutaDocumentSetupParticipant;
import org.apache.uima.ruta.ide.ui.editor.RutaOutlinePage;
import org.apache.uima.ruta.ide.ui.text.RutaPairMatcher;
import org.apache.uima.ruta.ide.ui.text.folding.RutaFoldingStructureProvider;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.editor.ToggleCommentAction;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaEditor
extends ScriptEditor {
    public static final String EDITOR_ID = "org.apache.uima.ruta.ide.ui.editor.RutaEditor";
    public static final String EDITOR_CONTEXT = "#RutaEditorContext";
    public static final String RULER_CONTEXT = "#RutaRulerContext";
    private IFoldingStructureProvider foldingProvider;
    private RutaPairMatcher bracketMatcher;
    static final String[] properties = new String[]{"editor_folding_blocks", "editor_folding_exclude_list", "editor_folding_include_list"};
    private Highlighter highlighter;
    private HashMap<Annotation, Position> myAnnotations;

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new ToggleCommentAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
    }

    protected String[] getFoldingEventPreferenceKeys() {
        return properties;
    }

    public IPreferenceStore getScriptPreferenceStore() {
        return RutaIdePlugin.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return RutaIdePlugin.getDefault().getTextTools();
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new RutaOutlinePage(this, RutaIdePlugin.getDefault().getPreferenceStore());
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 doc;
        if (document instanceof IDocumentExtension3 && (doc = (IDocumentExtension3)document).getDocumentPartitioner("__ruta_partitioning") == null) {
            RutaDocumentSetupParticipant participant = new RutaDocumentSetupParticipant();
            participant.setup(document);
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.foldingProvider == null) {
            this.foldingProvider = new RutaFoldingStructureProvider();
        }
        return this.foldingProvider;
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), RutaIdePlugin.getDefault().getPreferenceStore());
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        super.selectionChanged();
        if (this.myAnnotations != null && !this.myAnnotations.isEmpty()) {
            this.removeAnnotations(this.myAnnotations.keySet());
        }
        RutaSelectionParser parser = new RutaSelectionParser();
        ISourceModule unit = (ISourceModule)this.getInputModelElement();
        ModuleDeclaration parsed = parser.parse((IModuleSource)unit);
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        RutaReferenceVisitor visitor1 = new RutaReferenceVisitor(caret);
        ASTNode node = null;
        try {
            parsed.traverse((ASTVisitor)visitor1);
        }
        catch (Exception e) {
            // empty catch block
        }
        node = visitor1.getResult();
        if (node == null) {
            RutaReferenceDeclarationVisitor visitor2 = new RutaReferenceDeclarationVisitor(caret);
            try {
                parsed.traverse((ASTVisitor)visitor2);
            }
            catch (Exception e) {
                // empty catch block
            }
            node = visitor2.getResult();
        }
        if (node != null) {
            ReferenceFinder refFinder = new ReferenceFinder(node);
            try {
                parsed.traverse((ASTVisitor)refFinder);
            }
            catch (Exception e) {
                // empty catch block
            }
            List<ASTNode> result = refFinder.getResult();
            this.myAnnotations = new HashMap(result.size());
            for (ASTNode each : result) {
                Expression e;
                Annotation annotation = new Annotation("org.eclipse.search.results", true, null);
                Position position = null;
                int sourceStart = each.sourceStart();
                int sourceEnd = each.sourceEnd();
                if (each instanceof RutaAction) {
                    e = (RutaAction)each;
                    sourceStart = e.getNameStart();
                    sourceEnd = e.getNameEnd();
                } else if (each instanceof RutaCondition) {
                    e = (RutaCondition)each;
                    sourceStart = e.getNameStart();
                    sourceEnd = e.getNameEnd();
                }
                position = new Position(sourceStart, sourceEnd - sourceStart);
                this.myAnnotations.put(annotation, position);
            }
            this.addAnnotations(this.myAnnotations);
        }
    }

    public void highlightElement(int id) {
        if (this.myAnnotations != null && !this.myAnnotations.isEmpty()) {
            this.removeAnnotations(this.myAnnotations.keySet());
        }
        RutaSelectionParser parser = new RutaSelectionParser();
        ISourceModule unit = (ISourceModule)this.getInputModelElement();
        ModuleDeclaration parsed = parser.parse((IModuleSource)unit);
        RutaRuleIdVisitor visitor = new RutaRuleIdVisitor(id);
        try {
            parsed.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            // empty catch block
        }
        RutaRule rule = visitor.getResult();
        this.myAnnotations = new HashMap();
        if (rule != null) {
            Annotation annotation = new Annotation("org.eclipse.search.results", true, null);
            int sourceStart = rule.sourceStart();
            int sourceEnd = rule.sourceEnd();
            Position position = new Position(sourceStart, sourceEnd - sourceStart);
            this.getSourceViewer().revealRange(sourceStart, sourceEnd - sourceStart);
            this.myAnnotations.put(annotation, position);
        }
        this.addAnnotations(this.myAnnotations);
    }

    private void removeAnnotations(Collection<Annotation> annotations) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        for (Annotation annotation : annotations) {
            model.removeAnnotation(annotation);
        }
    }

    private void addAnnotations(Map<Annotation, Position> annotationToPositionMap) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        for (Annotation a : annotationToPositionMap.keySet()) {
            Position p = annotationToPositionMap.get(a);
            model.addAnnotation(a, p);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.apache.uima.ruta.ide.ui.rutaEditorScope"});
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return RutaLanguageToolkit.getDefault();
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage("No bracket selected");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (RutaEditor.isSurroundedByBrackets((IDocument)document, (int)sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.bracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage("No matching bracket found");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.bracketMatcher.getAnchor();
        int targetOffset = 0 == anchor ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage("Matching bracket is outside selected element");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.bracketMatcher = new RutaPairMatcher(BRACKETS, this);
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor.matching_brackets", "editor.matching_brackets_color");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected class FormatElementAction
    extends Action
    implements IUpdate {
        FormatElementAction() {
            this.setEnabled(RutaEditor.this.isEditorInputModifiable());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                ScriptSourceViewer viewer = (ScriptSourceViewer)RutaEditor.this.getSourceViewer();
                if (viewer.isEditable()) {
                    Point selection = viewer.rememberSelection();
                    try {
                        viewer.setRedraw(false);
                        String type = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"__ruta_partitioning", (int)selection.x, (boolean)true);
                        if (type.equals("__dftl_partition_content_type") && selection.y == 0) {
                            try {
                                ISourceReference reference;
                                ISourceRange range;
                                int kind;
                                IModelElement element = RutaEditor.this.getElementAt(selection.x, true);
                                if (element != null && element.exists() && ((kind = element.getElementType()) == 7 || kind == 9) && (range = (reference = (ISourceReference)element).getSourceRange()) != null) {
                                    viewer.setSelectedRange(range.getOffset(), range.getLength());
                                    viewer.doOperation(15);
                                }
                                break block10;
                            }
                            catch (ModelException exception) {}
                            break block10;
                        }
                        viewer.setSelectedRange(selection.x, 1);
                        viewer.doOperation(15);
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        viewer.setRedraw(true);
                        viewer.restoreSelection();
                    }
                }
            }
        }

        public void update() {
            this.setEnabled(RutaEditor.this.isEditorInputModifiable());
        }
    }
}

