/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class NonBlockingCookieStore
implements CookieStore {
    protected ConcurrentMap<Key, HttpCookie> all = new ConcurrentHashMap<Key, HttpCookie>(100, 0.75f, 2);

    NonBlockingCookieStore() {
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        if (cookie.getMaxAge() == 0L) {
            return;
        }
        if (cookie.getDomain() != null) {
            this.add(new DomainKey(cookie), cookie);
        }
        if (uri != null) {
            this.add(new UriKey(uri, cookie), cookie);
        }
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        List<HttpCookie> ret = this.all.entrySet().stream().filter(entry -> this.entryValid((Map.Entry<Key, HttpCookie>)entry) && this.matches((Map.Entry<Key, HttpCookie>)entry, uri)).map(Map.Entry::getValue).distinct().collect(Collectors.toList());
        return ret;
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.all.entrySet().stream().filter(this::entryValid).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public List<URI> getURIs() {
        return this.all.entrySet().stream().filter(entry -> entry.getKey() instanceof UriKey).filter(this::entryValid).map(entry -> ((UriKey)entry.getKey()).getURI()).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        boolean domainRemoved = false;
        boolean uriRemoved = false;
        if (cookie.getDomain() != null) {
            domainRemoved = this.remove(new DomainKey(cookie));
        }
        if (uri != null) {
            uriRemoved = this.remove(new UriKey(uri, cookie));
        }
        return domainRemoved || uriRemoved;
    }

    @Override
    public boolean removeAll() {
        int initialSize = this.all.size();
        this.all.clear();
        return initialSize > 0;
    }

    private static URI makeURI(String domain) {
        try {
            return new URI("http", domain, null, null, null);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public boolean entryValid(Map.Entry<Key, HttpCookie> entry) {
        if (entry.getValue().hasExpired()) {
            this.remove(entry.getKey());
            return false;
        }
        return true;
    }

    private boolean netscapeDomainMatches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String H = host.substring(0, lengthDiff);
            String D = host.substring(lengthDiff);
            return D.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    private boolean matches(Map.Entry<Key, HttpCookie> entry, URI uri) {
        HttpCookie cookie = entry.getValue();
        boolean secureLink = "https".equalsIgnoreCase(uri.getScheme());
        if (!secureLink && cookie.getSecure()) {
            return false;
        }
        String host = uri.getHost();
        if (entry.getKey() instanceof UriKey) {
            return ((UriKey)entry.getKey()).host.equalsIgnoreCase(host);
        }
        String domain = cookie.getDomain();
        if (cookie.getVersion() == 0) {
            return this.netscapeDomainMatches(domain, host);
        }
        return HttpCookie.domainMatches(domain, host);
    }

    protected void add(Key key, HttpCookie cookie) {
        this.all.put(key, cookie);
    }

    protected boolean remove(Key key) {
        return this.all.remove(key) != null;
    }

    protected static class DomainKey
    extends Key {
        public static final String TYPE = "domain";
        final String domain;
        final String path;

        public DomainKey(HttpCookie cookie) {
            super(cookie.getName());
            this.domain = cookie.getDomain();
            this.path = cookie.getPath();
        }

        public static boolean domainKey(String type) {
            return TYPE.equals(type);
        }

        @Override
        public String getKeyType() {
            return TYPE;
        }

        private boolean pathEquals(DomainKey rhs) {
            if (this.path == null && rhs.path == null) {
                return true;
            }
            if (this.path == null && rhs.path != null) {
                return false;
            }
            if (this.path != null && rhs.path == null) {
                return false;
            }
            return this.path.equalsIgnoreCase(rhs.path);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DomainKey)) {
                return false;
            }
            DomainKey rhs = (DomainKey)o;
            return this.name.equalsIgnoreCase(rhs.name) && this.domain.equalsIgnoreCase(rhs.domain) && this.pathEquals(rhs);
        }

        public int hashCode() {
            return 37 * (37 * this.name.hashCode() + this.domain.hashCode()) + (this.path == null ? 0 : this.path.hashCode());
        }

        public String toString() {
            return String.format("DomainKey(name: %s, domain: %s, path: %s", this.name, this.domain, this.path);
        }
    }

    protected static class UriKey
    extends Key {
        public static final String TYPE = "uri";
        final String host;

        public UriKey(URI uri, HttpCookie cookie) {
            super(cookie.getName());
            this.host = UriKey.forStorage(uri.getHost());
        }

        public static boolean uriKey(String type) {
            return TYPE.equals(type);
        }

        @Override
        public String getKeyType() {
            return TYPE;
        }

        public URI getURI() {
            try {
                return new URI("http", this.host, null, null);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public int hashCode() {
            return 37 * this.name.hashCode() + this.host.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof UriKey)) {
                return false;
            }
            UriKey rhs = (UriKey)o;
            return this.host.equals(rhs.host) && this.name.equals(rhs.name);
        }

        public String toString() {
            return String.format("UriKey(name: %s, host: %s)", this.name, this.host);
        }
    }

    protected static abstract class Key {
        final String name;
        final Instant createdAt;

        public Key(String name) {
            this.name = name;
            this.createdAt = Instant.now();
        }

        public abstract String getKeyType();

        public static boolean specified(String val) {
            return val != null && !"".equals(val.trim());
        }

        static Key make(URI uri, HttpCookie cookie) {
            if (!Key.specified(cookie.getDomain())) {
                return new UriKey(uri, cookie);
            }
            return new DomainKey(cookie);
        }

        public static String forStorage(String str) {
            return str == null ? str : str.toLowerCase();
        }
    }
}

