/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.money.CurrencyUnit;
import org.javamoney.moneta.function.DefaultMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

class MonetarySummaryMap
implements Map<CurrencyUnit, MonetarySummaryStatistics> {
    private final Map<CurrencyUnit, MonetarySummaryStatistics> statisticsMap = new HashMap<CurrencyUnit, MonetarySummaryStatistics>();

    MonetarySummaryMap() {
    }

    @Override
    public int size() {
        return this.statisticsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.statisticsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.statisticsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.statisticsMap.containsValue(value);
    }

    @Override
    public MonetarySummaryStatistics get(Object key) {
        if (CurrencyUnit.class.isInstance(key)) {
            CurrencyUnit unit = (CurrencyUnit)CurrencyUnit.class.cast(key);
            return this.statisticsMap.getOrDefault(unit, new DefaultMonetarySummaryStatistics(unit));
        }
        return this.statisticsMap.get(key);
    }

    @Override
    public MonetarySummaryStatistics put(CurrencyUnit key, MonetarySummaryStatistics value) {
        return this.statisticsMap.put(key, value);
    }

    @Override
    public MonetarySummaryStatistics remove(Object key) {
        return this.statisticsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends CurrencyUnit, ? extends MonetarySummaryStatistics> m) {
        this.statisticsMap.putAll(m);
    }

    @Override
    public void clear() {
        this.statisticsMap.clear();
    }

    @Override
    public Set<CurrencyUnit> keySet() {
        return this.statisticsMap.keySet();
    }

    @Override
    public Collection<MonetarySummaryStatistics> values() {
        return this.statisticsMap.values();
    }

    @Override
    public Set<Map.Entry<CurrencyUnit, MonetarySummaryStatistics>> entrySet() {
        return this.statisticsMap.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (MonetarySummaryMap.class.isInstance(obj)) {
            MonetarySummaryMap other = (MonetarySummaryMap)MonetarySummaryMap.class.cast(obj);
            return this.statisticsMap.equals(other.statisticsMap);
        }
        return false;
    }

    @Override
    public MonetarySummaryStatistics putIfAbsent(CurrencyUnit key, MonetarySummaryStatistics value) {
        MonetarySummaryStatistics v = this.statisticsMap.get(key);
        if (Objects.isNull(v)) {
            v = this.put(key, value);
        }
        return v;
    }

    @Override
    public int hashCode() {
        return this.statisticsMap.hashCode();
    }

    public String toString() {
        return "MonetarySummaryMap: " + this.statisticsMap.toString();
    }
}

