/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classindex;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ClassIndexerAnalyzer
implements AnalyzerPlugin {
    public static final String X_CLASSINDEX = "-x-classindex";
    public static final String BND_HASHES = "bnd.hashes";

    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        if (analyzer.getProperty(X_CLASSINDEX) == null) {
            return false;
        }
        for (Map.Entry<Descriptors.PackageRef, Attrs> e : analyzer.getContained().entrySet()) {
            Descriptors.PackageRef export = e.getKey();
            Attrs attrs = e.getValue();
            Set<Clazz> classspace = analyzer.getClassspace(export);
            if (classspace.isEmpty()) continue;
            ArrayList<Integer> hashes = new ArrayList<Integer>();
            for (Clazz c : classspace) {
                Descriptors.TypeRef tr = c.getClassName();
                if (tr.isArray() || tr.isNested()) continue;
                int hash = tr.getShorterName().hashCode();
                hashes.add(hash);
            }
            attrs.putTyped(BND_HASHES, hashes);
        }
        return false;
    }

    public static int hash(String last) {
        return last.hashCode();
    }

    public static boolean isEqual(String a, String b) {
        return a.equals(b);
    }
}

