/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.ImportExportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.RouterUtils;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRouteCompletionProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)ExportRouteCompletionProcessor.class.getName());
    private ImportExportConfigurationService<ExportConfiguration> exportConfigurationService;
    private int executionsHistorySize;

    public void process(Exchange exchange) throws Exception {
        ExportConfiguration exportConfig = (ExportConfiguration)exchange.getIn().getHeader("exportConfig");
        HashMap<Object, Object> execution = new HashMap<Object, Object>();
        execution.put(RouterConstants.KEY_EXECS_DATE, ((Date)exchange.getProperty("CamelCreatedTimestamp")).getTime());
        execution.put(RouterConstants.KEY_EXECS_EXTRACTED, exchange.getProperty("CamelSplitSize"));
        ExportConfiguration exportConfiguration = (ExportConfiguration)this.exportConfigurationService.load(exportConfig.getItemId());
        exportConfiguration = (ExportConfiguration)RouterUtils.addExecutionEntry((ImportExportConfiguration)exportConfiguration, execution, (int)this.executionsHistorySize);
        exportConfiguration.setStatus("SUCCESS");
        this.exportConfigurationService.save((Object)exportConfiguration, false);
        logger.info("Processing route {} completed.", (Object)exchange.getFromRouteId());
    }

    public void setExportConfigurationService(ImportExportConfigurationService<ExportConfiguration> exportConfigurationService) {
        this.exportConfigurationService = exportConfigurationService;
    }

    public void setExecutionsHistorySize(int executionsHistorySize) {
        this.executionsHistorySize = executionsHistorySize;
    }
}

