/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationResponseHeaderDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="rest")
@XmlRootElement(name="responseMessage")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestOperationResponseMsgDefinition {
    @XmlTransient
    private VerbDefinition verb;
    @XmlAttribute
    @Metadata(defaultValue="200")
    private String code = "200";
    @XmlAttribute(required=true)
    private String message = "success";
    @XmlAttribute
    @Metadata(defaultValue="")
    private String responseModel;
    @XmlElement(name="header")
    private List<RestOperationResponseHeaderDefinition> headers;

    public RestOperationResponseMsgDefinition(VerbDefinition verb) {
        this();
        this.verb = verb;
    }

    public RestOperationResponseMsgDefinition() {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResponseModel() {
        return this.responseModel != null ? this.responseModel : "";
    }

    public void setResponseModel(String responseModel) {
        this.responseModel = responseModel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<RestOperationResponseHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<RestOperationResponseHeaderDefinition> headers) {
        this.headers = headers;
    }

    public RestOperationResponseMsgDefinition code(int code) {
        this.setCode("" + code);
        return this;
    }

    public RestOperationResponseMsgDefinition code(String code) {
        this.setCode(code);
        return this;
    }

    public RestOperationResponseMsgDefinition message(String msg) {
        this.setMessage(msg);
        return this;
    }

    public RestOperationResponseMsgDefinition responseModel(Class<?> type) {
        this.setResponseModel(type.getCanonicalName());
        return this;
    }

    public RestOperationResponseHeaderDefinition header(String name) {
        if (this.headers == null) {
            this.headers = new ArrayList<RestOperationResponseHeaderDefinition>();
        }
        RestOperationResponseHeaderDefinition header = new RestOperationResponseHeaderDefinition(this);
        header.setName(name);
        this.headers.add(header);
        return header;
    }

    public RestDefinition endResponseMessage() {
        ObjectHelper.notEmpty(this.code, "code");
        ObjectHelper.notEmpty(this.message, "message");
        this.verb.getResponseMsgs().add(this);
        return this.verb.getRest();
    }
}

