/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.repository.WorkspaceRepositoryMarker;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

class WorkspaceRepositoryDynamic
extends BaseRepository
implements Repository,
WorkspaceRepositoryMarker {
    private final Workspace workspace;

    WorkspaceRepositoryDynamic(Workspace workspace) {
        this.workspace = workspace;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        List resources = this.workspace.getAllProjects().stream().map(Project::getResources).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Requirement, Collection<Capability>> result = requirements.stream().collect(Collectors.toMap(Function.identity(), requirement -> this.findProvider(resources, (Requirement)requirement), ResourceUtils::capabilitiesCombiner));
        return result;
    }

    private List<Capability> findProvider(Collection<? extends Resource> resources, Requirement requirement) {
        String namespace = requirement.getNamespace();
        return resources.stream().flatMap(resource -> ResourceUtils.capabilityStream(resource, namespace)).filter(ResourceUtils.matcher(requirement)).collect(ResourceUtils.toCapabilities());
    }

    public String toString() {
        return "Workspace";
    }
}

