/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.command.completers.InstalledRepoNameCompleter;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="feature-repo-remove", description="Remove features repository URLs from a cluster group")
@Service
public class RepoRemoveCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="repository", description="Name or url of the repository to remove", required=true, multiValued=false)
    @Completion(value=InstalledRepoNameCompleter.class)
    String repository;
    @Option(name="-u", aliases={"--uninstall-all"}, description="Uninstall all features contained in the features repositories", required=false, multiValued=false)
    boolean uninstall;
    @Reference
    private EventProducer eventProducer;
    @Reference
    private FeaturesService featuresService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + this.groupName);
        Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + this.groupName);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ArrayList<String> urls = new ArrayList<String>();
            Pattern pattern = Pattern.compile(this.repository);
            for (String repositoryUrl : clusterRepositories.keySet()) {
                String repositoryName = (String)clusterRepositories.get(repositoryUrl);
                if (repositoryName != null && !repositoryName.isEmpty()) {
                    Matcher nameMatcher = pattern.matcher(repositoryName);
                    if (nameMatcher.matches()) {
                        urls.add(repositoryUrl);
                        continue;
                    }
                    Matcher uriMatcher = pattern.matcher(repositoryUrl);
                    if (!uriMatcher.matches()) continue;
                    urls.add(repositoryUrl);
                    continue;
                }
                Matcher uriMatcher = pattern.matcher(repositoryUrl);
                if (!uriMatcher.matches()) continue;
                urls.add(repositoryUrl);
            }
            for (String url : urls) {
                boolean found = false;
                for (Object repository : clusterRepositories.keySet()) {
                    if (!this.repository.equals(url)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    Features repositoryModel = JaxbUtil.unmarshal(url, true);
                    clusterRepositories.remove(url);
                    for (Feature feature : repositoryModel.getFeature()) {
                        clusterFeatures.remove(feature.getName() + "/" + feature.getVersion());
                    }
                    ClusterRepositoryEvent event = new ClusterRepositoryEvent(url, RepositoryEvent.EventType.RepositoryRemoved);
                    event.setUninstall(this.uninstall);
                    event.setSourceGroup(group);
                    event.setSourceNode(this.clusterManager.getNode());
                    this.eventProducer.produce((Event)event);
                    continue;
                }
                System.err.println("Features repository URL " + url + " not found in cluster group " + this.groupName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }
}

