/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.util.Objects;
import org.javamoney.moneta.internal.loader.LoadableResource;
import org.javamoney.moneta.internal.loader.ResourceCache;
import org.javamoney.moneta.spi.LoadDataInformation;

public class LoadableResourceBuilder {
    private LoadDataInformation loadDataInformation;
    private ResourceCache cache;

    public LoadableResourceBuilder withLoadDataInformation(LoadDataInformation loadDataInformation) {
        this.loadDataInformation = loadDataInformation;
        return this;
    }

    public LoadableResourceBuilder withCache(ResourceCache cache) {
        this.cache = cache;
        return this;
    }

    public LoadableResource build() {
        if (Objects.isNull(this.cache)) {
            throw new IllegalStateException("The cache should be informed");
        }
        if (Objects.isNull(this.loadDataInformation)) {
            throw new IllegalStateException("The loadDataInformation should be informed");
        }
        return new LoadableResource(this.cache, this.loadDataInformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LoadableResourceBuilder.class.getName()).append('{').append(" loadDataInformation: ").append(this.loadDataInformation).append(',').append(" cache: ").append(this.loadDataInformation).append('}');
        return sb.toString();
    }
}

