/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.unomi.router.api.services.ProfileExportService;
import org.apache.unomi.router.core.processor.ExportRouteCompletionProcessor;
import org.apache.unomi.router.core.processor.LineBuildProcessor;
import org.apache.unomi.router.core.route.RouterAbstractRouteBuilder;
import org.apache.unomi.router.core.strategy.StringLinesAggregationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileExportProducerRouteBuilder
extends RouterAbstractRouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ProfileExportProducerRouteBuilder.class);
    private ExportRouteCompletionProcessor exportRouteCompletionProcessor;
    private ProfileExportService profileExportService;

    public ProfileExportProducerRouteBuilder(Map<String, String> kafkaProps, String configType) {
        super(kafkaProps, configType);
    }

    public void setProfileExportService(ProfileExportService profileExportService) {
        this.profileExportService = profileExportService;
    }

    public void configure() throws Exception {
        logger.info("Configure Recurrent Route 'Export :: Data Producer'");
        RouteDefinition rtDef = "kafka".equals(this.configType) ? this.from((Endpoint)((KafkaEndpoint)this.getEndpointURI("to", "direct:depositExportBuffer"))) : this.from((String)this.getEndpointURI("to", "direct:depositExportBuffer"));
        ((AggregateDefinition)((RouteDefinition)((RouteDefinition)rtDef.unmarshal((DataFormat)this.jacksonDataFormat)).process((Processor)new LineBuildProcessor(this.profileExportService))).aggregate((Expression)this.constant(true), (AggregationStrategy)new StringLinesAggregationStrategy()).completionPredicate(this.exchangeProperty("CamelSplitSize").isEqualTo((Object)this.exchangeProperty("CamelAggregatedSize"))).eagerCheckCompletion().process((Processor)this.exportRouteCompletionProcessor)).toD("${in.header.exportConfig.getProperty('destination')}");
    }

    public void setExportRouteCompletionProcessor(ExportRouteCompletionProcessor exportRouteCompletionProcessor) {
        this.exportRouteCompletionProcessor = exportRouteCompletionProcessor;
    }
}

