/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServletRequestForwardWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletRequestForwardWrapper.class.getName());
    private static final String JSON_CONTENT_TYPE_UTF8 = "application/json;charset=UTF-8";

    public HttpServletRequestForwardWrapper(HttpServletRequest request) {
        super(request);
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpServletRequestForwardWrapper requestWrapper = new HttpServletRequestForwardWrapper(request);
            requestWrapper.getServletContext().getContext("/cxs").getRequestDispatcher("/cxs" + request.getRequestURI()).forward((ServletRequest)requestWrapper, (ServletResponse)response);
        }
        catch (Throwable t) {
            logger.error("HttpServletRequestForwardWrapper failed to forward the request", t);
            response.sendError(500, "Internal server error");
        }
    }

    public String getHeader(String name) {
        if ("Content-Type".equals(name) || "content-type".equals(name)) {
            return JSON_CONTENT_TYPE_UTF8;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if ("Content-Type".equals(name) || "content-type".equals(name)) {
            return Collections.enumeration(Collections.singleton(JSON_CONTENT_TYPE_UTF8));
        }
        return super.getHeaders(name);
    }

    public String getContentType() {
        return JSON_CONTENT_TYPE_UTF8;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }
}

