/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractAdvice
implements CamelInternalProcessorAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(ContractAdvice.class);
    private Contract contract;

    public ContractAdvice(Contract contract) {
        this.contract = contract;
    }

    public Object before(Exchange exchange) throws Exception {
        if (!(exchange.getIn() instanceof DataTypeAware)) {
            return null;
        }
        try {
            DataType to = this.contract.getInputType();
            if (to != null) {
                DataTypeAware target = (DataTypeAware)((Object)exchange.getIn());
                DataType from = target.getDataType();
                if (!to.equals(from)) {
                    LOG.debug("Looking for transformer for INPUT: from='{}', to='{}'", (Object)from, (Object)to);
                    this.doTransform(exchange.getIn(), from, to);
                    target.setDataType(to);
                }
                if (this.contract.isValidateInput()) {
                    this.doValidate(exchange.getIn(), to);
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        return null;
    }

    public void after(Exchange exchange, Object data) throws Exception {
        Message target;
        if (exchange.isFailed()) {
            return;
        }
        Message message = target = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        if (!(target instanceof DataTypeAware)) {
            return;
        }
        try {
            DataType to = this.contract.getOutputType();
            if (to != null) {
                DataTypeAware typeAwareTarget = (DataTypeAware)((Object)target);
                DataType from = typeAwareTarget.getDataType();
                if (!to.equals(from)) {
                    LOG.debug("Looking for transformer for OUTPUT: from='{}', to='{}'", (Object)from, (Object)to);
                    this.doTransform(target, from, to);
                    typeAwareTarget.setDataType(to);
                }
                if (this.contract.isValidateOutput()) {
                    this.doValidate(target, to);
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    private void doTransform(Message message, DataType from, DataType to) throws Exception {
        if (from == null) {
            this.convertIfRequired(message, to);
            return;
        }
        this.convertIfRequired(message, from);
        if (this.applyMatchedTransformer(message, from, to)) {
            return;
        }
        if (from.isJavaType()) {
            this.convertIfRequired(message, to);
            return;
        }
        if (this.applyTransformerChain(message, from, to)) {
            return;
        }
        throw new IllegalArgumentException("No Transformer found for [from='" + from + "', to='" + to + "']");
    }

    private boolean convertIfRequired(Message message, DataType type) throws Exception {
        if (type != null && type.isJavaType() && type.getName() != null) {
            CamelContext context = message.getExchange().getContext();
            Class<?> typeJava = this.getClazz(type.getName(), context);
            if (!typeJava.isAssignableFrom(message.getBody().getClass())) {
                LOG.debug("Converting to '{}'", (Object)typeJava.getName());
                message.setBody(message.getMandatoryBody(typeJava));
                return true;
            }
        }
        return false;
    }

    private boolean applyTransformer(Transformer transformer, Message message, DataType from, DataType to) throws Exception {
        if (transformer != null) {
            LOG.debug("Applying transformer: from='{}', to='{}', transformer='{}'", new Object[]{from, to, transformer});
            transformer.transform(message, from, to);
            return true;
        }
        return false;
    }

    private boolean applyMatchedTransformer(Message message, DataType from, DataType to) throws Exception {
        Transformer transformer = message.getExchange().getContext().resolveTransformer(from, to);
        return this.applyTransformer(transformer, message, from, to);
    }

    private boolean applyTransformerChain(Message message, DataType from, DataType to) throws Exception {
        CamelContext context = message.getExchange().getContext();
        Transformer fromTransformer = context.resolveTransformer(from.getModel());
        Transformer toTransformer = context.resolveTransformer(to.getModel());
        if (fromTransformer != null && toTransformer != null) {
            LOG.debug("Applying transformer 1/2: from='{}', to='{}', transformer='{}'", new Object[]{from, to, fromTransformer});
            fromTransformer.transform(message, from, new DataType(Object.class));
            LOG.debug("Applying transformer 2/2: from='{}', to='{}', transformer='{}'", new Object[]{from, to, toTransformer});
            toTransformer.transform(message, new DataType(Object.class), to);
            return true;
        }
        return false;
    }

    private Class<?> getClazz(String type, CamelContext context) throws Exception {
        return context.getClassResolver().resolveMandatoryClass(type);
    }

    private void doValidate(Message message, DataType type) throws ValidationException {
        Validator validator = message.getExchange().getContext().resolveValidator(type);
        if (validator == null) {
            throw new ValidationException(message.getExchange(), String.format("No Validator found for '%s'", type));
        }
        LOG.debug("Applying validator: type='{}', validator='{}'", (Object)type, (Object)validator);
        validator.validate(message, type);
    }
}

