/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.impl;

import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.unomi.shell.migration.Migration;
import org.apache.unomi.shell.migration.service.MigrationContext;
import org.apache.unomi.shell.migration.utils.HttpRequestException;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.osgi.framework.BundleContext;

public class MigrationTo122
implements Migration {
    private CloseableHttpClient httpClient;
    private String esAddress;

    @Override
    public void execute(MigrationContext migrationContext, BundleContext bundleContext) throws IOException {
        this.httpClient = migrationContext.getHttpClient();
        this.esAddress = migrationContext.getConfigString("esAddress");
        this.deleteOldIndexTemplate(migrationContext);
    }

    private void deleteOldIndexTemplate(MigrationContext migrationContext) throws IOException {
        String oldMonthlyIndexTemplate = "context_monthlyindex";
        try {
            migrationContext.printMessage("Deleting old monthly index template " + oldMonthlyIndexTemplate);
            HttpUtils.executeDeleteRequest(this.httpClient, this.esAddress + "/_template/" + oldMonthlyIndexTemplate, null);
        }
        catch (HttpRequestException e) {
            if (e.getCode() == 404) {
                migrationContext.printMessage("Old monthly index template not found, skipping deletion");
            }
            throw e;
        }
    }
}

