/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;

public class ApiError {
    public static final ApiError NONE = new ApiError(Errors.NONE, null);
    private static final String CODE_KEY_NAME = "error_code";
    private static final String MESSAGE_KEY_NAME = "error_message";
    private final Errors error;
    private final String message;

    public static ApiError fromThrowable(Throwable t) {
        Errors error = Errors.forException(t);
        String message = error.message().equals(t.getMessage()) ? null : t.getMessage();
        return new ApiError(error, message);
    }

    public ApiError(Struct struct) {
        this.error = Errors.forCode(struct.getShort(CODE_KEY_NAME));
        this.message = struct.hasField(MESSAGE_KEY_NAME) ? struct.getString(MESSAGE_KEY_NAME) : null;
    }

    public ApiError(Errors error, String message) {
        this.error = error;
        this.message = message;
    }

    public void write(Struct struct) {
        struct.set(CODE_KEY_NAME, (Object)this.error.code());
        if (struct.hasField(MESSAGE_KEY_NAME) && this.message != null && this.error != Errors.NONE) {
            struct.set(MESSAGE_KEY_NAME, (Object)this.message);
        }
    }

    public boolean is(Errors error) {
        return this.error == error;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean isSuccess() {
        return this.is(Errors.NONE);
    }

    public Errors error() {
        return this.error;
    }

    public String message() {
        return this.message;
    }

    public String messageWithFallback() {
        if (this.message == null) {
            return this.error.message();
        }
        return this.message;
    }

    public ApiException exception() {
        return this.error.exception(this.message);
    }

    public String toString() {
        return "ApiError(error=" + (Object)((Object)this.error) + ", message=" + this.message + ")";
    }
}

