/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.HasName;
import io.github.classgraph.PackageInfoList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PackageInfo
implements Comparable<PackageInfo>,
HasName {
    private String name;
    private AnnotationInfoList annotationInfo;
    private PackageInfo parent;
    private Set<PackageInfo> children;
    private final Map<String, ClassInfo> memberClassNameToClassInfo = new HashMap<String, ClassInfo>();

    PackageInfo() {
    }

    PackageInfo(String packageName) {
        this.name = packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void addAnnotations(AnnotationInfoList packageAnnotations) {
        if (packageAnnotations != null && !packageAnnotations.isEmpty()) {
            if (this.annotationInfo == null) {
                this.annotationInfo = new AnnotationInfoList(packageAnnotations);
            } else {
                this.annotationInfo.addAll(packageAnnotations);
            }
        }
    }

    void addClassInfo(ClassInfo classInfo) {
        this.memberClassNameToClassInfo.put(classInfo.getName(), classInfo);
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationInfoList getAnnotationInfo() {
        return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : this.annotationInfo;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    public PackageInfo getParent() {
        return this.parent;
    }

    public PackageInfoList getChildren() {
        if (this.children == null) {
            return PackageInfoList.EMPTY_LIST;
        }
        PackageInfoList childrenSorted = new PackageInfoList((Collection<PackageInfo>)this.children);
        Collections.sort(childrenSorted, new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo o1, PackageInfo o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return childrenSorted;
    }

    public ClassInfo getClassInfo(String className) {
        return this.memberClassNameToClassInfo.get(className);
    }

    public ClassInfoList getClassInfo() {
        return new ClassInfoList(new HashSet<ClassInfo>(this.memberClassNameToClassInfo.values()), true);
    }

    private void getClassInfoRecursive(Set<ClassInfo> reachableClassInfo) {
        reachableClassInfo.addAll(this.memberClassNameToClassInfo.values());
        for (PackageInfo subPackageInfo : this.getChildren()) {
            subPackageInfo.getClassInfoRecursive(reachableClassInfo);
        }
    }

    public ClassInfoList getClassInfoRecursive() {
        HashSet<ClassInfo> reachableClassInfo = new HashSet<ClassInfo>();
        this.getClassInfoRecursive(reachableClassInfo);
        return new ClassInfoList(reachableClassInfo, true);
    }

    static PackageInfo getPackage(String packageName, Map<String, PackageInfo> packageNameToPackageInfo) {
        PackageInfo packageInfo = packageNameToPackageInfo.get(packageName);
        if (packageInfo != null) {
            return packageInfo;
        }
        packageInfo = new PackageInfo(packageName);
        packageNameToPackageInfo.put(packageName, packageInfo);
        if (!packageInfo.name.isEmpty()) {
            int lastDotIdx = packageInfo.name.lastIndexOf(46);
            String parentPackageName = lastDotIdx < 0 ? "" : packageInfo.name.substring(0, lastDotIdx);
            PackageInfo parentPackageInfo = PackageInfo.getPackage(parentPackageName, packageNameToPackageInfo);
            if (parentPackageInfo.children == null) {
                parentPackageInfo.children = new HashSet<PackageInfo>();
            }
            parentPackageInfo.children.add(packageInfo);
            packageInfo.parent = parentPackageInfo;
        }
        return packageInfo;
    }

    @Override
    public int compareTo(PackageInfo o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageInfo)) {
            return false;
        }
        return this.name.equals(((PackageInfo)o).name);
    }

    public String toString() {
        return this.name;
    }
}

