/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ResourceModel
extends AbstractReadOnlyModel<String>
implements IComponentAssignedModel<String> {
    private static final long serialVersionUID = 1L;
    private final String resourceKey;
    private final IModel<String> defaultValue;

    public ResourceModel(String resourceKey) {
        this(resourceKey, (IModel<String>)null);
    }

    public ResourceModel(String resourceKey, String defaultValue) {
        this(resourceKey, Model.of(defaultValue));
    }

    public ResourceModel(String resourceKey, IModel<String> defaultValue) {
        this.resourceKey = resourceKey;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getObject() {
        return Application.get().getResourceSettings().getLocalizer().getString(this.resourceKey, null, null, null, null, this.defaultValue);
    }

    @Override
    public IWrapModel<String> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component);
    }

    private class AssignmentWrapper
    extends LoadableDetachableModel<String>
    implements IWrapModel<String> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(Component component) {
            this.component = component;
        }

        @Override
        public IModel<String> getWrappedModel() {
            return ResourceModel.this;
        }

        @Override
        protected String load() {
            return Application.get().getResourceSettings().getLocalizer().getString(ResourceModel.this.resourceKey, this.component, null, null, null, ResourceModel.this.defaultValue);
        }

        @Override
        protected void onDetach() {
            ResourceModel.this.detach();
        }
    }
}

