MOD=ft2demos
VER=2.3.8
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

# We use a string of hex digits to make it more evident that it is
# just a hash value and not supposed to be relevant at end-user
# machines.
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemsvs6

(

set -x

FREETYPE=`latest --arch=${ARCH} freetype`

# Don't build ftgrid as it uses debugging-only API not in my build of freetype
patch -p0 <<'EOF'
--- Makefile
+++ Makefile
@@ -249,7 +249,7 @@
   EXES := ftlint ftmemchk ftdump testname fttimer ftbench ftchkwd ftpatchk
 
   # Comment out the next line if you don't have a graphics subsystem.
-  EXES += ftview ftmulti ftstring ftgamma ftgrid ftdiff
+  EXES += ftview ftmulti ftstring ftgamma ftdiff
 
   # ftvalid requires ftgxval.c and ftotval.c
   #
EOF

make -j3 TOP_DIR=../../freetype2/${VER}-${REV}_${ARCH}

# My helper scripts wants something to be "installed" but ft2demos has no "make install"...
mkdir -p /devel/target/$HEX/bin
cp bin/.libs/*.exe /devel/target/$HEX/bin

# Generate zip archive distribution

cd /devel/target/$HEX
rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&
zip /tmp/$RUNZIP bin/*.exe &&

# Nothing in the dev package as ft2demos is a set of demo or developer
# tools, and not a library, but for consistency I make one anyway
zip /tmp/$DEVZIP nul: &&
zip -d /tmp/$DEVZIP nul:.

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
