/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.hierarchy.View;

public class CellName {
    private String name;
    private View view;
    private int version;

    private CellName() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public View getView() {
        return this.view;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return this.name + ";" + this.version + "{" + this.view.getAbbreviation() + "}";
    }

    public static CellName parseName(String name) {
        CellName n = new CellName();
        n.view = View.UNKNOWN;
        int openCurly = name.indexOf(123);
        int closeCurly = name.lastIndexOf(125);
        if (openCurly != -1 && closeCurly != -1) {
            String viewName = name.substring(openCurly + 1, closeCurly);
            n.view = View.findView(viewName);
            if (n.view == null) {
                System.out.println("Unknown view: " + viewName);
                return null;
            }
        }
        n.version = 0;
        int semiColon = name.indexOf(59);
        if (semiColon != -1) {
            String versionString = openCurly > semiColon ? name.substring(semiColon + 1, openCurly) : name.substring(semiColon + 1);
            n.version = Integer.parseInt(versionString);
            if (n.version <= 0) {
                System.out.println("Cell versions must be positive, this is " + n.version);
                return null;
            }
        }
        if (semiColon == -1) {
            semiColon = name.length();
        }
        if (openCurly == -1) {
            openCurly = name.length();
        }
        int nameEnd = Math.min(semiColon, openCurly);
        n.name = name.substring(0, nameEnd);
        return n;
    }
}

