/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.tool.generator.layout.LayoutLib;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class Messenger {
    private PrintStream logStrm;

    public Messenger(boolean logToFile) {
        if (logToFile) {
            File f = new File("nccLog.txt");
            String fileName = f.getAbsolutePath();
            FileOutputStream fileStrm = null;
            try {
                fileStrm = new FileOutputStream(f);
            }
            catch (Exception e) {
                String msg = "can't write to log file: " + fileName;
                throw new RuntimeException(msg);
            }
            BufferedOutputStream bufStrm = new BufferedOutputStream(fileStrm);
            this.logStrm = new PrintStream(bufStrm);
            Date d = new Date();
            this.logStrm.println(fileName + " file started " + d);
        }
    }

    public void print(String s) {
        System.out.print(s);
        if (this.logStrm != null) {
            this.logStrm.print(s);
        }
    }

    public void println(String s) {
        System.out.println(s);
        if (this.logStrm != null) {
            this.logStrm.println(s);
        }
    }

    public void println() {
        System.out.println();
        if (this.logStrm != null) {
            this.logStrm.println("");
        }
    }

    public void flush() {
        System.out.flush();
        if (this.logStrm != null) {
            this.logStrm.flush();
        }
    }

    public void error(boolean pred, String msg) {
        this.flush();
        if (pred) {
            this.println(msg);
        }
        LayoutLib.error(pred, msg);
    }
}

