/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class OpenFile {
    public static String chooseInputFile(Type type, String title) {
        if (title == null) {
            title = "Open file";
            if (type != null) {
                title = "Open " + type.getDescription();
            }
        }
        boolean useSwing = true;
        if (TopLevel.getOperatingSystem() == TopLevel.OS.MACINTOSH) {
            useSwing = false;
        }
        if (useSwing) {
            OpenFileSwing dialog = new OpenFileSwing();
            dialog.saveDialog = false;
            dialog.setDialogTitle(title);
            dialog.setFileFilter(type.getFileFilterSwing());
            dialog.setCurrentDirectory(new File(User.getWorkingDirectory()));
            int returnVal = dialog.showOpenDialog(null);
            if (returnVal == 0) {
                File file = dialog.getSelectedFile();
                return file.getPath();
            }
            return null;
        }
        FileDialog dialog = new FileDialog((Frame)TopLevel.getCurrentJFrame(), title, 0);
        dialog.setDirectory(User.getWorkingDirectory());
        dialog.setFilenameFilter(type.getFileFilterAWT());
        dialog.setVisible(true);
        String fileName = dialog.getFile();
        if (fileName == null) {
            return null;
        }
        User.setWorkingDirectory(dialog.getDirectory());
        return dialog.getDirectory() + fileName;
    }

    public static String chooseOutputFile(Type type, String title, String defaultFile) {
        if (title != null) {
            title = type != null ? "Write " + type.getDescription() : "Write file";
        }
        boolean useSwing = true;
        if (TopLevel.getOperatingSystem() == TopLevel.OS.MACINTOSH) {
            useSwing = false;
        }
        if (useSwing) {
            OpenFileSwing dialog = new OpenFileSwing();
            dialog.saveDialog = true;
            dialog.setDialogTitle(title);
            dialog.setFileFilter(type.getFileFilterSwing());
            dialog.addChoosableFileFilter(type.getFileFilterSwing());
            dialog.setCurrentDirectory(new File(User.getWorkingDirectory()));
            dialog.setSelectedFile(new File(defaultFile));
            int returnVal = dialog.showSaveDialog(null);
            if (returnVal == 0) {
                File file = dialog.getSelectedFile();
                return file.getPath();
            }
            return null;
        }
        FileDialog awtDialog = new FileDialog((Frame)TopLevel.getCurrentJFrame(), title, 1);
        awtDialog.setDirectory(User.getWorkingDirectory());
        awtDialog.setFile(defaultFile);
        awtDialog.setFilenameFilter(type.getFileFilterAWT());
        awtDialog.setVisible(true);
        String fileName = awtDialog.getFile();
        if (fileName == null) {
            return null;
        }
        return awtDialog.getDirectory() + fileName;
    }

    private static class OpenFileSwing
    extends JFileChooser {
        private boolean saveDialog;

        private OpenFileSwing() {
        }

        public void approveSelection() {
            File f = this.getSelectedFile();
            if (this.saveDialog) {
                int result;
                String filename = f.getName();
                if (f.exists() && (result = JOptionPane.showConfirmDialog(this, "The file " + filename + " already exists, would you like to overwrite it?", "Overwrite?", 0, 2)) != 0) {
                    return;
                }
            }
            this.setSelectedFile(f);
            User.setWorkingDirectory(this.getCurrentDirectory().getPath());
            super.approveSelection();
        }
    }

    private static class FileFilterAWT
    implements FilenameFilter {
        private String[] extensions;
        private String desc;

        public FileFilterAWT(String[] extensions, String desc) {
            this.extensions = extensions;
            this.desc = desc;
        }

        public boolean accept(File f, String filename) {
            if (this.extensions.length == 0) {
                return true;
            }
            int i = filename.lastIndexOf(46);
            if (i < 0) {
                return false;
            }
            String thisExtension = filename.substring(i + 1);
            if (thisExtension == null) {
                return false;
            }
            for (int j = 0; j < this.extensions.length; ++j) {
                String extension = this.extensions[j];
                if (!extension.equalsIgnoreCase(thisExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    private static class FileFilterSwing
    extends FileFilter {
        private String[] extensions;
        private String desc;

        public FileFilterSwing(String[] extensions, String desc) {
            this.extensions = extensions;
            this.desc = desc;
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            if (this.extensions.length == 0) {
                return true;
            }
            String filename = f.getName();
            int i = filename.lastIndexOf(46);
            if (i < 0) {
                return false;
            }
            String thisExtension = filename.substring(i + 1);
            if (thisExtension == null) {
                return false;
            }
            for (int j = 0; j < this.extensions.length; ++j) {
                String extension = this.extensions[j];
                if (!extension.equalsIgnoreCase(thisExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    public static class Type {
        public static final Type ANY = new Type("All", new String[0], "All Files");
        public static final Type ELIB = new Type("ELIB", new String[]{"elib"}, "Library File (elib)");
        public static final Type TEXT = new Type("Text", new String[]{"txt"}, "Text File (txt)");
        public static final Type HTML = new Type("HTML", new String[]{"html"}, "HTML File (html)");
        public static final Type READABLEDUMP = new Type("ReadableDump", new String[]{"txt"}, "Readable Dump Library File (txt)");
        public static final Type CIF = new Type("CIF", new String[]{"cif"}, "CIF File (cif)");
        public static final Type GDS = new Type("GDS", new String[]{"gds"}, "GDS File (gds)");
        public static final Type POSTSCRIPT = new Type("PostScript", new String[]{"ps"}, "PostScript (ps)");
        public static final Type SPICE = new Type("Spice", new String[]{"spi", "sp"}, "Spice Deck (spi, sp)");
        public static final Type SPICEOUT = new Type("SpiceOutput", new String[]{"spo"}, "Spice/GNUCap Output FIle (spo)");
        public static final Type PSPICEOUT = new Type("PSpiceOutput", new String[]{"spo"}, "PSpice/Spice3 Output FIle (spo)");
        public static final Type HSPICEOUT = new Type("HSpiceOutput", new String[]{"tr0", "pa0"}, "HSpice Output File (tr0/pa0)");
        public static final Type RAWSPICEOUT = new Type("RawSpiceOutput", new String[]{"raw"}, "Spice Raw Output File (raw)");
        public static final Type RAWSSPICEOUT = new Type("RawSmartSpiceOutput", new String[]{"raw"}, "SmartSPICE Raw Output File (raw)");
        public static final Type CDL = new Type("CDL", new String[]{"cdl"}, "CDL Deck (cdl)");
        public static final Type VERILOG = new Type("Verilog", new String[]{"v"}, "Verilog Deck (v)");
        public static final Type VERILOGOUT = new Type("VerilogOutput", new String[]{"dump"}, "Verilog VCD Dump (vcd)");
        public static final Type MAXWELL = new Type("Maxwell", new String[]{"mac"}, "Maxwell Deck (mac)");
        public static final Type IRSIM = new Type("IRSIM", new String[]{"sim"}, "IRSIM Deck (sim)");
        public static final Type JAVA = new Type("Java", new String[]{"java", "bsh"}, "Java Script File (java, bsh)");
        public static final Type PADARR = new Type("PadArray", new String[]{"arr"}, "Pad Generator Array File (arr)");
        private final String name;
        private final String[] extensions;
        private final String desc;
        private FileFilterSwing ffs;
        private FileFilterAWT ffa;

        private Type(String name, String[] extensions, String desc) {
            this.name = name;
            this.extensions = extensions;
            this.desc = desc;
            this.ffs = null;
            this.ffa = null;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public FileFilterSwing getFileFilterSwing() {
            if (this.ffs == null) {
                this.ffs = new FileFilterSwing(this.extensions, this.desc);
            }
            return this.ffs;
        }

        public FileFilterAWT getFileFilterAWT() {
            if (this.ffa == null) {
                this.ffa = new FileFilterAWT(this.extensions, this.desc);
            }
            return this.ffa;
        }

        public String toString() {
            return this.name;
        }
    }
}

