/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.tree.DefaultMutableTreeNode;

public class EditWindow
extends JPanel
implements WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener,
HighlightListener {
    private double scale;
    private double offx = 0.0;
    private double offy = 0.0;
    private Rectangle2D databaseBounds;
    private Dimension sz;
    private Cell cell;
    private VarContext cellVarContext;
    private WindowFrame wf;
    private PixelDrawing offscreen = null;
    private JPanel overall;
    private JScrollBar bottomScrollBar;
    private JScrollBar rightScrollBar;
    private boolean showGrid = false;
    private double gridXSpacing;
    private double gridYSpacing;
    private boolean doingAreaDrag = false;
    private Point startDrag = new Point();
    private Point endDrag = new Point();
    private boolean showPopupCloud = false;
    private List popupCloudText;
    private Point2D popupCloudPoint;
    private static List redrawThese = new ArrayList();
    private static EditWindow runningNow = null;
    private static final int SCROLLBARRESOLUTION = 200;
    private static final BasicStroke selectionLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 3.0f);
    private int lastXPosition;
    private int lastYPosition;
    private List crossProbeObjects = new ArrayList();
    private static final double FRAMESCALE = 18.0;
    private static final double HASCHXSIZE = 153.0;
    private static final double HASCHYSIZE = 99.0;
    private static final double ASCHXSIZE = 198.0;
    private static final double ASCHYSIZE = 153.0;
    private static final double BSCHXSIZE = 306.0;
    private static final double BSCHYSIZE = 198.0;
    private static final double CSCHXSIZE = 432.0;
    private static final double CSCHYSIZE = 306.0;
    private static final double DSCHXSIZE = 648.0;
    private static final double DSCHYSIZE = 432.0;
    private static final double ESCHXSIZE = 864.0;
    private static final double ESCHYSIZE = 648.0;
    private static final double FRAMEWID = 2.6999999999999997;
    private static final double XLOGOBOX = 36.0;
    private static final double YLOGOBOX = 18.0;
    private List foundInCell;
    private StringsInCell currentStringInCell;
    private int currentFindPosition;
    private Rectangle2D lastOverallBounds = null;
    private Point2D lastOffset = null;
    private static final double scrollPagePercent = 0.2;
    private List cellHistory;
    private int cellHistoryLocation;
    public static final String propGoBackEnabled = "GoBackEnabled";
    public static final String propGoForwardEnabled = "GoForwardEnabled";
    private static final int cellHistoryLimit = 20;

    private EditWindow(Cell cell, WindowFrame wf) {
        this.cell = cell;
        this.wf = wf;
        this.gridXSpacing = User.getDefGridXSpacing();
        this.gridYSpacing = User.getDefGridYSpacing();
        this.sz = new Dimension(500, 500);
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.databaseBounds = new Rectangle2D.Double();
        this.cellHistory = new ArrayList();
        this.cellHistoryLocation = -1;
        this.overall = new JPanel();
        this.overall.setLayout(new GridBagLayout());
        int thumbSize = 10;
        this.bottomScrollBar = new JScrollBar(0, 100, thumbSize, 0, 200 + thumbSize);
        this.bottomScrollBar.setBlockIncrement(50);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.overall.add((Component)this.bottomScrollBar, gbc);
        this.bottomScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.bottomScrollBar.setValue(this.bottomScrollBar.getMaximum() / 2);
        this.rightScrollBar = new JScrollBar(1, 100, thumbSize, 0, 200 + thumbSize);
        this.rightScrollBar.setBlockIncrement(50);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.overall.add((Component)this.rightScrollBar, gbc);
        this.rightScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.rightScrollBar.setValue(this.rightScrollBar.getMaximum() / 2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.overall.add((Component)this, gbc);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        Highlight.addHighlightListener(this);
        if (wf != null) {
            this.setCell(cell, VarContext.globalContext);
        }
    }

    public static EditWindow CreateElectricDoc(Cell cell, WindowFrame wf) {
        EditWindow ui = new EditWindow(cell, wf);
        return ui;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Cell cell = (Cell)NodeProto.findNodeProto(source.getText());
        if (cell == null) {
            return;
        }
        this.setCell(cell, VarContext.globalContext);
    }

    public void mousePressed(MouseEvent evt) {
        MessagesWindow.userCommandIssued();
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        WindowFrame.setCurrentWindowFrame(wnd.wf);
        WindowFrame.curMouseListener.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseReleased(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseClicked(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseListener.mouseEntered(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseExited(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseMoved(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseDragged(evt);
    }

    private void showCoordinates(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            StatusBar.setCoordinates("(" + TextUtils.formatDouble(pt.getX(), 2) + "," + TextUtils.formatDouble(pt.getY(), 2) + ")", wnd.wf);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.curMouseWheelListener.mouseWheelMoved(evt);
    }

    public void keyPressed(KeyEvent evt) {
        MessagesWindow.userCommandIssued();
        WindowFrame.curKeyListener.keyPressed(evt);
    }

    public void keyReleased(KeyEvent evt) {
        WindowFrame.curKeyListener.keyReleased(evt);
    }

    public void keyTyped(KeyEvent evt) {
        WindowFrame.curKeyListener.keyTyped(evt);
    }

    public void highlightChanged() {
        this.repaint();
    }

    public Point getLastMousePosition() {
        return new Point(this.lastXPosition, this.lastYPosition);
    }

    public JPanel getPanel() {
        return this.overall;
    }

    public static EditWindow getCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return null;
        }
        if (wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        return null;
    }

    public static EditWindow needCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        System.out.println("There is no current window for this operation");
        return null;
    }

    public Cell getCell() {
        return this.cell;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public void setCell(Cell cell, VarContext context) {
        this.setCell(cell, context, true);
    }

    private void setCell(Cell cell, VarContext context, boolean addToHistory) {
        this.saveCurrentCellHistoryState();
        this.cell = cell;
        this.cellVarContext = context;
        Library curLib = Library.getCurrent();
        curLib.setCurCell(cell);
        Highlight.clear();
        Highlight.finished();
        this.setWindowTitle();
        if (this.wf != null && cell != null && this.wf == WindowFrame.getCurrentWindowFrame()) {
            PaletteFrame.autoTechnologySwitch(cell);
        }
        this.fillScreen();
        if (addToHistory) {
            this.addToHistory(cell, context);
        }
        if (cell != null && User.isCheckCellDates()) {
            cell.checkCellDates();
        }
        this.clearCrossProbeLevels();
    }

    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, ""));
    }

    public static EditWindow findWindow(Cell cell) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || content.getCell() != cell) continue;
            return (EditWindow)content;
        }
        return null;
    }

    public PixelDrawing getOffscreen() {
        return this.offscreen;
    }

    public void loadExplorerTree(DefaultMutableTreeNode rootNode) {
        this.wf.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        this.wf.jobExplorerNode = Job.getExplorerTree();
        this.wf.errorExplorerNode = ErrorLogger.getExplorerTree();
        this.wf.signalExplorerNode = null;
        rootNode.add(this.wf.libraryExplorerNode);
        rootNode.add(this.wf.jobExplorerNode);
        rootNode.add(this.wf.errorExplorerNode);
    }

    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        Highlight.removeHighlightListener(this);
    }

    public static int getScrollBarResolution() {
        return 200;
    }

    public JScrollBar getBottomScrollBar() {
        return this.bottomScrollBar;
    }

    public JScrollBar getRightScrollBar() {
        return this.rightScrollBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Image img;
        if (this.cell != null && this.cell == WindowFrame.getCurrentCell()) {
            this.requestFocus();
        }
        this.wf.redoExplorerTreeIfRequested();
        if (this.offscreen == null || !this.getSize().equals(this.sz)) {
            this.setScreenSize(this.getSize());
            this.repaintContents(null);
            return;
        }
        Image image = img = this.offscreen.getImage();
        synchronized (image) {
            g.drawImage(img, 0, 0, this);
        }
        if (this.cell != null) {
            if (this.showGrid) {
                this.drawGrid(g);
            }
            this.drawCellFrame(g);
            this.showCrossProbeLevels(g);
            long start = System.currentTimeMillis();
            Iterator it = Highlight.getHighlights();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                Cell highCell = h.getCell();
                if (highCell != this.cell) continue;
                h.showHighlight(this, g);
            }
            long end = System.currentTimeMillis();
            if (this.doingAreaDrag) {
                this.showDragBox(g);
            }
            if (this.showPopupCloud) {
                this.drawPopupCloud((Graphics2D)g);
            }
        }
    }

    public void fullRepaint() {
        this.repaintContents(null);
    }

    public static void repaintAllContents() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaintContents(null);
        }
    }

    public static void repaintAll() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintContents(Rectangle2D bounds) {
        if (this.offscreen == null) {
            return;
        }
        this.setScrollPosition();
        List list = redrawThese;
        synchronized (list) {
            if (runningNow != null) {
                if (runningNow != this && !redrawThese.contains(this)) {
                    redrawThese.add(this);
                }
                return;
            }
            runningNow = this;
        }
        RenderJob renderJob = new RenderJob(this, this.offscreen, bounds);
    }

    public Image renderNode(NodeInst ni, double scale) {
        this.offscreen.clearImage(false);
        this.setScale(scale);
        this.offscreen.drawNode(ni, DBMath.MATID, true, null);
        return this.offscreen.composite();
    }

    public Image renderArc(ArcInst ai, double scale) {
        this.offscreen.clearImage(false);
        this.setScale(scale);
        this.offscreen.drawArc(ai, DBMath.MATID);
        return this.offscreen.composite();
    }

    public void clearCrossProbeLevels() {
        this.crossProbeObjects.clear();
    }

    public boolean hasCrossProbeData() {
        return this.crossProbeObjects.size() > 0;
    }

    public void addCrossProbeLine(Point2D start, Point2D end, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = true;
        cp.start = start;
        cp.end = end;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    public void addCrossProbeBox(Rectangle2D box, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = false;
        cp.box = box;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    private void showCrossProbeLevels(Graphics g) {
        Iterator it = this.crossProbeObjects.iterator();
        while (it.hasNext()) {
            Point pE;
            Point pS;
            CrossProbe cp = (CrossProbe)it.next();
            g.setColor(cp.color);
            if (cp.isLine) {
                pS = this.databaseToScreen(cp.start);
                pE = this.databaseToScreen(cp.end);
                g.drawLine(pS.x, pS.y, pE.x, pE.y);
                continue;
            }
            pS = this.databaseToScreen(cp.box.getMinX(), cp.box.getMinY());
            pE = this.databaseToScreen(cp.box.getMaxX(), cp.box.getMaxY());
            int lX = Math.min(pS.x, pE.x);
            int lY = Math.min(pS.y, pE.y);
            int wid = Math.abs(pS.x - pE.x);
            int hei = Math.abs(pS.y - pE.y);
            g.fillRect(lX, lY, wid, hei);
        }
    }

    public boolean isDoingAreaDrag() {
        return this.doingAreaDrag;
    }

    public void setDoingAreaDrag() {
        this.doingAreaDrag = true;
    }

    public void clearDoingAreaDrag() {
        this.doingAreaDrag = false;
    }

    public Point getStartDrag() {
        return this.startDrag;
    }

    public void setStartDrag(int x, int y) {
        this.startDrag.setLocation(x, y);
    }

    public Point getEndDrag() {
        return this.endDrag;
    }

    public void setEndDrag(int x, int y) {
        this.endDrag.setLocation(x, y);
    }

    private void showDragBox(Graphics g) {
        int lX = (int)Math.min(this.startDrag.getX(), this.endDrag.getX());
        int hX = (int)Math.max(this.startDrag.getX(), this.endDrag.getX());
        int lY = (int)Math.min(this.startDrag.getY(), this.endDrag.getY());
        int hY = (int)Math.max(this.startDrag.getY(), this.endDrag.getY());
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(selectionLine);
        g.setColor(Color.white);
        g.drawLine(lX, lY, lX, hY);
        g.drawLine(lX, hY, hX, hY);
        g.drawLine(hX, hY, hX, lY);
        g.drawLine(hX, lY, lX, lY);
    }

    public int getCellFrameInfo(Dimension d) {
        Variable var = this.cell.getVar(User.FRAME_SIZE, String.class);
        if (var == null) {
            return 2;
        }
        String frameInfo = (String)var.getObject();
        if (frameInfo.length() == 0) {
            return 2;
        }
        int retval = 0;
        char chr = frameInfo.charAt(0);
        double wid = 0.0;
        double hei = 0.0;
        if (chr == 'x') {
            wid = 38.7;
            hei = 20.7;
            retval = 1;
        } else {
            switch (chr) {
                case 'h': {
                    wid = 153.0;
                    hei = 99.0;
                    break;
                }
                case 'a': {
                    wid = 198.0;
                    hei = 153.0;
                    break;
                }
                case 'b': {
                    wid = 306.0;
                    hei = 198.0;
                    break;
                }
                case 'c': {
                    wid = 432.0;
                    hei = 306.0;
                    break;
                }
                case 'd': {
                    wid = 648.0;
                    hei = 432.0;
                    break;
                }
                case 'e': {
                    wid = 864.0;
                    hei = 648.0;
                }
            }
        }
        if (frameInfo.indexOf("v") >= 0) {
            d.setSize(hei, wid);
        } else {
            d.setSize(wid, hei);
        }
        return retval;
    }

    private void drawCellFrame(Graphics g) {
        Dimension d = new Dimension();
        int frameFactor = this.getCellFrameInfo(d);
        if (frameFactor == 2) {
            return;
        }
        Variable var = this.cell.getVar(User.FRAME_SIZE, String.class);
        if (var == null) {
            return;
        }
        String frameInfo = (String)var.getObject();
        double schXSize = d.getWidth();
        double schYSize = d.getHeight();
        boolean drawTitleBox = true;
        int xSections = 8;
        int ySections = 4;
        if (frameFactor == 1) {
            ySections = 0;
            xSections = 0;
        } else {
            if (frameInfo.indexOf("v") >= 0) {
                xSections = 4;
                ySections = 8;
            }
            if (frameInfo.indexOf("n") >= 0) {
                drawTitleBox = false;
            }
        }
        double xLogoBox = 36.0;
        double yLogoBox = 18.0;
        double frameWid = 2.6999999999999997;
        g.setColor(Color.BLACK);
        if (xSections > 0) {
            char chr;
            int i;
            double xSecSize = (schXSize - frameWid * 2.0) / (double)xSections;
            double ySecSize = (schYSize - frameWid * 2.0) / (double)ySections;
            Point2D.Double point0 = new Point2D.Double(-schXSize / 2.0, -schYSize / 2.0);
            Point2D.Double point1 = new Point2D.Double(-schXSize / 2.0, schYSize / 2.0);
            Point2D.Double point2 = new Point2D.Double(schXSize / 2.0, schYSize / 2.0);
            Point2D.Double point3 = new Point2D.Double(schXSize / 2.0, -schYSize / 2.0);
            this.showFrameLine(g, point0, point1);
            this.showFrameLine(g, point1, point2);
            this.showFrameLine(g, point2, point3);
            this.showFrameLine(g, point3, point0);
            point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, -schYSize / 2.0 + frameWid);
            point1 = new Point2D.Double(-schXSize / 2.0 + frameWid, schYSize / 2.0 - frameWid);
            point2 = new Point2D.Double(schXSize / 2.0 - frameWid, schYSize / 2.0 - frameWid);
            point3 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
            this.showFrameLine(g, point0, point1);
            this.showFrameLine(g, point1, point2);
            this.showFrameLine(g, point2, point3);
            this.showFrameLine(g, point3, point0);
            Point textSize = this.deltaDatabaseToScreen(frameWid, frameWid);
            int height = (int)Math.abs(((Point2D)textSize).getY()) - 2;
            for (i = 0; i < xSections; ++i) {
                double x = (double)i * xSecSize - (schXSize / 2.0 - frameWid);
                if (i > 0) {
                    point0 = new Point2D.Double(x, schYSize / 2.0 - frameWid);
                    point1 = new Point2D.Double(x, schYSize / 2.0 - frameWid / 2.0);
                    this.showFrameLine(g, point0, point1);
                    point0 = new Point2D.Double(x, -schYSize / 2.0 + frameWid);
                    point1 = new Point2D.Double(x, -schYSize / 2.0 + frameWid / 2.0);
                    this.showFrameLine(g, point0, point1);
                }
                chr = (char)(49 + xSections - i - 1);
                point0 = new Point2D.Double(x + xSecSize / 2.0, schYSize / 2.0 - frameWid / 2.0);
                this.showFrameText(g, point0, height, 0.0, 0.0, String.valueOf(chr));
                point0 = new Point2D.Double(x + xSecSize / 2.0, -schYSize / 2.0 + frameWid / 2.0);
                this.showFrameText(g, point0, height, 0.0, 0.0, String.valueOf(chr));
            }
            for (i = 0; i < ySections; ++i) {
                double y = (double)i * ySecSize - (schYSize / 2.0 - frameWid);
                if (i > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid, y);
                    point1 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y);
                    this.showFrameLine(g, point0, point1);
                    point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, y);
                    point1 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y);
                    this.showFrameLine(g, point0, point1);
                }
                chr = (char)(65 + i);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y + ySecSize / 2.0);
                this.showFrameText(g, point0, height, 0.0, 0.0, String.valueOf(chr));
                point0 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y + ySecSize / 2.0);
                this.showFrameText(g, point0, height, 0.0, 0.0, String.valueOf(chr));
            }
        }
        if (drawTitleBox) {
            Point textSize = this.deltaDatabaseToScreen(yLogoBox * 2.0 / 15.0, yLogoBox * 2.0 / 15.0);
            int height = (int)Math.abs(((Point2D)textSize).getY());
            Point2D.Double point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox);
            Point2D.Double point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox);
            Point2D.Double point2 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
            Point2D.Double point3 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid);
            this.showFrameLine(g, point0, point1);
            this.showFrameLine(g, point1, point2);
            this.showFrameLine(g, point2, point3);
            this.showFrameLine(g, point3, point0);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
            point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
            this.showFrameLine(g, point0, point1);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
            point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
            this.showFrameLine(g, point0, point1);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
            point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
            this.showFrameLine(g, point0, point1);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
            point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
            this.showFrameLine(g, point0, point1);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
            point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
            this.showFrameLine(g, point0, point1);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 13.5 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 3.0 / 15.0, "Name: " + this.cell.describe());
            String projectName = User.getFrameProjectName();
            Variable pVar = this.cell.getLibrary().getVar(User.FRAME_PROJECT_NAME, String.class);
            if (pVar != null) {
                projectName = (String)pVar.getObject();
            }
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 10.5 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 3.0 / 15.0, projectName);
            String designerName = User.getFrameDesignerName();
            Variable dVar = this.cell.getLibrary().getVar(User.FRAME_DESIGNER_NAME, String.class);
            if (dVar != null) {
                designerName = (String)dVar.getObject();
            }
            if ((dVar = this.cell.getVar(User.FRAME_DESIGNER_NAME, String.class)) != null) {
                designerName = (String)dVar.getObject();
            }
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 7.5 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 3.0 / 15.0, designerName);
            String companyName = User.getFrameCompanyName();
            Variable cVar = this.cell.getLibrary().getVar(User.FRAME_COMPANY_NAME, String.class);
            if (cVar != null) {
                companyName = (String)cVar.getObject();
            }
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 5.0 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 2.0 / 15.0, companyName);
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 3.0 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 2.0 / 15.0, "Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
            point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 1.0 / 15.0);
            this.showFrameText(g, point0, height, xLogoBox, yLogoBox * 2.0 / 15.0, "Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
        }
    }

    private void showFrameLine(Graphics g, Point2D from, Point2D to) {
        Point f = this.databaseToScreen(from);
        Point t = this.databaseToScreen(to);
        g.drawLine(f.x, f.y, t.x, t.y);
    }

    private void showFrameText(Graphics g, Point2D ctr, int initialHeight, double maxWid, double maxHei, String string) {
        Font font = new Font(User.getDefaultFont(), 0, initialHeight);
        g.setFont(font);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = font.createGlyphVector(frc, string);
        LineMetrics lm = font.getLineMetrics(string, frc);
        Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
        double width = rect.width;
        double height = lm.getHeight();
        Point2D databaseSize = this.deltaScreenToDatabase((int)width, (int)height);
        double dbWidth = Math.abs(databaseSize.getX());
        double dbHeight = Math.abs(databaseSize.getY());
        if (maxWid > 0.0 && maxHei > 0.0 && (dbWidth > maxWid || dbHeight > maxHei)) {
            double scale = Math.min(maxWid / dbWidth, maxHei / dbHeight);
            font = new Font(User.getDefaultFont(), 0, (int)((double)initialHeight * scale));
            if (font != null) {
                gv = font.createGlyphVector(frc, string);
                lm = font.getLineMetrics(string, frc);
                rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
                width = rect.width;
                height = lm.getHeight();
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Point p = this.databaseToScreen(ctr);
        g2.drawGlyphVector(gv, (float)((double)p.x - width / 2.0), (float)((double)p.y + height / 2.0 - (double)lm.getDescent()));
    }

    public void setGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public boolean isGrid() {
        return this.showGrid;
    }

    public double getGridXSpacing() {
        return this.gridXSpacing;
    }

    public void setGridXSpacing(double spacing) {
        this.gridXSpacing = spacing;
    }

    public double getGridYSpacing() {
        return this.gridYSpacing;
    }

    public void setGridYSpacing(double spacing) {
        this.gridYSpacing = spacing;
    }

    public Rectangle2D displayableBounds() {
        Point2D low = this.screenToDatabase(0, 0);
        Point2D high = this.screenToDatabase(this.sz.width - 1, this.sz.height - 1);
        Rectangle2D.Double bounds = new Rectangle2D.Double(low.getX(), high.getY(), high.getX() - low.getX(), low.getY() - high.getY());
        return bounds;
    }

    private void drawGrid(Graphics g) {
        if (this.gridXSpacing == 0.0 || this.gridYSpacing == 0.0) {
            return;
        }
        double spacingX = this.gridXSpacing;
        double spacingY = this.gridYSpacing;
        double boldSpacingX = spacingX * (double)User.getDefGridXBoldFrequency();
        double boldSpacingY = spacingY * (double)User.getDefGridYBoldFrequency();
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.displayableBounds();
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        g.setColor(new Color(User.getColorGrid()));
        for (double i = y1; i > hY; i -= spacingY) {
            int y = (int)((lY - i) * scaleY);
            if (y < 0 || y > this.sz.height) continue;
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                int x = (int)((j - lX) * scaleX);
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    g.fillRect(x - 2, y, 5, 1);
                    g.fillRect(x, y - 2, 1, 5);
                    g.fillRect(x - 1, y - 1, 3, 3);
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    g.fillRect(x - 1, y, 3, 1);
                    g.fillRect(x, y - 1, 1, 3);
                    continue;
                }
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    public void initTextSearch(String search, boolean caseSensitive) {
        Name name;
        this.foundInCell = new ArrayList();
        Iterator it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            name = ni.getNameKey();
            if (!name.isTempname()) {
                EditWindow.findAllMatches(ni, null, 0, name, name.toString(), this.foundInCell, search, caseSensitive);
            }
            this.addVariableTextToList(ni, this.foundInCell, search, caseSensitive);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            name = ai.getNameKey();
            if (!name.isTempname()) {
                EditWindow.findAllMatches(ai, null, 0, name, name.toString(), this.foundInCell, search, caseSensitive);
            }
            this.addVariableTextToList(ai, this.foundInCell, search, caseSensitive);
        }
        it = this.cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            this.addVariableTextToList(pp, this.foundInCell, search, caseSensitive);
        }
        it = this.cell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            EditWindow.findAllMatches(null, var, -1, null, var.getPureValue(-1, -1), this.foundInCell, search, caseSensitive);
        }
        this.currentFindPosition = -1;
        this.currentStringInCell = null;
    }

    public boolean findNextText(boolean reverse) {
        if (this.foundInCell == null || this.foundInCell.size() == 0) {
            this.currentStringInCell = null;
            return false;
        }
        if (reverse) {
            --this.currentFindPosition;
            if (this.currentFindPosition < 0) {
                this.currentFindPosition = this.foundInCell.size() - 1;
            }
        } else {
            ++this.currentFindPosition;
            if (this.currentFindPosition >= this.foundInCell.size()) {
                this.currentFindPosition = 0;
            }
        }
        this.currentStringInCell = (StringsInCell)this.foundInCell.get(this.currentFindPosition);
        Highlight.clear();
        if (this.currentStringInCell.object == null) {
            Highlight.addText(this.cell, this.cell, (Variable)this.currentStringInCell.object, null);
        } else {
            ElectricObject eObj = (ElectricObject)this.currentStringInCell.object;
            Variable var = eObj.getVar(this.currentStringInCell.key);
            Highlight.addText(eObj, this.cell, var, this.currentStringInCell.name);
        }
        Highlight.finished();
        return true;
    }

    public void replaceText(String replace) {
        if (this.currentStringInCell == null) {
            return;
        }
        ReplaceTextJob job = new ReplaceTextJob(this, replace);
    }

    public void replaceAllText(String replace) {
        ReplaceAllTextJob job = new ReplaceAllTextJob(this, replace);
    }

    private void addVariableTextToList(ElectricObject eObj, List foundInCell, String search, boolean caseSensitive) {
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            Object obj = var.getObject();
            if (obj instanceof String) {
                EditWindow.findAllMatches(eObj, var, -1, null, (String)obj, foundInCell, search, caseSensitive);
                continue;
            }
            if (!(obj instanceof String[])) continue;
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                EditWindow.findAllMatches(eObj, var, i, null, strings[i], foundInCell, search, caseSensitive);
            }
        }
    }

    private static void findAllMatches(Object object, Variable variable, int lineInVariable, Name name, String theLine, List foundInCell, String search, boolean caseSensitive) {
        int startPos = 0;
        while ((startPos = TextUtils.findStringInString(theLine, search, startPos, caseSensitive, false)) >= 0) {
            int endPos = startPos + search.length();
            Variable.Key key = null;
            if (variable != null) {
                key = variable.getKey();
            }
            foundInCell.add(new StringsInCell(object, key, name, lineInVariable, theLine, startPos, endPos));
            startPos = endPos;
        }
    }

    private void changeOneText(StringsInCell sic, String rep, Cell cell) {
        if (sic.replaced) {
            return;
        }
        sic.replaced = true;
        String oldString = sic.theLine;
        String newString = oldString.substring(0, sic.startPosition) + rep + oldString.substring(sic.endPosition);
        if (sic.object == null) {
            cell.updateVar(sic.key, (Object)newString);
        } else if (sic.key == null) {
            if (sic.name == null) {
                Export pp = (Export)sic.object;
                pp.setProtoName(newString);
                Undo.redrawObject(pp.getOriginalPort().getNodeInst());
            } else {
                Geometric geom = (Geometric)sic.object;
                geom.setName(newString);
                Undo.redrawObject(geom);
            }
        } else {
            ElectricObject base = (ElectricObject)sic.object;
            Variable var = base.getVar(sic.key);
            Object obj = var.getObject();
            Object newVar = null;
            if (obj instanceof String) {
                base.updateVar(sic.key, (Object)newString);
            } else if (obj instanceof String[]) {
                String[] oldLines = (String[])obj;
                String[] newLines = new String[oldLines.length];
                for (int i = 0; i < oldLines.length; ++i) {
                    newLines[i] = i == sic.lineInVariable ? newString : oldLines[i];
                }
                base.updateVar(sic.key, (Object)newLines);
            }
        }
        int delta = rep.length() - (sic.endPosition - sic.startPosition);
        if (delta != 0) {
            Iterator it = this.foundInCell.iterator();
            while (it.hasNext()) {
                StringsInCell oSIC = (StringsInCell)it.next();
                if (oSIC == sic || oSIC.object != sic.object || oSIC.key != sic.key || oSIC.name != sic.name || oSIC.lineInVariable != sic.lineInVariable) continue;
                oSIC.theLine = newString;
                if (oSIC.startPosition <= sic.startPosition) continue;
                oSIC.startPosition += delta;
                oSIC.endPosition += delta;
            }
        }
    }

    public boolean getShowPopupCloud() {
        return this.showPopupCloud;
    }

    public void setShowPopupCloud(List text, Point2D point) {
        this.showPopupCloud = true;
        this.popupCloudText = text;
        this.popupCloudPoint = point;
    }

    public void clearShowPopupCloud() {
        this.showPopupCloud = false;
    }

    private void drawPopupCloud(Graphics2D g) {
    }

    public Dimension getScreenSize() {
        return this.sz;
    }

    public void setScreenSize(Dimension sz) {
        this.sz = sz;
        this.offscreen = new PixelDrawing(this);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.computeDatabaseBounds();
    }

    public Point2D getOffset() {
        return new Point2D.Double(this.offx, this.offy);
    }

    public void setOffset(Point2D off) {
        this.offx = off.getX();
        this.offy = off.getY();
        this.computeDatabaseBounds();
    }

    private void computeDatabaseBounds() {
        double width = (double)this.sz.width / this.scale;
        double height = (double)this.sz.height / this.scale;
        this.databaseBounds.setRect(this.offx - width / 2.0, this.offy - height / 2.0, width, height);
    }

    public Rectangle2D getDisplayedBounds() {
        return this.databaseBounds;
    }

    public void bottomScrollChanged() {
        if (this.cell == null) {
            return;
        }
        Rectangle2D bounds = this.cell.getBounds();
        double xWidth = bounds.getWidth();
        double xCenter = bounds.getCenterX();
        int xThumbPos = this.bottomScrollBar.getValue();
        int scrollBarResolution = EditWindow.getScrollBarResolution();
        double scaleFactor = scrollBarResolution / 4;
        int computedXThumbPos = (int)((this.offx - xCenter) / xWidth * scaleFactor) + scrollBarResolution / 2;
        if (computedXThumbPos != xThumbPos) {
            this.offx = (double)(xThumbPos - scrollBarResolution / 2) / scaleFactor * xWidth + xCenter;
            this.computeDatabaseBounds();
            this.repaintContents(null);
        }
    }

    public void rightScrollChanged() {
        if (this.cell == null) {
            return;
        }
        Rectangle2D bounds = this.cell.getBounds();
        double yHeight = bounds.getHeight();
        double yCenter = bounds.getCenterY();
        int yThumbPos = this.rightScrollBar.getValue();
        System.out.println("right.getValue() is " + this.rightScrollBar.getValue());
        int scrollBarResolution = EditWindow.getScrollBarResolution();
        double scaleFactor = scrollBarResolution / 4;
        int computedYThumbPos = (int)((yCenter - this.offy) / yHeight * scaleFactor) + scrollBarResolution / 2;
        if (computedYThumbPos != yThumbPos) {
            this.offy = yCenter - (double)(yThumbPos - scrollBarResolution / 2) / scaleFactor * yHeight;
            this.computeDatabaseBounds();
            this.repaintContents(null);
        }
    }

    private void setScrollPositionOLD() {
        this.rightScrollBar.setEnabled(this.cell != null);
        this.bottomScrollBar.setEnabled(this.cell != null);
        if (this.cell != null) {
            int scrollBarResolution = EditWindow.getScrollBarResolution();
            double scaleFactor = scrollBarResolution / 4;
            Rectangle2D bounds = this.cell.getBounds();
            double xWidth = bounds.getWidth();
            double xCenter = bounds.getCenterX();
            int xThumbPos = (int)((this.offx - xCenter) / xWidth * scaleFactor) + scrollBarResolution / 2;
            this.bottomScrollBar.setValue(xThumbPos);
            double yHeight = bounds.getHeight();
            double yCenter = bounds.getCenterY();
            int yThumbPos = (int)((yCenter - this.offy) / yHeight * scaleFactor) + scrollBarResolution / 2;
            this.rightScrollBar.setValue(yThumbPos);
        }
    }

    public void setScrollPosition() {
        this.bottomScrollBar.setEnabled(this.cell != null);
        this.rightScrollBar.setEnabled(this.cell != null);
        if (this.cell == null) {
            return;
        }
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        Rectangle2D overallBounds = cellBounds.createUnion(viewBounds);
        if (this.lastOverallBounds != null && this.lastOffset != null && this.lastOverallBounds.equals(overallBounds) && this.lastOffset.equals(this.getOffset())) {
            return;
        }
        if (!this.bottomScrollBar.getValueIsAdjusting()) {
            this.bottomScrollBar.getModel().setRangeProperties((int)(this.offx - 0.5 * viewBounds.getWidth()), (int)viewBounds.getWidth(), (int)(overallBounds.getX() - 0.2 * overallBounds.getWidth()), (int)(overallBounds.getX() + overallBounds.getWidth() + 0.2 * overallBounds.getWidth()), false);
            this.bottomScrollBar.setEnabled(false);
            this.bottomScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getWidth()));
            this.bottomScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getWidth()));
            this.bottomScrollBar.setEnabled(true);
        }
        if (!this.rightScrollBar.getValueIsAdjusting()) {
            this.rightScrollBar.getModel().setRangeProperties((int)(-this.offy - 0.5 * viewBounds.getHeight()), (int)viewBounds.getHeight(), (int)(-(overallBounds.getY() + overallBounds.getHeight() + 0.2 * overallBounds.getHeight())), (int)(-(overallBounds.getY() - 0.2 * overallBounds.getHeight())), false);
            this.rightScrollBar.setEnabled(false);
            this.rightScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getHeight()));
            this.rightScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getHeight()));
            this.rightScrollBar.setEnabled(true);
        }
        if (!this.bottomScrollBar.getValueIsAdjusting() && !this.rightScrollBar.getValueIsAdjusting()) {
            this.lastOverallBounds = overallBounds;
            this.lastOffset = this.getOffset();
        }
    }

    public void bottomScrollChanged(int value) {
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double newoffx = (double)value + 0.5 * viewBounds.getWidth();
        double ignoreDelta = 0.03 * viewBounds.getWidth();
        double delta = newoffx - this.offx;
        if (Math.abs(delta) < Math.abs(ignoreDelta)) {
            return;
        }
        Point2D.Double offset = new Point2D.Double(newoffx, this.offy);
        this.setOffset(offset);
        this.repaintContents(null);
    }

    public void rightScrollChanged(int value) {
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double newoffy = -((double)value + 0.5 * viewBounds.getHeight());
        double ignoreDelta = 0.03 * viewBounds.getHeight();
        double delta = newoffy - this.offy;
        if (Math.abs(delta) < Math.abs(ignoreDelta)) {
            return;
        }
        Point2D.Double offset = new Point2D.Double(this.offx, newoffy);
        this.setOffset(offset);
        this.repaintContents(null);
    }

    private void setScreenBounds(Rectangle2D bounds) {
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (width == 0.0) {
            width = 2.0;
        }
        if (height == 0.0) {
            height = 2.0;
        }
        double scalex = (double)this.sz.width / width * 0.9;
        double scaley = (double)this.sz.height / height * 0.9;
        this.scale = Math.min(scalex, scaley);
        this.offx = bounds.getCenterX();
        this.offy = bounds.getCenterY();
    }

    public void focusScreen(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        this.setScreenBounds(bounds);
        this.setScrollPosition();
        this.computeDatabaseBounds();
        this.repaintContents(null);
    }

    public void fillScreen() {
        if (this.cell != null && !this.cell.getView().isTextView()) {
            Rectangle2D cellBounds = this.cell.getBounds();
            Dimension d = new Dimension();
            int frameFactor = this.getCellFrameInfo(d);
            Rectangle2D.Double frameBounds = new Rectangle2D.Double(-d.getWidth() / 2.0, -d.getHeight() / 2.0, d.getWidth(), d.getHeight());
            if (frameFactor == 0) {
                cellBounds = frameBounds;
            } else {
                if (cellBounds.getWidth() == 0.0 && cellBounds.getHeight() == 0.0) {
                    int defaultCellSize = 60;
                    cellBounds = new Rectangle2D.Double(cellBounds.getCenterX() - (double)(defaultCellSize / 2), cellBounds.getCenterY() - (double)(defaultCellSize / 2), defaultCellSize, defaultCellSize);
                }
                this.setScreenBounds(cellBounds);
                Rectangle2D relativeTextBounds = this.cell.getRelativeTextBounds(this);
                if (relativeTextBounds != null) {
                    Rectangle2D.Double newCellBounds = new Rectangle2D.Double();
                    Rectangle2D.union(relativeTextBounds, cellBounds, newCellBounds);
                    cellBounds = newCellBounds;
                }
                if (frameFactor == 1) {
                    Rectangle2D.union(frameBounds, cellBounds, frameBounds);
                    cellBounds = frameBounds;
                }
            }
            this.focusScreen(cellBounds);
            return;
        }
        this.repaint();
    }

    public void zoomOutContents() {
        double scale = this.getScale();
        this.setScale(scale / 2.0);
        this.repaintContents(null);
    }

    public void zoomInContents() {
        double scale = this.getScale();
        this.setScale(scale * 2.0);
        this.repaintContents(null);
    }

    public void focusOnHighlighted() {
        Rectangle2D bounds = Highlight.getHighlightedArea(this);
        this.focusScreen(bounds);
    }

    public VarContext getVarContext() {
        return this.cellVarContext;
    }

    public void downHierarchy() {
        Highlight h = Highlight.getOneHighlight();
        if (h == null) {
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        NodeInst ni = null;
        PortInst pi = null;
        if (eobj instanceof NodeInst) {
            ni = (NodeInst)eobj;
        }
        if (eobj instanceof PortInst) {
            pi = (PortInst)eobj;
            ni = pi.getNodeInst();
        }
        if (ni == null) {
            System.out.println("Must select a Node to descend into");
            return;
        }
        NodeProto np = ni.getProto();
        if (!(np instanceof Cell)) {
            System.out.println("Can only descend into cell instances");
            return;
        }
        Cell cell = (Cell)np;
        Cell schCell = cell.getEquivalent();
        if (this.cell == schCell) {
            schCell = cell;
        }
        if (schCell == null) {
            schCell = cell;
        }
        if (pi != null) {
            this.setCell(schCell, this.cellVarContext.push(pi));
        } else {
            this.setCell(schCell, this.cellVarContext.push(ni));
        }
        if (pi != null) {
            PortInst origPort = schCell.findExport(pi.getPortProto().getName()).getOriginalPort();
            Highlight.addElectricObject(origPort.getNodeInst(), schCell);
            Highlight.finished();
        }
    }

    public void upHierarchy() {
        try {
            Iterator it;
            Cell iconView;
            Cell schCell;
            Nodable no = this.cellVarContext.getNodable();
            if (no != null) {
                Cell parent = no.getParent();
                VarContext context = this.cellVarContext.pop();
                CellHistory foundHistory = null;
                for (int i = this.cellHistory.size() - 1; i > -1; --i) {
                    CellHistory history = (CellHistory)this.cellHistory.get(i);
                    if (history.cell != parent || !history.context.equals(context)) continue;
                    foundHistory = history;
                    break;
                }
                PortInst pi = this.cellVarContext.getPortInst();
                this.setCell(parent, context, true);
                if (foundHistory != null) {
                    this.setOffset(foundHistory.offset);
                    this.setScale(foundHistory.scale);
                }
                if (pi != null) {
                    Highlight.addElectricObject(pi, parent);
                } else if (no instanceof NodeInst) {
                    Highlight.addElectricObject((NodeInst)no, parent);
                }
                return;
            }
            if (this.cell.getView() == View.ICON && (schCell = this.cell.getEquivalent()) != null) {
                this.setCell(schCell, VarContext.globalContext);
                return;
            }
            TreeSet<String> found = new TreeSet<String>();
            Iterator it2 = this.cell.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                Cell parent = ni.getParent();
                found.add(parent.describe());
            }
            if (this.cell.getView() == View.SCHEMATIC && (iconView = this.cell.iconView()) != null) {
                it = iconView.getInstancesOf();
                while (it.hasNext()) {
                    NodeInst ni = (NodeInst)it.next();
                    if (ni.isIconOfParent()) continue;
                    Cell parent = ni.getParent();
                    found.add(parent.describe());
                }
            }
            if (found.size() == 0) {
                System.out.println("Not in any cells");
            } else if (found.size() == 1) {
                String cellName = (String)found.iterator().next();
                Cell parent = (Cell)NodeProto.findNodeProto(cellName);
                this.setCell(parent, VarContext.globalContext);
            } else {
                JPopupMenu parents = new JPopupMenu("parents");
                it = found.iterator();
                while (it.hasNext()) {
                    String cellName = (String)it.next();
                    JMenuItem menuItem = new JMenuItem(cellName);
                    menuItem.addActionListener(this);
                    parents.add(menuItem);
                }
                parents.show(this, 0, 0);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void cellHistoryGoBack() {
        if (this.cellHistoryLocation <= 0) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation - 1);
    }

    public void cellHistoryGoForward() {
        if (this.cellHistoryLocation >= this.cellHistory.size() - 1) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation + 1);
    }

    public boolean cellHistoryCanGoBack() {
        return this.cellHistoryLocation > 0;
    }

    public boolean cellHistoryCanGoForward() {
        return this.cellHistoryLocation < this.cellHistory.size() - 1;
    }

    public void fireCellHistoryStatus() {
        if (this.cellHistoryLocation > 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
        }
        if (this.cellHistoryLocation < this.cellHistory.size() - 1) {
            this.getPanel().firePropertyChange(propGoForwardEnabled, false, true);
        }
    }

    private void addToHistory(Cell cell, VarContext context) {
        if (cell == null) {
            return;
        }
        CellHistory history = new CellHistory();
        history.cell = cell;
        history.context = context;
        if (this.cellHistoryLocation < this.cellHistory.size() - 1) {
            for (int i = this.cellHistoryLocation + 1; i < this.cellHistory.size(); ++i) {
                this.cellHistory.remove(i);
            }
            this.getPanel().firePropertyChange(propGoForwardEnabled, true, false);
        }
        if (this.cellHistoryLocation == 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
        }
        this.cellHistory.add(history);
        this.cellHistoryLocation = this.cellHistory.size() - 1;
        if (this.cellHistoryLocation > 20) {
            this.cellHistory.remove(0);
            --this.cellHistoryLocation;
        }
    }

    private void saveCurrentCellHistoryState() {
        if (this.cellHistoryLocation < 0) {
            return;
        }
        CellHistory current = (CellHistory)this.cellHistory.get(this.cellHistoryLocation);
        current.offset = new Point2D.Double(this.offx, this.offy);
        current.scale = this.scale;
        current.highlights = new ArrayList();
        current.highlights.clear();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            current.highlights.add(it.next());
        }
        current.highlightOffset = Highlight.getHighlightOffset();
    }

    private void setCellByHistory(int location) {
        if (this.cellHistoryLocation == this.cellHistory.size() - 1) {
            if (location < this.cellHistory.size() - 1) {
                this.getPanel().firePropertyChange(propGoForwardEnabled, false, true);
            }
        } else if (location == this.cellHistory.size() - 1) {
            this.getPanel().firePropertyChange(propGoForwardEnabled, true, false);
        }
        if (this.cellHistoryLocation == 0) {
            if (location > 0) {
                this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
            }
        } else if (location == 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, true, false);
        }
        CellHistory history = (CellHistory)this.cellHistory.get(location);
        if (history.cell == null || !history.cell.isLinked()) {
            history.cell = null;
            history.context = VarContext.globalContext;
            history.offset = new Point2D.Double(0.0, 0.0);
            history.highlights = new ArrayList();
            history.highlightOffset = new Point2D.Double(0.0, 0.0);
        }
        this.setCell(history.cell, history.context, false);
        this.setOffset(history.offset);
        this.setScale(history.scale);
        Highlight.setHighlightList(history.highlights);
        Highlight.setHighlightOffset((int)history.highlightOffset.getX(), (int)history.highlightOffset.getY());
        this.cellHistoryLocation = location;
        this.repaintContents(null);
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = (double)(screenX - this.sz.width / 2) / this.scale + this.offx;
        double dbY = (double)(this.sz.height / 2 - screenY) / this.scale + this.offy;
        return new Point2D.Double(dbX, dbY);
    }

    public Point2D deltaScreenToDatabase(int screenDX, int screenDY) {
        double dbDX = (double)screenDX / this.scale;
        double dbDY = (double)(-screenDY) / this.scale;
        return new Point2D.Double(dbDX, dbDY);
    }

    public int databaseToScreenX(double dbX) {
        return (int)((double)(this.sz.width / 2) + (dbX - this.offx) * this.scale);
    }

    public int databaseToScreenY(double dbY) {
        return (int)((double)(this.sz.height / 2) - (dbY - this.offy) * this.scale);
    }

    public Point databaseToScreen(double dbX, double dbY) {
        return new Point(this.databaseToScreenX(dbX), this.databaseToScreenY(dbY));
    }

    public Point databaseToScreen(Point2D db) {
        return new Point(this.databaseToScreenX(db.getX()), this.databaseToScreenY(db.getY()));
    }

    public Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        double sLX = (double)(this.sz.width / 2) + (db.getMinX() - this.offx) * this.scale;
        double sHX = (double)(this.sz.width / 2) + (db.getMaxX() - this.offx) * this.scale;
        double sLY = (double)(this.sz.height / 2) - (db.getMinY() - this.offy) * this.scale;
        double sHY = (double)(this.sz.height / 2) - (db.getMaxY() - this.offy) * this.scale;
        sLX = sLX < 0.0 ? (sLX -= 0.5) : (sLX += 0.5);
        sHX = sHX < 0.0 ? (sHX -= 0.5) : (sHX += 0.5);
        sLY = sLY < 0.0 ? (sLY -= 0.5) : (sLY += 0.5);
        sHY = sHY < 0.0 ? (sHY -= 0.5) : (sHY += 0.5);
        int screenLX = (int)sLX;
        int screenHX = (int)sHX;
        int screenLY = (int)sLY;
        int screenHY = (int)sHY;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX, screenHY - screenLY);
    }

    public Point deltaDatabaseToScreen(double dbDX, double dbDY) {
        int screenDX = (int)Math.round(dbDX * this.scale);
        int screenDY = (int)Math.round(-dbDY * this.scale);
        return new Point(screenDX, screenDY);
    }

    public static void gridAlign(Point2D pt) {
        double alignment = User.getAlignmentToGrid();
        long x = Math.round(pt.getX() / alignment);
        long y = Math.round(pt.getY() / alignment);
        pt.setLocation((double)x * alignment, (double)y * alignment);
    }

    public double getTextUnitSize(int pointSize) {
        Point2D pt = this.deltaScreenToDatabase(pointSize, pointSize);
        return pt.getX();
    }

    public int getTextPointSize(double pointSize) {
        Point pt = this.deltaDatabaseToScreen(pointSize, pointSize);
        return pt.x;
    }

    public static int getDefaultFontSize() {
        return 14;
    }

    public Font getFont(TextDescriptor descript) {
        int size = EditWindow.getDefaultFontSize();
        int fontStyle = 0;
        String fontName = User.getDefaultFont();
        if (descript != null) {
            TextDescriptor.ActiveFont af;
            int fontIndex;
            size = descript.getTrueSize(this);
            if (size <= 0) {
                size = 1;
            }
            if (descript.isItalic()) {
                fontStyle |= 2;
            }
            if (descript.isBold()) {
                fontStyle |= 1;
            }
            if ((fontIndex = descript.getFace()) != 0 && (af = TextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (size < 5) {
            return null;
        }
        Font font = new Font(fontName, fontStyle, size);
        return font;
    }

    public GlyphVector getGlyphs(String text, Font font) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        GlyphVector gv = font.createGlyphVector(frc, text);
        return gv;
    }

    private static class CellHistory {
        public Cell cell;
        public VarContext context;
        public Point2D offset;
        public double scale;
        public List highlights;
        public Point2D highlightOffset;

        private CellHistory() {
        }
    }

    private static class ReplaceAllTextJob
    extends Job {
        EditWindow wnd;
        String replace;

        public ReplaceAllTextJob(EditWindow wnd, String replace) {
            super("Replace All Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.replace = replace;
            this.startJob();
        }

        public boolean doIt() {
            int total = 0;
            this.wnd.currentFindPosition = 0;
            while (this.wnd.currentFindPosition < this.wnd.foundInCell.size()) {
                this.wnd.currentStringInCell = (StringsInCell)this.wnd.foundInCell.get(this.wnd.currentFindPosition);
                this.wnd.changeOneText(this.wnd.currentStringInCell, this.replace, this.wnd.cell);
                ++total;
                this.wnd.currentFindPosition++;
            }
            if (total == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                System.out.println("Replaced " + total + " times");
            }
            return true;
        }
    }

    private static class ReplaceTextJob
    extends Job {
        EditWindow wnd;
        String replace;

        public ReplaceTextJob(EditWindow wnd, String replace) {
            super("Replace Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.replace = replace;
            this.startJob();
        }

        public boolean doIt() {
            this.wnd.changeOneText(this.wnd.currentStringInCell, this.replace, this.wnd.cell);
            return true;
        }
    }

    private static class StringsInCell {
        Object object;
        Variable.Key key;
        Name name;
        String theLine;
        int lineInVariable;
        int startPosition;
        int endPosition;
        boolean replaced;

        StringsInCell(Object object, Variable.Key key, Name name, int lineInVariable, String theLine, int startPosition, int endPosition) {
            this.object = object;
            this.key = key;
            this.name = name;
            this.lineInVariable = lineInVariable;
            this.theLine = theLine;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.replaced = false;
        }

        public String toString() {
            return "StringsInCell obj=" + this.object + " var=" + this.key + " name=" + this.name + " line=" + this.lineInVariable + " start=" + this.startPosition + " end=" + this.endPosition + " msg=" + this.theLine;
        }
    }

    private static class CrossProbe {
        boolean isLine;
        Point2D start;
        Point2D end;
        Rectangle2D box;
        Color color;

        private CrossProbe() {
        }
    }

    private static class RenderJob
    extends Job {
        private EditWindow wnd;
        private PixelDrawing offscreen;
        private Rectangle2D bounds;

        protected RenderJob(EditWindow wnd, PixelDrawing offscreen, Rectangle2D bounds) {
            super("Display", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.offscreen = offscreen;
            this.bounds = bounds;
            this.startJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doIt() {
            long start = System.currentTimeMillis();
            this.offscreen.drawImage(this.bounds);
            long end = System.currentTimeMillis();
            List list = redrawThese;
            synchronized (list) {
                if (redrawThese.size() > 0) {
                    runningNow = (EditWindow)redrawThese.get(0);
                    redrawThese.remove(0);
                    RenderJob nextJob = new RenderJob(runningNow, runningNow.getOffscreen(), null);
                    return true;
                }
                runningNow = null;
            }
            this.wnd.repaint();
            return true;
        }
    }

    private static class ScrollAdjustmentListener
    implements AdjustmentListener {
        EditWindow wnd;

        ScrollAdjustmentListener(EditWindow wnd) {
            this.wnd = wnd;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == this.wnd.getBottomScrollBar() && this.wnd.getCell() != null) {
                this.wnd.bottomScrollChanged(e.getValue());
            }
            if (e.getSource() == this.wnd.getRightScrollBar() && this.wnd.getCell() != null) {
                this.wnd.rightScrollChanged(e.getValue());
            }
        }
    }
}

