/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PortCharacteristic {
    private static final int CLKPORT = 2;
    private static final int C1PORT = 4;
    private static final int C2PORT = 6;
    private static final int C3PORT = 8;
    private static final int C4PORT = 10;
    private static final int C5PORT = 12;
    private static final int C6PORT = 14;
    private static final int INPORT = 16;
    private static final int OUTPORT = 18;
    private static final int BIDIRPORT = 20;
    private static final int PWRPORT = 22;
    private static final int GNDPORT = 24;
    private static final int REFOUTPORT = 26;
    private static final int REFINPORT = 28;
    private static final int REFBASEPORT = 30;
    private final String name;
    private final String shortName;
    private final String fullName;
    private final int bits;
    private final int order;
    private static int ordering = 0;
    private static HashMap characteristicList = new HashMap();
    public static final PortCharacteristic UNKNOWN = new PortCharacteristic("U", "Unknown", "unknown", 0);
    public static final PortCharacteristic IN = new PortCharacteristic("I", "Input", "input", 16);
    public static final PortCharacteristic OUT = new PortCharacteristic("O", "Output", "output", 18);
    public static final PortCharacteristic BIDIR = new PortCharacteristic("B", "Bidirectional", "bidirectional", 20);
    public static final PortCharacteristic PWR = new PortCharacteristic("P", "Power", "power", 22);
    public static final PortCharacteristic GND = new PortCharacteristic("G", "Ground", "ground", 24);
    public static final PortCharacteristic CLK = new PortCharacteristic("C", "Clock", "clock", 2);
    public static final PortCharacteristic C1 = new PortCharacteristic("C1", "Clock Phase 1", "clock1", 4);
    public static final PortCharacteristic C2 = new PortCharacteristic("C2", "Clock Phase 2", "clock2", 6);
    public static final PortCharacteristic C3 = new PortCharacteristic("C3", "Clock Phase 3", "clock3", 8);
    public static final PortCharacteristic C4 = new PortCharacteristic("C4", "Clock Phase 4", "clock4", 10);
    public static final PortCharacteristic C5 = new PortCharacteristic("C5", "Clock Phase 5", "clock5", 12);
    public static final PortCharacteristic C6 = new PortCharacteristic("C6", "Clock Phase 6", "clock6", 14);
    public static final PortCharacteristic REFOUT = new PortCharacteristic("RO", "Reference Output", "refout", 26);
    public static final PortCharacteristic REFIN = new PortCharacteristic("RI", "Reference Input", "refin", 28);
    public static final PortCharacteristic REFBASE = new PortCharacteristic("RB", "Reference Base", "refbase", 30);

    private PortCharacteristic(String shortName, String fullName, String name, int bits) {
        this.shortName = shortName;
        this.fullName = fullName;
        this.name = name;
        this.bits = bits;
        this.order = ordering++;
        characteristicList.put(new Integer(bits), this);
    }

    public int getBits() {
        return this.bits;
    }

    public int getOrder() {
        return this.order;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReference() {
        return this == REFIN || this == REFOUT || this == REFBASE;
    }

    public static PortCharacteristic findCharacteristic(int bits) {
        Object obj = characteristicList.get(new Integer(bits));
        if (obj == null) {
            return null;
        }
        return (PortCharacteristic)obj;
    }

    public static PortCharacteristic findCharacteristic(String wantName) {
        Iterator it = characteristicList.values().iterator();
        while (it.hasNext()) {
            PortCharacteristic ch = (PortCharacteristic)it.next();
            if (!ch.name.equals(wantName)) continue;
            return ch;
        }
        return null;
    }

    public static PortCharacteristic findCharacteristicShort(String shortName) {
        Iterator it = characteristicList.values().iterator();
        while (it.hasNext()) {
            PortCharacteristic ch = (PortCharacteristic)it.next();
            if (!ch.shortName.equals(shortName)) continue;
            return ch;
        }
        return null;
    }

    public static List getOrderedCharacteristics() {
        ArrayList orderedList = new ArrayList();
        Iterator it = characteristicList.values().iterator();
        while (it.hasNext()) {
            orderedList.add(it.next());
        }
        Collections.sort(orderedList, new CharacteristicOrder());
        return orderedList;
    }

    public String toString() {
        return this.name;
    }

    static class CharacteristicOrder
    implements Comparator {
        CharacteristicOrder() {
        }

        public int compare(Object o1, Object o2) {
            PortCharacteristic c1 = (PortCharacteristic)o1;
            PortCharacteristic c2 = (PortCharacteristic)o2;
            return c1.order - c2.order;
        }
    }
}

