/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CellUsage
extends HierarchyEnumerator.Visitor {
    private Map cellsInUse = new HashMap();
    private List cellsInRevTopoOrder = new ArrayList();
    private Map groupToAdditions = new HashMap();
    private Cell root;

    CellUsage() {
    }

    private void processCellGroupAdditions(CellContext cellCtxt) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cellCtxt.cell);
        if (ann == null) {
            return;
        }
        Cell.CellGroup group = ann.getGroupToJoin();
        if (group == null) {
            return;
        }
        HashSet<CellContext> additions = (HashSet<CellContext>)this.groupToAdditions.get(group);
        if (additions == null) {
            additions = new HashSet<CellContext>();
            this.groupToAdditions.put(group, additions);
        }
        additions.add(cellCtxt);
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.root == null) {
            this.root = cell;
        }
        VarContext context = info.getContext();
        if (this.cellsInUse.containsKey(cell)) {
            return false;
        }
        CellContext cellCtxt = new CellContext(cell, context);
        this.cellsInUse.put(cell, cellCtxt);
        this.processCellGroupAdditions(cellCtxt);
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
        this.cellsInRevTopoOrder.add(info.getCell());
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    public boolean cellIsUsed(Cell cell) {
        return this.cellsInUse.containsKey(cell);
    }

    public Iterator cellsInReverseTopologicalOrder() {
        return this.cellsInRevTopoOrder.iterator();
    }

    public CellContext getCellContext(Cell cell) {
        LayoutLib.error(!this.cellsInUse.containsKey(cell), "cell not found");
        return (CellContext)this.cellsInUse.get(cell);
    }

    public Set getGroupAdditions(Cell.CellGroup group) {
        Set additions = (Set)this.groupToAdditions.get(group);
        return additions != null ? additions : new HashSet();
    }

    public Cell getRoot() {
        return this.root;
    }
}

