/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccRandom;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.jemNets.NccNetlist;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.LeafEquivRecords;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccGlobals {
    private static final int CODE_PART = 0;
    private static final int CODE_WIRE = 1;
    private static final int CODE_PORT = 2;
    private NccRandom randGen = new NccRandom();
    private final NccOptions options;
    private EquivRecord root;
    private EquivRecord parts;
    private EquivRecord wires;
    private EquivRecord ports;
    private Cell[] rootCells;
    private VarContext[] rootContexts;
    public int passNumber;
    private LeafEquivRecords partLeafRecs;
    private LeafEquivRecords wireLeafRecs;

    private List getNetObjs(int code, NccNetlist nets) {
        switch (code) {
            case 0: {
                return nets.getPartArray();
            }
            case 1: {
                return nets.getWireArray();
            }
            case 2: {
                return nets.getPortArray();
            }
        }
        this.error("invalid code");
        return null;
    }

    private EquivRecord buildEquivRec(int code, List nccNets) {
        boolean atLeastOneNetObj = false;
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nets = (NccNetlist)it.next();
            List netObjs = this.getNetObjs(code, nets);
            if (netObjs.size() != 0) {
                atLeastOneNetObj = true;
            }
            ckts.add(Circuit.please(netObjs));
        }
        if (!atLeastOneNetObj) {
            return null;
        }
        return EquivRecord.newLeafRecord(code, ckts, this);
    }

    private void println(String s) {
        System.out.println(s);
        System.out.flush();
    }

    public NccGlobals(NccOptions options) {
        this.options = options;
    }

    public void setInitialNetlists(List nccNets) {
        this.parts = this.buildEquivRec(0, nccNets);
        this.wires = this.buildEquivRec(1, nccNets);
        this.ports = this.buildEquivRec(2, nccNets);
        ArrayList<EquivRecord> el = new ArrayList<EquivRecord>();
        if (this.parts != null) {
            el.add(this.parts);
        }
        if (this.wires != null) {
            el.add(this.wires);
        }
        if (this.ports != null) {
            el.add(this.ports);
        }
        this.root = EquivRecord.newRootRecord(el);
        this.rootCells = new Cell[nccNets.size()];
        this.rootContexts = new VarContext[nccNets.size()];
        int i = 0;
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nl = (NccNetlist)it.next();
            this.rootCells[i] = nl.getRootCell();
            this.rootContexts[i] = nl.getRootContext();
            ++i;
        }
    }

    public void initLeafLists() {
        this.partLeafRecs = new LeafEquivRecords(this.parts, this);
        this.wireLeafRecs = new LeafEquivRecords(this.wires, this);
    }

    public EquivRecord getRoot() {
        return this.root;
    }

    public EquivRecord getParts() {
        return this.parts;
    }

    public EquivRecord getWires() {
        return this.wires;
    }

    public EquivRecord getPorts() {
        return this.ports;
    }

    public int getNumNetlistsBeingCompared() {
        return this.rootCells.length;
    }

    public Cell[] getRootCells() {
        return this.rootCells;
    }

    public VarContext[] getRootContexts() {
        return this.rootContexts;
    }

    public String[] getRootCellNames() {
        String[] rootCellNames = new String[this.rootCells.length];
        for (int i = 0; i < this.rootCells.length; ++i) {
            rootCellNames[i] = NccUtils.fullName(this.rootCells[i]);
        }
        return rootCellNames;
    }

    public void status1(String msg) {
        if (this.options.howMuchStatus >= 1) {
            this.println(msg);
        }
    }

    public void status2(String msg) {
        if (this.options.howMuchStatus >= 2) {
            this.println(msg);
        }
    }

    public void flush() {
        System.out.flush();
    }

    public void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public void error(String msg) {
        LayoutLib.error(true, msg);
    }

    public NccOptions getOptions() {
        return this.options;
    }

    public int getRandom() {
        return this.randGen.next();
    }

    public LeafEquivRecords getPartLeafEquivRecs() {
        return this.partLeafRecs;
    }

    public LeafEquivRecords getWireLeafEquivRecs() {
        return this.wireLeafRecs;
    }

    public HierarchyEnumerator.NetNameProxy[][] getEquivalentNets() {
        int numDes = this.getNumNetlistsBeingCompared();
        HierarchyEnumerator.NetNameProxy[][] equivNets = new HierarchyEnumerator.NetNameProxy[numDes][];
        int numMatched = this.wireLeafRecs.numMatched();
        for (int i = 0; i < numDes; ++i) {
            equivNets[i] = new HierarchyEnumerator.NetNameProxy[numMatched];
        }
        int wireNdx = 0;
        Iterator it = this.wireLeafRecs.getMatched();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            int cktNdx = 0;
            Iterator cit = er.getCircuits();
            while (cit.hasNext()) {
                Circuit ckt = (Circuit)cit.next();
                LayoutLib.error(ckt.numNetObjs() != 1, "not matched?");
                Wire w = (Wire)ckt.getNetObjs().next();
                equivNets[cktNdx][wireNdx] = w.getNameProxy().getNetNameProxy();
                ++cktNdx;
            }
            ++wireNdx;
        }
        return equivNets;
    }
}

