/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class InteractiveRouter
extends Router {
    private List startRouteHighlights = new ArrayList();
    private boolean started;
    private EditWindow wnd;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InteractiveRouter() {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
        this.wnd = null;
    }

    public String toString() {
        return "Interactive Router";
    }

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElementPort var3, Point2D var4, Point2D var5, Point2D var6, VerticalRoute var7, boolean var8);

    public void startInteractiveRoute(EditWindow wnd) {
        this.wnd = wnd;
        this.startRouteHighlights.clear();
        Iterator it = wnd.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            this.startRouteHighlights.add(h);
        }
        wnd.getHighlighter().clear();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlighter highlighter = this.wnd.getHighlighter();
        highlighter.clear();
        highlighter.setHighlightList(this.startRouteHighlights);
        highlighter.finished();
        this.wnd = null;
        this.started = false;
    }

    public void makeRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked);
        wnd.getHighlighter().clear();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(EditWindow wnd, PortInst startPort, ArcProto arc) {
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        Cell cell = startPort.getNodeInst().getParent();
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Point2D.Double startLoc = new Point2D.Double(startPort.getPoly().getCenterX(), startPort.getPoly().getCenterY());
        Poly poly = InteractiveRouter.getConnectingSite(startPort, startLoc, -1.0);
        RouteElementPort startRE = RouteElementPort.existingPortInst(startPort, poly);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        PrimitiveNode pn = ((PrimitiveArc)arc).findOverridablePinProto();
        PortProto pp = pn.getPort(0);
        VerticalRoute vroute = VerticalRoute.newRoute(startPort.getPortProto(), arc);
        if (!vroute.isSpecificationSucceeded()) {
            this.cancelInteractiveRoute();
            return false;
        }
        vroute.buildRoute(route, startRE.getCell(), startRE, null, startLoc, startLoc, startLoc);
        wnd.getHighlighter().clear();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        MakeVerticalRouteJob job = new MakeVerticalRouteJob(this, route, startPort.getNodeInst().getParent(), true);
        this.started = false;
        return true;
    }

    public void highlightRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked);
        this.highlightRoute(wnd, route, cell);
    }

    public void highlightRoute(EditWindow wnd, Route route, Cell cell) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        wnd.getHighlighter().clear();
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement e = (RouteElement)it.next();
            e.addHighlightArea(wnd.getHighlighter());
        }
        wnd.getHighlighter().finished();
    }

    protected Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        PortProto endPort;
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        RouteElementPort startRE = null;
        RouteElementPort endRE = null;
        startObj = InteractiveRouter.filterRouteObject(startObj, clicked);
        endObj = InteractiveRouter.filterRouteObject(endObj, clicked);
        PortProto startPort = InteractiveRouter.getRoutePort(startObj);
        if (endObj == null) {
            ArcProto useArc = InteractiveRouter.getArcToUse(startPort, null);
            if (useArc == null) {
                return route;
            }
            PrimitiveNode pn = ((PrimitiveArc)useArc).findOverridablePinProto();
            endPort = pn.getPort(0);
        } else {
            endPort = InteractiveRouter.getRoutePort(endObj);
        }
        VerticalRoute vroute = VerticalRoute.newRoute(startPort, endPort);
        if (!vroute.isSpecificationSucceeded()) {
            return new Route();
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        double startArcWidth = InteractiveRouter.getArcWidthToUse(startObj, startArc);
        double endArcWidth = endObj == null ? startArcWidth : InteractiveRouter.getArcWidthToUse(endObj, endArc);
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked, startArcWidth - startArc.getWidthOffset());
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked, endArcWidth - endArc.getWidthOffset());
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint, startPoly, endPoly, startArc, endArc);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean contactsOnEndObject = true;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElementPort.existingPortInst(existingStartPort, startPoly);
        }
        if (startObj instanceof ArcInst) {
            startRE = this.findArcConnectingPoint(route, (ArcInst)startObj, startPoint);
            contactsOnEndObject = false;
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElementPort.existingPortInst(existingEndPort, endPoly);
            }
            if (endObj instanceof ArcInst) {
                endRE = this.findArcConnectingPoint(route, (ArcInst)endObj, endPoint);
                contactsOnEndObject = true;
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("  Can't route to " + endObj + ", no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                PortInst startPi = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPi.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startAi = (ArcInst)startObj;
                useArc = startAi.getProto();
            }
            if (!(useArc instanceof PrimitiveArc)) {
                System.out.println("  Don't know how to determine pin for arc " + useArc);
                return new Route();
            }
            PrimitiveNode pn = ((PrimitiveArc)useArc).findOverridablePinProto();
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset());
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        route.add(startRE);
        route.setStart(startRE);
        route.setEnd(startRE);
        if (this.planRoute(route, cell, endRE, startPoint, endPoint, clicked, vroute, contactsOnEndObject)) {
            return route;
        }
        return new Route();
    }

    protected static ElectricObject filterRouteObject(ElectricObject routeObj, Point2D clicked) {
        if (routeObj instanceof NodeInst) {
            return ((NodeInst)routeObj).findClosestPortInst(clicked);
        }
        if (routeObj instanceof Export) {
            Export exp = (Export)routeObj;
            return exp.getOriginalPort();
        }
        return routeObj;
    }

    protected static PortProto getRoutePort(ElectricObject routeObj) {
        if (!$assertionsDisabled && routeObj instanceof NodeInst) {
            throw new AssertionError();
        }
        if (routeObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)routeObj;
            PrimitiveNode pn = ((PrimitiveArc)ai.getProto()).findOverridablePinProto();
            return pn.getPort(0);
        }
        if (routeObj instanceof PortInst) {
            PortInst pi = (PortInst)routeObj;
            return pi.getPortProto();
        }
        return null;
    }

    protected static double getArcWidthToUse(ElectricObject routeObj, ArcProto ap) {
        ArcInst ai;
        double width = -1.0;
        if (routeObj instanceof ArcInst && (ai = (ArcInst)routeObj).getProto() == ap) {
            return ai.getWidth();
        }
        if (routeObj instanceof PortInst) {
            width = Router.getArcWidthToUse((PortInst)routeObj, ap);
        }
        return width;
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint, Poly startPoly, Poly endPoly, ArcProto startArc, ArcProto endArc) {
        double upperBoundX;
        double lowerBoundX;
        Rectangle2D startBounds = startPoly.getBounds2D();
        startPoint.setLocation(startBounds.getCenterX(), startBounds.getCenterY());
        if (startObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY());
            startPoint.setLocation(x, y);
        }
        if (endPoly == null) {
            endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            if (startArc.getTechnology() == Artwork.tech) {
                endPoint.setLocation(clicked);
            }
            return;
        }
        Rectangle2D endBounds = endPoly.getBounds2D();
        endPoint.setLocation(endBounds.getCenterX(), endBounds.getCenterY());
        if (endObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY());
            endPoint.setLocation(x, y);
        }
        if ((lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()))) {
            double x = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX());
            startPoint.setLocation(x, startPoint.getY());
            endPoint.setLocation(x, endPoint.getY());
        } else if (startBounds.getMinX() > endBounds.getMaxX()) {
            startPoint.setLocation(startBounds.getMinX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMaxX(), endPoint.getY());
        } else {
            startPoint.setLocation(startBounds.getMaxX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMinX(), endPoint.getY());
        }
        double lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
        double upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
        if (lowerBoundY <= upperBoundY) {
            double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY());
            startPoint.setLocation(startPoint.getX(), y);
            endPoint.setLocation(endPoint.getX(), y);
        } else if (startBounds.getMinY() > endBounds.getMaxY()) {
            startPoint.setLocation(startPoint.getX(), startBounds.getMinY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMaxY());
        } else {
            startPoint.setLocation(startPoint.getX(), startBounds.getMaxY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMinY());
        }
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked, double arcWidth) {
        PortInst pi;
        if (!$assertionsDisabled && clicked == null) {
            throw new AssertionError();
        }
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            boolean compressPort = false;
            if (ni.getProto() instanceof PrimitiveNode) {
                compressPort = true;
            }
            Poly poly = ni.getShapeOfPort(pp, clicked, compressPort, arcWidth);
            return poly;
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Point2D[] points = new Point2D[]{arc.getHead().getLocation(), arc.getTail().getLocation()};
            Poly poly = new Poly(points);
            return poly;
        }
        return null;
    }

    protected RouteElementPort findArcConnectingPoint(Route route, ArcInst arc, Point2D point) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = arc.getHead().getLocation();
        Point2D tail = arc.getTail().getLocation();
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHead().getPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTail().getPortInst(), tail);
        RouteElementPort startRE = null;
        Point2D minXpin = null;
        Point2D minYpin = null;
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
            minXpin = head;
        } else {
            minX = tail.getX();
            maxX = head.getX();
            minXpin = tail;
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
            minYpin = head;
        } else {
            minY = tail.getY();
            maxY = head.getY();
            minYpin = tail;
        }
        if (head.getX() == tail.getX()) {
            if (point.getY() > minY && point.getY() < maxY) {
                Point2D.Double location = new Point2D.Double(head.getX(), point.getY());
                startRE = this.bisectArc(route, arc, location);
            } else {
                startRE = point.getY() <= minY ? (minYpin == head ? headRE : tailRE) : (minYpin == head ? tailRE : headRE);
            }
        } else if (head.getY() == tail.getY()) {
            if (point.getX() > minX && point.getX() < maxX) {
                Point2D.Double location = new Point2D.Double(point.getX(), head.getY());
                startRE = this.bisectArc(route, arc, location);
            } else {
                startRE = point.getX() <= minX ? (minXpin == head ? headRE : tailRE) : (minXpin == head ? tailRE : headRE);
            }
        } else {
            double tailDist;
            double headDist = point.distance(head);
            startRE = headDist < (tailDist = point.distance(tail)) ? headRE : tailRE;
        }
        return startRE;
    }

    protected RouteElementPort bisectArc(Route route, ArcInst arc, Point2D bisectPoint) {
        Cell cell = arc.getParent();
        Point2D head = arc.getHead().getLocation();
        Point2D tail = arc.getTail().getLocation();
        PrimitiveNode pn = ((PrimitiveArc)arc.getProto()).findOverridablePinProto();
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
        RouteElementPort newPinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height);
        newPinRE.setBisectArcPin(true);
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHead().getPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTail().getPortInst(), tail);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name1 = null;
        String name2 = null;
        if (head.distance(bisectPoint) > tail.distance(bisectPoint)) {
            name1 = arc.getName();
        } else {
            name2 = arc.getName();
        }
        RouteElementArc newHeadArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getWidth(), headRE, newPinRE, head, bisectPoint, name1, arc.getNameTextDescriptor(), arc);
        RouteElementArc newTailArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getWidth(), newPinRE, tailRE, bisectPoint, tail, name2, arc.getNameTextDescriptor(), arc);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElementArc deleteArcRE = RouteElementArc.deleteArc(arc);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected static double getClosestValue(double min, double max, double clicked) {
        if (clicked >= max) {
            return max;
        }
        if (clicked <= min) {
            return min;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max;
        double min;
        if (bound1 < bound2) {
            min = bound1;
            max = bound2;
        } else {
            min = bound2;
            max = bound1;
        }
        return point >= min && point <= max;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = line.getP1();
        Point2D tail = line.getP2();
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
        } else {
            minX = tail.getX();
            maxX = head.getX();
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
        } else {
            minY = tail.getY();
            maxY = head.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    static {
        $assertionsDisabled = !InteractiveRouter.class.desiredAssertionStatus();
    }

    public static class MakeVerticalRouteJob
    extends Router.CreateRouteJob {
        protected MakeVerticalRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router, route, cell, false);
        }

        public boolean doIt() {
            PortInst pi;
            NodeInst ni;
            if (!super.doIt()) {
                return false;
            }
            RouteElementPort startRE = this.route.getStart();
            if (startRE.getAction() == RouteElement.RouteElementAction.existingPortInst && (ni = (pi = startRE.getPortInst()).getNodeInst()).getProto().getFunction() == PrimitiveNode.Function.PIN) {
                CircuitChanges.Reconnect re = CircuitChanges.Reconnect.erasePassThru(ni, false);
                if (re != null) {
                    re.reconnectArcs();
                }
                ni.kill();
            }
            return true;
        }
    }
}

