/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Change
extends EDialog
implements HighlightListener {
    private static final int CHANGE_SELECTED = 1;
    private static final int CHANGE_CONNECTED = 2;
    private static final int CHANGE_CELL = 3;
    private static final int CHANGE_LIBRARY = 4;
    private static final int CHANGE_EVERYWHERE = 5;
    private static Change theDialog = null;
    private static boolean nodesAndArcs = false;
    private static int whatToChange = 1;
    private List geomsToChange;
    private static String libSelected = null;
    private JList changeList;
    private DefaultListModel changeListModel;
    private List changeNodeProtoList;
    private EditWindow wnd;
    private static final Pattern dummyName = Pattern.compile("(.*?)FROM(.*?)\\{(.*)");
    private boolean dontReload = false;
    private JCheckBox allowMissingPorts;
    private JButton apply;
    private JRadioButton changeConnected;
    private JRadioButton changeEverywhere;
    private JRadioButton changeInCell;
    private JRadioButton changeInLibrary;
    private JCheckBox changeNodesWithArcs;
    private ButtonGroup changeOption;
    private JRadioButton changeSelected;
    private JButton done;
    private JCheckBox ignorePortNames;
    private JLabel jLabel1;
    private JComboBox librariesPopup;
    private JScrollPane listPane;
    private JCheckBox showCells;
    private JCheckBox showPrimitives;

    public static void showChangeDialog() {
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new Change((Frame)jf, false);
        }
        theDialog.loadInfo(true);
        theDialog.setVisible(true);
    }

    private Change(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.changeListModel = new DefaultListModel();
        this.changeList = new JList(this.changeListModel);
        this.changeList.setSelectionMode(0);
        this.listPane.setViewportView(this.changeList);
        this.changeNodeProtoList = new ArrayList();
        this.changeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Change.this.apply(null);
                }
            }
        });
        List libList = Library.getVisibleLibrariesSortedByName();
        int curIndex = libList.indexOf(Library.getCurrent());
        Iterator it = libList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            this.librariesPopup.addItem(lib.getName());
            if (!lib.getName().equals(libSelected)) continue;
            curIndex = -1;
            this.librariesPopup.setSelectedItem(libSelected);
        }
        if (curIndex >= 0) {
            this.librariesPopup.setSelectedIndex(curIndex);
        }
        this.librariesPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.showPrimitives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.showCells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeNodesWithArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeConnected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeEverywhere.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        switch (whatToChange) {
            case 1: {
                this.changeSelected.setSelected(true);
                break;
            }
            case 2: {
                this.changeConnected.setSelected(true);
                break;
            }
            case 3: {
                this.changeInCell.setSelected(true);
                break;
            }
            case 4: {
                this.changeInLibrary.setSelected(true);
                break;
            }
            case 5: {
                this.changeEverywhere.setSelected(true);
            }
        }
        this.finishInitialization();
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(true);
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(false);
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void whatToChangeChanged(ActionEvent evt) {
        JRadioButton src = (JRadioButton)evt.getSource();
        if (src == this.changeSelected) {
            whatToChange = 1;
        } else if (src == this.changeConnected) {
            whatToChange = 2;
        } else if (src == this.changeInCell) {
            whatToChange = 3;
        } else if (src == this.changeInLibrary) {
            whatToChange = 4;
        } else if (src == this.changeEverywhere) {
            whatToChange = 5;
        }
        Geometric geomToChange = (Geometric)this.geomsToChange.get(0);
        if (whatToChange == 5) {
            if (geomToChange instanceof ArcInst) {
                if (this.changeNodesWithArcs.isSelected()) {
                    this.changeNodesWithArcs.setSelected(false);
                    this.reload(false);
                }
                this.changeNodesWithArcs.setEnabled(false);
            }
        } else if (geomToChange instanceof ArcInst) {
            this.changeNodesWithArcs.setEnabled(true);
        }
    }

    private void loadInfo(boolean showHighlighted) {
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        this.geomsToChange = new ArrayList();
        if (this.wnd != null) {
            List highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
            Iterator it = highs.iterator();
            while (it.hasNext()) {
                this.geomsToChange.add(it.next());
            }
        }
        if (this.geomsToChange.size() == 0) {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(false);
            this.apply.setEnabled(false);
            this.changeSelected.setEnabled(false);
            this.changeConnected.setEnabled(false);
            this.changeInCell.setEnabled(false);
            this.changeInLibrary.setEnabled(false);
            this.changeEverywhere.setEnabled(false);
            return;
        }
        this.apply.setEnabled(true);
        this.changeSelected.setEnabled(true);
        this.changeConnected.setEnabled(true);
        this.changeInCell.setEnabled(true);
        this.changeInLibrary.setEnabled(true);
        this.changeEverywhere.setEnabled(true);
        Geometric geomToChange = (Geometric)this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            this.librariesPopup.setEnabled(true);
            this.ignorePortNames.setEnabled(true);
            this.allowMissingPorts.setEnabled(true);
            this.showPrimitives.setEnabled(true);
            this.showCells.setEnabled(true);
            NodeInst ni = (NodeInst)geomToChange;
            if (ni.getProto() instanceof Cell) {
                this.showCells.setSelected(true);
            } else {
                this.showPrimitives.setSelected(true);
            }
            this.changeNodesWithArcs.setSelected(false);
            this.changeNodesWithArcs.setEnabled(false);
        } else {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(true);
            this.changeNodesWithArcs.setSelected(nodesAndArcs);
        }
        this.reload(true);
    }

    private void reload(boolean canSwitchLibraries) {
        if (this.dontReload) {
            return;
        }
        this.changeListModel.clear();
        this.changeNodeProtoList.clear();
        if (this.geomsToChange.size() == 0) {
            return;
        }
        Technology curTech = Technology.getCurrent();
        Geometric geomToChange = (Geometric)this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            NodeInst ni = (NodeInst)geomToChange;
            if (this.showCells.isSelected()) {
                Library lib;
                if (ni.getProto() instanceof Cell && canSwitchLibraries) {
                    Cell parent = (Cell)ni.getProto();
                    lib = parent.getLibrary();
                    this.dontReload = true;
                    this.librariesPopup.setSelectedItem(lib.getName());
                    this.dontReload = false;
                }
                String libName = (String)this.librariesPopup.getSelectedItem();
                lib = Library.findLibrary(libName);
                List cells = lib.getCellsSortedByName();
                Iterator it = cells.iterator();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    this.changeListModel.addElement(cell.noLibDescribe());
                    this.changeNodeProtoList.add(cell);
                }
            }
            if (this.showPrimitives.isSelected()) {
                List list = curTech.getNodesSortedByName();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    PrimitiveNode np = (PrimitiveNode)it.next();
                    this.changeListModel.addElement(np.describe());
                    this.changeNodeProtoList.add(np);
                }
                if (curTech != Generic.tech) {
                    this.changeListModel.addElement("Generic:Universal-Pin");
                    this.changeNodeProtoList.add(Generic.tech.universalPinNode);
                    this.changeListModel.addElement("Generic:Invisible-Pin");
                    this.changeNodeProtoList.add(Generic.tech.invisiblePinNode);
                    this.changeListModel.addElement("Generic:Unrouted-Pin");
                    this.changeNodeProtoList.add(Generic.tech.unroutedPinNode);
                }
            }
            this.changeList.setSelectedIndex(0);
            if (ni.getProto() instanceof Cell) {
                Cell c = (Cell)ni.getProto();
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(c.noLibDescribe())) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            } else {
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(ni.getProto().describe())) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            }
            if (this.showCells.isSelected()) {
                String geomName = ((NodeInst)geomToChange).getProto().describe();
                Matcher mat = dummyName.matcher(geomName);
                if (mat.matches()) {
                    this.changeList.setSelectedValue(mat.group(1) + "{" + mat.group(3), true);
                    this.librariesPopup.setSelectedItem(mat.group(2));
                } else {
                    this.changeList.setSelectedValue(geomName, true);
                }
            }
        } else {
            Technology arcTech;
            PrimitiveArc ap;
            ArcInst ai = (ArcInst)geomToChange;
            PortProto pp1 = ai.getHead().getPortInst().getPortProto();
            PortProto pp2 = ai.getTail().getPortInst().getPortProto();
            Iterator it = curTech.getArcs();
            while (it.hasNext()) {
                ap = (PrimitiveArc)it.next();
                if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                this.changeListModel.addElement(ap.describe());
            }
            if (curTech != Generic.tech) {
                it = Generic.tech.getArcs();
                while (it.hasNext()) {
                    ap = (PrimitiveArc)it.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                    this.changeListModel.addElement(ap.describe());
                }
            }
            if ((arcTech = ai.getProto().getTechnology()) != curTech && arcTech != Generic.tech) {
                Iterator it2 = arcTech.getArcs();
                while (it2.hasNext()) {
                    PrimitiveArc ap2 = (PrimitiveArc)it2.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap2) || !pp2.connectsTo(ap2))) continue;
                    this.changeListModel.addElement(ap2.describe());
                }
            }
            this.changeList.setSelectedIndex(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Change.this.centerSelection(Change.this.changeList);
            }
        });
    }

    private void doTheChange() {
        ChangeObject job = new ChangeObject(this);
    }

    protected String getLibSelected() {
        return (String)this.librariesPopup.getSelectedItem();
    }

    private void initComponents() {
        this.changeOption = new ButtonGroup();
        this.done = new JButton();
        this.apply = new JButton();
        this.listPane = new JScrollPane();
        this.changeSelected = new JRadioButton();
        this.changeConnected = new JRadioButton();
        this.changeInCell = new JRadioButton();
        this.changeInLibrary = new JRadioButton();
        this.changeEverywhere = new JRadioButton();
        this.changeNodesWithArcs = new JCheckBox();
        this.showPrimitives = new JCheckBox();
        this.showCells = new JCheckBox();
        this.ignorePortNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.librariesPopup = new JComboBox();
        this.allowMissingPorts = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Change.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.apply(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(150, 22));
        this.listPane.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.changeSelected.setText("Change selected ones only");
        this.changeOption.add(this.changeSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.changeSelected, gridBagConstraints);
        this.changeConnected.setText("Change all connected to this");
        this.changeOption.add(this.changeConnected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeConnected, gridBagConstraints);
        this.changeInCell.setText("Change all in this cell");
        this.changeOption.add(this.changeInCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInCell, gridBagConstraints);
        this.changeInLibrary.setText("Change all in this library");
        this.changeOption.add(this.changeInLibrary);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInLibrary, gridBagConstraints);
        this.changeEverywhere.setText("Change all in all libraries");
        this.changeOption.add(this.changeEverywhere);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 10, 4);
        this.getContentPane().add((Component)this.changeEverywhere, gridBagConstraints);
        this.changeNodesWithArcs.setText("Change nodes with arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.getContentPane().add((Component)this.changeNodesWithArcs, gridBagConstraints);
        this.showPrimitives.setText("Show primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPrimitives, gridBagConstraints);
        this.showCells.setText("Show cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showCells, gridBagConstraints);
        this.ignorePortNames.setText("Ignore port names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignorePortNames, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.librariesPopup, gridBagConstraints);
        this.allowMissingPorts.setText("Allow missing ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowMissingPorts, gridBagConstraints);
        this.pack();
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void apply(ActionEvent evt) {
        this.doTheChange();
        libSelected = (String)this.librariesPopup.getSelectedItem();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        theDialog = null;
    }

    private static class ChangeObject
    extends Job {
        Change dialog;
        NodeProto[] contactStack = new NodeProto[100];
        ArcProto[] contactStackArc = new ArcProto[100];

        protected ChangeObject(Change dialog) {
            super("Change type", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Iterator geomit = this.dialog.geomsToChange.iterator();
            while (geomit.hasNext()) {
                String line;
                Geometric geomToChange = (Geometric)geomit.next();
                if (geomToChange instanceof NodeInst) {
                    boolean allowMissingPorts;
                    NodeInst ni = (NodeInst)geomToChange;
                    if (CircuitChanges.cantEdit(ni.getParent(), ni, true) != 0) {
                        return false;
                    }
                    line = this.dialog.getLibSelected();
                    Library library = Library.findLibrary(line);
                    if (library == null) {
                        return false;
                    }
                    int index = this.dialog.changeList.getSelectedIndex();
                    NodeProto np = (NodeProto)this.dialog.changeNodeProtoList.get(index);
                    if (np == null) {
                        return false;
                    }
                    NodeProto oldNType = ni.getProto();
                    if (oldNType == np) {
                        System.out.println("Node already of type " + np.describe());
                        return false;
                    }
                    boolean ignorePortNames = this.dialog.ignorePortNames.isSelected();
                    NodeInst onlyNewNi = CircuitChanges.replaceNodeInst(ni, np, ignorePortNames, allowMissingPorts = this.dialog.allowMissingPorts.isSelected());
                    if (onlyNewNi == null) {
                        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), np.describe() + " does not fit in the place of " + oldNType.describe(), "Change failed", 0);
                        return false;
                    }
                    this.dialog.wnd.getHighlighter().addElectricObject(onlyNewNi, onlyNewNi.getParent());
                    int total = 1;
                    if (this.dialog.changeEverywhere.isSelected()) {
                        Iterator it = Library.getLibraries();
                        while (it.hasNext()) {
                            Library lib = (Library)it.next();
                            Iterator cIt = lib.getCells();
                            while (cIt.hasNext()) {
                                Cell cell = (Cell)cIt.next();
                                boolean found = true;
                                block3: while (found) {
                                    found = false;
                                    Iterator nIt = cell.getNodes();
                                    while (nIt.hasNext()) {
                                        NodeInst newNi;
                                        NodeInst lNi = (NodeInst)nIt.next();
                                        if (lNi.getProto() != oldNType) continue;
                                        if (lNi.isIconOfParent()) {
                                            System.out.println("Example icon in cell " + cell.describe() + " not replaced");
                                            continue;
                                        }
                                        int errorCode = CircuitChanges.cantEdit(cell, lNi, true);
                                        if (errorCode < 0) {
                                            return false;
                                        }
                                        if (errorCode > 0 || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                                        ++total;
                                        found = true;
                                        continue block3;
                                    }
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe() + " nodes in all libraries replaced with " + np.describe());
                        continue;
                    }
                    if (this.dialog.changeInLibrary.isSelected()) {
                        Library lib = Library.getCurrent();
                        Iterator cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = (Cell)cIt.next();
                            boolean found = true;
                            block6: while (found) {
                                found = false;
                                Iterator nIt = cell.getNodes();
                                while (nIt.hasNext()) {
                                    NodeInst newNi;
                                    NodeInst lNi = (NodeInst)nIt.next();
                                    if (lNi.getProto() != oldNType) continue;
                                    int errorCode = CircuitChanges.cantEdit(cell, lNi, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block6;
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe() + " nodes in library " + lib.getName() + " replaced with " + np.describe());
                        continue;
                    }
                    if (this.dialog.changeInCell.isSelected()) {
                        Cell cell = WindowFrame.getCurrentCell();
                        boolean found = true;
                        block8: while (found) {
                            found = false;
                            Iterator nIt = cell.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst newNi;
                                NodeInst lNi = (NodeInst)nIt.next();
                                if (lNi.getProto() != oldNType) continue;
                                int errorCode = CircuitChanges.cantEdit(cell, lNi, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                                ++total;
                                found = true;
                                continue block8;
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe() + " nodes in cell " + cell.describe() + " replaced with " + np.describe());
                        continue;
                    }
                    if (this.dialog.changeConnected.isSelected()) {
                        NodeInst lNi;
                        Cell curCell = WindowFrame.getCurrentCell();
                        Netlist netlist = curCell.getUserNetlist();
                        ArrayList<NodeInst> others = new ArrayList<NodeInst>();
                        Iterator it = curCell.getNodes();
                        while (it.hasNext()) {
                            lNi = (NodeInst)it.next();
                            if (lNi.getProto() != oldNType || lNi == onlyNewNi) continue;
                            boolean found = false;
                            Iterator pIt = onlyNewNi.getPortInsts();
                            while (pIt.hasNext()) {
                                PortInst pi = (PortInst)pIt.next();
                                Iterator lPIt = lNi.getPortInsts();
                                while (lPIt.hasNext()) {
                                    PortInst lPi = (PortInst)lPIt.next();
                                    if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                break;
                            }
                            if (!found) continue;
                            others.add(lNi);
                        }
                        it = others.iterator();
                        while (it.hasNext()) {
                            NodeInst newNi;
                            lNi = (NodeInst)it.next();
                            int errorCode = CircuitChanges.cantEdit(curCell, lNi, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                            ++total;
                        }
                        System.out.println("All " + total + " " + oldNType.describe() + " nodes connected to this replaced with " + np.describe());
                        continue;
                    }
                    System.out.println("Node " + oldNType.describe() + " replaced with " + np.describe());
                    continue;
                }
                ArcInst ai = (ArcInst)geomToChange;
                if (CircuitChanges.cantEdit(ai.getParent(), null, true) != 0) {
                    return false;
                }
                line = (String)this.dialog.changeList.getSelectedValue();
                ArcProto ap = ArcProto.findArcProto(line);
                if (ap == null) {
                    System.out.println("Nothing called '" + line + "'");
                    return false;
                }
                ArcProto oldAType = ai.getProto();
                if (oldAType == ap) {
                    System.out.println("Arc already of type " + ap.describe());
                    return false;
                }
                if (this.dialog.changeNodesWithArcs.isSelected()) {
                    if (this.dialog.changeInLibrary.isSelected()) {
                        Iterator it = Library.getCurrent().getCells();
                        while (it.hasNext()) {
                            Cell cell = (Cell)it.next();
                            this.replaceAllArcs(cell, ai, ap, false, true);
                        }
                    } else {
                        this.replaceAllArcs(ai.getParent(), ai, ap, this.dialog.changeConnected.isSelected(), this.dialog.changeInCell.isSelected());
                    }
                    return true;
                }
                ArcInst onlyNewAi = ai.replace(ap);
                if (onlyNewAi == null) {
                    System.out.println(ap.describe() + " does not fit in the place of " + oldAType.describe());
                    return false;
                }
                this.dialog.wnd.getHighlighter().addElectricObject(onlyNewAi, onlyNewAi.getParent());
                int total = 1;
                if (this.dialog.changeEverywhere.isSelected()) {
                    Iterator it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = (Library)it.next();
                        Iterator cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = (Cell)cIt.next();
                            boolean found = true;
                            block17: while (found) {
                                found = false;
                                Iterator nIt = cell.getArcs();
                                while (nIt.hasNext()) {
                                    ArcInst newAi;
                                    ArcInst lAi = (ArcInst)nIt.next();
                                    if (lAi.getProto() != oldAType) continue;
                                    int errorCode = CircuitChanges.cantEdit(cell, null, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newAi = lAi.replace(ap)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block17;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in the library replaced with " + ap.describe());
                    continue;
                }
                if (this.dialog.changeInLibrary.isSelected()) {
                    Library lib = Library.getCurrent();
                    Iterator cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = (Cell)cIt.next();
                        boolean found = true;
                        block20: while (found) {
                            found = false;
                            Iterator nIt = cell.getArcs();
                            while (nIt.hasNext()) {
                                ArcInst newAi;
                                ArcInst lAi = (ArcInst)nIt.next();
                                if (lAi.getProto() != oldAType) continue;
                                int errorCode = CircuitChanges.cantEdit(cell, null, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newAi = lAi.replace(ap)) == null) continue;
                                ++total;
                                found = true;
                                continue block20;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in library " + lib.getName() + " replaced with " + ap.describe());
                    continue;
                }
                if (this.dialog.changeInCell.isSelected()) {
                    Cell cell = WindowFrame.getCurrentCell();
                    boolean found = true;
                    block22: while (found) {
                        found = false;
                        Iterator nIt = cell.getArcs();
                        while (nIt.hasNext()) {
                            ArcInst newAi;
                            ArcInst lAi = (ArcInst)nIt.next();
                            if (lAi.getProto() != oldAType) continue;
                            int errorCode = CircuitChanges.cantEdit(cell, null, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newAi = lAi.replace(ap)) == null) continue;
                            ++total;
                            found = true;
                            continue block22;
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in cell " + cell.describe() + " replaced with " + ap.describe());
                    continue;
                }
                if (this.dialog.changeConnected.isSelected()) {
                    ArcInst lAi;
                    ArrayList<ArcInst> others = new ArrayList<ArcInst>();
                    Cell cell = WindowFrame.getCurrentCell();
                    Netlist netlist = cell.getUserNetlist();
                    Iterator it = cell.getArcs();
                    while (it.hasNext()) {
                        lAi = (ArcInst)it.next();
                        if (lAi == onlyNewAi || !netlist.sameNetwork(onlyNewAi, lAi)) continue;
                        others.add(lAi);
                    }
                    it = others.iterator();
                    while (it.hasNext()) {
                        lAi = (ArcInst)it.next();
                        ArcInst newAi = lAi.replace(ap);
                        if (newAi == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs connected to this replaced with " + ap.describe());
                    continue;
                }
                System.out.println("Arc " + oldAType.describe() + " replaced with " + ap.describe());
            }
            return true;
        }

        private void replaceAllArcs(Cell cell, ArcInst oldAi, ArcProto ap, boolean connected, boolean thiscell) {
            NodeInst ni;
            ArcInst ai;
            ArcInst ai2;
            ArcInst ai3;
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            List highs = wnd.getHighlighter().getHighlightedEObjs(true, true);
            HashSet<Geometric> geomMarked = new HashSet<Geometric>();
            Iterator it = highs.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof ArcInst) || (ai3 = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
                geomMarked.add(ai3);
            }
            if (connected) {
                Netlist netlist = cell.getUserNetlist();
                Iterator it2 = cell.getArcs();
                while (it2.hasNext()) {
                    ai3 = (ArcInst)it2.next();
                    if (ai3.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai3, oldAi)) continue;
                    geomMarked.add(ai3);
                }
            }
            if (thiscell) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai4 = (ArcInst)it.next();
                    if (ai4.getProto() != oldAi.getProto()) continue;
                    geomMarked.add(ai4);
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni2 = (NodeInst)it.next();
                if (ni2.getProto() instanceof Cell || ni2.getNumExports() != 0 || ni2.getFunction() != PrimitiveNode.Function.PIN) continue;
                boolean allArcs = true;
                Iterator cIt = ni2.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    if (geomMarked.contains(con.getArc())) continue;
                    allArcs = false;
                    break;
                }
                if (!allArcs) continue;
                geomMarked.add(ni2);
            }
            PrimitiveNode pin = ((PrimitiveArc)ap).findOverridablePinProto();
            double xS = pin.getDefWidth();
            double yS = pin.getDefHeight();
            ArrayList<NodeInst> dupPins = new ArrayList<NodeInst>();
            Iterator it3 = cell.getNodes();
            while (it3.hasNext()) {
                NodeInst ni3 = (NodeInst)it3.next();
                if (!geomMarked.contains(ni3)) continue;
                dupPins.add(ni3);
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            Iterator it4 = dupPins.iterator();
            while (it4.hasNext()) {
                NodeInst ni4 = (NodeInst)it4.next();
                NodeInst newNi = NodeInst.makeInstance(pin, ni4.getAnchorCenter(), xS, yS, cell);
                if (newNi == null) {
                    return;
                }
                geomMarked.remove(newNi);
                newNodes.put(ni4, newNi);
            }
            ArrayList<ArcInst> dupArcs = new ArrayList<ArcInst>();
            Iterator it5 = cell.getArcs();
            while (it5.hasNext()) {
                ai2 = (ArcInst)it5.next();
                if (!geomMarked.contains(ai2)) continue;
                dupArcs.add(ai2);
            }
            it5 = dupArcs.iterator();
            while (it5.hasNext()) {
                ArcInst newAi;
                ai2 = (ArcInst)it5.next();
                NodeInst ni0 = ai2.getHead().getPortInst().getNodeInst();
                PortInst pi0 = null;
                NodeInst newNi0 = (NodeInst)newNodes.get(ni0);
                if (newNi0 != null) {
                    ni0 = newNi0;
                    pi0 = ni0.getOnlyPortInst();
                } else {
                    pi0 = this.makeContactStack(ai2, 0, ap);
                    if (pi0 == null) {
                        return;
                    }
                }
                NodeInst ni1 = ai2.getTail().getPortInst().getNodeInst();
                PortInst pi1 = null;
                NodeInst newNi1 = (NodeInst)newNodes.get(ni1);
                if (newNi1 != null) {
                    ni1 = newNi1;
                    pi1 = ni1.getOnlyPortInst();
                } else {
                    pi1 = this.makeContactStack(ai2, 1, ap);
                    if (pi1 == null) {
                        return;
                    }
                }
                double wid = ap.getDefaultWidth();
                if (ai2.getWidth() > wid) {
                    wid = ai2.getWidth();
                }
                if ((newAi = ArcInst.makeInstance(ap, wid, pi0, pi1, ai2.getHead().getLocation(), ai2.getTail().getLocation(), null)) == null) {
                    return;
                }
                newAi.copyPropertiesFrom(ai2);
                geomMarked.remove(newAi);
            }
            ArrayList<ArcInst> killArcs = new ArrayList<ArcInst>();
            Iterator it6 = cell.getArcs();
            while (it6.hasNext()) {
                ai = (ArcInst)it6.next();
                if (!geomMarked.contains(ai)) continue;
                killArcs.add(ai);
            }
            it6 = killArcs.iterator();
            while (it6.hasNext()) {
                ai = (ArcInst)it6.next();
                ai.kill();
            }
            ArrayList<NodeInst> killNodes = new ArrayList<NodeInst>();
            Iterator it7 = cell.getNodes();
            while (it7.hasNext()) {
                ni = (NodeInst)it7.next();
                if (!geomMarked.contains(ni)) continue;
                killNodes.add(ni);
            }
            it7 = killNodes.iterator();
            while (it7.hasNext()) {
                ni = (NodeInst)it7.next();
                ni.kill();
            }
        }

        private PortInst makeContactStack(ArcInst ai, int end, ArcProto ap) {
            HashSet marked;
            NodeInst lastNi = ai.getConnection(end).getPortInst().getNodeInst();
            PortProto lastPp = ai.getConnection(end).getPortInst().getPortProto();
            int depth = this.findPathToArc(lastPp, ap, 0, marked = new HashSet());
            if (depth < 0) {
                return null;
            }
            Cell cell = ai.getParent();
            PortInst retPi = lastNi.findPortInstFromProto(lastPp);
            Point2D center = ai.getConnection(end).getLocation();
            for (int i = 0; i < depth; ++i) {
                double yS;
                double xS = this.contactStack[i].getDefWidth();
                NodeInst newNi = NodeInst.makeInstance(this.contactStack[i], center, xS, yS = this.contactStack[i].getDefHeight(), cell);
                if (newNi == null) {
                    return null;
                }
                PortInst thisPi = newNi.findPortInstFromProto(this.contactStack[i].getPort(0));
                ArcProto typ = this.contactStackArc[i];
                double wid = typ.getDefaultWidth();
                ArcInst newAi = ArcInst.makeInstance(typ, wid, thisPi, retPi);
                retPi = thisPi;
                if (newAi != null) continue;
                return null;
            }
            return retPi;
        }

        int findPathToArc(PortProto pp, ArcProto ap, int depth, Set marked) {
            if (pp.connectsTo(ap)) {
                return depth;
            }
            NodeProto bestNp = null;
            ArcProto bestAp = null;
            int bestDepth = 0;
            Technology tech = ap.getTechnology();
            Iterator it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode.Function fun;
                PrimitiveNode nextNp = (PrimitiveNode)it.next();
                if (marked.contains(nextNp) || (fun = nextNp.getFunction()) != PrimitiveNode.Function.CONTACT) continue;
                PortProto nextPp = nextNp.getPort(0);
                ArcProto[] connections = nextPp.getBasePort().getConnections();
                ArcProto found = null;
                for (int i = 0; i < connections.length; ++i) {
                    ArcProto thisAp = connections[i];
                    if (thisAp.getTechnology() != tech || !pp.connectsTo(thisAp)) continue;
                    found = thisAp;
                    break;
                }
                if (found == null) continue;
                this.contactStack[depth] = nextNp;
                marked.add(nextNp);
                int newDepth = this.findPathToArc(nextPp, ap, depth + 1, marked);
                marked.remove(nextNp);
                if (newDepth < 0 || bestNp != null && newDepth >= bestDepth) continue;
                bestDepth = newDepth;
                bestNp = nextNp;
                bestAp = found;
            }
            if (bestNp != null) {
                this.contactStack[depth] = bestNp;
                this.contactStackArc[depth] = bestAp;
                marked.add(bestNp);
                int newDepth = this.findPathToArc(bestNp.getPort(0), ap, depth + 1, marked);
                marked.remove(bestNp);
                return newDepth;
            }
            return -1;
        }
    }
}

