/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class SelectObject
extends EDialog {
    private static final int NODES = 1;
    private static final int ARCS = 2;
    private static final int EXPORTS = 3;
    private static final int NETS = 4;
    private static int what = 1;
    private Cell cell;
    private JList list;
    private DefaultListModel model;
    private Highlighter highlighter;
    private JRadioButton arcs;
    private JButton done;
    private JRadioButton exports;
    private JRadioButton networks;
    private JRadioButton nodes;
    private JScrollPane objectPane;
    private ButtonGroup whatGroup;

    public static void selectObjectDialog() {
        SelectObject dialog = new SelectObject((Frame)TopLevel.getCurrentJFrame(), false);
        dialog.setVisible(true);
    }

    private SelectObject(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        switch (what) {
            case 1: {
                this.nodes.setSelected(true);
                break;
            }
            case 2: {
                this.arcs.setSelected(true);
                break;
            }
            case 3: {
                this.exports.setSelected(true);
                break;
            }
            case 4: {
                this.networks.setSelected(true);
            }
        }
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.objectPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SelectObject.this.listClicked();
            }
        });
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.closeDialog(null);
            }
        });
        this.nodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked();
            }
        });
        this.arcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked();
            }
        });
        this.exports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked();
            }
        });
        this.networks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked();
            }
        });
        this.buttonClicked();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.closeDialog(null);
    }

    private void listClicked() {
        String s = (String)this.list.getSelectedValue();
        if (this.nodes.isSelected()) {
            Iterator it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (!s.equals(ni.getName())) continue;
                this.highlighter.clear();
                this.highlighter.addElectricObject(ni, this.cell);
                this.highlighter.finished();
                return;
            }
        } else if (this.arcs.isSelected()) {
            Iterator it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                if (!s.equals(ai.getName())) continue;
                this.highlighter.clear();
                this.highlighter.addElectricObject(ai, this.cell);
                this.highlighter.finished();
                return;
            }
        } else if (this.exports.isSelected()) {
            Iterator it = this.cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                if (!s.equals(pp.getName())) continue;
                this.highlighter.clear();
                this.highlighter.addText(pp, this.cell, null, null);
                this.highlighter.finished();
                return;
            }
        } else {
            Netlist netlist = this.cell.getUserNetlist();
            Iterator it = netlist.getNetworks();
            while (it.hasNext()) {
                Network net = (Network)it.next();
                String netName = net.describe();
                if (netName.length() == 0 || !s.equals(netName)) continue;
                this.highlighter.clear();
                this.highlighter.addNetwork(net, this.cell);
                this.highlighter.finished();
                return;
            }
        }
    }

    private void buttonClicked() {
        Iterator it;
        this.model.clear();
        this.cell = WindowFrame.getCurrentCell();
        if (this.cell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent wc = wf.getContent();
        if (wc == null) {
            return;
        }
        this.highlighter = wc.getHighlighter();
        if (this.highlighter == null) {
            return;
        }
        ArrayList<String> allNames = new ArrayList<String>();
        if (this.nodes.isSelected()) {
            what = 1;
            it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                allNames.add(ni.getName());
            }
        } else if (this.arcs.isSelected()) {
            what = 2;
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                allNames.add(ai.getName());
            }
        } else if (this.exports.isSelected()) {
            what = 3;
            it = this.cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                allNames.add(pp.getName());
            }
        } else {
            what = 4;
            Netlist netlist = this.cell.getUserNetlist();
            Iterator it2 = netlist.getNetworks();
            while (it2.hasNext()) {
                Network net = (Network)it2.next();
                String netName = net.describe();
                if (netName.length() == 0) continue;
                allNames.add(netName);
            }
        }
        Collections.sort(allNames, new TextUtils.StringsWithNumbers());
        it = allNames.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            this.model.addElement(s);
        }
    }

    private void initComponents() {
        this.whatGroup = new ButtonGroup();
        this.done = new JButton();
        this.objectPane = new JScrollPane();
        this.nodes = new JRadioButton();
        this.exports = new JRadioButton();
        this.arcs = new JRadioButton();
        this.networks = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Object");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectObject.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.objectPane.setMinimumSize(new Dimension(200, 200));
        this.objectPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.objectPane, gridBagConstraints);
        this.nodes.setText("Nodes");
        this.whatGroup.add(this.nodes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.nodes, gridBagConstraints);
        this.exports.setText("Exports");
        this.whatGroup.add(this.exports);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exports, gridBagConstraints);
        this.arcs.setText("Arcs");
        this.whatGroup.add(this.arcs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.arcs, gridBagConstraints);
        this.networks.setText("Networks");
        this.whatGroup.add(this.networks);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.networks, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

