/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.Main;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class FileMenu {
    private static PageFormat pageFormat = null;

    protected static void addFileMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu fileMenu = new MenuBar.Menu("File", 'F');
        menuBar.add(fileMenu);
        fileMenu.addMenuItem("New Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.newLibraryCommand();
            }
        });
        fileMenu.addMenuItem("Open Library...", KeyStroke.getKeyStroke(79, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.openLibraryCommand();
            }
        });
        MenuBar.Menu importSubMenu = new MenuBar.Menu("Import");
        fileMenu.add(importSubMenu);
        importSubMenu.addMenuItem("CIF (Caltech Intermediate Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.CIF);
            }
        });
        importSubMenu.addMenuItem("GDS II (Stream)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.GDS);
            }
        });
        importSubMenu.addMenuItem("EDIF (Electronic Design Interchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.EDIF);
            }
        });
        importSubMenu.addMenuItem("LEF (Library Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.LEF);
            }
        });
        importSubMenu.addMenuItem("DEF (Design Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.DEF);
            }
        });
        importSubMenu.addMenuItem("DXF (AutoCAD)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.DXF);
            }
        });
        importSubMenu.addMenuItem("SUE (Schematic User Environment)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.SUE);
            }
        });
        importSubMenu.addSeparator();
        importSubMenu.addMenuItem("ELIB...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.ELIB);
            }
        });
        importSubMenu.addMenuItem("Readable Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.READABLEDUMP);
            }
        });
        importSubMenu.addMenuItem("Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.readTextCell();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Close Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.closeLibraryCommand(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Save Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.DEFAULTLIB, false, true);
            }
        });
        fileMenu.addMenuItem("Save Library as...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveAsLibraryCommand(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Save All Libraries", KeyStroke.getKeyStroke(83, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveAllLibrariesCommand();
            }
        });
        fileMenu.addMenuItem("Save All Libraries in Format...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveAllLibrariesInFormatCommand();
            }
        });
        MenuBar.Menu exportSubMenu = new MenuBar.Menu("Export");
        fileMenu.add(exportSubMenu);
        exportSubMenu.addMenuItem("CIF (Caltech Intermediate Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.CIF, false);
            }
        });
        exportSubMenu.addMenuItem("GDS II (Stream)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.GDS, false);
            }
        });
        exportSubMenu.addMenuItem("EDIF (Electronic Design Interchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.EDIF, false);
            }
        });
        exportSubMenu.addMenuItem("LEF (Library Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.LEF, false);
            }
        });
        exportSubMenu.addMenuItem("L...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.L, false);
            }
        });
        if (IOTool.hasSkill()) {
            exportSubMenu.addMenuItem("Skill (Cadence Commands)...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.exportCommand(FileType.SKILL, false);
                }
            });
        }
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("Eagle...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.EAGLE, false);
            }
        });
        exportSubMenu.addMenuItem("ECAD...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.ECAD, false);
            }
        });
        exportSubMenu.addMenuItem("Pads...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PADS, false);
            }
        });
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.writeTextCell();
            }
        });
        exportSubMenu.addMenuItem("PostScript...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.POSTSCRIPT, false);
            }
        });
        exportSubMenu.addMenuItem("PNG (Portable Network Graphics)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PNG, false);
            }
        });
        exportSubMenu.addMenuItem("DXF (AutoCAD)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.DXF, false);
            }
        });
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("ELIB (Version 6)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.ELIB, true, false);
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Change Current Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.changeCurrentLibraryCommand();
            }
        });
        fileMenu.addMenuItem("List Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.listLibrariesCommand();
            }
        });
        fileMenu.addMenuItem("Rename Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.renameLibrary(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Mark All Libraries for Saving", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.markAllLibrariesForSavingCommand();
            }
        });
        MenuBar.Menu checkSubMenu = new MenuBar.Menu("Check Libraries");
        fileMenu.add(checkSubMenu);
        checkSubMenu.addMenuItem("Check", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.checkAndRepairCommand(false);
            }
        });
        checkSubMenu.addMenuItem("Repair", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.checkAndRepairCommand(true);
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Page Setup...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.pageSetupCommand();
            }
        });
        fileMenu.addMenuItem("Print...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.printCommand();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Preferences...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.preferencesCommand();
            }
        });
        if (TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
            fileMenu.addMenuItem("Quit", KeyStroke.getKeyStroke(81, buckyBit), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.quitCommand();
                }
            });
        }
        fileMenu.addMenuItem("Force Quit (and Save)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.forceQuit();
            }
        });
    }

    public static void newLibraryCommand() {
        String newLibName = JOptionPane.showInputDialog("New Library Name", (Object)"");
        if (newLibName == null) {
            return;
        }
        NewLibrary job = new NewLibrary(newLibName);
    }

    public static void openLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.LIBRARYFORMATS, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Object deleteThis = null;
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            FileType type = FileMenu.getLibraryFormat(fileName, FileType.DEFAULTLIB);
            ReadLibrary job = new ReadLibrary(fileURL, type, deleteLib);
        }
    }

    public static FileType getLibraryFormat(String fileName, FileType defaultType) {
        for (int i = 0; i < FileType.libraryTypes.length; ++i) {
            FileType type = FileType.libraryTypes[i];
            if (!fileName.endsWith("." + type.getExtensions()[0])) continue;
            return type;
        }
        return defaultType;
    }

    private static boolean openALibrary(URL fileURL, FileType type) {
        Library noname;
        Library lib = null;
        lib = type == FileType.ELIB || type == FileType.JELIB || type == FileType.READABLEDUMP ? Input.readLibrary(fileURL, type) : Input.importLibrary(fileURL, type);
        if (lib != null && (noname = Library.findLibrary("noname")) != null && !noname.getCells().hasNext()) {
            noname.kill();
        }
        Undo.noUndoAllowed();
        if (lib == null) {
            return false;
        }
        lib.setCurrent();
        Cell cell = lib.getCurCell();
        if (cell == null) {
            System.out.println("No current cell in this library");
        } else if (!Main.BATCHMODE) {
            CreateCellWindow creator = new CreateCellWindow(cell);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(creator);
            } else {
                creator.run();
            }
        }
        return true;
    }

    public static void importLibraryCommand(FileType type) {
        String fileName = OpenFile.chooseInputFile(type, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Object deleteThis = null;
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            ReadLibrary job = new ReadLibrary(fileURL, type, deleteLib);
        }
    }

    public static void closeLibraryCommand(Library lib) {
        Set found = Library.findReferenceInCell(lib);
        if (found.size() != 0) {
            System.out.println("Cannot close library '" + lib.getName() + "':");
            System.out.print("\t Cells ");
            Iterator i = found.iterator();
            while (i.hasNext()) {
                Cell cell = (Cell)i.next();
                System.out.print("'" + cell.getName() + "'(" + cell.getLibrary().getName() + ") ");
            }
            System.out.println("refer to it.");
            return;
        }
        if (FileMenu.preventLoss(lib, 1)) {
            return;
        }
        String libName = lib.getName();
        WindowFrame.removeLibraryReferences(lib);
        CloseLibrary job = new CloseLibrary(lib);
    }

    public static boolean saveLibraryCommand(Library lib, FileType type, boolean compatibleWith6, boolean forceToType) {
        String[] extensions = type.getExtensions();
        String extension = extensions[0];
        String fileName = null;
        if (lib.isFromDisk()) {
            File file;
            if (type == FileType.JELIB || type == FileType.ELIB && !compatibleWith6) {
                fileName = lib.getLibFile().getPath();
                if (forceToType) {
                    type = OpenFile.getOpenFileType(fileName, FileType.DEFAULTLIB);
                    if (Main.getDebug()) {
                        FileType oldtype = type;
                        if (fileName.endsWith(".elib")) {
                            oldtype = FileType.ELIB;
                        } else if (fileName.endsWith(".jelib")) {
                            oldtype = FileType.JELIB;
                        } else if (fileName.endsWith(".txt")) {
                            oldtype = FileType.READABLEDUMP;
                        }
                        if (type != oldtype) {
                            System.out.println("Wrong type determined by OpenFile.getOpenFileType");
                        }
                    }
                }
            }
            if (fileName != null && (file = new File(fileName)).exists() && !file.canWrite()) {
                fileName = null;
            }
        }
        if (fileName == null) {
            fileName = OpenFile.chooseOutputFile(FileType.libraryTypes, null, lib.getName() + "." + extension);
            if (fileName == null) {
                return false;
            }
            type = FileMenu.getLibraryFormat(fileName, type);
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library oLib = (Library)it.next();
                if (oLib.isHidden() || oLib == lib || oLib.isChangedMajor() || !oLib.referencesLib(lib)) continue;
                oLib.setChangedMajor();
            }
        }
        SaveLibrary job = new SaveLibrary(lib, fileName, type, compatibleWith6);
        return true;
    }

    public static void saveAsLibraryCommand(Library lib) {
        lib.clearFromDisk();
        FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true);
        WindowFrame.wantToRedoTitleNames();
    }

    public static void saveAllLibrariesCommand() {
        FileMenu.saveAllLibrariesCommand(FileType.DEFAULTLIB, false, true);
    }

    public static void saveAllLibrariesCommand(FileType type, boolean compatibleWith6, boolean forceToType) {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor()) continue;
            if (lib.getLibFile() != null) {
                type = FileMenu.getLibraryFormat(lib.getLibFile().getFile(), type);
            }
            if (FileMenu.saveLibraryCommand(lib, type, compatibleWith6, forceToType)) continue;
            break;
        }
    }

    public static void saveAllLibrariesInFormatCommand() {
        Object[] formats = new Object[]{FileType.ELIB, FileType.JELIB, FileType.READABLEDUMP};
        Object format = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Output file format for all libraries:", "Save All Libraries In Format...", -1, null, formats, FileType.DEFAULTLIB);
        FileType outType = (FileType)format;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            if (lib.getLibFile() != null) {
                String fullName = lib.getLibFile().getFile();
                fullName = fullName.replaceAll("\\.\\w*?$", "." + outType.getExtensions()[0]);
                lib.setLibFile(TextUtils.makeURLToFile(fullName));
            }
            lib.setChangedMajor();
            lib.setChangedMinor();
        }
        FileMenu.saveAllLibrariesCommand(outType, false, false);
    }

    public static void exportCommand(FileType type, boolean isNetlist) {
        WindowFrame wf;
        WindowContent wnd;
        if (type == FileType.POSTSCRIPT) {
            if (PostScript.syncAll()) {
                return;
            }
            if (IOTool.isPrintEncapsulated()) {
                type = FileType.EPS;
            }
        }
        WindowContent windowContent = wnd = (wf = WindowFrame.getCurrentWindowFrame(false)) != null ? wf.getContent() : null;
        if (wnd == null) {
            System.out.println("No current window");
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
        }
        VarContext context = wnd instanceof EditWindow ? ((EditWindow)wnd).getVarContext() : null;
        String[] extensions = type.getExtensions();
        String filePath = (cell != null ? cell.getName() : "") + "." + extensions[0];
        if (type == FileType.SPICE && !Simulation.getSpiceRunChoice().equals("Don't Run")) {
            filePath = Simulation.getSpiceUseRunDir() ? Simulation.getSpiceRunDir() + File.separator + filePath : User.getWorkingDirectory() + File.separator + filePath;
            if (User.isShowFileSelectionForNetlists() && !Simulation.getSpiceOutputOverwrite()) {
                String saveDir = User.getWorkingDirectory();
                filePath = OpenFile.chooseOutputFile(type, null, filePath);
                User.setWorkingDirectory(saveDir);
                if (filePath == null) {
                    return;
                }
            }
            FileMenu.exportCellCommand(cell, context, filePath, type);
            return;
        }
        if (User.isShowFileSelectionForNetlists() || !isNetlist) {
            if ((filePath = OpenFile.chooseOutputFile(type, null, filePath)) == null) {
                return;
            }
        } else {
            filePath = User.getWorkingDirectory() + File.separator + filePath;
        }
        if (type == FileType.PNG) {
            String name = cell != null ? cell.describe() : filePath;
            ExportImage job = new ExportImage(name, wnd, filePath);
            return;
        }
        FileMenu.exportCellCommand(cell, context, filePath, type);
    }

    public static void exportCellCommand(Cell cell, VarContext context, String filePath, FileType type) {
        ExportCell job = new ExportCell(cell, context, filePath, type);
    }

    public static void pageSetupCommand() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pageFormat = pageFormat == null ? pj.pageDialog(pj.defaultPage()) : pj.pageDialog(pageFormat);
    }

    private static ElectricPrinter getOutputPreferences(WindowContent context, PrinterJob pj) {
        if (pageFormat == null) {
            pageFormat = pj.defaultPage();
            pageFormat.setOrientation(0);
            pageFormat = pj.validatePage(pageFormat);
        }
        ElectricPrinter ep = new ElectricPrinter(context, pageFormat);
        pj.setPrintable(ep, pageFormat);
        return ep;
    }

    public static void printCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            System.out.println("No current window to print");
            return;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(wf.getTitle());
        ElectricPrinter ep = FileMenu.getOutputPreferences(wf.getContent(), pj);
        String pName = IOTool.getPrinterName();
        PrintService[] printers = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printerToUse = null;
        for (int i = 0; i < printers.length; ++i) {
            if (!pName.equals(printers[i].getName())) continue;
            printerToUse = printers[i];
            break;
        }
        if (printerToUse != null) {
            try {
                pj.setPrintService(printerToUse);
            }
            catch (PrinterException e) {
                System.out.println("Printing error " + e);
            }
        }
        if (pj.printDialog()) {
            JPanel overall = wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(false);
            Dimension oldSize = null;
            if (wf.getContent() instanceof WaveformWindow) {
                int iw = (int)pageFormat.getImageableWidth();
                int ih = (int)pageFormat.getImageableHeight();
                oldSize = overall.getSize();
                overall.setSize(iw, ih);
                overall.validate();
                overall.repaint();
            }
            if ((printerToUse = pj.getPrintService()) != null) {
                IOTool.setPrinterName(printerToUse.getName());
            }
            SwingUtilities.invokeLater(new PrintJobAWT(wf, pj, oldSize));
        }
    }

    public static boolean quitCommand() {
        if (FileMenu.preventLoss(null, 0)) {
            return false;
        }
        try {
            QuitJob job = new QuitJob();
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean preventLoss(Library desiredLib, int action) {
        boolean saveCancelled = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (desiredLib != null && desiredLib != lib || lib.isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor()) continue;
            String how = "significantly";
            if (!lib.isChangedMajor()) {
                how = "insignificantly";
            }
            String theAction = "Save before quitting?";
            if (action == 1) {
                theAction = "Save before closing?";
            } else if (action == 2) {
                theAction = "Save before replacing?";
            }
            Object[] options = new String[]{"Yes", "No", "Cancel", "No to All"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Library " + lib.getName() + " has changed " + how + ".  " + theAction, "Save Library?", -1, 2, null, options, options[0]);
            if (ret == 0) {
                if (FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true)) continue;
                saveCancelled = true;
                continue;
            }
            if (ret == 1) continue;
            if (ret == 2) {
                return true;
            }
            if (ret != 3) continue;
            break;
        }
        return saveCancelled;
    }

    public static void forceQuit() {
        int i;
        boolean dirty = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor()) continue;
            dirty = true;
            break;
        }
        if (dirty) {
            Object[] options = new String[]{"Force Save and Quit", "Cancel", "Quit without Saving"};
            int i2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning!  Libraries Changed!  Saving changes now may create bad libraries!"}, "Force Quit", -1, 2, null, options, options[1]);
            if (i2 == 0) {
                if (!FileMenu.forceSave(false)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error during forced library save, not quiting", "Saving Failed", 0);
                    return;
                }
                System.exit(1);
            }
            if (i2 == 1) {
                return;
            }
            if (i2 == 2) {
                System.exit(1);
            }
        }
        if ((i = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! You are about to kill Electric!", "Do you really want to force quit?"}, "Force Quit", 0, 2)) == 0) {
            System.exit(1);
        }
    }

    public static boolean forceSave(boolean confirm) {
        String currentDir;
        File panicDir;
        boolean dirty = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor()) continue;
            dirty = true;
            break;
        }
        if (!dirty) {
            System.out.println("Libraries have not changed, not saving");
            return true;
        }
        if (confirm) {
            Object[] options = new String[]{"Cancel", "Force Save"};
            int i = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! Saving changes now may create bad libraries!", "Libraries will be saved to \"Panic\" directory in current directory", "Do you really want to force save?"}, "Force Save", -1, 2, null, options, options[0]);
            if (i == 0) {
                return false;
            }
        }
        if (!(panicDir = new File(currentDir = User.getWorkingDirectory(), "panic")).exists() && !panicDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create panic directory", panicDir.getAbsolutePath()}, "Error creating panic directory", 0);
            return false;
        }
        boolean retValue = true;
        FileType type = FileType.DEFAULTLIB;
        Iterator it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            if (lib.isHidden()) continue;
            URL libURL = lib.getLibFile();
            File newLibFile = null;
            if (libURL.getPath() == null) {
                newLibFile = new File(panicDir.getAbsolutePath(), lib.getName() + type.getExtensions()[0]);
            } else {
                File libFile = new File(libURL.getPath());
                String fileName = libFile.getName();
                if (fileName == null) {
                    fileName = lib.getName() + type.getExtensions()[0];
                }
                newLibFile = new File(panicDir.getAbsolutePath(), fileName);
            }
            URL newLibURL = TextUtils.makeURLToFile(newLibFile.getAbsolutePath());
            lib.setLibFile(newLibURL);
            boolean error = Output.writeLibrary(lib, type, false);
            if (!error) continue;
            System.out.println("Error saving library " + lib.getName());
            retValue = false;
        }
        return retValue;
    }

    public static class QuitJob
    extends Job {
        public QuitJob() {
            super("Quitting", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            ActivityLogger.finished();
            System.exit(0);
            return true;
        }
    }

    private static class PrintJobAWT
    implements Runnable {
        private WindowFrame wf;
        private PrinterJob pj;
        private Dimension oldSize;

        PrintJobAWT(WindowFrame wf, PrinterJob pj, Dimension oldSize) {
            this.wf = wf;
            this.pj = pj;
            this.oldSize = oldSize;
        }

        public void run() {
            try {
                this.pj.print();
            }
            catch (PrinterException pe) {
                System.out.println("Print aborted.");
            }
            JPanel overall = this.wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(true);
            if (this.oldSize != null) {
                overall.setSize(this.oldSize);
                overall.validate();
            }
        }
    }

    private static class ExportImage
    extends Job {
        String filePath;
        WindowContent wnd;

        public ExportImage(String description, WindowContent wnd, String filePath) {
            super("Export " + description + " (" + FileType.PNG + ")", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.filePath = filePath;
            this.startJob();
        }

        public boolean doIt() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            ElectricPrinter ep = FileMenu.getOutputPreferences(this.wnd, pj);
            BufferedImage img = this.wnd.getOffScreenImage(ep);
            PNG.writeImage(img, this.filePath);
            return true;
        }
    }

    private static class ExportCell
    extends Job {
        Cell cell;
        VarContext context;
        String filePath;
        FileType type;

        public ExportCell(Cell cell, VarContext context, String filePath, FileType type) {
            super("Export " + cell.describe() + " (" + type + ")", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.type = type;
            this.startJob();
        }

        public boolean doIt() {
            Output.writeCell(this.cell, this.context, this.filePath, this.type);
            return true;
        }
    }

    public static class SaveLibrary
    extends Job {
        Library lib;
        String newName;
        FileType type;
        boolean compatibleWith6;

        public SaveLibrary(Library lib, String newName, FileType type, boolean compatibleWith6) {
            super("Write Library " + lib.getName(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.type = type;
            this.compatibleWith6 = compatibleWith6;
            this.startJob();
        }

        public boolean doIt() {
            boolean retVal = false;
            try {
                retVal = this._doIt();
                if (!retVal) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Error saving files", "Please check your disk libraries"}, "Saving Failed", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Exception caught when saving files", e.getMessage(), "Please check your disk libraries"}, "Saving Failed", 0);
                ActivityLogger.logException(e);
            }
            return retVal;
        }

        private boolean _doIt() {
            boolean error;
            if (this.newName != null) {
                URL libURL = TextUtils.makeURLToFile(this.newName);
                this.lib.setLibFile(libURL);
                this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
            }
            return !(error = Output.writeLibrary(this.lib, this.type, this.compatibleWith6));
        }
    }

    public static class CloseLibrary
    extends Job {
        Library lib;

        public CloseLibrary(Library lib) {
            super("Close Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        public boolean doIt() {
            if (this.lib.kill()) {
                System.out.println("Library " + this.lib.getName() + " closed");
                WindowFrame.wantToRedoTitleNames();
                EditWindow.repaintAll();
                TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
            }
            return true;
        }
    }

    public static class CreateCellWindow
    implements Runnable {
        private Cell cell;

        public CreateCellWindow(Cell cell) {
            this.cell = cell;
        }

        public void run() {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content.getCell() != null) continue;
                wf.setCellWindow(this.cell);
                TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
                return;
            }
            WindowFrame.createEditWindow(this.cell);
            TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
        }
    }

    public static class ReadInitialELIBs
    extends Job {
        List fileURLs;

        public ReadInitialELIBs(List fileURLs) {
            super("Read Initial Libraries", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURLs = fileURLs;
            this.startJob();
        }

        public boolean doIt() {
            Library mainLib = Library.newInstance("noname", null);
            if (mainLib == null) {
                return false;
            }
            mainLib.setCurrent();
            boolean success = false;
            Iterator it = this.fileURLs.iterator();
            while (it.hasNext()) {
                URL file = (URL)it.next();
                FileType defType = FileType.DEFAULTLIB;
                String fileName = file.getFile();
                defType = FileMenu.getLibraryFormat(fileName, defType);
                if (!FileMenu.openALibrary(file, defType)) continue;
                success = true;
            }
            if (success) {
                // empty if block
            }
            return true;
        }
    }

    public static class ReadLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Library deleteLib;

        public ReadLibrary(URL fileURL, FileType type, Library deleteLib) {
            super("Read External Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.type = type;
            this.deleteLib = deleteLib;
            this.startJob();
        }

        public boolean doIt() {
            if (this.deleteLib != null) {
                if (Library.getNumVisibleLibraries() > 1) {
                    if (!this.deleteLib.kill()) {
                        return false;
                    }
                    this.deleteLib = null;
                } else {
                    this.deleteLib.setName("FORMERVERSIONOF" + this.deleteLib.getName());
                }
            }
            FileMenu.openALibrary(this.fileURL, this.type);
            if (this.deleteLib != null) {
                this.deleteLib.kill();
            }
            return true;
        }
    }

    public static class NewLibrary
    extends Job {
        private String newLibName;

        public NewLibrary(String newLibName) {
            super("New Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newLibName = newLibName;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Library.newInstance(this.newLibName, null);
            if (lib == null) {
                return false;
            }
            lib.setCurrent();
            EditWindow.repaintAll();
            TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
            System.out.println("New Library '" + lib.getName() + "' created");
            return true;
        }
    }
}

