/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class Exec
extends Thread {
    private final String command;
    private final String[] exec;
    private final String[] envVars;
    private final File dir;
    private final OutputStream outStreamRedir;
    private final OutputStream errStreamRedir;
    private PrintWriter processWriter;
    private Process p = null;
    private final ArrayList finishedListeners;

    public Exec(String command, String[] envVars, File dir, OutputStream outStreamRedir, OutputStream errStreamRedir) {
        this.command = command;
        this.exec = null;
        this.envVars = envVars;
        this.dir = dir;
        this.outStreamRedir = outStreamRedir;
        this.errStreamRedir = errStreamRedir;
        this.processWriter = null;
        this.finishedListeners = new ArrayList();
        this.setName(command);
    }

    public Exec(String[] exec, String[] envVars, File dir, OutputStream outStreamRedir, OutputStream errStreamRedir) {
        this.command = null;
        this.exec = exec;
        this.envVars = envVars;
        this.dir = dir;
        this.outStreamRedir = outStreamRedir;
        this.errStreamRedir = errStreamRedir;
        this.processWriter = null;
        this.finishedListeners = new ArrayList();
        this.setName(exec[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Runtime rt = Runtime.getRuntime();
            ExecProcessReader outReader = null;
            ExecProcessReader errReader = null;
            Exec exec = this;
            synchronized (exec) {
                this.p = this.command != null ? rt.exec(this.command, this.envVars, this.dir) : rt.exec(this.exec, this.envVars, this.dir);
                outReader = new ExecProcessReader(this.p.getInputStream(), this.outStreamRedir);
                errReader = new ExecProcessReader(this.p.getErrorStream(), this.errStreamRedir);
                outReader.start();
                errReader.start();
                this.processWriter = new PrintWriter(this.p.getOutputStream());
            }
            int exitVal = this.p.waitFor();
            if (this.outStreamRedir != null) {
                outReader.join();
            }
            if (this.errStreamRedir != null) {
                errReader.join();
            }
            StringBuffer com = new StringBuffer();
            if (this.command != null) {
                com.append(this.command);
            } else {
                for (int i = 0; i < this.exec.length; ++i) {
                    com.append(this.exec[i] + " ");
                }
            }
            System.out.println("Process finished [exit: " + exitVal + "]: " + com.toString());
            Object object = this.finishedListeners;
            synchronized (object) {
                FinishedEvent e = new FinishedEvent(this, com.toString(), this.dir, exitVal);
                ArrayList copy = new ArrayList();
                Iterator it = this.finishedListeners.iterator();
                while (it.hasNext()) {
                    copy.add(it.next());
                }
                it = copy.iterator();
                while (it.hasNext()) {
                    FinishedListener l = (FinishedListener)it.next();
                    l.processFinished(e);
                }
            }
            object = this;
            synchronized (object) {
                if (this.processWriter != null) {
                    this.processWriter.close();
                    this.processWriter = null;
                }
            }
        }
        catch (Exception e) {
            ActivityLogger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String line) {
        Exec exec = this;
        synchronized (exec) {
            if (this.processWriter == null) {
                System.out.println("Can't write to process: No valid process running.");
                return;
            }
            this.processWriter.println(line);
            this.processWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinishedListener(FinishedListener a) {
        ArrayList arrayList = this.finishedListeners;
        synchronized (arrayList) {
            this.finishedListeners.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinishedListener(FinishedListener a) {
        ArrayList arrayList = this.finishedListeners;
        synchronized (arrayList) {
            this.finishedListeners.remove(a);
        }
    }

    public synchronized void destroyProcess() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public static class FinishedEvent {
        private Object source;
        private String exec;
        private int exitValue;
        private File dir;

        public FinishedEvent(Object source, String exec, File dir, int exitValue) {
            this.source = source;
            this.exec = exec;
            this.exitValue = exitValue;
            this.dir = dir;
        }

        public Object getSource() {
            return this.source;
        }

        public String getExec() {
            return this.exec;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public File getWorkingDir() {
            return this.dir;
        }
    }

    public static interface FinishedListener {
        public void processFinished(FinishedEvent var1);
    }

    public static class ExecProcessReader
    extends Thread {
        private InputStream in;
        private OutputStream redirect;

        public ExecProcessReader(InputStream in) {
            this(in, null);
        }

        public ExecProcessReader(InputStream in, OutputStream redirect) {
            this.in = in;
            this.redirect = redirect;
            this.setName("ExecProcessReader");
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.redirect != null) {
                    pw = new PrintWriter(this.redirect);
                }
                InputStreamReader input = new InputStreamReader(this.in);
                BufferedReader reader = new BufferedReader(input);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                    pw.flush();
                }
                reader.close();
                input.close();
            }
            catch (IOException e) {
                ActivityLogger.logException(e);
            }
        }
    }
}

