/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogicalEffortTab
extends ProjSettingsPanel {
    private HashMap<Technology, Double> gateCapacitance;
    private HashMap<Technology, Double> wireCapRatio;
    private HashMap<Technology, Double> diffToGateCapRatio;
    private boolean changingLE;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel25;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField leConvergence;
    private JTextField leDefaultWireCapRatio;
    private JTextField leDiffToGateCapRatio;
    private JTextField leGateCapacitance;
    private JTextField leGlobalFanOut;
    private JTextField leKeeperSizeRatio;
    private JTextField leMaxIterations;
    private JComboBox leTechnology;
    private JCheckBox leUseLocalSettings;
    private JPanel logicalEffort;

    public LogicalEffortTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.logicalEffort;
    }

    public String getName() {
        return "Logical Effort";
    }

    public void init() {
        this.leUseLocalSettings.setSelected(LETool.isUseLocalSettings());
        this.leGlobalFanOut.setText(TextUtils.formatDouble(LETool.getGlobalFanout()));
        this.leConvergence.setText(TextUtils.formatDouble(LETool.getConvergenceEpsilon()));
        this.leMaxIterations.setText(String.valueOf(LETool.getMaxIterations()));
        this.leKeeperSizeRatio.setText(TextUtils.formatDouble(LETool.getKeeperRatio()));
        this.gateCapacitance = new HashMap();
        this.wireCapRatio = new HashMap();
        this.diffToGateCapRatio = new HashMap();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (!tech.isLayout()) continue;
            this.leTechnology.addItem(tech.getTechName());
            this.gateCapacitance.put(tech, new Double(tech.getGateCapacitance()));
            this.wireCapRatio.put(tech, new Double(tech.getWireRatio()));
            this.diffToGateCapRatio.put(tech, new Double(tech.getDiffAlpha()));
        }
        this.leTechnology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogicalEffortTab.this.showArcsInTechnology();
            }
        });
        this.leTechnology.setSelectedItem(Technology.getCurrent().getTechName());
        this.changingLE = false;
        this.leGateCapacitance.getDocument().addDocumentListener(new LEDocumentListener(this));
        this.leDefaultWireCapRatio.getDocument().addDocumentListener(new LEDocumentListener(this));
        this.leDiffToGateCapRatio.getDocument().addDocumentListener(new LEDocumentListener(this));
    }

    private void leInfoChanged() {
        if (this.changingLE) {
            return;
        }
        String techName = (String)this.leTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        double dVal = TextUtils.atof(this.leGateCapacitance.getText());
        this.gateCapacitance.put(tech, new Double(dVal));
        dVal = TextUtils.atof(this.leDefaultWireCapRatio.getText());
        this.wireCapRatio.put(tech, new Double(dVal));
        dVal = TextUtils.atof(this.leDiffToGateCapRatio.getText());
        this.diffToGateCapRatio.put(tech, new Double(dVal));
    }

    private void showArcsInTechnology() {
        String techName = (String)this.leTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changingLE = true;
        Double dVal = this.gateCapacitance.get(tech);
        this.leGateCapacitance.setText(TextUtils.formatDouble(dVal));
        dVal = this.wireCapRatio.get(tech);
        this.leDefaultWireCapRatio.setText(TextUtils.formatDouble(dVal));
        dVal = this.diffToGateCapRatio.get(tech);
        this.leDiffToGateCapRatio.setText(TextUtils.formatDouble(dVal));
        this.changingLE = false;
    }

    public void term() {
        int i;
        boolean nowBoolean = this.leUseLocalSettings.isSelected();
        if (LETool.isUseLocalSettings() != nowBoolean) {
            LETool.setUseLocalSettings(nowBoolean);
        }
        double value = TextUtils.atof(this.leGlobalFanOut.getText());
        if (LETool.getGlobalFanout() != value) {
            LETool.setGlobalFanout(value);
        }
        value = TextUtils.atof(this.leConvergence.getText());
        if (LETool.getConvergenceEpsilon() != value) {
            LETool.setConvergenceEpsilon(value);
        }
        if ((i = Integer.parseInt(this.leMaxIterations.getText())) != LETool.getMaxIterations()) {
            LETool.setMaxIterations(i);
        }
        value = TextUtils.atof(this.leKeeperSizeRatio.getText());
        if (LETool.getKeeperRatio() != value) {
            LETool.setKeeperRatio(value);
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (!tech.isLayout()) continue;
            Double dVal = this.gateCapacitance.get(tech);
            if (tech.getGateCapacitance() != dVal.doubleValue()) {
                tech.setGateCapacitance(dVal);
            }
            dVal = this.wireCapRatio.get(tech);
            if (tech.getWireRatio() != dVal.doubleValue()) {
                tech.setWireRatio(dVal);
            }
            dVal = this.diffToGateCapRatio.get(tech);
            if (tech.getDiffAlpha() == dVal.doubleValue()) continue;
            tech.setDiffAlpha(dVal);
        }
    }

    private void initComponents() {
        this.logicalEffort = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel25 = new JLabel();
        this.leUseLocalSettings = new JCheckBox();
        this.leGlobalFanOut = new JTextField();
        this.leConvergence = new JTextField();
        this.leMaxIterations = new JTextField();
        this.leKeeperSizeRatio = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel23 = new JLabel();
        this.leDiffToGateCapRatio = new JTextField();
        this.jLabel22 = new JLabel();
        this.leDefaultWireCapRatio = new JTextField();
        this.jLabel20 = new JLabel();
        this.leGateCapacitance = new JTextField();
        this.jLabel1 = new JLabel();
        this.leTechnology = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LogicalEffortTab.this.closeDialog(evt);
            }
        });
        this.logicalEffort.setLayout(new GridBagLayout());
        this.jLabel4.setText("Global Fan-Out (step-up):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel14.setText("Convergence epsilon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setText("Maximum number of iterations:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel25.setText("Keeper size ratio (keeper size / driver size):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel25, gridBagConstraints);
        this.leUseLocalSettings.setText("Use Local (cell) LE Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.logicalEffort.add((Component)this.leUseLocalSettings, gridBagConstraints);
        this.leGlobalFanOut.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leGlobalFanOut, gridBagConstraints);
        this.leConvergence.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leConvergence, gridBagConstraints);
        this.leMaxIterations.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leMaxIterations, gridBagConstraints);
        this.leKeeperSizeRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leKeeperSizeRatio, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Tech-specific"));
        this.jLabel23.setText("Diffusion to gate cap ratio (alpha) :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel23, gridBagConstraints);
        this.leDiffToGateCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leDiffToGateCapRatio, gridBagConstraints);
        this.jLabel22.setText("Default wire cap ratio (Cwire / Cgate):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel22, gridBagConstraints);
        this.leDefaultWireCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leDefaultWireCapRatio, gridBagConstraints);
        this.jLabel20.setText("Gate capacitance (fF/Lambda):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel20, gridBagConstraints);
        this.leGateCapacitance.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leGateCapacitance, gridBagConstraints);
        this.jLabel1.setText("For Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.logicalEffort, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LEDocumentListener
    implements DocumentListener {
        private LogicalEffortTab dialog;

        LEDocumentListener(LogicalEffortTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }
    }
}

