/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.CompileVHDL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenerateVHDL {
    private static final int MAXINPUTS = 30;
    private static final int BLOCKNORMAL = 0;
    private static final int BLOCKMOSTRAN = 1;
    private static final int BLOCKBUFFER = 2;
    private static final int BLOCKPOSLOGIC = 3;
    private static final int BLOCKINVERTER = 4;
    private static final int BLOCKNAND = 5;
    private static final int BLOCKNOR = 6;
    private static final int BLOCKXNOR = 7;
    private static final int BLOCKFLOPDS = 8;
    private static final int BLOCKFLOPDR = 9;
    private static final int BLOCKFLOPTS = 10;
    private static final int BLOCKFLOPTR = 11;
    private static final int BLOCKFLOP = 12;
    static List<String> vhdlStrings;

    public static List<String> convertCell(Cell cell) {
        if (cell.getNumPorts() == 0) {
            System.out.println("Cannot convert " + cell + " to VHDL: it has no ports");
            return null;
        }
        vhdlStrings = new ArrayList<String>();
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, new Visitor());
        return vhdlStrings;
    }

    private static void generateVHDL(HierarchyEnumerator.CellInfo info) {
        Network net;
        int special;
        Cell cell = info.getCell();
        if (vhdlStrings.size() > 0) {
            vhdlStrings.add("");
            vhdlStrings.add("");
        }
        vhdlStrings.add("-- VHDL automatically generated by Electric " + Version.getVersion() + " for " + cell);
        Netlist nl = info.getNetlist();
        HashSet<String> exportNames = new HashSet<String>();
        vhdlStrings.add("entity " + GenerateVHDL.addString(cell.getName(), null) + " is port(" + GenerateVHDL.addPortList(null, cell, nl, 0, exportNames) + ");");
        vhdlStrings.add("  end " + GenerateVHDL.addString(cell.getName(), null) + ";");
        vhdlStrings.add("");
        vhdlStrings.add("architecture " + GenerateVHDL.addString(cell.getName(), null) + "_BODY of " + GenerateVHDL.addString(cell.getName(), null) + " is");
        int instNum = 1;
        HashMap<ArcInst, Integer> negatedHeads = new HashMap<ArcInst, Integer>();
        HashMap<ArcInst, Integer> negatedTails = new HashMap<ArcInst, Integer>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (ai.getHead().isNegated()) {
                negatedHeads.put(ai, new Integer(instNum++));
            }
            if (!ai.getTail().isNegated()) continue;
            negatedTails.put(ai, new Integer(instNum++));
        }
        int[] gotNand = new int[31];
        int[] gotNor = new int[31];
        int[] gotXNor = new int[31];
        ArrayList<String> componentList = new ArrayList<String>();
        boolean gotInverters = false;
        Iterator<NodeInst> it2 = cell.getNodes();
        while (it2.hasNext()) {
            int i;
            AnalyzePrimitive ap;
            String pt;
            NodeInst ni = it2.next();
            if (ni.isIconOfParent() || (pt = (ap = new AnalyzePrimitive(ni, negatedHeads, negatedTails)).getPrimName()) == null) continue;
            special = ap.getSpecial();
            if (special == 4) {
                gotInverters = true;
                continue;
            }
            if (special == 5) {
                i = TextUtils.atoi(pt.substring(4));
                if (i <= 30) {
                    int n = i;
                    gotNand[n] = gotNand[n] + 1;
                    continue;
                }
                System.out.println("Cannot handle " + i + "-input NAND, limit is " + 30);
                continue;
            }
            if (special == 6) {
                i = TextUtils.atoi(pt.substring(3));
                if (i <= 30) {
                    int n = i;
                    gotNor[n] = gotNor[n] + 1;
                    continue;
                }
                System.out.println("Cannot handle " + i + "-input NOR, limit is " + 30);
                continue;
            }
            if (special == 7) {
                i = TextUtils.atoi(pt.substring(4));
                if (i <= 30) {
                    int n = i;
                    gotXNor[n] = gotXNor[n] + 1;
                    continue;
                }
                System.out.println("Cannot handle " + i + "-input XNOR, limit is " + 30);
                continue;
            }
            if (ni.getProto().getNumPorts() == 0 || componentList.contains(pt)) continue;
            componentList.add(pt);
            vhdlStrings.add("  component " + GenerateVHDL.addString(pt, null) + " port(" + GenerateVHDL.addPortList(ni, ni.getProto(), nl, special, null) + ");");
            vhdlStrings.add("    end component;");
        }
        if (negatedHeads.size() > 0 || negatedTails.size() > 0) {
            gotInverters = true;
        }
        if (gotInverters) {
            vhdlStrings.add("  component inverter port(a: in BIT; y: out BIT);");
            vhdlStrings.add("    end component;");
        }
        for (int i = 0; i < 30; ++i) {
            int j;
            StringBuffer multiDec;
            if (gotNand[i] != 0) {
                multiDec = new StringBuffer();
                multiDec.append("  component nand" + i + " port(");
                for (j = 1; j <= i; ++j) {
                    if (j > 1) {
                        multiDec.append(", ");
                    }
                    multiDec.append("a" + j);
                }
                multiDec.append(": in BIT; y: out BIT);");
                vhdlStrings.add(multiDec.toString());
                vhdlStrings.add("    end component;");
            }
            if (gotNor[i] != 0) {
                multiDec = new StringBuffer();
                multiDec.append("  component nor" + i + " port(");
                for (j = 1; j <= i; ++j) {
                    if (j > 1) {
                        multiDec.append(", ");
                    }
                    multiDec.append("a" + j);
                }
                multiDec.append(": in BIT; y: out BIT);");
                vhdlStrings.add(multiDec.toString());
                vhdlStrings.add("    end component;");
            }
            if (gotXNor[i] == 0) continue;
            multiDec = new StringBuffer();
            multiDec.append("  component xnor" + i + " port(");
            for (j = 1; j <= i; ++j) {
                if (j > 1) {
                    multiDec.append(", ");
                }
                multiDec.append("a" + j);
            }
            multiDec.append(": in BIT; y: out BIT);");
            vhdlStrings.add(multiDec.toString());
            vhdlStrings.add("    end component;");
        }
        HashSet<String> signalNames = new HashSet<String>();
        ArrayList<String> bodyStrings = new ArrayList<String>();
        Iterator<Nodable> it3 = nl.getNodables();
        while (it3.hasNext()) {
            Nodable no = it3.next();
            if (no.getProto().getNumPorts() == 0) continue;
            special = 0;
            String pt = no.getProto().getName();
            if (no instanceof NodeInst) {
                AnalyzePrimitive ap = new AnalyzePrimitive((NodeInst)no, negatedHeads, negatedTails);
                pt = ap.getPrimName();
                if (pt == null) continue;
                special = ap.getSpecial();
            }
            StringBuffer infstr = new StringBuffer();
            infstr.append("  ");
            String instname = no.getName();
            infstr.append(GenerateVHDL.addString(instname, null));
            if (componentList.contains(instname)) {
                infstr.append("NV");
            }
            infstr.append(": " + GenerateVHDL.addString(pt, null) + " port map(" + GenerateVHDL.addRealPorts(no, special, negatedHeads, negatedTails, signalNames, nl) + ");");
            bodyStrings.add(infstr.toString());
        }
        for (ArcInst ai : negatedHeads.keySet()) {
            Integer index = (Integer)negatedHeads.get(ai);
            StringBuffer invertStr = new StringBuffer();
            invertStr.append("  PSEUDO_INVERT" + index + ": inverter port map(");
            net = nl.getNetwork(ai, 0);
            if (ai.getHeadPortInst().getPortProto().getBasePort().getCharacteristic() == PortCharacteristic.OUT) {
                invertStr.append("PINV" + index + ", " + GenerateVHDL.addString(net.describe(false), cell));
            } else {
                invertStr.append(GenerateVHDL.addString(net.describe(false), cell) + ", PINV" + index);
            }
            invertStr.append(");");
            bodyStrings.add(invertStr.toString());
        }
        for (ArcInst ai : negatedTails.keySet()) {
            Integer index = (Integer)negatedHeads.get(ai);
            StringBuffer invertStr = new StringBuffer();
            invertStr.append("  PSEUDO_INVERT" + index + ": inverter port map(");
            net = nl.getNetwork(ai, 0);
            if (ai.getTailPortInst().getPortProto().getBasePort().getCharacteristic() == PortCharacteristic.OUT) {
                invertStr.append("PINV" + index + ", " + GenerateVHDL.addString(net.describe(false), cell));
            } else {
                invertStr.append(GenerateVHDL.addString(net.describe(false), cell) + ", PINV" + index);
            }
            invertStr.append(");");
            bodyStrings.add(invertStr.toString());
        }
        vhdlStrings.add("");
        boolean first = false;
        int lineLen = 0;
        StringBuffer infstr = new StringBuffer();
        for (String signalName : signalNames) {
            if (exportNames.contains(signalName)) continue;
            if (!first) {
                infstr.append("  signal ");
                lineLen = 9;
            } else {
                infstr.append(", ");
                lineLen += 2;
            }
            first = true;
            if (lineLen + signalName.length() > 80) {
                vhdlStrings.add(infstr.toString());
                infstr = new StringBuffer();
                infstr.append("    ");
                lineLen = 4;
            }
            infstr.append(GenerateVHDL.addString(signalName, cell));
            lineLen += signalName.length();
        }
        if (first) {
            infstr.append(": BIT;");
            vhdlStrings.add(infstr.toString());
        }
        vhdlStrings.add("");
        vhdlStrings.add("begin");
        for (String str : bodyStrings) {
            vhdlStrings.add(str);
        }
        vhdlStrings.add("end " + GenerateVHDL.addString(cell.getName(), null) + "_BODY;");
    }

    private static String addRealPorts(Nodable no, int special, Map<ArcInst, Integer> negatedHeads, Map<ArcInst, Integer> negatedTails, HashSet<String> signalNames, Netlist nl) {
        NodeProto np = no.getProto();
        boolean first = false;
        StringBuffer infstr = new StringBuffer();
        for (int pass = 0; pass < 5; ++pass) {
            Iterator<PortProto> it = np.getPorts();
            while (it.hasNext()) {
                PortProto otherPP;
                PortProto pp = it.next();
                if (np == Schematics.tech.transistor4Node && pp.getName().equals("b") || pass == 0 && pp.getCharacteristic() != PortCharacteristic.IN || pass == 1 && pp.getCharacteristic() != PortCharacteristic.OUT || pass == 2 && pp.getCharacteristic() != PortCharacteristic.PWR || pass == 3 && pp.getCharacteristic() != PortCharacteristic.GND || pass == 4 && (pp.getCharacteristic() == PortCharacteristic.IN || pp.getCharacteristic() == PortCharacteristic.OUT || pp.getCharacteristic() == PortCharacteristic.PWR || pp.getCharacteristic() == PortCharacteristic.GND)) continue;
                if (special == 1) {
                    PrimitivePort oPp;
                    boolean connected = false;
                    Iterator<PortProto> oIt = np.getPorts();
                    while (oIt.hasNext() && (oPp = (PrimitivePort)oIt.next()) != pp) {
                        if (oPp.getTopology() != ((PrimitivePort)pp).getTopology()) continue;
                        connected = true;
                        break;
                    }
                    if (connected) continue;
                }
                if ((special == 3 || special == 2 || special == 4 || special == 5 || special == 6 || special == 7) && !pp.getName().equals("a") && !pp.getName().equals("y") || (special == 10 || special == 8) && !pp.getName().equals("i1") && !pp.getName().equals("ck") && !pp.getName().equals("preset") && !pp.getName().equals("q") || (special == 11 || special == 9) && !pp.getName().equals("i1") && !pp.getName().equals("ck") && !pp.getName().equals("clear") && !pp.getName().equals("q")) continue;
                if (pp.getBasePort().isIsolated()) {
                    Iterator<Connection> cIt = no.getNodeInst().getConnections();
                    while (cIt.hasNext()) {
                        Integer index;
                        ArcInst ai;
                        ArcProto.Function fun;
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp || (fun = (ai = con.getArc()).getProto().getFunction()) == ArcProto.Function.NONELEC) continue;
                        String sigName = "open";
                        Network net = nl.getNetwork(ai, 0);
                        if (net != null) {
                            sigName = GenerateVHDL.addString(net.describe(false), no.getParent());
                        }
                        if (con.isNegated() && (index = con.getEndIndex() == 1 ? negatedHeads.get(ai) : negatedTails.get(ai)) != null) {
                            sigName = "PINV" + index;
                        }
                        signalNames.add(sigName);
                        if (first) {
                            infstr.append(", ");
                        }
                        first = true;
                        infstr.append(sigName);
                    }
                    continue;
                }
                boolean portNamed = false;
                Iterator<Connection> cIt = no.getNodeInst().getConnections();
                while (cIt.hasNext()) {
                    Integer index;
                    Connection con = cIt.next();
                    otherPP = con.getPortInst().getPortProto();
                    if (otherPP instanceof Export) {
                        otherPP = ((Export)otherPP).getEquivalent();
                    }
                    if (otherPP != pp) continue;
                    ArcInst ai = con.getArc();
                    if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) break;
                    if (first) {
                        infstr.append(", ");
                    }
                    first = true;
                    if (con.isNegated() && (index = con.getEndIndex() == 1 ? negatedHeads.get(ai) : negatedTails.get(ai)) != null) {
                        String sigName = "PINV" + index;
                        infstr.append(sigName);
                        signalNames.add(sigName);
                        continue;
                    }
                    int wid = nl.getBusWidth(ai);
                    for (int i = 0; i < wid; ++i) {
                        if (i != 0) {
                            infstr.append(", ");
                        }
                        Network subNet = nl.getNetwork(ai, i);
                        String subNetName = GenerateVHDL.getOneNetworkName(subNet);
                        String sigName = GenerateVHDL.addString(subNetName, no.getParent());
                        infstr.append(sigName);
                        signalNames.add(sigName);
                    }
                    portNamed = true;
                    break;
                }
                if (portNamed) continue;
                Iterator<Export> eIt = no.getNodeInst().getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    otherPP = e.getOriginalPort().getPortProto();
                    if (otherPP instanceof Export) {
                        otherPP = ((Export)otherPP).getEquivalent();
                    }
                    if (otherPP != pp) continue;
                    if (first) {
                        infstr.append(", ");
                    }
                    first = true;
                    int wid = nl.getBusWidth(e);
                    for (int i = 0; i < wid; ++i) {
                        if (i != 0) {
                            infstr.append(", ");
                        }
                        Network subNet = nl.getNetwork(e, i);
                        String subNetName = GenerateVHDL.getOneNetworkName(subNet);
                        infstr.append(GenerateVHDL.addString(subNetName, no.getParent()));
                    }
                    portNamed = true;
                    break;
                }
                if (portNamed) continue;
                if (first) {
                    infstr.append(", ");
                }
                first = true;
                infstr.append("open");
                System.out.println("Warning: port " + pp.getName() + " of node " + ((Object)no).toString() + " is not connected");
            }
        }
        return infstr.toString();
    }

    private static String addString(String orig, Cell environment) {
        StringBuffer sb = new StringBuffer();
        boolean nonAlnum = false;
        for (int i = 0; i < orig.length(); ++i) {
            char chr = orig.charAt(i);
            if (Character.isLetterOrDigit(chr)) {
                sb.append(chr);
                continue;
            }
            sb.append('_');
            nonAlnum = true;
        }
        if (!nonAlnum) {
            if (CompileVHDL.isKeyword(orig) != null) {
                sb.append('_');
                return sb.toString();
            }
            if (orig.equalsIgnoreCase("bit")) {
                sb.append('_');
                return sb.toString();
            }
        }
        if (environment != null) {
            Iterator<NodeInst> it = environment.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || !orig.equals(ni.getProto().getName())) continue;
                sb.append('_');
                break;
            }
        }
        return sb.toString();
    }

    private static String addPortList(NodeInst ni, NodeProto np, Netlist nl, int special, HashSet<String> exportNames) {
        Cell cnp;
        if (special == 10 || special == 8) {
            return "i1, ck, preset: in BIT; q: out BIT";
        }
        if (special == 11 || special == 9) {
            return "i1, ck, clear: in BIT; q: out BIT";
        }
        if (np instanceof Cell && ((Cell)np).getView() == View.ICON && (cnp = ((Cell)np).contentsView()) != null) {
            np = cnp;
        }
        if (ni != null && np instanceof Cell) {
            nl = ((Cell)np).acquireUserNetlist();
        }
        HashSet<PortProto> flaggedPorts = new HashSet<PortProto>();
        Iterator<PortProto> it = np.getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            if (special == 1) {
                PortProto oPp;
                boolean connected = false;
                Iterator<PortProto> oIt = np.getPorts();
                while (it.hasNext() && (oPp = oIt.next()) != pp) {
                    if (((PrimitivePort)oPp).getTopology() != ((PrimitivePort)pp).getTopology()) continue;
                    connected = true;
                    break;
                }
                if (connected) {
                    flaggedPorts.add(pp);
                    continue;
                }
            }
            if (special != 3 && special != 2 && special != 4 || pp.getName().equals("a") || pp.getName().equals("y")) continue;
            flaggedPorts.add(pp);
        }
        String before = "";
        StringBuffer infstr = new StringBuffer();
        before = GenerateVHDL.addThesePorts(infstr, ni, np, nl, PortCharacteristic.IN, flaggedPorts, exportNames, before);
        before = GenerateVHDL.addThesePorts(infstr, ni, np, nl, PortCharacteristic.OUT, flaggedPorts, exportNames, before);
        before = GenerateVHDL.addThesePorts(infstr, ni, np, nl, PortCharacteristic.PWR, flaggedPorts, exportNames, before);
        before = GenerateVHDL.addThesePorts(infstr, ni, np, nl, PortCharacteristic.GND, flaggedPorts, exportNames, before);
        before = GenerateVHDL.addThesePorts(infstr, ni, np, nl, null, flaggedPorts, exportNames, before);
        return infstr.toString();
    }

    private static String addThesePorts(StringBuffer infstr, NodeInst ni, NodeProto np, Netlist nl, PortCharacteristic bits, HashSet flaggedPorts, HashSet<String> exportNames, String before) {
        boolean didsome = false;
        HashSet<Network> networksFound = new HashSet<Network>();
        Iterator<PortProto> it = np.getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            if (flaggedPorts.contains(pp)) continue;
            PortCharacteristic ch = pp.getCharacteristic();
            if (bits == null ? ch == PortCharacteristic.IN || ch == PortCharacteristic.OUT || ch == PortCharacteristic.PWR || ch == PortCharacteristic.GND : ch != bits) continue;
            Cell cell = null;
            cell = ni != null ? ni.getParent() : (Cell)np;
            int wid = 1;
            if (pp instanceof Export) {
                wid = nl.getBusWidth((Export)pp);
            }
            for (int i = 0; i < wid; ++i) {
                String portName = pp.getName();
                if (pp instanceof Export) {
                    Network net = nl.getNetwork((Export)pp, i);
                    if (net != null) {
                        if (networksFound.contains(net)) continue;
                        networksFound.add(net);
                        portName = GenerateVHDL.getOneNetworkName(net);
                    } else {
                        System.out.println("Cannot find network for export '" + pp.getName() + "' on " + np);
                    }
                }
                if (pp.getBasePort().isIsolated()) {
                    int inst = 1;
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        infstr.append(before);
                        before = ", ";
                        String exportName = GenerateVHDL.addString(portName, cell) + inst++;
                        infstr.append(exportName);
                        if (exportNames == null) continue;
                        exportNames.add(exportName);
                    }
                } else {
                    infstr.append(before);
                    before = ", ";
                    String exportName = GenerateVHDL.addString(portName, cell);
                    infstr.append(exportName);
                    if (exportNames != null) {
                        exportNames.add(exportName);
                    }
                }
                didsome = true;
            }
        }
        if (didsome) {
            if (bits == PortCharacteristic.IN) {
                infstr.append(": in BIT");
            } else if (bits == PortCharacteristic.OUT || bits == PortCharacteristic.PWR || bits == PortCharacteristic.GND) {
                infstr.append(": out BIT");
            } else {
                infstr.append(": inout BIT");
            }
            before = "; ";
        }
        return before;
    }

    private static String getOneNetworkName(Network net) {
        Iterator<String> nIt = net.getNames();
        if (nIt.hasNext()) {
            return nIt.next();
        }
        return net.describe(false);
    }

    private static class AnalyzePrimitive {
        private String primName;
        private int special = 0;

        private String getPrimName() {
            return this.primName;
        }

        private int getSpecial() {
            return this.special;
        }

        private AnalyzePrimitive(NodeInst ni, Map<ArcInst, Integer> negatedHeads, Map<ArcInst, Integer> negatedTails) {
            Connection con;
            Iterator<Connection> it;
            Connection isNeg;
            Connection con2;
            if (ni.isCellInstance()) {
                this.primName = ni.getProto().getName();
                return;
            }
            PrimitiveNode.Function k = ni.getFunction();
            this.primName = null;
            if (k == PrimitiveNode.Function.TRANMOS || k == PrimitiveNode.Function.TRA4NMOS) {
                this.primName = "nMOStran";
                Variable var = ni.getVar(Simulation.WEAK_NODE_KEY);
                if (var != null) {
                    this.primName = "nMOStranWeak";
                }
                this.special = 1;
            } else if (k == PrimitiveNode.Function.TRADMOS || k == PrimitiveNode.Function.TRA4DMOS) {
                this.primName = "DMOStran";
                this.special = 1;
            } else if (k == PrimitiveNode.Function.TRAPMOS || k == PrimitiveNode.Function.TRA4PMOS) {
                this.primName = "PMOStran";
                Variable var = ni.getVar(Simulation.WEAK_NODE_KEY);
                if (var != null) {
                    this.primName = "PMOStranWeak";
                }
                this.special = 1;
            } else if (k == PrimitiveNode.Function.TRANPN || k == PrimitiveNode.Function.TRA4NPN) {
                this.primName = "NPNtran";
            } else if (k == PrimitiveNode.Function.TRAPNP || k == PrimitiveNode.Function.TRA4PNP) {
                this.primName = "PNPtran";
            } else if (k == PrimitiveNode.Function.TRANJFET || k == PrimitiveNode.Function.TRA4NJFET) {
                this.primName = "NJFET";
            } else if (k == PrimitiveNode.Function.TRAPJFET || k == PrimitiveNode.Function.TRA4PJFET) {
                this.primName = "PJFET";
            } else if (k == PrimitiveNode.Function.TRADMES || k == PrimitiveNode.Function.TRA4DMES) {
                this.primName = "DMEStran";
            } else if (k == PrimitiveNode.Function.TRAEMES || k == PrimitiveNode.Function.TRA4EMES) {
                this.primName = "EMEStran";
            } else if (k == PrimitiveNode.Function.FLIPFLOPRSMS || k == PrimitiveNode.Function.FLIPFLOPRSN || k == PrimitiveNode.Function.FLIPFLOPRSP) {
                this.primName = "rsff";
                this.special = 12;
            } else if (k == PrimitiveNode.Function.FLIPFLOPJKMS || k == PrimitiveNode.Function.FLIPFLOPJKN || k == PrimitiveNode.Function.FLIPFLOPJKP) {
                this.primName = "jkff";
                this.special = 12;
            } else if (k == PrimitiveNode.Function.FLIPFLOPDMS || k == PrimitiveNode.Function.FLIPFLOPDN || k == PrimitiveNode.Function.FLIPFLOPDP) {
                this.primName = "dsff";
                this.special = 8;
                Iterator<Connection> it2 = ni.getConnections();
                while (it2.hasNext()) {
                    Connection con3 = it2.next();
                    if (!con3.getPortInst().getPortProto().getName().equals("clear")) continue;
                    this.primName = "drff";
                    this.special = 9;
                    break;
                }
            } else if (k == PrimitiveNode.Function.FLIPFLOPTMS || k == PrimitiveNode.Function.FLIPFLOPTN || k == PrimitiveNode.Function.FLIPFLOPTP) {
                this.primName = "tsff";
                this.special = 10;
                Iterator<Connection> it3 = ni.getConnections();
                while (it3.hasNext()) {
                    Connection con4 = it3.next();
                    if (!con4.getPortInst().getPortProto().getName().equals("clear")) continue;
                    this.primName = "trff";
                    this.special = 11;
                    break;
                }
            } else if (k == PrimitiveNode.Function.BUFFER) {
                this.primName = Schematics.getVHDLNames(Schematics.tech.bufferNode);
                int slashPos = this.primName.indexOf(47);
                this.special = 2;
                Iterator<Connection> it4 = ni.getConnections();
                while (it4.hasNext()) {
                    con2 = it4.next();
                    if (!con2.getPortInst().getPortProto().getName().equals("y") || !con2.isNegated()) continue;
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 4;
                    if (con2.getEndIndex() == 1) {
                        negatedHeads.remove(con2.getArc());
                        break;
                    }
                    negatedTails.remove(con2.getArc());
                    break;
                }
                if (this.special == 2 && slashPos >= 0) {
                    this.primName = this.primName.substring(0, slashPos);
                }
            } else if (k == PrimitiveNode.Function.GATEAND) {
                this.primName = Schematics.getVHDLNames(Schematics.tech.andNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 5;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.GATEOR) {
                this.primName = Schematics.getVHDLNames(Schematics.tech.orNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 6;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.GATEXOR) {
                this.primName = Schematics.getVHDLNames(Schematics.tech.xorNode);
                int slashPos = this.primName.indexOf(47);
                int inPort = 0;
                isNeg = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    con = it.next();
                    if (con.getPortInst().getPortProto().getName().equals("a")) {
                        ++inPort;
                    }
                    if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
                    isNeg = con;
                }
                if (isNeg != null) {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(slashPos + 1);
                    }
                    this.special = 7;
                    if (isNeg.getEndIndex() == 1) {
                        negatedHeads.remove(isNeg.getArc());
                    } else {
                        negatedTails.remove(isNeg.getArc());
                    }
                } else {
                    if (slashPos >= 0) {
                        this.primName = this.primName.substring(0, slashPos);
                    }
                    this.special = 3;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.MUX) {
                this.primName = Schematics.getVHDLNames(Schematics.tech.muxNode);
                int inPort = 0;
                Iterator<Connection> it5 = ni.getConnections();
                while (it5.hasNext()) {
                    con2 = it5.next();
                    if (!con2.getPortInst().getPortProto().getName().equals("a")) continue;
                    ++inPort;
                }
                this.primName = this.primName + inPort;
            } else if (k == PrimitiveNode.Function.CONPOWER) {
                this.primName = "power";
            } else if (k == PrimitiveNode.Function.CONGROUND) {
                this.primName = "ground";
            }
            if (this.primName == null) {
                Iterator<Export> it6 = ni.getExports();
                while (it6.hasNext()) {
                    Export e = it6.next();
                    if (e.isPower()) {
                        this.primName = "power";
                        break;
                    }
                    if (!e.isGround()) continue;
                    this.primName = "ground";
                    break;
                }
            }
        }
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        private static HashSet<Cell> seenCells;

        private Visitor() {
            seenCells = new HashSet();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (seenCells.contains(cell)) {
                return true;
            }
            seenCells.add(cell);
            GenerateVHDL.generateVHDL(info);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

