/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ThreeDTab
extends PreferencePanel {
    private boolean initial3DTextChanging = false;
    private JList threeDLayerList;
    private DefaultListModel threeDLayerModel;
    protected HashMap<Layer, GenMath.MutableDouble> threeDThicknessMap;
    protected HashMap<Layer, GenMath.MutableDouble> threeDDistanceMap;
    private JPanel threeDSideView;
    private JLabel jLabel45;
    private JLabel jLabel47;
    private JPanel threeD;
    private JTextField threeDHeight;
    private JScrollPane threeDLayerPane;
    private JLabel threeDTechnology;
    private JTextField threeDThickness;

    public static ThreeDTab create3DTab(Frame parent, boolean modal) {
        ThreeDTab tab = null;
        Class plugin = Resources.get3DClass("ui.JThreeDTab");
        if (plugin != null) {
            try {
                Constructor instance = plugin.getDeclaredConstructor(Frame.class, Boolean.class);
                Object panel = instance.newInstance(parent, new Boolean(modal));
                tab = (ThreeDTab)panel;
            }
            catch (Exception e) {
                System.out.println("Cannot create instance of 3D plugin JThreeDTab: " + e.getMessage());
            }
        } else {
            tab = new ThreeDTab(parent, modal);
        }
        return tab;
    }

    public ThreeDTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getPanel() {
        return this.threeD;
    }

    @Override
    public String getName() {
        return "3D";
    }

    @Override
    public void init() {
        this.threeDTechnology.setText("Layer cross section for technology '" + this.curTech.getTechName() + "'");
        this.threeDLayerModel = new DefaultListModel();
        this.threeDLayerList = new JList(this.threeDLayerModel);
        this.threeDLayerList.setSelectionMode(0);
        this.threeDLayerPane.setViewportView(this.threeDLayerList);
        this.threeDLayerList.clearSelection();
        this.threeDLayerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ThreeDTab.this.threeDValuesChanged(false);
            }
        });
        this.threeDThicknessMap = new HashMap();
        this.threeDDistanceMap = new HashMap();
        for (Layer layer : this.curTech.getLayersSortedByHeight()) {
            if (layer.isPseudoLayer()) continue;
            this.threeDLayerModel.addElement(layer.getName());
            this.threeDThicknessMap.put(layer, new GenMath.MutableDouble(layer.getThickness()));
            this.threeDDistanceMap.put(layer, new GenMath.MutableDouble(layer.getDistance()));
        }
        this.threeDLayerList.setSelectedIndex(0);
        this.threeDHeight.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDThickness.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDSideView = new ThreeDSideView(this);
        this.threeDSideView.setMinimumSize(new Dimension(200, 450));
        this.threeDSideView.setPreferredSize(new Dimension(200, 450));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 4;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDSideView, gbc);
        this.threeDValuesChanged(false);
    }

    private void threeDValuesChanged(boolean set) {
        if (!set) {
            this.initial3DTextChanging = true;
        } else if (this.initial3DTextChanging) {
            return;
        }
        String layerName = (String)this.threeDLayerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer == null) {
            return;
        }
        GenMath.MutableDouble thickness = this.threeDThicknessMap.get(layer);
        GenMath.MutableDouble height = this.threeDDistanceMap.get(layer);
        if (set) {
            thickness.setValue(TextUtils.atof(this.threeDThickness.getText()));
            height.setValue(TextUtils.atof(this.threeDHeight.getText()));
        } else {
            this.threeDHeight.setText(TextUtils.formatDouble(height.doubleValue()));
            this.threeDThickness.setText(TextUtils.formatDouble(thickness.doubleValue()));
        }
        if (!set) {
            this.initial3DTextChanging = false;
        }
        this.threeDSideView.repaint();
    }

    @Override
    public void term() {
        Iterator<Layer> it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer.isPseudoLayer()) continue;
            GenMath.MutableDouble thickness = this.threeDThicknessMap.get(layer);
            GenMath.MutableDouble height = this.threeDDistanceMap.get(layer);
            if (thickness.doubleValue() != layer.getThickness()) {
                layer.setThickness(thickness.doubleValue());
            }
            if (height.doubleValue() == layer.getDistance()) continue;
            layer.setDistance(height.doubleValue());
        }
    }

    private void initComponents() {
        this.threeD = new JPanel();
        this.threeDTechnology = new JLabel();
        this.threeDLayerPane = new JScrollPane();
        this.jLabel45 = new JLabel();
        this.jLabel47 = new JLabel();
        this.threeDThickness = new JTextField();
        this.threeDHeight = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ThreeDTab.this.closeDialog(evt);
            }
        });
        this.threeD.setLayout(new GridBagLayout());
        this.threeDTechnology.setText("Layer cross section for technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDLayerPane, gridBagConstraints);
        this.jLabel45.setText("Thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.jLabel45, gridBagConstraints);
        this.jLabel47.setText("Distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.jLabel47, gridBagConstraints);
        this.threeDThickness.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDThickness, gridBagConstraints);
        this.threeDHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDHeight, gridBagConstraints);
        this.getContentPane().add((Component)this.threeD, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ThreeDInfoDocumentListener
    implements DocumentListener {
        ThreeDTab dialog;

        ThreeDInfoDocumentListener(ThreeDTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }
    }

    private class ThreeDSideView
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        ThreeDTab dialog;
        double lowHeight = Double.MAX_VALUE;
        double highHeight = Double.MIN_VALUE;

        ThreeDSideView(ThreeDTab dialog) {
            this.dialog = dialog;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            Iterator<Layer> it = dialog.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (layer.isPseudoLayer() || !layer.isVisible()) continue;
                GenMath.MutableDouble thickness = dialog.threeDThicknessMap.get(layer);
                GenMath.MutableDouble distance = dialog.threeDDistanceMap.get(layer);
                double dis = distance.doubleValue();
                double thick = thickness.doubleValue() / 2.0;
                double valLow = dis - thick;
                double valHig = dis + thick;
                if (valLow < this.lowHeight) {
                    this.lowHeight = valLow;
                }
                if (!(valHig > this.highHeight)) continue;
                this.highHeight = valHig;
            }
            this.lowHeight -= 4.0;
            this.highHeight += 4.0;
        }

        @Override
        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, 0, dim.height - 1);
            g.drawLine(0, dim.height - 1, dim.width - 1, dim.height - 1);
            g.drawLine(dim.width - 1, dim.height - 1, dim.width - 1, 0);
            g.drawLine(dim.width - 1, 0, 0, 0);
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer selectedLayer = this.dialog.curTech.findLayer(layerName);
            Iterator<Layer> it = this.dialog.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (layer.isPseudoLayer()) continue;
                if (layer == selectedLayer) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLACK);
                }
                GenMath.MutableDouble thickness = this.dialog.threeDThicknessMap.get(layer);
                GenMath.MutableDouble distance = this.dialog.threeDDistanceMap.get(layer);
                double dis = distance.doubleValue() + thickness.doubleValue() / 2.0;
                int yValue = dim.height - (int)((dis - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
                int yHeight = (int)(thickness.doubleValue() / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
                if (yHeight == 0) {
                    g.drawLine(0, yValue, dim.width / 3, yValue);
                } else {
                    int firstPart = dim.width / 6;
                    int pointPos = dim.width / 4;
                    g.drawLine(0, yValue - yHeight / 2, firstPart, yValue - yHeight / 2);
                    g.drawLine(0, yValue + yHeight / 2, firstPart, yValue + yHeight / 2);
                    g.drawLine(firstPart, yValue - yHeight / 2, pointPos, yValue);
                    g.drawLine(firstPart, yValue + yHeight / 2, pointPos, yValue);
                    g.drawLine(pointPos, yValue, dim.width / 3, yValue);
                }
                String string = layer.getName();
                Font font = new Font(User.getDefaultFont(), 0, 9);
                g.setFont(font);
                FontRenderContext frc = new FontRenderContext(null, true, true);
                GlyphVector gv = font.createGlyphVector(frc, string);
                LineMetrics lm = font.getLineMetrics(string, frc);
                double txtHeight = lm.getHeight();
                Graphics2D g2 = (Graphics2D)g;
                g2.drawGlyphVector(gv, dim.width / 3 + 1, (float)((double)yValue + txtHeight / 2.0) - lm.getDescent());
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Dimension dim = this.getSize();
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer selectedLayer = this.dialog.curTech.findLayer(layerName);
            GenMath.MutableDouble height = this.dialog.threeDDistanceMap.get(selectedLayer);
            int yValue = dim.height - (int)((height.doubleValue() - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5);
            if (Math.abs(yValue - evt.getY()) > 5) {
                int bestDist = dim.height;
                Iterator<Layer> it = this.dialog.curTech.getLayers();
                while (it.hasNext()) {
                    int dist;
                    Layer layer = it.next();
                    if (layer.isPseudoLayer() || (dist = Math.abs((yValue = dim.height - (int)(((height = this.dialog.threeDDistanceMap.get(layer)).doubleValue() - this.lowHeight) / (this.highHeight - this.lowHeight) * (double)dim.height + 0.5)) - evt.getY())) >= bestDist) continue;
                    bestDist = dist;
                    selectedLayer = layer;
                }
                this.dialog.threeDLayerList.setSelectedValue(selectedLayer.getName(), true);
                this.dialog.threeDValuesChanged(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            Dimension dim = this.getSize();
            String layerName = (String)this.dialog.threeDLayerList.getSelectedValue();
            Layer layer = this.dialog.curTech.findLayer(layerName);
            GenMath.MutableDouble height = ThreeDTab.this.threeDDistanceMap.get(layer);
            double newHeight = (double)(dim.height - evt.getY()) / (double)dim.height * (this.highHeight - this.lowHeight) + this.lowHeight;
            if (height.doubleValue() != newHeight) {
                height.setValue(newHeight);
                this.dialog.threeDHeight.setText(TextUtils.formatDouble(newHeight));
                this.repaint();
            }
        }
    }
}

