/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class AlphaBlender {
    private Color background;
    private int[] opaqueData;
    private static final int SCALE_SH = 8;
    private static final int SCALE = 256;
    private AlphaBlendGroup[] groups;
    private int[][] layerBits;
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int r5;
    private int r6;
    private int r7;
    private int r8;
    private int r9;
    private int r10;
    private int r11;
    private int r12;
    private int r13;
    private int r14;
    private int r15;
    private int r16;
    private int r17;
    private int r18;
    private int r19;
    private int r20;
    private int r21;
    private int r22;
    private int r23;
    private int r24;
    private int r25;
    private int r26;
    private int r27;
    private int r28;
    private int r29;
    private int r30;
    private int r31;
    private int g0;
    private int g1;
    private int g2;
    private int g3;
    private int g4;
    private int g5;
    private int g6;
    private int g7;
    private int g8;
    private int g9;
    private int g10;
    private int g11;
    private int g12;
    private int g13;
    private int g14;
    private int g15;
    private int g16;
    private int g17;
    private int g18;
    private int g19;
    private int g20;
    private int g21;
    private int g22;
    private int g23;
    private int g24;
    private int g25;
    private int g26;
    private int g27;
    private int g28;
    private int g29;
    private int g30;
    private int g31;
    private int b0;
    private int b1;
    private int b2;
    private int b3;
    private int b4;
    private int b5;
    private int b6;
    private int b7;
    private int b8;
    private int b9;
    private int b10;
    private int b11;
    private int b12;
    private int b13;
    private int b14;
    private int b15;
    private int b16;
    private int b17;
    private int b18;
    private int b19;
    private int b20;
    private int b21;
    private int b22;
    private int b23;
    private int b24;
    private int b25;
    private int b26;
    private int b27;
    private int b28;
    private int b29;
    private int b30;
    private int b31;

    void init(int backgroundValue, List<EditWindow.LayerColor> blendingOrder, Map<Layer, int[]> layerBits) {
        this.background = new Color(backgroundValue);
        ArrayList<int[]> bits = new ArrayList<int[]>();
        ArrayList<EditWindow.LayerColor> colors = new ArrayList<EditWindow.LayerColor>();
        for (EditWindow.LayerColor layerColor : blendingOrder) {
            int[] b = layerBits.get(layerColor.layer);
            if (b == null) continue;
            bits.add(b);
            colors.add(layerColor);
        }
        this.layerBits = (int[][])bits.toArray((T[])new int[bits.size()][]);
        this.groups = new AlphaBlendGroup[bits.size() / 13 + 1];
        int k = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            int l = (bits.size() - k) / (this.groups.length - i);
            this.groups[i] = new AlphaBlendGroup(this.layerBits, colors, k, l, i == 0);
            k += l;
        }
    }

    void composeLine(int inputOffset, int minX, int maxX, int[] opaqueData, int opaqueOffset) {
        int minInt = minX >> 5;
        int maxInt = maxX >> 5;
        this.opaqueData = opaqueData;
        if (minInt == maxInt) {
            int mask = (1 << (maxX & 0x1F) + 1) - (1 << (minX & 0x1F));
            this.composeBits(inputOffset + minInt, mask, opaqueOffset + (minInt << 5));
            return;
        }
        if ((minX & 0x1F) != 0) {
            int headMask = -(1 << (minX & 0x1F));
            this.composeBits(inputOffset + minInt, headMask, opaqueOffset + (minInt << 5));
            ++minInt;
        }
        if ((maxX & 0x1F) != 31) {
            int tailMask = (1 << (maxX & 0x1F) + 1) - 1;
            this.composeBits(inputOffset + maxInt, tailMask, opaqueOffset + (maxInt << 5));
            --maxInt;
        }
        opaqueOffset += minInt << 5;
        for (int index = minInt; index <= maxInt; ++index) {
            for (AlphaBlendGroup group : this.groups) {
                group.unpackBytes(inputOffset + index);
            }
            opaqueOffset = this.storeRGB32(opaqueOffset);
        }
    }

    void composeBits(int inputOffset, int mask, int outputOffset) {
        for (AlphaBlendGroup group : this.groups) {
            group.unpackBytes(inputOffset);
        }
        if ((mask & 1) != 0) {
            this.storeRGB(outputOffset + 0, this.r0, this.g0, this.b0);
        }
        if ((mask & 2) != 0) {
            this.storeRGB(outputOffset + 1, this.r1, this.g1, this.b1);
        }
        if ((mask & 4) != 0) {
            this.storeRGB(outputOffset + 2, this.r2, this.g2, this.b2);
        }
        if ((mask & 8) != 0) {
            this.storeRGB(outputOffset + 3, this.r3, this.g3, this.b3);
        }
        if ((mask & 0x10) != 0) {
            this.storeRGB(outputOffset + 4, this.r4, this.g4, this.b4);
        }
        if ((mask & 0x20) != 0) {
            this.storeRGB(outputOffset + 5, this.r5, this.g5, this.b5);
        }
        if ((mask & 0x40) != 0) {
            this.storeRGB(outputOffset + 6, this.r6, this.g6, this.b6);
        }
        if ((mask & 0x80) != 0) {
            this.storeRGB(outputOffset + 7, this.r7, this.g7, this.b7);
        }
        if ((mask & 0x100) != 0) {
            this.storeRGB(outputOffset + 8, this.r8, this.g8, this.b8);
        }
        if ((mask & 0x200) != 0) {
            this.storeRGB(outputOffset + 9, this.r9, this.g9, this.b9);
        }
        if ((mask & 0x400) != 0) {
            this.storeRGB(outputOffset + 10, this.r10, this.g10, this.b10);
        }
        if ((mask & 0x800) != 0) {
            this.storeRGB(outputOffset + 11, this.r11, this.g11, this.b11);
        }
        if ((mask & 0x1000) != 0) {
            this.storeRGB(outputOffset + 12, this.r12, this.g12, this.b12);
        }
        if ((mask & 0x2000) != 0) {
            this.storeRGB(outputOffset + 13, this.r13, this.g13, this.b13);
        }
        if ((mask & 0x4000) != 0) {
            this.storeRGB(outputOffset + 14, this.r14, this.g14, this.b14);
        }
        if ((mask & 0x8000) != 0) {
            this.storeRGB(outputOffset + 15, this.r15, this.g15, this.b15);
        }
        if ((mask & 0x10000) != 0) {
            this.storeRGB(outputOffset + 16, this.r16, this.g16, this.b16);
        }
        if ((mask & 0x20000) != 0) {
            this.storeRGB(outputOffset + 17, this.r17, this.g17, this.b17);
        }
        if ((mask & 0x40000) != 0) {
            this.storeRGB(outputOffset + 18, this.r18, this.g18, this.b18);
        }
        if ((mask & 0x80000) != 0) {
            this.storeRGB(outputOffset + 19, this.r19, this.g19, this.b19);
        }
        if ((mask & 0x100000) != 0) {
            this.storeRGB(outputOffset + 20, this.r20, this.g20, this.b20);
        }
        if ((mask & 0x200000) != 0) {
            this.storeRGB(outputOffset + 21, this.r21, this.g21, this.b21);
        }
        if ((mask & 0x400000) != 0) {
            this.storeRGB(outputOffset + 22, this.r22, this.g22, this.b22);
        }
        if ((mask & 0x800000) != 0) {
            this.storeRGB(outputOffset + 23, this.r23, this.g23, this.b23);
        }
        if ((mask & 0x1000000) != 0) {
            this.storeRGB(outputOffset + 24, this.r24, this.g24, this.b24);
        }
        if ((mask & 0x2000000) != 0) {
            this.storeRGB(outputOffset + 25, this.r25, this.g25, this.b25);
        }
        if ((mask & 0x4000000) != 0) {
            this.storeRGB(outputOffset + 26, this.r26, this.g26, this.b26);
        }
        if ((mask & 0x8000000) != 0) {
            this.storeRGB(outputOffset + 27, this.r27, this.g27, this.b27);
        }
        if ((mask & 0x10000000) != 0) {
            this.storeRGB(outputOffset + 28, this.r28, this.g28, this.b28);
        }
        if ((mask & 0x20000000) != 0) {
            this.storeRGB(outputOffset + 29, this.r29, this.g29, this.b29);
        }
        if ((mask & 0x40000000) != 0) {
            this.storeRGB(outputOffset + 30, this.r30, this.g30, this.b30);
        }
        if ((mask & Integer.MIN_VALUE) != 0) {
            this.storeRGB(outputOffset + 31, this.r31, this.g31, this.b31);
        }
    }

    private int storeRGB32(int baseIndex) {
        this.storeRGB(baseIndex++, this.r0, this.g0, this.b0);
        this.storeRGB(baseIndex++, this.r1, this.g1, this.b1);
        this.storeRGB(baseIndex++, this.r2, this.g2, this.b2);
        this.storeRGB(baseIndex++, this.r3, this.g3, this.b3);
        this.storeRGB(baseIndex++, this.r4, this.g4, this.b4);
        this.storeRGB(baseIndex++, this.r5, this.g5, this.b5);
        this.storeRGB(baseIndex++, this.r6, this.g6, this.b6);
        this.storeRGB(baseIndex++, this.r7, this.g7, this.b7);
        this.storeRGB(baseIndex++, this.r8, this.g8, this.b8);
        this.storeRGB(baseIndex++, this.r9, this.g9, this.b9);
        this.storeRGB(baseIndex++, this.r10, this.g10, this.b10);
        this.storeRGB(baseIndex++, this.r11, this.g11, this.b11);
        this.storeRGB(baseIndex++, this.r12, this.g12, this.b12);
        this.storeRGB(baseIndex++, this.r13, this.g13, this.b13);
        this.storeRGB(baseIndex++, this.r14, this.g14, this.b14);
        this.storeRGB(baseIndex++, this.r15, this.g15, this.b15);
        this.storeRGB(baseIndex++, this.r16, this.g16, this.b16);
        this.storeRGB(baseIndex++, this.r17, this.g17, this.b17);
        this.storeRGB(baseIndex++, this.r18, this.g18, this.b18);
        this.storeRGB(baseIndex++, this.r19, this.g19, this.b19);
        this.storeRGB(baseIndex++, this.r20, this.g20, this.b20);
        this.storeRGB(baseIndex++, this.r21, this.g21, this.b21);
        this.storeRGB(baseIndex++, this.r22, this.g22, this.b22);
        this.storeRGB(baseIndex++, this.r23, this.g23, this.b23);
        this.storeRGB(baseIndex++, this.r24, this.g24, this.b24);
        this.storeRGB(baseIndex++, this.r25, this.g25, this.b25);
        this.storeRGB(baseIndex++, this.r26, this.g26, this.b26);
        this.storeRGB(baseIndex++, this.r27, this.g27, this.b27);
        this.storeRGB(baseIndex++, this.r28, this.g28, this.b28);
        this.storeRGB(baseIndex++, this.r29, this.g29, this.b29);
        this.storeRGB(baseIndex++, this.r30, this.g30, this.b30);
        this.storeRGB(baseIndex++, this.r31, this.g31, this.b31);
        return baseIndex;
    }

    private void storeRGB(int baseIndex, int red, int green, int blue) {
        int color = ((red | green | blue) & 0xFFFFFF00) == 0 ? red << 16 | green << 8 | blue : this.normalizeRgbDim(red, green, blue);
        this.opaqueData[baseIndex] = color;
    }

    private int normalizeRgbDim(int red, int green, int blue) {
        int max;
        int min;
        if (red <= green) {
            min = red;
            max = green;
        } else {
            min = green;
            max = red;
        }
        if (blue > max) {
            max = blue;
        }
        if (blue < min) {
            min = blue;
        }
        if (max - min <= 255) {
            int dec = min < 0 ? min : max - 255;
            red -= dec;
            green -= dec;
            blue -= dec;
        } else {
            int dec = max - 255;
            red = Math.max(0, red - dec);
            green = Math.max(0, green - dec);
            blue = Math.max(0, blue - dec);
        }
        return red << 16 | green << 8 | blue;
    }

    private class AlphaBlendGroup {
        int groupShift;
        int groupMask;
        int[] redMap;
        int[] greenMap;
        int[] blueMap;
        int[] inverseAlphaMap;
        int[][] bits;

        AlphaBlendGroup(int[][] bits, List<EditWindow.LayerColor> cols, int offset, int len, boolean fillBackround) {
            this.groupShift = offset;
            this.groupMask = (1 << len) - 1;
            int mapLen = 1 << len;
            this.redMap = new int[mapLen];
            this.greenMap = new int[mapLen];
            this.blueMap = new int[mapLen];
            this.inverseAlphaMap = new int[mapLen];
            this.bits = new int[len][];
            for (int i = 0; i < len; ++i) {
                this.bits[i] = bits[offset + i];
            }
            float[] backgroundComps = AlphaBlender.this.background.getRGBColorComponents(null);
            float bRed = backgroundComps[0];
            float bGreen = backgroundComps[1];
            float bBlue = backgroundComps[2];
            for (int k = 0; k < mapLen; ++k) {
                double red = 0.0;
                double green = 0.0;
                double blue = 0.0;
                double ia = 1.0;
                if (fillBackround) {
                    red = bRed;
                    green = bGreen;
                    blue = bBlue;
                    ia = 0.0;
                }
                for (int i = 0; i < len; ++i) {
                    if ((k & 1 << i) == 0) continue;
                    EditWindow.LayerColor lc = cols.get(offset + i);
                    double iAlpha = lc.inverseAlpha;
                    red *= iAlpha;
                    green *= iAlpha;
                    blue *= iAlpha;
                    ia *= iAlpha;
                    red += (double)lc.premultipliedRed;
                    green += (double)lc.premultipliedGreen;
                    blue += (double)lc.premultipliedBlue;
                }
                this.redMap[k] = (int)(red * 256.0 * 255.0);
                this.greenMap[k] = (int)(green * 256.0 * 255.0);
                this.blueMap[k] = (int)(blue * 256.0 * 255.0);
                this.inverseAlphaMap[k] = (int)(ia * 256.0);
            }
        }

        private void unpackBytes(int index) {
            int pixel0 = 0;
            int pixel1 = 0;
            int pixel2 = 0;
            int pixel3 = 0;
            int pixel4 = 0;
            int pixel5 = 0;
            int pixel6 = 0;
            int pixel7 = 0;
            int pixel8 = 0;
            int pixel9 = 0;
            int pixel10 = 0;
            int pixel11 = 0;
            int pixel12 = 0;
            int pixel13 = 0;
            int pixel14 = 0;
            int pixel15 = 0;
            int pixel16 = 0;
            int pixel17 = 0;
            int pixel18 = 0;
            int pixel19 = 0;
            int pixel20 = 0;
            int pixel21 = 0;
            int pixel22 = 0;
            int pixel23 = 0;
            int pixel24 = 0;
            int pixel25 = 0;
            int pixel26 = 0;
            int pixel27 = 0;
            int pixel28 = 0;
            int pixel29 = 0;
            int pixel30 = 0;
            int pixel31 = 0;
            for (int i = 0; i < this.bits.length; ++i) {
                int value = this.bits[i][index];
                if (value == 0) continue;
                pixel0 |= (value & 1) << i;
                pixel1 |= (value >> 1 & 1) << i;
                pixel2 |= (value >> 2 & 1) << i;
                pixel3 |= (value >> 3 & 1) << i;
                pixel4 |= (value >> 4 & 1) << i;
                pixel5 |= (value >> 5 & 1) << i;
                pixel6 |= (value >> 6 & 1) << i;
                pixel7 |= (value >> 7 & 1) << i;
                pixel8 |= (value >> 8 & 1) << i;
                pixel9 |= (value >> 9 & 1) << i;
                pixel10 |= (value >> 10 & 1) << i;
                pixel11 |= (value >> 11 & 1) << i;
                pixel12 |= (value >> 12 & 1) << i;
                pixel13 |= (value >> 13 & 1) << i;
                pixel14 |= (value >> 14 & 1) << i;
                pixel15 |= (value >> 15 & 1) << i;
                pixel16 |= (value >> 16 & 1) << i;
                pixel17 |= (value >> 17 & 1) << i;
                pixel18 |= (value >> 18 & 1) << i;
                pixel19 |= (value >> 19 & 1) << i;
                pixel20 |= (value >> 20 & 1) << i;
                pixel21 |= (value >> 21 & 1) << i;
                pixel22 |= (value >> 22 & 1) << i;
                pixel23 |= (value >> 23 & 1) << i;
                pixel24 |= (value >> 24 & 1) << i;
                pixel25 |= (value >> 25 & 1) << i;
                pixel26 |= (value >> 26 & 1) << i;
                pixel27 |= (value >> 27 & 1) << i;
                pixel28 |= (value >> 28 & 1) << i;
                pixel29 |= (value >> 29 & 1) << i;
                pixel30 |= (value >> 30 & 1) << i;
                pixel31 |= (value >> 31 & 1) << i;
            }
            int red = this.redMap[pixel0];
            int green = this.greenMap[pixel0];
            int blue = this.blueMap[pixel0];
            int ia = this.inverseAlphaMap[pixel0];
            if (ia == 0) {
                AlphaBlender.this.r0 = red >> 8;
                AlphaBlender.this.g0 = green >> 8;
                AlphaBlender.this.b0 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r0 = red + AlphaBlender.this.r0 * ia >> 8;
                AlphaBlender.this.g0 = green + AlphaBlender.this.g0 * ia >> 8;
                AlphaBlender.this.b0 = blue + AlphaBlender.this.b0 * ia >> 8;
            }
            red = this.redMap[pixel1];
            green = this.greenMap[pixel1];
            blue = this.blueMap[pixel1];
            ia = this.inverseAlphaMap[pixel1];
            if (ia == 0) {
                AlphaBlender.this.r1 = red >> 8;
                AlphaBlender.this.g1 = green >> 8;
                AlphaBlender.this.b1 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r1 = red + AlphaBlender.this.r1 * ia >> 8;
                AlphaBlender.this.g1 = green + AlphaBlender.this.g1 * ia >> 8;
                AlphaBlender.this.b1 = blue + AlphaBlender.this.b1 * ia >> 8;
            }
            red = this.redMap[pixel2];
            green = this.greenMap[pixel2];
            blue = this.blueMap[pixel2];
            ia = this.inverseAlphaMap[pixel2];
            if (ia == 0) {
                AlphaBlender.this.r2 = red >> 8;
                AlphaBlender.this.g2 = green >> 8;
                AlphaBlender.this.b2 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r2 = red + AlphaBlender.this.r2 * ia >> 8;
                AlphaBlender.this.g2 = green + AlphaBlender.this.g2 * ia >> 8;
                AlphaBlender.this.b2 = blue + AlphaBlender.this.b2 * ia >> 8;
            }
            red = this.redMap[pixel3];
            green = this.greenMap[pixel3];
            blue = this.blueMap[pixel3];
            ia = this.inverseAlphaMap[pixel3];
            if (ia == 0) {
                AlphaBlender.this.r3 = red >> 8;
                AlphaBlender.this.g3 = green >> 8;
                AlphaBlender.this.b3 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r3 = red + AlphaBlender.this.r3 * ia >> 8;
                AlphaBlender.this.g3 = green + AlphaBlender.this.g3 * ia >> 8;
                AlphaBlender.this.b3 = blue + AlphaBlender.this.b3 * ia >> 8;
            }
            red = this.redMap[pixel4];
            green = this.greenMap[pixel4];
            blue = this.blueMap[pixel4];
            ia = this.inverseAlphaMap[pixel4];
            if (ia == 0) {
                AlphaBlender.this.r4 = red >> 8;
                AlphaBlender.this.g4 = green >> 8;
                AlphaBlender.this.b4 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r4 = red + AlphaBlender.this.r4 * ia >> 8;
                AlphaBlender.this.g4 = green + AlphaBlender.this.g4 * ia >> 8;
                AlphaBlender.this.b4 = blue + AlphaBlender.this.b4 * ia >> 8;
            }
            red = this.redMap[pixel5];
            green = this.greenMap[pixel5];
            blue = this.blueMap[pixel5];
            ia = this.inverseAlphaMap[pixel5];
            if (ia == 0) {
                AlphaBlender.this.r5 = red >> 8;
                AlphaBlender.this.g5 = green >> 8;
                AlphaBlender.this.b5 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r5 = red + AlphaBlender.this.r5 * ia >> 8;
                AlphaBlender.this.g5 = green + AlphaBlender.this.g5 * ia >> 8;
                AlphaBlender.this.b5 = blue + AlphaBlender.this.b5 * ia >> 8;
            }
            red = this.redMap[pixel6];
            green = this.greenMap[pixel6];
            blue = this.blueMap[pixel6];
            ia = this.inverseAlphaMap[pixel6];
            if (ia == 0) {
                AlphaBlender.this.r6 = red >> 8;
                AlphaBlender.this.g6 = green >> 8;
                AlphaBlender.this.b6 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r6 = red + AlphaBlender.this.r6 * ia >> 8;
                AlphaBlender.this.g6 = green + AlphaBlender.this.g6 * ia >> 8;
                AlphaBlender.this.b6 = blue + AlphaBlender.this.b6 * ia >> 8;
            }
            red = this.redMap[pixel7];
            green = this.greenMap[pixel7];
            blue = this.blueMap[pixel7];
            ia = this.inverseAlphaMap[pixel7];
            if (ia == 0) {
                AlphaBlender.this.r7 = red >> 8;
                AlphaBlender.this.g7 = green >> 8;
                AlphaBlender.this.b7 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r7 = red + AlphaBlender.this.r7 * ia >> 8;
                AlphaBlender.this.g7 = green + AlphaBlender.this.g7 * ia >> 8;
                AlphaBlender.this.b7 = blue + AlphaBlender.this.b7 * ia >> 8;
            }
            red = this.redMap[pixel8];
            green = this.greenMap[pixel8];
            blue = this.blueMap[pixel8];
            ia = this.inverseAlphaMap[pixel8];
            if (ia == 0) {
                AlphaBlender.this.r8 = red >> 8;
                AlphaBlender.this.g8 = green >> 8;
                AlphaBlender.this.b8 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r8 = red + AlphaBlender.this.r8 * ia >> 8;
                AlphaBlender.this.g8 = green + AlphaBlender.this.g8 * ia >> 8;
                AlphaBlender.this.b8 = blue + AlphaBlender.this.b8 * ia >> 8;
            }
            red = this.redMap[pixel9];
            green = this.greenMap[pixel9];
            blue = this.blueMap[pixel9];
            ia = this.inverseAlphaMap[pixel9];
            if (ia == 0) {
                AlphaBlender.this.r9 = red >> 8;
                AlphaBlender.this.g9 = green >> 8;
                AlphaBlender.this.b9 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r9 = red + AlphaBlender.this.r9 * ia >> 8;
                AlphaBlender.this.g9 = green + AlphaBlender.this.g9 * ia >> 8;
                AlphaBlender.this.b9 = blue + AlphaBlender.this.b9 * ia >> 8;
            }
            red = this.redMap[pixel10];
            green = this.greenMap[pixel10];
            blue = this.blueMap[pixel10];
            ia = this.inverseAlphaMap[pixel10];
            if (ia == 0) {
                AlphaBlender.this.r10 = red >> 8;
                AlphaBlender.this.g10 = green >> 8;
                AlphaBlender.this.b10 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r10 = red + AlphaBlender.this.r10 * ia >> 8;
                AlphaBlender.this.g10 = green + AlphaBlender.this.g10 * ia >> 8;
                AlphaBlender.this.b10 = blue + AlphaBlender.this.b10 * ia >> 8;
            }
            red = this.redMap[pixel11];
            green = this.greenMap[pixel11];
            blue = this.blueMap[pixel11];
            ia = this.inverseAlphaMap[pixel11];
            if (ia == 0) {
                AlphaBlender.this.r11 = red >> 8;
                AlphaBlender.this.g11 = green >> 8;
                AlphaBlender.this.b11 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r11 = red + AlphaBlender.this.r11 * ia >> 8;
                AlphaBlender.this.g11 = green + AlphaBlender.this.g11 * ia >> 8;
                AlphaBlender.this.b11 = blue + AlphaBlender.this.b11 * ia >> 8;
            }
            red = this.redMap[pixel12];
            green = this.greenMap[pixel12];
            blue = this.blueMap[pixel12];
            ia = this.inverseAlphaMap[pixel12];
            if (ia == 0) {
                AlphaBlender.this.r12 = red >> 8;
                AlphaBlender.this.g12 = green >> 8;
                AlphaBlender.this.b12 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r12 = red + AlphaBlender.this.r12 * ia >> 8;
                AlphaBlender.this.g12 = green + AlphaBlender.this.g12 * ia >> 8;
                AlphaBlender.this.b12 = blue + AlphaBlender.this.b12 * ia >> 8;
            }
            red = this.redMap[pixel13];
            green = this.greenMap[pixel13];
            blue = this.blueMap[pixel13];
            ia = this.inverseAlphaMap[pixel13];
            if (ia == 0) {
                AlphaBlender.this.r13 = red >> 8;
                AlphaBlender.this.g13 = green >> 8;
                AlphaBlender.this.b13 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r13 = red + AlphaBlender.this.r13 * ia >> 8;
                AlphaBlender.this.g13 = green + AlphaBlender.this.g13 * ia >> 8;
                AlphaBlender.this.b13 = blue + AlphaBlender.this.b13 * ia >> 8;
            }
            red = this.redMap[pixel14];
            green = this.greenMap[pixel14];
            blue = this.blueMap[pixel14];
            ia = this.inverseAlphaMap[pixel14];
            if (ia == 0) {
                AlphaBlender.this.r14 = red >> 8;
                AlphaBlender.this.g14 = green >> 8;
                AlphaBlender.this.b14 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r14 = red + AlphaBlender.this.r14 * ia >> 8;
                AlphaBlender.this.g14 = green + AlphaBlender.this.g14 * ia >> 8;
                AlphaBlender.this.b14 = blue + AlphaBlender.this.b14 * ia >> 8;
            }
            red = this.redMap[pixel15];
            green = this.greenMap[pixel15];
            blue = this.blueMap[pixel15];
            ia = this.inverseAlphaMap[pixel15];
            if (ia == 0) {
                AlphaBlender.this.r15 = red >> 8;
                AlphaBlender.this.g15 = green >> 8;
                AlphaBlender.this.b15 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r15 = red + AlphaBlender.this.r15 * ia >> 8;
                AlphaBlender.this.g15 = green + AlphaBlender.this.g15 * ia >> 8;
                AlphaBlender.this.b15 = blue + AlphaBlender.this.b15 * ia >> 8;
            }
            red = this.redMap[pixel16];
            green = this.greenMap[pixel16];
            blue = this.blueMap[pixel16];
            ia = this.inverseAlphaMap[pixel16];
            if (ia == 0) {
                AlphaBlender.this.r16 = red >> 8;
                AlphaBlender.this.g16 = green >> 8;
                AlphaBlender.this.b16 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r16 = red + AlphaBlender.this.r16 * ia >> 8;
                AlphaBlender.this.g16 = green + AlphaBlender.this.g16 * ia >> 8;
                AlphaBlender.this.b16 = blue + AlphaBlender.this.b16 * ia >> 8;
            }
            red = this.redMap[pixel17];
            green = this.greenMap[pixel17];
            blue = this.blueMap[pixel17];
            ia = this.inverseAlphaMap[pixel17];
            if (ia == 0) {
                AlphaBlender.this.r17 = red >> 8;
                AlphaBlender.this.g17 = green >> 8;
                AlphaBlender.this.b17 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r17 = red + AlphaBlender.this.r17 * ia >> 8;
                AlphaBlender.this.g17 = green + AlphaBlender.this.g17 * ia >> 8;
                AlphaBlender.this.b17 = blue + AlphaBlender.this.b17 * ia >> 8;
            }
            red = this.redMap[pixel18];
            green = this.greenMap[pixel18];
            blue = this.blueMap[pixel18];
            ia = this.inverseAlphaMap[pixel18];
            if (ia == 0) {
                AlphaBlender.this.r18 = red >> 8;
                AlphaBlender.this.g18 = green >> 8;
                AlphaBlender.this.b18 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r18 = red + AlphaBlender.this.r18 * ia >> 8;
                AlphaBlender.this.g18 = green + AlphaBlender.this.g18 * ia >> 8;
                AlphaBlender.this.b18 = blue + AlphaBlender.this.b18 * ia >> 8;
            }
            red = this.redMap[pixel19];
            green = this.greenMap[pixel19];
            blue = this.blueMap[pixel19];
            ia = this.inverseAlphaMap[pixel19];
            if (ia == 0) {
                AlphaBlender.this.r19 = red >> 8;
                AlphaBlender.this.g19 = green >> 8;
                AlphaBlender.this.b19 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r19 = red + AlphaBlender.this.r19 * ia >> 8;
                AlphaBlender.this.g19 = green + AlphaBlender.this.g19 * ia >> 8;
                AlphaBlender.this.b19 = blue + AlphaBlender.this.b19 * ia >> 8;
            }
            red = this.redMap[pixel20];
            green = this.greenMap[pixel20];
            blue = this.blueMap[pixel20];
            ia = this.inverseAlphaMap[pixel20];
            if (ia == 0) {
                AlphaBlender.this.r20 = red >> 8;
                AlphaBlender.this.g20 = green >> 8;
                AlphaBlender.this.b20 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r20 = red + AlphaBlender.this.r20 * ia >> 8;
                AlphaBlender.this.g20 = green + AlphaBlender.this.g20 * ia >> 8;
                AlphaBlender.this.b20 = blue + AlphaBlender.this.b20 * ia >> 8;
            }
            red = this.redMap[pixel21];
            green = this.greenMap[pixel21];
            blue = this.blueMap[pixel21];
            ia = this.inverseAlphaMap[pixel21];
            if (ia == 0) {
                AlphaBlender.this.r21 = red >> 8;
                AlphaBlender.this.g21 = green >> 8;
                AlphaBlender.this.b21 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r21 = red + AlphaBlender.this.r21 * ia >> 8;
                AlphaBlender.this.g21 = green + AlphaBlender.this.g21 * ia >> 8;
                AlphaBlender.this.b21 = blue + AlphaBlender.this.b21 * ia >> 8;
            }
            red = this.redMap[pixel22];
            green = this.greenMap[pixel22];
            blue = this.blueMap[pixel22];
            ia = this.inverseAlphaMap[pixel22];
            if (ia == 0) {
                AlphaBlender.this.r22 = red >> 8;
                AlphaBlender.this.g22 = green >> 8;
                AlphaBlender.this.b22 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r22 = red + AlphaBlender.this.r22 * ia >> 8;
                AlphaBlender.this.g22 = green + AlphaBlender.this.g22 * ia >> 8;
                AlphaBlender.this.b22 = blue + AlphaBlender.this.b22 * ia >> 8;
            }
            red = this.redMap[pixel23];
            green = this.greenMap[pixel23];
            blue = this.blueMap[pixel23];
            ia = this.inverseAlphaMap[pixel23];
            if (ia == 0) {
                AlphaBlender.this.r23 = red >> 8;
                AlphaBlender.this.g23 = green >> 8;
                AlphaBlender.this.b23 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r23 = red + AlphaBlender.this.r23 * ia >> 8;
                AlphaBlender.this.g23 = green + AlphaBlender.this.g23 * ia >> 8;
                AlphaBlender.this.b23 = blue + AlphaBlender.this.b23 * ia >> 8;
            }
            red = this.redMap[pixel24];
            green = this.greenMap[pixel24];
            blue = this.blueMap[pixel24];
            ia = this.inverseAlphaMap[pixel24];
            if (ia == 0) {
                AlphaBlender.this.r24 = red >> 8;
                AlphaBlender.this.g24 = green >> 8;
                AlphaBlender.this.b24 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r24 = red + AlphaBlender.this.r24 * ia >> 8;
                AlphaBlender.this.g24 = green + AlphaBlender.this.g24 * ia >> 8;
                AlphaBlender.this.b24 = blue + AlphaBlender.this.b24 * ia >> 8;
            }
            red = this.redMap[pixel25];
            green = this.greenMap[pixel25];
            blue = this.blueMap[pixel25];
            ia = this.inverseAlphaMap[pixel25];
            if (ia == 0) {
                AlphaBlender.this.r25 = red >> 8;
                AlphaBlender.this.g25 = green >> 8;
                AlphaBlender.this.b25 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r25 = red + AlphaBlender.this.r25 * ia >> 8;
                AlphaBlender.this.g25 = green + AlphaBlender.this.g25 * ia >> 8;
                AlphaBlender.this.b25 = blue + AlphaBlender.this.b25 * ia >> 8;
            }
            red = this.redMap[pixel26];
            green = this.greenMap[pixel26];
            blue = this.blueMap[pixel26];
            ia = this.inverseAlphaMap[pixel26];
            if (ia == 0) {
                AlphaBlender.this.r26 = red >> 8;
                AlphaBlender.this.g26 = green >> 8;
                AlphaBlender.this.b26 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r26 = red + AlphaBlender.this.r26 * ia >> 8;
                AlphaBlender.this.g26 = green + AlphaBlender.this.g26 * ia >> 8;
                AlphaBlender.this.b26 = blue + AlphaBlender.this.b26 * ia >> 8;
            }
            red = this.redMap[pixel27];
            green = this.greenMap[pixel27];
            blue = this.blueMap[pixel27];
            ia = this.inverseAlphaMap[pixel27];
            if (ia == 0) {
                AlphaBlender.this.r27 = red >> 8;
                AlphaBlender.this.g27 = green >> 8;
                AlphaBlender.this.b27 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r27 = red + AlphaBlender.this.r27 * ia >> 8;
                AlphaBlender.this.g27 = green + AlphaBlender.this.g27 * ia >> 8;
                AlphaBlender.this.b27 = blue + AlphaBlender.this.b27 * ia >> 8;
            }
            red = this.redMap[pixel28];
            green = this.greenMap[pixel28];
            blue = this.blueMap[pixel28];
            ia = this.inverseAlphaMap[pixel28];
            if (ia == 0) {
                AlphaBlender.this.r28 = red >> 8;
                AlphaBlender.this.g28 = green >> 8;
                AlphaBlender.this.b28 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r28 = red + AlphaBlender.this.r28 * ia >> 8;
                AlphaBlender.this.g28 = green + AlphaBlender.this.g28 * ia >> 8;
                AlphaBlender.this.b28 = blue + AlphaBlender.this.b28 * ia >> 8;
            }
            red = this.redMap[pixel29];
            green = this.greenMap[pixel29];
            blue = this.blueMap[pixel29];
            ia = this.inverseAlphaMap[pixel29];
            if (ia == 0) {
                AlphaBlender.this.r29 = red >> 8;
                AlphaBlender.this.g29 = green >> 8;
                AlphaBlender.this.b29 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r29 = red + AlphaBlender.this.r29 * ia >> 8;
                AlphaBlender.this.g29 = green + AlphaBlender.this.g29 * ia >> 8;
                AlphaBlender.this.b29 = blue + AlphaBlender.this.b29 * ia >> 8;
            }
            red = this.redMap[pixel30];
            green = this.greenMap[pixel30];
            blue = this.blueMap[pixel30];
            ia = this.inverseAlphaMap[pixel30];
            if (ia == 0) {
                AlphaBlender.this.r30 = red >> 8;
                AlphaBlender.this.g30 = green >> 8;
                AlphaBlender.this.b30 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r30 = red + AlphaBlender.this.r30 * ia >> 8;
                AlphaBlender.this.g30 = green + AlphaBlender.this.g30 * ia >> 8;
                AlphaBlender.this.b30 = blue + AlphaBlender.this.b30 * ia >> 8;
            }
            red = this.redMap[pixel31];
            green = this.greenMap[pixel31];
            blue = this.blueMap[pixel31];
            ia = this.inverseAlphaMap[pixel31];
            if (ia == 0) {
                AlphaBlender.this.r31 = red >> 8;
                AlphaBlender.this.g31 = green >> 8;
                AlphaBlender.this.b31 = blue >> 8;
            } else if (ia != 256) {
                AlphaBlender.this.r31 = red + AlphaBlender.this.r31 * ia >> 8;
                AlphaBlender.this.g31 = green + AlphaBlender.this.g31 * ia >> 8;
                AlphaBlender.this.b31 = blue + AlphaBlender.this.b31 * ia >> 8;
            }
        }
    }
}

