/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutLib {
    public static final double DEF_SIZE = Double.POSITIVE_INFINITY;

    public static void error(boolean errorHasOccurred, String msg) {
        if (!errorHasOccurred) {
            return;
        }
        RuntimeException e = new RuntimeException(msg);
        ActivityLogger.logException(e);
        throw e;
    }

    public static Library openLibForRead(String libFileName) {
        URL libFileURL = TextUtils.makeURLToFile(libFileName);
        String libName = TextUtils.getFileNameWithoutExtension(libFileURL);
        Library lib = Library.findLibrary(libName);
        FileType type = OpenFile.getOpenFileType(libFileName, FileType.DEFAULTLIB);
        if (lib == null) {
            lib = LibraryFiles.readLibrary(libFileURL, null, type, false);
        }
        LayoutLib.error(lib == null, "can't open Library for reading: " + libFileName);
        return lib;
    }

    public static Library openLibForWrite(String libName) {
        Library lib = Library.findLibrary(libName);
        if (lib != null) {
            return lib;
        }
        lib = Library.newInstance(libName, null);
        URL libURL = TextUtils.makeURLToFile(libName);
        lib.setLibFile(libURL);
        LayoutLib.error(lib == null, "can't open Library for modify: " + libName);
        return lib;
    }

    public static void writeLibrary(Library lib) {
        Output.writeLibrary(lib, FileType.JELIB, false, false, false);
    }

    public static double getArcInstWidth(ArcInst ai) {
        double w = ai.getLambdaBaseWidth();
        return DBMath.round(w);
    }

    public static double getNodeProtoWidth(NodeProto np) {
        SizeOffset so = np.getProtoSizeOffset();
        double w = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
        return DBMath.round(w);
    }

    public static double getNodeProtoHeight(NodeProto np) {
        SizeOffset so = np.getProtoSizeOffset();
        double h = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
        return DBMath.round(h);
    }

    private static void prln(String msg) {
        System.out.println(msg);
    }

    public static double widestWireWidth(PortInst port) {
        double lowerMax;
        PortProto pp = port.getPortProto();
        double maxWid = -1.0;
        Iterator<ArcInst> arcs = LayoutLib.getArcInstsOnPortInst(port);
        while (arcs.hasNext()) {
            ArcInst ai = arcs.next();
            maxWid = Math.max(maxWid, LayoutLib.getArcInstWidth(ai));
        }
        if (pp instanceof Export && (lowerMax = LayoutLib.widestWireWidth(((Export)pp).getOriginalPort())) != Double.POSITIVE_INFINITY) {
            maxWid = Math.max(maxWid, lowerMax);
        }
        if (maxWid < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return DBMath.round(maxWid);
    }

    public static Iterator<ArcInst> getArcInstsOnPortInst(PortInst pi) {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            Connection c = it.next();
            arcs.add(c.getArc());
        }
        return arcs.iterator();
    }

    public static double roundCenterX(PortInst pi) {
        return pi.getCenter().getX();
    }

    public static double roundCenterY(PortInst pi) {
        return pi.getCenter().getY();
    }

    public static Rectangle2D calculateNodeInst(NodeProto np, double x, double y, double width, double height) {
        if (np instanceof Cell) {
            width = (double)(width < 0.0 ? -1 : 1) * np.getDefWidth();
            height = (double)(height < 0.0 ? -1 : 1) * np.getDefHeight();
        } else {
            double signH;
            double signW;
            SizeOffset so = np.getProtoSizeOffset();
            double d = signW = width < 0.0 ? -1.0 : 1.0;
            if (width == Double.POSITIVE_INFINITY || width == Double.NEGATIVE_INFINITY) {
                width = signW * np.getDefWidth();
            } else {
                double hi = so.getHighXOffset();
                double lo = so.getLowXOffset();
                LayoutLib.error(lo != hi, "asymmetric X offset");
                width = signW * (Math.abs(width) + hi + lo);
            }
            double d2 = signH = height < 0.0 ? -1.0 : 1.0;
            if (height == Double.POSITIVE_INFINITY || height == Double.NEGATIVE_INFINITY) {
                height = signH * np.getDefHeight();
            } else {
                double hi = so.getHighYOffset();
                double lo = so.getLowYOffset();
                LayoutLib.error(lo != hi, "asymmetric Y offset");
                height = signH * (Math.abs(height) + hi + lo);
            }
        }
        x = DBMath.round(x);
        y = DBMath.round(y);
        width = DBMath.round(width);
        height = DBMath.round(height);
        return new Rectangle2D.Double(x, y, width, height);
    }

    public static NodeInst newNodeInst(NodeProto np, double x, double y, double width, double height, double angle, Cell parent) {
        Rectangle2D rect = LayoutLib.calculateNodeInst(np, x, y, width, height);
        return LayoutLib.newNodeInst(np, rect, angle, parent);
    }

    public static NodeInst newNodeInst(NodeProto np, Rectangle2D rect, double angle, Cell parent) {
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        Orientation orient = Orientation.fromJava((int)Math.round(angle * 10.0), width < 0.0, height < 0.0);
        NodeInst ni = NodeInst.newInstance(np, new Point2D.Double(x, y), Math.abs(width), Math.abs(height), parent, orient, null, 0);
        LayoutLib.error(ni == null, "newNodeInst failed");
        if (np instanceof Cell) {
            Point2D ref = LayoutLib.getPosition(ni);
            ni.move(x - ref.getX(), y - ref.getY());
        }
        return ni;
    }

    public static void modNodeInst(NodeInst ni, double dx, double dy, double dw, double dh, boolean mirrorAboutYAxis, boolean mirrorAboutXAxis, double dAngle) {
        double newX = LayoutLib.getPosition(ni).getX() + dx;
        double newY = LayoutLib.getPosition(ni).getY() + dy;
        Orientation dOrient = Orientation.fromJava((int)Math.rint(dAngle * 10.0), mirrorAboutYAxis, mirrorAboutXAxis);
        ni.modifyInstance(0.0, 0.0, dw, dh, dOrient);
        ni.move(newX - LayoutLib.getPosition(ni).getX(), newY - LayoutLib.getPosition(ni).getY());
    }

    public static Point2D getPosition(NodeInst ni) {
        Point2D p;
        NodeProto np = ni.getProto();
        if (np instanceof Cell) {
            AffineTransform xForm = ni.transformOut();
            p = xForm.transform(new Point2D.Double(0.0, 0.0), null);
        } else {
            p = ni.getAnchorCenter();
        }
        double x = DBMath.round(((Point2D)p).getX());
        double y = DBMath.round(((Point2D)p).getY());
        return new Point2D.Double(x, y);
    }

    public static ArcInst newArcInst(ArcProto ap, double width, PortInst head, double hX, double hY, PortInst tail, double tX, double tY) {
        if (width == Double.POSITIVE_INFINITY) {
            width = ap.getDefaultLambdaBaseWidth();
        }
        hX = DBMath.round(hX);
        hY = DBMath.round(hY);
        tX = DBMath.round(tX);
        tY = DBMath.round(tY);
        ArcInst ai = ArcInst.newInstanceBase(ap, width = DBMath.round(width), head, tail, new Point2D.Double(hX, hY), new Point2D.Double(tX, tY), null, 0);
        LayoutLib.error(ai == null, "newArcInst failed");
        ai.setFixedAngle(true);
        return ai;
    }

    public static ArcInst newArcInst(ArcProto ap, double width, PortInst head, PortInst tail) {
        ArcInst ai;
        EPoint headP = head.getCenter();
        double hX = headP.getX();
        double hY = headP.getY();
        EPoint tailP = tail.getCenter();
        double tX = tailP.getX();
        double tY = tailP.getY();
        if (hX == tX || hY == tY) {
            ai = LayoutLib.newArcInst(ap, width, head, hX, hY, tail, tX, tY);
        } else {
            Cell parent = head.getNodeInst().getParent();
            PrimitiveNode pinProto = ap.findOverridablePinProto();
            PortInst pin = LayoutLib.newNodeInst(pinProto, tX, hY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent).getOnlyPortInst();
            EPoint pinP = pin.getCenter();
            double newX = pinP.getX();
            double newY = pinP.getY();
            if (newX != tX || newY != hY) {
                Rectangle2D r = head.getBounds();
                double loy = r.getMinY();
                double hiy = r.getMaxY();
                System.out.println(loy + " " + hiy);
                LayoutLib.error(true, "center moved");
            }
            ai = LayoutLib.newArcInst(ap, width, head, pin);
            ai.setFixedAngle(true);
            ai = LayoutLib.newArcInst(ap, width, pin, tail);
        }
        ai.setFixedAngle(true);
        return ai;
    }

    public static Export newExport(Cell cell, String name, PortCharacteristic role, ArcProto ap, double w, double x, double y) {
        PrimitiveNode np = ap.findOverridablePinProto();
        LayoutLib.error(np == null, "LayoutLib.newExport: This layer has no layer-pin");
        double defSz = Double.POSITIVE_INFINITY;
        NodeInst ni = LayoutLib.newNodeInst(np, x, y, defSz, defSz, 0.0, cell);
        LayoutLib.newArcInst(ap, w, ni.getOnlyPortInst(), ni.getOnlyPortInst());
        Export e = Export.newInstance(cell, ni.getOnlyPortInst(), name);
        e.setCharacteristic(role);
        return e;
    }

    public static Rectangle2D roundBounds(Rectangle2D r) {
        double w = DBMath.round(r.getWidth());
        double h = DBMath.round(r.getHeight());
        double x = DBMath.round(r.getX());
        double y = DBMath.round(r.getY());
        return new Rectangle2D.Double(x, y, w, h);
    }

    public static Rectangle2D getBounds(NodeInst node) {
        Rectangle2D bounds = node.findEssentialBounds();
        if (bounds == null) {
            bounds = node.getBounds();
        }
        return LayoutLib.roundBounds(bounds);
    }

    public static Rectangle2D getBounds(Cell c) {
        Rectangle2D bounds = c.findEssentialBounds();
        if (bounds == null) {
            bounds = c.getBounds();
        }
        return LayoutLib.roundBounds(bounds);
    }

    public static void abutLeft(NodeInst node, double leftX, double originY) {
        double cY = LayoutLib.getPosition(node).getY();
        Rectangle2D bd = node.findEssentialBounds();
        LayoutLib.error(bd == null, "can't abut NodeInsts that don't have essential-bounds");
        LayoutLib.modNodeInst(node, leftX - bd.getX(), originY - cY, 0.0, 0.0, false, false, 0.0);
    }

    public static void abutLeftRight(double leftX, double originY, Collection<NodeInst> nodeInsts) {
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev == null) {
                LayoutLib.abutLeft(ni, leftX, originY);
            } else {
                LayoutLib.abutLeftRight(prev, ni);
            }
            prev = ni;
        }
    }

    public static void abutLeftRight(NodeInst leftNode, NodeInst rightNode) {
        LayoutLib.abutLeft(rightNode, LayoutLib.getBounds(leftNode).getMaxX(), LayoutLib.getPosition(leftNode).getY());
    }

    public static void abutLeftRight(Collection<NodeInst> nodeInsts) {
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev != null) {
                LayoutLib.abutLeftRight(prev, ni);
            }
            prev = ni;
        }
    }

    public static void abutBottom(NodeInst node, double originX, double botY) {
        double cX = LayoutLib.getPosition(node).getX();
        Rectangle2D eb = node.findEssentialBounds();
        LayoutLib.error(eb == null, "can't abut a NodeInst that doesn't have Essential Bounds");
        LayoutLib.modNodeInst(node, originX - cX, botY - eb.getMinY(), 0.0, 0.0, false, false, 0.0);
    }

    public static void abutBottomTop(NodeInst bottomNode, double space, NodeInst topNode) {
        LayoutLib.abutBottom(topNode, LayoutLib.getPosition(bottomNode).getX(), LayoutLib.getBounds(bottomNode).getMaxY() + space);
    }

    public static void abutBottomTop(double originX, double botY, Collection<NodeInst> nodeInsts, double space) {
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev == null) {
                LayoutLib.abutBottom(ni, originX, botY);
            } else {
                LayoutLib.abutBottomTop(prev, space, ni);
            }
            prev = ni;
        }
    }

    public static void abutBottomTop(Collection<NodeInst> nodeInsts, double space) {
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev != null) {
                LayoutLib.abutBottomTop(prev, space, ni);
            }
            prev = ni;
        }
    }

    private static Point2D getPointAtCorner(NodeInst ni, Corner cnr) {
        Rectangle2D b = ni.findEssentialBounds();
        double x = cnr == Corner.TL || cnr == Corner.BL ? b.getMinX() : b.getMaxX();
        double y = cnr == Corner.BL || cnr == Corner.BR ? b.getMinY() : b.getMaxY();
        return new Point2D.Double(x, y);
    }

    public static void alignCorners(NodeInst niFixed, Corner cnrFixed, NodeInst niMove, Corner cnrMove, double offsetX, double offsetY) {
        Point2D ptFixed = LayoutLib.getPointAtCorner(niFixed, cnrFixed);
        Point2D ptMove = LayoutLib.getPointAtCorner(niMove, cnrMove);
        double dx = ptFixed.getX() - ptMove.getX() + offsetX;
        double dy = ptFixed.getY() - ptMove.getY() + offsetY;
        niMove.move(dx, dy);
    }

    public static Rectangle2D getBounds(Cell cell, Layer.Function function) {
        Rectangle2D bounds = null;
        Technology tech = cell.getTechnology();
        Layer.Function.Set thisFunction = new Layer.Function.Set(function);
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            AffineTransform trans = ni.rotateOut();
            Poly[] polys = tech.getShapeOfNode(ni, false, true, thisFunction);
            if (polys == null) continue;
            for (int i = 0; i < polys.length; ++i) {
                if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                polys[i].transform(trans);
                bounds = bounds == null ? polys[i].getBox() : bounds.createUnion(polys[i].getBox());
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Poly[] polys = tech.getShapeOfArc(ai, thisFunction);
            if (polys == null) continue;
            for (int i = 0; i < polys.length; ++i) {
                if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                bounds = bounds == null ? polys[i].getBox() : bounds.createUnion(polys[i].getBox());
            }
        }
        return bounds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Corner {
        TL,
        TR,
        BL,
        BR;

    }
}

