/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TechnologyTab
extends PreferencePanel {
    private JList schemPrimList;
    private DefaultListModel schemPrimModel;
    private Map<PrimitiveNode, String> schemPrimMap;
    private boolean changingVHDL = false;
    private JPanel artworkPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel52;
    private JPanel layoutPanel;
    private JCheckBox rotateLayoutTransistors;
    private JPanel schematicsPanel;
    private JCheckBox techArtworkArrowsFilled;
    private JTextField techSchematicsNegatingSize;
    private JPanel technology;
    private JTextField vhdlName;
    private JTextField vhdlNegatedName;
    private JScrollPane vhdlPrimPane;

    public TechnologyTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.techSchematicsNegatingSize);
        EDialog.makeTextFieldSelectAllOnTab(this.vhdlName);
        EDialog.makeTextFieldSelectAllOnTab(this.vhdlNegatedName);
    }

    public JPanel getPanel() {
        return this.technology;
    }

    public String getName() {
        return "Technology";
    }

    public void init() {
        this.rotateLayoutTransistors.setSelected(User.isRotateLayoutTransistors());
        this.techArtworkArrowsFilled.setSelected(Artwork.tech().isFilledArrowHeads());
        this.techSchematicsNegatingSize.setText(TextUtils.formatDouble(Schematics.tech().getNegatingBubbleSize()));
        this.schemPrimModel = new DefaultListModel();
        this.schemPrimList = new JList(this.schemPrimModel);
        this.schemPrimList.setSelectionMode(0);
        this.vhdlPrimPane.setViewportView(this.schemPrimList);
        this.schemPrimList.clearSelection();
        this.schemPrimList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TechnologyTab.this.schemClickPrim();
            }
        });
        this.schemPrimModel.clear();
        this.schemPrimMap = new HashMap<PrimitiveNode, String>();
        Iterator<PrimitiveNode> it = Schematics.tech().getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np != Schematics.tech().andNode && np != Schematics.tech().orNode && np != Schematics.tech().xorNode && np != Schematics.tech().muxNode && np != Schematics.tech().bufferNode) continue;
            String str = Schematics.tech().getVHDLNames(np);
            this.schemPrimMap.put(np, str);
            this.schemPrimModel.addElement(this.makeLine(np, str));
        }
        this.schemPrimList.setSelectedIndex(0);
        this.vhdlName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.vhdlNegatedName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.schemClickPrim();
    }

    private String makeLine(PrimitiveNode np, String vhdlName) {
        return np.getName() + "  (" + vhdlName + ")";
    }

    private void schemClickPrim() {
        this.changingVHDL = true;
        PrimitiveNode np = this.getSelectedPrim();
        if (np == null) {
            return;
        }
        String vhdlNames = this.schemPrimMap.get(np);
        int slashPos = vhdlNames.indexOf(47);
        if (slashPos < 0) {
            this.vhdlName.setText(vhdlNames);
            this.vhdlNegatedName.setText("");
        } else {
            this.vhdlName.setText(vhdlNames.substring(0, slashPos));
            this.vhdlNegatedName.setText(vhdlNames.substring(slashPos + 1));
        }
        this.changingVHDL = false;
    }

    private PrimitiveNode getSelectedPrim() {
        String str = (String)this.schemPrimList.getSelectedValue();
        int spacePos = str.indexOf(32);
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        PrimitiveNode np = Schematics.tech().findNodeProto(str);
        return np;
    }

    private void primVHDLChanged() {
        PrimitiveNode np;
        if (this.changingVHDL) {
            return;
        }
        String str = this.vhdlName.getText();
        String strNot = this.vhdlNegatedName.getText();
        String vhdl = "";
        if (str.length() > 0 || strNot.length() > 0) {
            vhdl = str + "/" + strNot;
        }
        if ((np = this.getSelectedPrim()) == null) {
            return;
        }
        this.schemPrimMap.put(np, vhdl);
        int index = this.schemPrimList.getSelectedIndex();
        this.schemPrimModel.set(index, this.makeLine(np, vhdl));
    }

    public void term() {
        double currentNegatingBubbleSize;
        boolean currentArrowsFilled;
        boolean redrawWindows = false;
        boolean redrawMenus = false;
        boolean currentRotateTransistors = this.rotateLayoutTransistors.isSelected();
        if (currentRotateTransistors != User.isRotateLayoutTransistors()) {
            User.setRotateLayoutTransistors(currentRotateTransistors);
            redrawMenus = true;
        }
        if ((currentArrowsFilled = this.techArtworkArrowsFilled.isSelected()) != Artwork.tech().isFilledArrowHeads()) {
            Artwork.tech().setFilledArrowHeads(currentArrowsFilled);
            redrawWindows = true;
        }
        if ((currentNegatingBubbleSize = TextUtils.atof(this.techSchematicsNegatingSize.getText())) != Schematics.tech().getNegatingBubbleSize()) {
            Schematics.tech().setNegatingBubbleSize(currentNegatingBubbleSize);
            redrawWindows = true;
        }
        for (int i = 0; i < this.schemPrimModel.size(); ++i) {
            String oldVHDLname;
            String newVHDLname;
            String str = (String)this.schemPrimModel.get(i);
            int spacePos = str.indexOf(32);
            if (spacePos < 0) continue;
            String primName = str.substring(0, spacePos);
            PrimitiveNode np = Schematics.tech().findNodeProto(primName);
            if (np == null || (newVHDLname = str.substring(spacePos + 3, str.length() - 1)).equals(oldVHDLname = Schematics.tech().getVHDLNames(np))) continue;
            Schematics.tech().setVHDLNames(np, newVHDLname);
        }
        if (redrawMenus) {
            Technology tech = Technology.getCurrent();
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                wf.getPaletteTab().loadForTechnology(tech, wf);
            }
        }
        if (redrawWindows) {
            EditWindow.repaintAllContents();
        }
    }

    public void reset() {
        if (User.isFactoryRotateLayoutTransistors() != User.isRotateLayoutTransistors()) {
            User.setRotateLayoutTransistors(User.isFactoryRotateLayoutTransistors());
        }
        if (Artwork.tech().isFactoryFilledArrowHeads() != Artwork.tech().isFilledArrowHeads()) {
            Artwork.tech().setFilledArrowHeads(Artwork.tech().isFactoryFilledArrowHeads());
        }
        if (Schematics.tech().getFactoryNegatingBubbleSize() != Schematics.tech().getNegatingBubbleSize()) {
            Schematics.tech().setNegatingBubbleSize(Schematics.tech().getFactoryNegatingBubbleSize());
        }
        Iterator<PrimitiveNode> it = Schematics.tech().getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np != Schematics.tech().andNode && np != Schematics.tech().orNode && np != Schematics.tech().xorNode && np != Schematics.tech().muxNode && np != Schematics.tech().bufferNode || Schematics.tech().getFactoryVHDLNames(np).equals(Schematics.tech().getVHDLNames(np))) continue;
            Schematics.tech().setVHDLNames(np, Schematics.tech().getFactoryVHDLNames(np));
        }
    }

    private void initComponents() {
        this.technology = new JPanel();
        this.artworkPanel = new JPanel();
        this.techArtworkArrowsFilled = new JCheckBox();
        this.schematicsPanel = new JPanel();
        this.techSchematicsNegatingSize = new JTextField();
        this.jLabel52 = new JLabel();
        this.vhdlPrimPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.vhdlName = new JTextField();
        this.jLabel2 = new JLabel();
        this.vhdlNegatedName = new JTextField();
        this.layoutPanel = new JPanel();
        this.rotateLayoutTransistors = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.technology.setLayout(new GridBagLayout());
        this.artworkPanel.setLayout(new GridBagLayout());
        this.artworkPanel.setBorder(BorderFactory.createTitledBorder("Artwork"));
        this.techArtworkArrowsFilled.setText("Arrows filled");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.artworkPanel.add((Component)this.techArtworkArrowsFilled, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.artworkPanel, gridBagConstraints);
        this.schematicsPanel.setLayout(new GridBagLayout());
        this.schematicsPanel.setBorder(BorderFactory.createTitledBorder("Schematics"));
        this.techSchematicsNegatingSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.techSchematicsNegatingSize, gridBagConstraints);
        this.jLabel52.setText("Negating Bubble Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.jLabel52, gridBagConstraints);
        this.vhdlPrimPane.setMinimumSize(new Dimension(22, 100));
        this.vhdlPrimPane.setPreferredSize(new Dimension(22, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.vhdlPrimPane, gridBagConstraints);
        this.jLabel1.setText("VHDL for primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.vhdlName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.vhdlName, gridBagConstraints);
        this.jLabel2.setText("VHDL for negated primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.vhdlNegatedName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schematicsPanel.add((Component)this.vhdlNegatedName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.schematicsPanel, gridBagConstraints);
        this.layoutPanel.setLayout(new GridBagLayout());
        this.layoutPanel.setBorder(BorderFactory.createTitledBorder("Layout Technologies"));
        this.rotateLayoutTransistors.setText("Rotate transistors in menu");
        this.rotateLayoutTransistors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rotateLayoutTransistors.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layoutPanel.add((Component)this.rotateLayoutTransistors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.layoutPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.technology, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SchemPrimDocumentListener
    implements DocumentListener {
        TechnologyTab dialog;

        SchemPrimDocumentListener(TechnologyTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }
    }
}

