/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.ExportChecker;
import com.sun.electric.tool.ncc.processing.ForceMatch;
import com.sun.electric.tool.ncc.processing.HashCodePartitioning;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.LocalPartitionResult;
import com.sun.electric.tool.ncc.processing.LocalPartitioning;
import com.sun.electric.tool.ncc.processing.ReportHashCodeFailure;
import com.sun.electric.tool.ncc.processing.SerialParallelMerge;
import com.sun.electric.tool.ncc.result.BenchmarkResults;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.strategy.StratCheckSizes;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NccEngine {
    private NccGlobals globals;

    private List<NccNetlist> buildNccNetlists(List<Cell> cells, List<VarContext> contexts, boolean blackBox, HierarchyInfo hierInfo) {
        this.globals.error(cells.size() != contexts.size(), "number of cells, and contexts must be the same");
        ArrayList<NccNetlist> nccLists = new ArrayList<NccNetlist>();
        Iterator<Cell> itCell = cells.iterator();
        Iterator<VarContext> itCon = contexts.iterator();
        while (itCell.hasNext()) {
            VarContext context;
            Cell cell = itCell.next();
            NccNetlist nccList = new NccNetlist(cell, context = itCon.next(), hierInfo, blackBox, this.globals);
            if (nccList.userAbort()) {
                return null;
            }
            nccLists.add(nccList);
        }
        return nccLists;
    }

    private int[] getNetObjCounts(EquivRecord rec, int numCells) {
        int[] counts = new int[numCells];
        if (rec == null) {
            return counts;
        }
        int i = 0;
        Iterator<Circuit> it = rec.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = it.next();
            counts[i] = ckt.numNetObjs();
            ++i;
        }
        return counts;
    }

    private void printWireComponentCounts() {
        int numCells = this.globals.getNumNetlistsBeingCompared();
        int[] partCounts = this.getNetObjCounts(this.globals.getParts(), numCells);
        int[] wireCounts = this.getNetObjCounts(this.globals.getWires(), numCells);
        int[] portCounts = this.getNetObjCounts(this.globals.getWires(), numCells);
        String[] cellNames = this.globals.getRootCellNames();
        VarContext[] contexts = this.globals.getRootContexts();
        for (int i = 0; i < cellNames.length; ++i) {
            this.globals.status1("  Cell: " + cellNames[i] + " has " + wireCounts[i] + " wires, " + partCounts[i] + " parts, and " + portCounts[i] + " ports after series/parallel combination. " + "Instance path: " + contexts[i].getInstPath("/"));
        }
    }

    private NccResult designsMatch(HierarchyInfo hierInfo, boolean hierInfoOnly) {
        long start = NccUtils.getTime();
        boolean noNetlists = this.globals.cantBuildNetlist();
        if (noNetlists) {
            this.globals.status2("netlist error");
            this.globals.initLeafLists();
            return NccResult.newResult(false, false, false, this.globals);
        }
        ExportChecker expCheck = new ExportChecker(this.globals);
        expCheck.markPortsForRenaming();
        boolean expNamesOK = expCheck.matchByName();
        if (expNamesOK) {
            expCheck.saveInfoNeededToMakeMeASubcircuit(hierInfo);
        } else if (hierInfo != null) {
            hierInfo.purgeCurrentCompareList();
        }
        if (this.globals.getRoot() == null) {
            this.globals.status2("all cells empty");
            this.globals.initLeafLists();
            return NccResult.newResult(true, true, true, this.globals);
        }
        start = NccUtils.registerTiming("  Export name matching took: ", start, BenchmarkResults.BenchIdx.EXPORT_MATCHING_TIME, this.globals);
        if (this.globals.userWantsToAbort()) {
            return NccResult.newUserAbortResult();
        }
        SerialParallelMerge.doYourJob(this.globals);
        start = NccUtils.registerTiming("  Serial/parallel merge took: ", start, BenchmarkResults.BenchIdx.MERGE_TIME, this.globals);
        if (this.globals.userWantsToAbort()) {
            return NccResult.newUserAbortResult();
        }
        this.printWireComponentCounts();
        HashSet<Part> forcedParts = new HashSet<Part>();
        HashSet<Wire> forcedWires = new HashSet<Wire>();
        ForceMatch.doYourJob(forcedParts, forcedWires, this.globals);
        LocalPartitionResult localRes = LocalPartitioning.doYourJob(forcedParts, forcedWires, this.globals);
        if (this.globals.userWantsToAbort()) {
            return NccResult.newUserAbortResult();
        }
        this.globals.initLeafLists();
        start = NccUtils.registerTiming("  Local partitioning took ", start, BenchmarkResults.BenchIdx.LOCAL_PARTITIONING_TIME, this.globals);
        boolean topoOK = HashCodePartitioning.doYourJob(this.globals);
        if (!localRes.matches()) {
            this.globals.getNccGuiInfo().setPartRecReports(localRes.getPartRecReports());
            this.globals.getNccGuiInfo().setWireRecReports(localRes.getWireRecReports());
            localRes.printErrorReport();
            return NccResult.newResult(expNamesOK, false, false, this.globals);
        }
        if (this.globals.userWantsToAbort()) {
            return NccResult.newUserAbortResult();
        }
        start = NccUtils.getTime();
        boolean expTopoOK = true;
        if (topoOK) {
            expCheck.suggestPortMatchesBasedOnTopology();
            expTopoOK = expCheck.ensureExportsWithMatchingNamesAreOnEquivalentNets();
        }
        start = NccUtils.registerTiming("  Export checking took ", start, BenchmarkResults.BenchIdx.EXPORT_CHECKING_TIME, this.globals);
        boolean sizesOK = StratCheckSizes.doYourJob(this.globals);
        start = NccUtils.registerTiming("  Size checking took ", start, BenchmarkResults.BenchIdx.SIZE_CHECKING_TIME, this.globals);
        if (!topoOK) {
            ReportHashCodeFailure hcf = new ReportHashCodeFailure(this.globals);
            this.globals.getNccGuiInfo().setPartRecReports(hcf.getPartRecReports());
            this.globals.getNccGuiInfo().setWireRecReports(hcf.getWireRecReports());
        }
        boolean exportsOK = expNamesOK && expTopoOK;
        boolean topologyOK = localRes.matches() && topoOK;
        return NccResult.newResult(exportsOK, topologyOK, sizesOK, this.globals);
    }

    private NccResult areEquivalent(List<Cell> cells, List<VarContext> contexts, HierarchyInfo hierInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        this.globals = new NccGlobals(options, aborter);
        this.globals.status2("********************************************************************************");
        Date before = new Date();
        List<NccNetlist> nccNetlists = this.buildNccNetlists(cells, contexts, blackBox, hierInfo);
        Date after = new Date();
        this.globals.status1("  NCC net list construction took " + NccUtils.hourMinSec(before, after) + ".");
        if (nccNetlists == null) {
            return NccResult.newUserAbortResult();
        }
        this.globals.setInitialNetlists(nccNetlists);
        NccResult result = this.designsMatch(hierInfo, false);
        if (result.match()) {
            NccUtils.incrementBenchmarkCount(BenchmarkResults.BenchIdx.PASS_RESULT, this.globals);
        } else {
            NccUtils.incrementBenchmarkCount(BenchmarkResults.BenchIdx.FAIL_RESULT, this.globals);
        }
        this.globals.status2("********************************************************************************");
        return result;
    }

    private static NccResult compare2(Cell cell1, VarContext context1, Cell cell2, VarContext context2, HierarchyInfo hierInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell1);
        cells.add(cell2);
        ArrayList<VarContext> contexts = new ArrayList<VarContext>();
        contexts.add(context1);
        contexts.add(context2);
        return NccEngine.compareMany(cells, contexts, hierInfo, blackBox, options, aborter);
    }

    private static NccResult compareMany(List<Cell> cells, List<VarContext> contexts, HierarchyInfo hierCompInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        NccEngine ncc = new NccEngine();
        return ncc.areEquivalent(cells, contexts, hierCompInfo, blackBox, options, aborter);
    }

    public static NccResult compare(List<Cell> cells, List<VarContext> contexts, HierarchyInfo hierCompInfo, NccOptions options, Aborter aborter) {
        return NccEngine.compareMany(cells, contexts, hierCompInfo, false, options, aborter);
    }

    public static NccResult compare(Cell cell1, VarContext context1, Cell cell2, VarContext context2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        return NccEngine.compare2(cell1, context1, cell2, context2, hierInfo, false, options, aborter);
    }

    public static NccResult buildBlackBoxes(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        return NccEngine.compare2(cell1, ctxt1, cell2, ctxt2, hierInfo, true, options, aborter);
    }
}

