/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlacementTab
extends PreferencePanel {
    private JPanel frame;
    private JLabel jLabel15;
    private JComboBox placementAlgorithm;

    public PlacementTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getUserPreferencesPanel() {
        return this.frame;
    }

    public String getName() {
        return "Placement";
    }

    public void init() {
        PlacementFrame[] algorithms;
        for (PlacementFrame an : algorithms = PlacementFrame.getPlacementAlgorithms()) {
            this.placementAlgorithm.addItem(an.getAlgorithmName());
        }
        this.placementAlgorithm.setSelectedItem(Placement.getAlgorithmName());
    }

    public void term() {
        String algorithm = (String)this.placementAlgorithm.getSelectedItem();
        if (!algorithm.equals(Placement.getAlgorithmName())) {
            Placement.setAlgorithmName(algorithm);
        }
    }

    public void reset() {
        if (!Placement.getFactoryAlgorithmName().equals(Placement.getAlgorithmName())) {
            Placement.setAlgorithmName(Placement.getFactoryAlgorithmName());
        }
    }

    private void initComponents() {
        this.frame = new JPanel();
        this.jLabel15 = new JLabel();
        this.placementAlgorithm = new JComboBox();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PlacementTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.frame.setLayout(new GridBagLayout());
        this.jLabel15.setText("Placement algorithm:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.placementAlgorithm, gridBagConstraints);
        this.getContentPane().add((Component)this.frame, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

