/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInst
extends Geometric
implements Nodable,
Comparable<NodeInst> {
    public static final Variable.Key NODE_PROTO = Variable.newKey("NODE_proto");
    public static final Variable.Key NODE_NAME = Variable.newKey("NODE_name");
    public static final Variable.Key TRACE = Variable.newKey("trace");
    public static final Variable.Key TRANSISTOR_LENGTH_KEY = Variable.newKey("transistor_width");
    private static final PortInst[] NULL_PORT_INST_ARRAY = new PortInst[0];
    final Topology topology;
    private ImmutableNodeInst d;
    private NodeProto protoType;
    private int nodeIndex = -1;
    private PortInst[] portInsts = NULL_PORT_INST_ARRAY;
    private final Rectangle2D.Double visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private boolean validVisBounds;

    public static boolean isSpecialNode(NodeInst ni) {
        NodeProto np = ni.getProto();
        return Generic.isSpecialGenericNode(ni) || np.getFunction().isPin() || np.getFunction() == PrimitiveNode.Function.CONNECT;
    }

    NodeInst(ImmutableNodeInst d, Topology topology) {
        this.topology = topology;
        this.protoType = d.protoId.inDatabase(this.getDatabase());
        this.d = d;
        this.portInsts = new PortInst[this.protoType.getNumPorts()];
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortProto pp = this.protoType.getPort(i);
            this.portInsts[i] = PortInst.newInstance(pp, this);
        }
    }

    private NodeInst(NodeProto protoType, ImmutableNodeInst d) {
        this.topology = null;
        assert (d.protoId == protoType.getId());
        this.d = d;
        this.protoType = protoType;
        this.portInsts = new PortInst[protoType.getNumPorts()];
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortProto pp = protoType.getPort(i);
            this.portInsts[i] = PortInst.newInstance(pp, this);
        }
    }

    protected Object writeReplace() {
        return new NodeInstKey(this);
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent) {
        return NodeInst.makeInstance(protoType, center, width, height, parent, Orientation.IDENT, null);
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name) {
        return NodeInst.makeInstance(protoType, center, width, height, parent, orient, name, 0);
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name, PrimitiveNode.Function function) {
        NodeInst ni = NodeInst.makeInstance(protoType, center, width, height, parent, orient, name);
        if (ni != null && !ni.isCellInstance()) {
            ((PrimitiveNode)protoType).getTechnology().setPrimitiveFunction(ni, function);
        }
        return ni;
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        NodeInst ni = NodeInst.newInstance(protoType, center, width, height, parent, orient, name, techBits);
        if (ni != null) {
            if (protoType instanceof Cell) {
                if (((Cell)protoType).isWantExpanded()) {
                    ni.setExpanded(true);
                }
            } else {
                protoType.getTechnology().setDefaultOutline(ni);
            }
            CircuitChangeJobs.inheritAttributes(ni);
        }
        return ni;
    }

    public static NodeInst makeDummyInstance(NodeProto np) {
        return NodeInst.makeDummyInstance(np, EPoint.ORIGIN, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT);
    }

    public static NodeInst makeDummyInstance(NodeProto np, EPoint center, double width, double height, Orientation orient) {
        return NodeInst.makeDummyInstance(np, 0, center, width, height, orient);
    }

    public static NodeInst makeDummyInstance(NodeProto np, int techBits, EPoint center, double width, double height, Orientation orient) {
        EPoint size = EPoint.ORIGIN;
        if (np instanceof PrimitiveNode) {
            ERectangle full = ((PrimitiveNode)np).getFullRectangle();
            long gridWidth = DBMath.lambdaToSizeGrid(width - full.getLambdaWidth());
            long gridHeight = DBMath.lambdaToSizeGrid(height - full.getLambdaHeight());
            size = EPoint.fromGrid(gridWidth, gridHeight);
        }
        ImmutableNodeInst d = ImmutableNodeInst.newInstance(0, np.getId(), Name.findName("node@0"), TextDescriptor.getNodeTextDescriptor(), orient, center, size, 0, techBits, TextDescriptor.getInstanceTextDescriptor());
        return new NodeInst(np, d);
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent) {
        return NodeInst.newInstance(protoType, center, width, height, parent, Orientation.IDENT, null);
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name) {
        return NodeInst.newInstance(protoType, center, width, height, parent, orient, name, 0);
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        if (name != null && parent.findNode(name) != null) {
            System.out.println(parent + " already has NodeInst with name \"" + name + "\"");
            return null;
        }
        EPoint size = EPoint.ORIGIN;
        if (protoType instanceof PrimitiveNode) {
            ERectangle full = ((PrimitiveNode)protoType).getFullRectangle();
            long gridWidth = DBMath.lambdaToSizeGrid(width - full.getLambdaWidth());
            long gridHeight = DBMath.lambdaToSizeGrid(height - full.getLambdaHeight());
            size = EPoint.fromGrid(gridWidth, gridHeight);
        }
        return NodeInst.newInstance(parent, protoType, name, null, center, size, orient, 0, techBits, null, null);
    }

    public static NodeInst newInstance(Cell parent, NodeProto protoType, String name, TextDescriptor nameDescriptor, Point2D center, EPoint size, Orientation orient, int flags, int techBits, TextDescriptor protoDescriptor, ErrorLogger errorLogger) {
        int nodeId;
        if (protoType == null) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        assert (parent.isLinked());
        if (protoType instanceof Cell) assert (((Cell)protoType).isLinked());
        Topology topology = parent.getTopology();
        EPoint anchor = EPoint.snap(center);
        Name nameKey = null;
        String msg = null;
        if (name != null) {
            nameKey = Name.findName(name);
            if (NodeInst.checkNameKey(nameKey, parent) || nameKey.isBus() && (!(protoType instanceof Cell) || !((Cell)protoType).isIcon())) {
                nameKey = null;
            } else if (parent.findNode(name) != null) {
                if (!nameKey.isTempname()) {
                    msg = parent + " already has NodeInst with name \"" + name + "\"";
                }
                nameKey = null;
            }
        }
        if (nameKey == null) {
            Name baseName;
            if (protoType instanceof Cell) {
                baseName = ((Cell)protoType).getBasename();
            } else {
                PrimitiveNode np = (PrimitiveNode)protoType;
                baseName = np.getTechnology().getPrimitiveFunction(np, techBits).getBasename();
            }
            nameKey = topology.getNodeAutoname(baseName);
            if (msg != null) {
                msg = msg + ", renamed to \"" + nameKey + "\"";
                System.out.println(msg);
            }
        }
        CellId parentId = parent.getId();
        if (nameDescriptor == null) {
            nameDescriptor = TextDescriptor.getNodeTextDescriptor();
        }
        if (protoDescriptor == null) {
            protoDescriptor = TextDescriptor.getInstanceTextDescriptor();
        }
        while (parent.getNodeById(nodeId = parentId.newNodeId()) != null) {
        }
        ImmutableNodeInst d = ImmutableNodeInst.newInstance(nodeId, protoType.getId(), nameKey, nameDescriptor, orient, anchor, size, flags, techBits, protoDescriptor);
        NodeInst ni = NodeInst.newInstance(parent, d);
        if (ni != null && msg != null && errorLogger != null) {
            errorLogger.logError(msg, ni, parent, null, 1);
        }
        return ni;
    }

    public static NodeInst newInstance(Cell parent, ImmutableNodeInst d) {
        if (d.protoId instanceof CellId) {
            Cell subCell = parent.getDatabase().getCell((CellId)d.protoId);
            if (Cell.isInstantiationRecursive(subCell, parent)) {
                System.out.println("Cannot create instance of " + subCell + " in " + parent + " because it would be a recursive case");
                return null;
            }
            subCell.getTechnology();
        }
        if (ImmutableNodeInst.isCellCenter(d.protoId) && parent.alreadyCellCenter()) {
            System.out.println("Can only be one cell-center in " + parent + ": new one ignored");
            return null;
        }
        if (parent.findNode(d.name.toString()) != null) {
            System.out.println(parent + " already has NodeInst with name \"" + d.name + "\"");
            return null;
        }
        NodeInst ni = NodeInst.lowLevelNewInstance(parent.getTopology(), d);
        if (ni.checkAndRepair(true, null, null) > 0) {
            return null;
        }
        if (parent.addNode(ni)) {
            return null;
        }
        Constraints.getCurrent().newObject(ni);
        if (ImmutableNodeInst.isCellCenter(d.protoId)) {
            parent.adjustReferencePoint(d.anchor.getX(), d.anchor.getY());
        }
        return ni;
    }

    public static NodeInst lowLevelNewInstance(Topology topology, ImmutableNodeInst d) {
        if (d.protoId instanceof CellId && ((CellId)d.protoId).isIcon()) {
            return new IconNodeInst(d, topology);
        }
        return new NodeInst(d, topology);
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("NodeInst already killed");
            return;
        }
        this.topology.cell.killNodes(Collections.singleton(this));
    }

    public void move(double dX, double dY) {
        this.modifyInstance(dX, dY, 0.0, 0.0, Orientation.IDENT);
    }

    public void resize(double dXSize, double dYSize) {
        this.modifyInstance(0.0, 0.0, dXSize, dYSize, Orientation.IDENT);
    }

    public void rotate(Orientation dOrient) {
        this.modifyInstance(0.0, 0.0, 0.0, 0.0, dOrient);
    }

    public void modifyInstance(double dX, double dY, double dXSize, double dYSize, Orientation dOrient) {
        ImmutableNodeInst oldD;
        if (ImmutableNodeInst.isCellCenter(this.protoType.getId())) {
            this.topology.cell.adjustReferencePoint(dX, dY);
            return;
        }
        ImmutableNodeInst d = oldD = this.getD();
        if (dX != 0.0 || dY != 0.0) {
            d = d.withAnchor(new EPoint(d.anchor.getX() + dX, d.anchor.getY() + dY));
        }
        if (this.protoType instanceof PrimitiveNode) {
            double lambdaX = d.size.getLambdaX() + dXSize;
            double lambdaY = d.size.getLambdaY() + dYSize;
            d = d.withSize(EPoint.fromLambda(lambdaX, lambdaY));
        }
        d = d.withOrient(dOrient.concatenate(d.orient));
        this.lowLevelModify(d);
        if (this.topology != null) {
            Constraints.getCurrent().modifyNodeInst(this, oldD);
        }
    }

    public static void modifyInstances(NodeInst[] nis, double[] dXs, double[] dYs, double[] dXSizes, double[] dYSizes) {
        double dY;
        double dX;
        NodeInst ni;
        int i;
        for (i = 0; i < nis.length; ++i) {
            double dYSize;
            ni = nis[i];
            if (ni == null) continue;
            dX = dXs != null ? dXs[i] : 0.0;
            dY = dYs != null ? dYs[i] : 0.0;
            double dXSize = dXSizes != null ? dXSizes[i] : 0.0;
            double d = dYSize = dYSizes != null ? dYSizes[i] : 0.0;
            if (ni.getProto() == Generic.tech().cellCenterNode) continue;
            ni.modifyInstance(dX, dY, dXSize, dYSize, Orientation.IDENT);
        }
        for (i = 0; i < nis.length; ++i) {
            ni = nis[i];
            if (ni == null || ni.getProto() != Generic.tech().cellCenterNode) continue;
            dX = dXs != null ? dXs[i] : 0.0;
            dY = dYs != null ? dYs[i] : 0.0;
            ni.topology.cell.adjustReferencePoint(dX, dY);
        }
    }

    public NodeInst replace(NodeProto np, boolean ignorePortNames, boolean allowMissingPorts) {
        NodeInst newNi;
        if (np instanceof Cell && Cell.isInstantiationRecursive((Cell)np, this.topology.cell)) {
            System.out.println("Cannot replace because it would be recursive");
            return null;
        }
        EPoint oldCenter = this.getAnchorCenter();
        double newXS = np.getDefWidth();
        double newYS = np.getDefHeight();
        if (np instanceof PrimitiveNode && this.getProto() instanceof PrimitiveNode) {
            SizeOffset oldSO = this.getProto().getProtoSizeOffset();
            SizeOffset newSO = np.getProtoSizeOffset();
            newXS = this.getXSize() - oldSO.getLowXOffset() - oldSO.getHighXOffset() + newSO.getLowXOffset() + newSO.getHighXOffset();
            newYS = this.getYSize() - oldSO.getLowYOffset() - oldSO.getHighYOffset() + newSO.getLowYOffset() + newSO.getHighYOffset();
        }
        if ((newNi = NodeInst.newInstance(np, oldCenter, newXS, newYS, this.topology.cell, this.getOrient(), null)) == null) {
            return null;
        }
        if (np instanceof Cell && this.getProto() instanceof Cell) {
            newNi.setExpanded(this.isExpanded());
        }
        PortAssociation[] oldAssoc = this.portAssociate(this, newNi, ignorePortNames);
        double arcDx = 0.0;
        double arcDy = 0.0;
        int arcCount = 0;
        String portMismatchError = null;
        ArrayList<String> arcMismatchErrors = null;
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            int index;
            Connection con = it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != con.getPortInst(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                if (allowMissingPorts) continue;
                portMismatchError = portMismatchError != null ? portMismatchError + "," : "No port on new node has same name and location as old node port(s):";
                portMismatchError = portMismatchError + " " + con.getPortInst().getPortProto().getName();
                continue;
            }
            PortInst opi = oldAssoc[index].assn;
            ArcInst ai = con.getArc();
            if (!opi.getPortProto().connectsTo(ai.getProto())) {
                if (allowMissingPorts) continue;
                if (arcMismatchErrors == null) {
                    arcMismatchErrors = new ArrayList<String>();
                }
                arcMismatchErrors.add(ai + " on old port " + con.getPortInst().getPortProto().getName() + " cannot connect to new port " + opi.getPortProto().getName());
                continue;
            }
            Poly poly = opi.getPoly();
            if (!poly.isInside(con.getLocation())) {
                double xp = poly.getCenterX();
                double yp = poly.getCenterY();
                arcDx += xp - con.getLocation().getX();
                arcDy += yp - con.getLocation().getY();
            }
            ++arcCount;
        }
        if (portMismatchError != null || arcMismatchErrors != null) {
            if (portMismatchError != null) {
                System.out.println(portMismatchError);
            }
            if (arcMismatchErrors != null) {
                for (String err : arcMismatchErrors) {
                    System.out.println(err);
                }
            }
            newNi.kill();
            return null;
        }
        ArrayList<String> exportErrors = null;
        Iterator<Export> it2 = this.getExports();
        while (it2.hasNext()) {
            int index;
            Export pp = it2.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pp.getOriginalPort(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                if (exportErrors == null) {
                    exportErrors = new ArrayList<String>();
                }
                exportErrors.add("No port on new node has same name and location as old node port: " + pp.getOriginalPort().getPortProto().getName());
                continue;
            }
            PortInst opi = oldAssoc[index].assn;
            if (!pp.doesntConnect(opi.getPortProto().getBasePort())) continue;
            newNi.kill();
            return null;
        }
        if (exportErrors != null) {
            for (String msg : exportErrors) {
                System.out.println(msg);
            }
            newNi.kill();
            return null;
        }
        HashSet<ArcInst> arcList = new HashSet<ArcInst>();
        Iterator<Connection> it3 = this.getConnections();
        while (it3.hasNext()) {
            arcList.add(it3.next().getArc());
        }
        for (ArcInst ai : arcList) {
            ArcInst newAi;
            NodeInst adjustThisNode;
            int ang;
            int ii;
            PortInst[] newPortInst = new PortInst[2];
            Point2D[] newPoint = new Point2D[2];
            int otherEnd = 0;
            for (int e = 0; e < 2; ++e) {
                EPoint newLoc;
                int index;
                PortInst pi = ai.getPortInst(e);
                if (pi.getNodeInst() != this) {
                    newPortInst[e] = pi;
                    newPoint[e] = ai.getLocation(e);
                    otherEnd = e;
                    continue;
                }
                for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pi; ++index) {
                }
                if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                    if (allowMissingPorts) continue;
                    System.out.println("No port on new node has same name and location as old node port: " + pi.getPortProto().getName());
                    newNi.kill();
                    return null;
                }
                PortInst opi = oldAssoc[index].assn;
                if (opi == null) {
                    if (!allowMissingPorts) {
                        System.out.println("Cannot re-connect " + ai);
                        continue;
                    }
                    ai.kill();
                    continue;
                }
                newPortInst[e] = opi;
                Poly poly = opi.getPoly();
                newPoint[e] = poly.isInside(newLoc = ai.getLocation(e)) ? newLoc : new EPoint(poly.getCenterX(), poly.getCenterY());
            }
            if (newPortInst[0] == null || newPortInst[1] == null) continue;
            boolean zigzag = false;
            if (ai.isFixedAngle() && (newPoint[0].getX() != newPoint[1].getX() || newPoint[0].getY() != newPoint[1].getY()) && (ii = DBMath.figureAngle(newPoint[0], newPoint[1])) % 1800 != (ang = ai.getAngle()) % 1800) {
                zigzag = true;
            }
            if (zigzag && !ai.isRigid() && ai.getAngle() % 900 == 0 && !(adjustThisNode = ai.getPortInst(otherEnd).getNodeInst()).hasExports()) {
                boolean adjustable = true;
                Iterator<Connection> oIt = adjustThisNode.getConnections();
                while (oIt.hasNext()) {
                    Connection otherCon = oIt.next();
                    ArcInst otherArc = otherCon.getArc();
                    if (otherArc == ai) continue;
                    if (otherArc.isRigid()) {
                        adjustable = false;
                        break;
                    }
                    if (otherArc.getAngle() % 900 != 0) {
                        adjustable = false;
                        break;
                    }
                    if ((ai.getAngle() / 900 & 1) != (otherArc.getAngle() / 900 & 1)) continue;
                    adjustable = false;
                    break;
                }
                if (adjustable) {
                    double dX = 0.0;
                    double dY = 0.0;
                    if (ai.getAngle() % 1800 == 0) {
                        dY = newPoint[1 - otherEnd].getY() - newPoint[otherEnd].getY();
                        newPoint[otherEnd] = new Point2D.Double(newPoint[otherEnd].getX(), newPoint[1 - otherEnd].getY());
                    } else {
                        dX = newPoint[1 - otherEnd].getX() - newPoint[otherEnd].getX();
                        newPoint[otherEnd] = new Point2D.Double(newPoint[1 - otherEnd].getX(), newPoint[otherEnd].getY());
                    }
                    ai.kill();
                    adjustThisNode.move(dX, dY);
                    ArcInst newAi2 = ArcInst.newInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], ai.getName(), 0);
                    if (newAi2 == null) {
                        newNi.kill();
                        return null;
                    }
                    newAi2.copyPropertiesFrom(ai);
                    continue;
                }
            }
            if (zigzag) {
                double cX = newPoint[0].getX();
                double cY = newPoint[1].getY();
                EditingPreferences ep = this.getEditingPreferences();
                PrimitiveNode pinNp = ai.getProto().findOverridablePinProto(ep);
                double psx = pinNp.getDefWidth();
                double psy = pinNp.getDefHeight();
                NodeInst pinNi = NodeInst.newInstance(pinNp, new Point2D.Double(cX, cY), psx, psy, this.topology.cell);
                PortInst pinPi = pinNi.getOnlyPortInst();
                newAi = ArcInst.newInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), newPortInst[1], pinPi, newPoint[1], new Point2D.Double(cX, cY), null, 0);
                if (newAi == null) {
                    return null;
                }
                newAi.copyPropertiesFrom(ai);
                ArcInst newAi2 = ArcInst.newInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), pinPi, newPortInst[0], new Point2D.Double(cX, cY), newPoint[0], null, 0);
                if (newAi2 == null) {
                    return null;
                }
                newAi2.copyConstraintsFrom(ai);
                if (newPortInst[0].getNodeInst() == this) {
                    ArcInst aiSwap = newAi;
                    newAi = newAi2;
                    newAi2 = aiSwap;
                }
            } else {
                newAi = ArcInst.newInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], null, 0);
                if (newAi == null) {
                    newNi.kill();
                    return null;
                }
                newAi.copyPropertiesFrom(ai);
            }
            ai.kill();
            newAi.setName(ai.getName());
        }
        ArrayList<Export> exportList = new ArrayList<Export>();
        Iterator<Export> it4 = this.getExports();
        while (it4.hasNext()) {
            exportList.add(it4.next());
        }
        for (Export pp : exportList) {
            int index;
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pp.getOriginalPort(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) continue;
            PortInst newPi = oldAssoc[index].assn;
            pp.move(newPi);
        }
        newNi.copyVarsFrom(this);
        newNi.copyTextDescriptorFrom(this, NODE_NAME);
        newNi.copyTextDescriptorFrom(this, NODE_PROTO);
        newNi.copyStateBitsAndExpandedFlag(this);
        if (!this.getNameKey().isTempname()) {
            String savedName = this.getName();
            String tempName = ElectricObject.uniqueObjectName(savedName, this.topology.cell, NodeInst.class, true, true);
            this.setName(tempName);
            newNi.setName(savedName);
        }
        this.kill();
        return newNi;
    }

    @Override
    public ImmutableNodeInst getD() {
        return this.d;
    }

    public boolean setD(ImmutableNodeInst newD, boolean notify) {
        this.checkChanging();
        ImmutableNodeInst oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        if (this.topology != null) {
            this.topology.cell.setTopologyModified();
            this.d = newD;
            assert (this.protoType == this.d.protoId.inDatabase(this.getDatabase()));
            if (notify) {
                Constraints.getCurrent().modifyNodeInst(this, oldD);
            }
        } else {
            this.d = newD;
            assert (this.protoType.getId() == this.d.protoId);
        }
        return true;
    }

    public void setDInUndo(ImmutableNodeInst newD) {
        this.checkUndoing();
        assert (this.d.protoId.isIcon() == newD.protoId.isIcon());
        this.d = newD;
        this.protoType = this.d.protoId.inDatabase(this.getDatabase());
        this.validVisBounds = false;
    }

    @Override
    public void addVar(Variable var) {
        if (this.setD(this.d.withVariable(var), true)) {
            this.checkPossibleVariableEffects(var.getKey());
        }
    }

    void addVar(PortProtoId portProtoId, Variable var) {
        this.setD(this.d.withPortInst(portProtoId, this.d.getPortInst(portProtoId).withVariable(var)), true);
    }

    @Override
    public void delVar(Variable.Key key) {
        if (this.setD(this.d.withoutVariable(key), true)) {
            this.checkPossibleVariableEffects(key);
        }
    }

    void delVar(PortProtoId portProtoId, Variable.Key key) {
        this.setD(this.d.withPortInst(portProtoId, this.d.getPortInst(portProtoId).withoutVariable(key)), true);
    }

    void delVars(PortProtoId portProtoId) {
        this.setD(this.d.withPortInst(portProtoId, ImmutablePortInst.EMPTY), true);
    }

    public void lowLevelModify(ImmutableNodeInst d) {
        if (this.topology != null) {
            boolean renamed;
            this.checkChanging();
            boolean bl = renamed = this.d.name != d.name;
            if (renamed) {
                this.topology.removeNodeName(this);
            }
            this.setD(d, false);
            if (renamed) {
                this.topology.addNodeName(this);
            }
            this.redoGeometric();
        } else {
            this.d = d;
            this.redoGeometric();
        }
    }

    public boolean isIconOfParent() {
        return this.protoType instanceof Cell && ((Cell)this.protoType).isIconOf(this.topology.cell);
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public final int getNodeIndex() {
        return this.nodeIndex;
    }

    @Override
    public boolean isLinked() {
        try {
            if (this.topology == null) {
                return false;
            }
            Cell parent = this.topology.cell;
            return parent.isLinked() && parent.getNode(this.nodeIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void checkChanging() {
        if (this.topology != null) {
            this.topology.cell.checkChanging();
        }
    }

    @Override
    public Cell whichCell() {
        return this.topology.cell;
    }

    @Override
    public EDatabase getDatabase() {
        return this.topology != null ? this.topology.cell.getDatabase() : null;
    }

    public CellTree getCellTreeUnsafe() {
        if (this.topology != null) {
            return this.topology.cell.treeUnsafe();
        }
        CellId clipCellId = Clipboard.getClipCellId();
        ImmutableCell cell = ImmutableCell.newInstance(clipCellId, 0L);
        cell = cell.withTechId(this.getProto().getTechnology().getId());
        TechPool techPool = TechPool.getThreadTechPool();
        CellBackup cellBackup = CellBackup.newInstance(cell, techPool);
        cellBackup = cellBackup.with(cell, new ImmutableNodeInst[]{this.getD()}, null, null, techPool);
        CellTree[] subTrees = CellTree.NULL_ARRAY;
        if (this.isCellInstance()) {
            Cell subCell = (Cell)this.protoType;
            CellUsage cu = clipCellId.getUsageIn(subCell.getId());
            subTrees = new CellTree[cu.indexInParent + 1];
            subTrees[cu.indexInParent] = subCell.treeUnsafe();
        }
        CellTree cellTree = CellTree.newInstance(cell, techPool).with(cellBackup, subTrees, techPool);
        return cellTree;
    }

    public CellBackup getCellBackupUnsafe() {
        if (this.topology != null) {
            return this.topology.cell.backupUnsafe();
        }
        CellId clipCellId = Clipboard.getClipCellId();
        ImmutableCell cell = ImmutableCell.newInstance(clipCellId, 0L);
        cell = cell.withTechId(this.getProto().getTechnology().getId());
        TechPool techPool = TechPool.getThreadTechPool();
        CellBackup cellBackup = CellBackup.newInstance(cell, techPool);
        cellBackup = cellBackup.with(cell, new ImmutableNodeInst[]{this.getD()}, null, null, techPool);
        return cellBackup;
    }

    public Orientation getOrient() {
        return this.d.orient;
    }

    public int getAngle() {
        return this.d.orient.getAngle();
    }

    public EPoint getAnchorCenter() {
        return this.d.anchor;
    }

    public double getAnchorCenterX() {
        return this.d.anchor.getX();
    }

    public double getAnchorCenterY() {
        return this.d.anchor.getY();
    }

    public double getXSize() {
        if (this.protoType instanceof Cell) {
            return this.protoType.getDefWidth();
        }
        long fullWidth = ((PrimitiveNode)this.protoType).getFullRectangle().getGridWidth();
        return DBMath.gridToLambda(this.d.size.getGridX() + fullWidth);
    }

    public double getLambdaBaseXSize() {
        if (this.protoType instanceof Cell) {
            return this.protoType.getDefWidth();
        }
        return DBMath.gridToLambda(this.d.size.getGridX() + this.getBaseRectangle().getGridWidth());
    }

    public double getXSizeWithoutOffset() {
        return GenMath.isNinetyDegreeRotation(this.getAngle()) ? this.getLambdaBaseYSize() : this.getLambdaBaseXSize();
    }

    public double getYSize() {
        if (this.protoType instanceof Cell) {
            return this.protoType.getDefHeight();
        }
        long fullHeight = ((PrimitiveNode)this.protoType).getFullRectangle().getGridHeight();
        return DBMath.gridToLambda(this.d.size.getGridY() + fullHeight);
    }

    public double getLambdaBaseYSize() {
        if (this.protoType instanceof Cell) {
            return this.protoType.getDefHeight();
        }
        return DBMath.gridToLambda(this.d.size.getGridY() + this.getBaseRectangle().getGridHeight());
    }

    public double getYSizeWithoutOffset() {
        return GenMath.isNinetyDegreeRotation(this.getAngle()) ? this.getLambdaBaseXSize() : this.getLambdaBaseYSize();
    }

    public boolean isMirroredAboutXAxis() {
        return this.isYMirrored();
    }

    public boolean isMirroredAboutYAxis() {
        return this.isXMirrored();
    }

    public boolean isXMirrored() {
        return this.d.orient.isXMirrored();
    }

    public boolean isYMirrored() {
        return this.d.orient.isYMirrored();
    }

    @Override
    public Iterator<Poly> getShape(Poly.Builder polyBuilder) {
        return polyBuilder.getShape(this);
    }

    public Poly getBaseShape() {
        return this.getBaseShape(this.d.anchor, this.d.size);
    }

    public Poly getBaseShape(EPoint anchor, double baseWidth, double baseHeight) {
        EPoint newSize = EPoint.ORIGIN;
        if (this.protoType instanceof PrimitiveNode) {
            ERectangle base = this.getBaseRectangle();
            newSize = EPoint.fromLambda(baseWidth - base.getWidth(), baseHeight - base.getHeight());
        }
        return this.getBaseShape(anchor, newSize);
    }

    private Poly getBaseShape(EPoint anchor, EPoint size) {
        double nodeHighY;
        double nodeLowY;
        double nodeHighX;
        double nodeLowX;
        if (this.protoType instanceof Cell) {
            ERectangle r = ((Cell)this.protoType).getBounds();
            nodeLowX = r.getLambdaMinX();
            nodeHighX = r.getLambdaMaxX();
            nodeLowY = r.getLambdaMinY();
            nodeHighY = r.getLambdaMaxY();
        } else {
            ERectangle baseRect = this.getBaseRectangle();
            long halfW = size.getGridX() >> 1;
            long halfH = size.getGridY() >> 1;
            nodeLowX = DBMath.gridToLambda(-halfW + baseRect.getGridMinX());
            nodeHighX = DBMath.gridToLambda(halfW + baseRect.getGridMaxX());
            nodeLowY = DBMath.gridToLambda(-halfH + baseRect.getGridMinY());
            nodeHighY = DBMath.gridToLambda(halfH + baseRect.getGridMaxY());
        }
        Point2D[] points = nodeLowX != nodeHighX || nodeLowY != nodeHighY ? Poly.makePoints(nodeLowX, nodeHighX, nodeLowY, nodeHighY) : new Point2D[]{new Point2D.Double(nodeLowX, nodeLowY)};
        Poly poly = new Poly(points);
        AffineTransform trans = this.getOrient().rotateAbout(anchor.getLambdaX(), anchor.getLambdaY(), 0.0, 0.0);
        poly.transform(trans);
        return poly;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.validVisBounds) {
            this.computeBounds();
        }
        return this.visBounds;
    }

    private void computeBounds() {
        if (this.d.protoId instanceof CellId) {
            Cell subCell = (Cell)this.getProto();
            ERectangle bounds = subCell.getBounds();
            this.d.orient.rectangleBounds(bounds.getMinX(), bounds.getMinY(), ((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY(), this.d.anchor.getX(), this.d.anchor.getY(), this.visBounds);
        } else {
            BoundsBuilder b = new BoundsBuilder(this.getCellBackupUnsafe());
            this.d.computeBounds(b, this.visBounds);
        }
        this.validVisBounds = true;
    }

    public void redoGeometric() {
        if (this.topology != null) {
            this.topology.cell.unfreshRTree();
        }
        this.validVisBounds = false;
    }

    public double[] getArcDegrees() {
        double[] returnValues = new double[2];
        if (this.protoType != Artwork.tech().circleNode && this.protoType != Artwork.tech().thickCircleNode) {
            return returnValues;
        }
        return this.getD().getArcDegrees();
    }

    public void setArcDegrees(double start, double curvature) {
        if (!(this.protoType instanceof PrimitiveNode)) {
            return;
        }
        if (this.protoType != Artwork.tech().circleNode && this.protoType != Artwork.tech().thickCircleNode) {
            return;
        }
        if (start == 0.0 && curvature == 0.0) {
            if (this.getVar(Artwork.ART_DEGREES) == null) {
                return;
            }
            this.delVar(Artwork.ART_DEGREES);
        } else {
            Float[] fAddr = new Float[]{new Float(start), new Float(curvature)};
            this.newVar(Artwork.ART_DEGREES, (Object)fAddr);
        }
    }

    private ERectangle getBaseRectangle() {
        return ((PrimitiveNode)this.protoType).getBaseRectangle();
    }

    public Rectangle2D getUntransformedBounds() {
        long hy;
        long ly;
        long hx;
        long lx;
        if (this.protoType instanceof PrimitiveNode) {
            ERectangle baseRect = this.getBaseRectangle();
            long halfW = this.d.size.getGridX() >> 1;
            long halfH = this.d.size.getGridY() >> 1;
            lx = -halfW + baseRect.getGridMinX();
            hx = halfW + baseRect.getGridMaxX();
            ly = -halfH + baseRect.getGridMinY();
            hy = halfH + baseRect.getGridMaxY();
        } else {
            ERectangle bounds = ((Cell)this.protoType).getBounds();
            lx = bounds.getGridMinX();
            hx = bounds.getGridMaxX();
            ly = bounds.getGridMinY();
            hy = bounds.getGridMaxY();
        }
        EPoint anchor = this.getAnchorCenter();
        return ERectangle.fromGrid(lx + anchor.getGridX(), ly + anchor.getGridY(), hx - lx, hy - ly);
    }

    @Override
    public Variable getParameter(Variable.Key key) {
        return null;
    }

    @Override
    public boolean isDefinedParameter(Variable.Key key) {
        return false;
    }

    @Override
    public Iterator<Variable> getParameters() {
        return ArrayIterator.emptyIterator();
    }

    @Override
    public Iterator<Variable> getDefinedParameters() {
        return ArrayIterator.emptyIterator();
    }

    public void addParameter(Variable param) {
    }

    public void delParameter(Variable.Key key) {
    }

    public Variable updateParam(Variable.Key key, Object value) {
        return null;
    }

    @Override
    public int numDisplayableVariables(boolean multipleStrings) {
        int numVarsOnNode = super.numDisplayableVariables(multipleStrings);
        if (this.isUsernamed()) {
            ++numVarsOnNode;
        }
        Iterator<PortInst> it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            numVarsOnNode += pi.numDisplayableVariables(multipleStrings);
        }
        return numVarsOnNode;
    }

    @Override
    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow0 wnd, boolean multipleStrings) {
        int numAddedVariables = 0;
        if (this.isUsernamed()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            TextDescriptor td = this.d.nameDescriptor;
            double offX = td.getXOff();
            double offY = td.getYOff();
            AbstractTextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            if (offX != 0.0 || offY != 0.0) {
                td = td.withOff(0.0, 0.0);
                style = Poly.rotateType(style, this);
            }
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.getNameKey().toString());
            polys[start].setTextDescriptor(td);
            polys[start].setLayer(null);
            polys[start].setDisplayedText(new DisplayedText(this, NODE_NAME));
            numAddedVariables = 1;
        }
        numAddedVariables += super.addDisplayableVariables(rect, polys, start + numAddedVariables, wnd, multipleStrings);
        Iterator<PortInst> it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            int justAdded = pi.addDisplayableVariables(rect, polys, start + numAddedVariables, wnd, multipleStrings);
            for (int i = 0; i < justAdded; ++i) {
                polys[start + numAddedVariables + i].setPort(pi.getPortProto());
            }
            numAddedVariables += justAdded;
        }
        return numAddedVariables;
    }

    public Poly[] getDisplayableVariables(EditWindow0 wnd) {
        return this.getDisplayableVariables(this.getUntransformedBounds(), wnd, true);
    }

    public AffineTransform transformOut() {
        return this.d.orient.rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY(), 0.0, 0.0);
    }

    public AffineTransform transformOut(AffineTransform prevTransform) {
        AffineTransform transform = this.transformOut();
        transform.preConcatenate(prevTransform);
        return transform;
    }

    public AffineTransform transformIn() {
        return this.d.orient.inverse().rotateAbout(0.0, 0.0, -this.getAnchorCenterX(), -this.getAnchorCenterY());
    }

    public AffineTransform transformIn(AffineTransform prevTransform) {
        AffineTransform transform = this.transformIn();
        transform.concatenate(prevTransform);
        return transform;
    }

    public AffineTransform translateIn() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(-dx, -dy);
        return transform;
    }

    public AffineTransform translateIn(AffineTransform prevTransform) {
        AffineTransform transform = this.translateIn();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform translateOut() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(dx, dy);
        return transform;
    }

    public AffineTransform translateOut(AffineTransform prevTransform) {
        AffineTransform transform = this.translateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform pureRotateOut() {
        return this.d.orient.pureRotate();
    }

    public AffineTransform pureRotateIn() {
        return this.d.orient.inverse().pureRotate();
    }

    public AffineTransform rotateIn() {
        return this.d.orient.inverse().rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY());
    }

    public AffineTransform rotateIn(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateIn();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform rotateOut() {
        return this.d.orient.rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY());
    }

    public AffineTransform rotateOutAboutTrueCenter() {
        return this.d.orient.rotateAbout(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public AffineTransform rotateOut(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform rotateOutAboutTrueCenter(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOutAboutTrueCenter();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public Poly getShapeOfPort(PortProto thePort) {
        return this.getShapeOfPort(thePort, null, false, -1.0);
    }

    public Poly getShapeOfPort(PortProto thePort, Point2D selectPt, boolean forWiringTool, double arcWidth) {
        PortOriginal fp = new PortOriginal(this, thePort);
        AffineTransform trans = fp.getTransformToTop();
        Cell cell = fp.getBottomCell();
        ImmutableNodeInst n = fp.getBottomImmutableNodeInst();
        PrimitivePort pp = fp.getBottomPortProto();
        PrimitiveNode np = pp.getParent();
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        Poly poly = polyBuilder.getShape(this.getCellTreeUnsafe(), n, pp, selectPt);
        Rectangle2D box = poly.getBox();
        if (forWiringTool && box != null) {
            if (arcWidth != -1.0 && np.getFunction().isContact()) {
                ERectangle baseRectangle = np.getBaseRectangle();
                double width = DBMath.gridToLambda(n.size.getGridX() + baseRectangle.getGridWidth());
                double height = DBMath.gridToLambda(n.size.getGridY() + baseRectangle.getGridHeight());
                double newportwidth = width - arcWidth;
                double newportheight = height - arcWidth;
                if (newportwidth < 0.0) {
                    newportwidth = 0.0;
                }
                if (newportheight < 0.0) {
                    newportheight = 0.0;
                }
                double offsetX = 0.0;
                double offsetY = 0.0;
                if (newportwidth < box.getWidth()) {
                    offsetX = 0.5 * (newportwidth - box.getWidth());
                    box = new Rectangle2D.Double(box.getX() - offsetX, box.getY(), box.getWidth() + 2.0 * offsetX, box.getHeight());
                }
                if (newportheight < box.getHeight()) {
                    offsetY = 0.5 * (newportheight - box.getHeight());
                    box = new Rectangle2D.Double(box.getX(), box.getY() - offsetY, box.getWidth(), box.getHeight() + 2.0 * offsetY);
                }
            }
            EditingPreferences ep = cell.getEditingPreferences();
            if (n.size.getGridX() >> 1 == np.getDefaultGridExtendX(ep)) {
                double x = poly.getCenterX();
                box = new Rectangle2D.Double(x, box.getMinY(), 0.0, box.getHeight());
            }
            if (n.size.getGridY() >> 1 == np.getDefaultGridExtendY(ep)) {
                double y = poly.getCenterY();
                box = new Rectangle2D.Double(box.getMinX(), y, box.getWidth(), 0.0);
            }
            poly = new Poly(box);
        }
        poly.transform(trans);
        return poly;
    }

    public EPoint[] getTrace() {
        return this.getD().getTrace();
    }

    public void setTrace(Point2D[] points) {
        double lY;
        double lX;
        double hX = lX = points[0].getX();
        double hY = lY = points[0].getY();
        for (int i = 1; i < points.length; ++i) {
            double y;
            if (points[i] == null) continue;
            double x = points[i].getX();
            if (x < lX) {
                lX = x;
            }
            if (x > hX) {
                hX = x;
            }
            if ((y = points[i].getY()) < lY) {
                lY = y;
            }
            if (!(y > hY)) continue;
            hY = y;
        }
        double newCX = (lX + hX) / 2.0;
        double newCY = (lY + hY) / 2.0;
        double newSX = hX - lX;
        double newSY = hY - lY;
        EPoint[] newPoints = new EPoint[points.length];
        for (int i = 0; i < newPoints.length; ++i) {
            if (points[i] == null) continue;
            newPoints[i] = new EPoint(points[i].getX() - newCX, points[i].getY() - newCY);
        }
        this.newVar(TRACE, (Object)newPoints);
        this.modifyInstance(newCX - this.getAnchorCenterX(), newCY - this.getAnchorCenterY(), newSX - this.getXSize(), newSY - this.getYSize(), this.getOrient().inverse());
    }

    public boolean traceWraps() {
        if (this.protoType == Artwork.tech().splineNode || this.protoType == Artwork.tech().openedPolygonNode || this.protoType == Artwork.tech().openedDottedPolygonNode || this.protoType == Artwork.tech().openedDashedPolygonNode || this.protoType == Artwork.tech().openedThickerPolygonNode) {
            return false;
        }
        return !this.getFunction().isFET();
    }

    public Iterator<PortInst> getPortInsts() {
        return ArrayIterator.iterator(this.portInsts);
    }

    public int getNumPortInsts() {
        return this.portInsts.length;
    }

    public PortInst getPortInst(int portIndex) {
        return this.portInsts[portIndex];
    }

    public PortInst getOnlyPortInst() {
        int sz = this.portInsts.length;
        if (sz != 1) {
            System.out.println("NodeInst.getOnlyPortInst: " + this.topology.cell + ", " + this + " doesn't have just one port, it has " + sz);
            return null;
        }
        return this.portInsts[0];
    }

    public PortInst findPortInst(String name) {
        PortProto pp = this.protoType.findPortProto(name);
        if (pp == null) {
            return null;
        }
        return this.portInsts[pp.getPortIndex()];
    }

    public PortInst findClosestPortInst(Point2D w) {
        double bestDist = Double.MAX_VALUE;
        PortInst bestPi = null;
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortInst pi = this.portInsts[i];
            Poly piPoly = pi.getPoly();
            Point2D.Double piPt = new Point2D.Double(piPoly.getCenterX(), piPoly.getCenterY());
            double thisDist = piPt.distance(w);
            if (!(thisDist < bestDist)) continue;
            bestDist = thisDist;
            bestPi = pi;
        }
        return bestPi;
    }

    public PortInst findPortInstFromProto(PortProto pp) {
        return this.portInsts[pp.getPortIndex()];
    }

    public void updatePortInsts(int[] pattern) {
        assert (pattern.length == this.protoType.getNumPorts());
        if (pattern.length == 0) {
            this.portInsts = NULL_PORT_INST_ARRAY;
            return;
        }
        PortInst[] newPortInsts = new PortInst[pattern.length];
        for (int i = 0; i < newPortInsts.length; ++i) {
            int p = pattern[i];
            newPortInsts[i] = p >= 0 ? this.portInsts[p] : PortInst.newInstance(this.protoType.getPort(i), this);
        }
        this.portInsts = newPortInsts;
    }

    public void updatePortInsts(boolean full) {
        int i;
        PortInst[] newPortInsts = new PortInst[this.protoType.getNumPorts()];
        for (i = 0; i < this.portInsts.length; ++i) {
            int portIndex;
            PortProto pp;
            PortInst pi = this.portInsts[i];
            if (full && (pi.getNodeInst() != this || (pp = pi.getPortProto()).getParent() != this.getProto() || pp instanceof Export && !((Export)pp).isLinked()) || (portIndex = pi.getPortIndex()) < 0) continue;
            newPortInsts[portIndex] = pi;
        }
        for (i = 0; i < newPortInsts.length; ++i) {
            if (newPortInsts[i] != null) continue;
            newPortInsts[i] = PortInst.newInstance(this.protoType.getPort(i), this);
        }
        this.portInsts = newPortInsts;
    }

    public Cell getProtoEquivalent() {
        if (!(this.protoType instanceof Cell)) {
            return null;
        }
        return ((Cell)this.protoType).getEquivalent();
    }

    public boolean hasExports() {
        return this.topology != null && this.topology.cell.getMemoization().hasExports(this.getD());
    }

    public Iterator<Export> getExports() {
        Iterator<ImmutableExport> it;
        ExportIterator eit = ArrayIterator.emptyIterator();
        if (this.topology != null && (it = this.topology.cell.getMemoization().getExports(this.getD().nodeId)).hasNext()) {
            eit = new ExportIterator(it);
        }
        return eit;
    }

    public int getNumExports() {
        return this.topology != null ? this.topology.cell.getMemoization().getNumExports(this.getD().nodeId) : 0;
    }

    private PortAssociation[] portAssociate(NodeInst ni1, NodeInst ni2, boolean ignorePortNames) {
        int total1 = ni1.getProto().getNumPorts();
        PortAssociation[] portInfo1 = new PortAssociation[total1];
        int k = 0;
        Iterator<PortInst> it1 = ni1.getPortInsts();
        while (it1.hasNext()) {
            PortInst pi1 = it1.next();
            portInfo1[k] = new PortAssociation();
            portInfo1[k].portInst = pi1;
            portInfo1[k].poly = pi1.getPoly();
            portInfo1[k].pos = new Point2D.Double(portInfo1[k].poly.getCenterX(), portInfo1[k].poly.getCenterY());
            portInfo1[k].assn = null;
            ++k;
        }
        int total2 = ni2.getProto().getNumPorts();
        PortAssociation[] portInfo2 = new PortAssociation[total2];
        k = 0;
        Iterator<PortInst> it2 = ni2.getPortInsts();
        while (it2.hasNext()) {
            PortInst pi2 = it2.next();
            portInfo2[k] = new PortAssociation();
            portInfo2[k].portInst = pi2;
            portInfo2[k].poly = pi2.getPoly();
            portInfo2[k].pos = new Point2D.Double(portInfo2[k].poly.getCenterX(), portInfo2[k].poly.getCenterY());
            portInfo2[k].assn = null;
            ++k;
        }
        if (!ignorePortNames) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || !pi2.getPortProto().getName().equals(pi1.getPortProto().getName())) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                if (portInfo1[i1].assn != null) continue;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || pass == 0 && (!portInfo1[i1].poly.polySame(portInfo2[i2].poly) || !this.connectivityMatches(pi1.getPortProto(), pi2.getPortProto()))) continue;
                    if (portInfo1[i1].assn != null) {
                        PortProto mpt = portInfo1[i1].assn.getPortProto();
                        if (ignorePortNames && (pi1.getPortProto().getName().equals(mpt.getName()) || !pi1.getPortProto().getName().equals(pi2.getPortProto().getName()))) continue;
                        boolean matchNew = this.connectivityMatches(pi1.getPortProto(), pi2.getPortProto());
                        boolean matchOld = this.connectivityMatches(pi1.getPortProto(), mpt);
                        if (!matchNew || matchOld) continue;
                    }
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int i1 = 0; i1 < total1; ++i1) {
            if (portInfo1[i1].assn != null) continue;
            for (int i2 = 0; i2 < total2; ++i2) {
                if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || !this.connectivityMatches(portInfo1[i1].portInst.getPortProto(), portInfo2[i2].portInst.getPortProto())) continue;
                portInfo1[i1].assn = portInfo2[i2].portInst;
            }
        }
        return portInfo1;
    }

    private boolean connectivityMatches(PortProto pp1, PortProto pp2) {
        ArcProto[] i2Conn2;
        ArcProto[] i1Conn1 = pp1.getBasePort().getConnections();
        if (i1Conn1.length != (i2Conn2 = pp2.getBasePort().getConnections()).length) {
            return false;
        }
        for (int j = 0; j < i1Conn1.length; ++j) {
            if (j >= i2Conn2.length) {
                return false;
            }
            if (i1Conn1[j] == i2Conn2[j]) continue;
            return false;
        }
        return true;
    }

    public boolean pinUseCount() {
        return this.topology != null && this.topology.cell.getMemoization().pinUseCount(this.getD());
    }

    public boolean isInlinePin() {
        if (!this.protoType.getFunction().isPin()) {
            return false;
        }
        int j = 0;
        ArcInst[] reconAr = new ArcInst[2];
        Point2D.Double[] delta = new Point2D.Double[2];
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            ArcInst ai;
            Connection con = it.next();
            if (j >= 2) {
                j = 0;
                break;
            }
            reconAr[j] = ai = con.getArc();
            EPoint thisLocation = con.getLocation();
            EPoint thatLocation = ai.getLocation(1 - con.getEndIndex());
            delta[j] = new Point2D.Double(thatLocation.getX() - thisLocation.getX(), thatLocation.getY() - thisLocation.getY());
            ++j;
        }
        if (j != 2) {
            return false;
        }
        if (reconAr[0].getProto() != reconAr[1].getProto()) {
            return false;
        }
        if (reconAr[0].getLambdaBaseWidth() != reconAr[1].getLambdaBaseWidth()) {
            return false;
        }
        if (((Point2D)delta[0]).getX() != 0.0 || ((Point2D)delta[0]).getY() != 0.0 || ((Point2D)delta[1]).getX() != 0.0 || ((Point2D)delta[1]).getY() != 0.0) {
            Point2D.Double zero = new Point2D.Double(0.0, 0.0);
            if (!(((Point2D)delta[0]).getX() == 0.0 && ((Point2D)delta[0]).getY() == 0.0 || ((Point2D)delta[1]).getX() == 0.0 && ((Point2D)delta[1]).getY() == 0.0 || DBMath.figureAngle(zero, delta[0]) == DBMath.figureAngle(delta[1], zero))) {
                return false;
            }
        }
        if (reconAr[0].getVar(ImmutableArcInst.ARC_RADIUS) != null) {
            return false;
        }
        if (reconAr[1].getVar(ImmutableArcInst.ARC_RADIUS) != null) {
            return false;
        }
        Name name0 = reconAr[0].getNameKey();
        Name name1 = reconAr[1].getNameKey();
        return name0 == null || name1 == null || name0.isTempname() || name1.isTempname();
    }

    public PortProto connectsTo(ArcProto arc) {
        int numPorts = this.protoType.getNumPorts();
        for (int i = 0; i < numPorts; ++i) {
            PortProto pp = this.protoType.getPort(i);
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public Iterator<Connection> getConnections() {
        if (this.topology == null) {
            Iterator<Connection> cit = ArrayIterator.emptyIterator();
            return cit;
        }
        return new ConnectionIterator(this.topology.cell.getMemoization(), this.getD());
    }

    Iterator<Connection> getConnections(PortProtoId portId) {
        if (this.topology == null) {
            Iterator<Connection> cit = ArrayIterator.emptyIterator();
            return cit;
        }
        return new ConnectionIterator(this.topology.cell.getMemoization(), this.getD(), portId);
    }

    public boolean hasConnections() {
        return this.topology != null && this.topology.cell.getMemoization().hasConnections(this.getD(), null);
    }

    public int getNumConnections() {
        return this.topology != null ? this.topology.cell.getMemoization().getNumConnections(this.getD()) : 0;
    }

    @Override
    public boolean isConnected(Geometric geom) {
        return geom instanceof ArcInst && ((ArcInst)geom).isConnected(this);
    }

    @Override
    public String getName() {
        return this.d.name.toString();
    }

    public boolean isUsernamed() {
        return this.d.isUsernamed();
    }

    @Override
    public Name getNameKey() {
        return this.d.name;
    }

    public boolean setName(String name) {
        assert (this.isLinked());
        Name key = null;
        Cell parent = this.topology.cell;
        if (name != null && name.length() > 0) {
            if (name.equals(this.getName())) {
                return false;
            }
            if (parent.findNode(name) != null) {
                System.out.println(parent + " already has NodeInst with name \"" + name + "\"");
                return true;
            }
            key = Name.findName(name);
        } else {
            if (!this.isUsernamed()) {
                return false;
            }
            key = this.topology.getNodeAutoname(this.getBasename());
        }
        if (NodeInst.checkNameKey(key, parent) || key.isBus() && (!(this.protoType instanceof Cell) || !((Cell)this.protoType).isIcon())) {
            return true;
        }
        ImmutableNodeInst oldD = this.d;
        this.lowLevelModify(this.d.withName(key));
        Constraints.getCurrent().modifyNodeInst(this, oldD);
        return false;
    }

    public static boolean checkNameKey(Name name, Cell parent) {
        String extrMsg;
        String string = extrMsg = parent != null ? parent.toString() : "";
        if (!name.isValid()) {
            System.out.println(extrMsg + ": Invalid name \"" + name + "\" wasn't assigned to node" + " :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isBus()) {
            if (name.isTempname()) {
                System.out.println(extrMsg + ": Temporary name \"" + name + "\" can't be bus");
                return true;
            }
            if (!parent.busNamesAllowed()) {
                System.out.println(extrMsg + ": Bus name \"" + name + "\" can be in icons and schematics only");
                return true;
            }
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(extrMsg + ": Name \"" + name + "\" with empty subnames wasn't assigned to node");
            } else {
                System.out.println(extrMsg + ": Cannot assign empty name \"" + name + "\" to node");
            }
            return true;
        }
        return false;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == NODE_NAME) {
            return this.d.nameDescriptor;
        }
        if (varKey == NODE_PROTO) {
            return this.d.protoDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == NODE_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        if (varKey == NODE_PROTO) {
            this.setD(this.d.withProtoDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == NODE_NAME || key == NODE_PROTO) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
        if (key == TRACE && this.protoType instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)this.protoType;
            this.lowLevelModify(this.d);
        } else if (key == Artwork.ART_DEGREES) {
            this.lowLevelModify(this.d);
        }
    }

    public boolean isInvisiblePinWithText() {
        if (this.getProto() != Generic.tech().invisiblePinNode) {
            return false;
        }
        if (this.hasExports()) {
            return true;
        }
        return this.numDisplayableVariables(false) != 0;
    }

    public Point2D invisiblePinWithOffsetText(boolean repair) {
        Poly.Type style;
        Technology tech;
        Poly[] polyList;
        if (!this.protoType.getFunction().isPin()) {
            return null;
        }
        if (this.hasConnections()) {
            return null;
        }
        if (this.protoType != Generic.tech().invisiblePinNode && (polyList = (tech = this.protoType.getTechnology()).getShapeOfNode(this)).length > 0 && !(style = polyList[0].getStyle()).isText()) {
            return null;
        }
        Iterator<Serializable> it = this.getExports();
        while (it.hasNext()) {
            Export pp = it.next();
            TextDescriptor td = pp.getTextDescriptor(Export.EXPORT_NAME);
            if (td.getXOff() == 0.0 && td.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + td.getXOff(), this.getAnchorCenterY() + td.getYOff());
            if (repair) {
                pp.setOff(Export.EXPORT_NAME, 0.0, 0.0);
            }
            return retVal;
        }
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay() || var.getXOff() == 0.0 && var.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + var.getXOff(), this.getAnchorCenterY() + var.getYOff());
            if (repair) {
                this.setOff(var.getKey(), 0.0, 0.0);
            }
            return retVal;
        }
        return null;
    }

    public String getTechSpecificAddition() {
        PrimitiveNode pNp;
        if (this.protoType instanceof PrimitiveNode && (pNp = (PrimitiveNode)this.protoType).isTechSpecific()) {
            String description = this.protoType.describe(false);
            PrimitiveNode.Function fun = this.getFunction();
            String funName = fun.getName();
            String funNameLC = funName.toLowerCase();
            String descLC = description.toLowerCase();
            if (!descLC.equals(funNameLC)) {
                if (funNameLC.startsWith(descLC) && (funName = funName.substring(description.length())).startsWith("-")) {
                    funName = funName.substring(1);
                }
                if (funNameLC.endsWith(descLC) && (funName = funName.substring(0, funName.length() - description.length())).endsWith("-")) {
                    funName = funName.substring(0, funName.length() - 1);
                }
                return funName;
            }
        }
        return "";
    }

    @Override
    public String describe(boolean withQuotes) {
        String name;
        String description = this.protoType.describe(false);
        String extra = this.getTechSpecificAddition();
        if (extra.length() > 0) {
            description = description + "(" + extra + ")";
        }
        String string = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    @Override
    public int compareTo(NodeInst that) {
        int cmp;
        if (this.topology != that.topology && (cmp = this.topology.cell.compareTo(that.topology.cell)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.d.nodeId - that.d.nodeId;
    }

    @Override
    public String toString() {
        if (this.protoType == null) {
            return "NodeInst no protoType";
        }
        return "node " + this.describe(true);
    }

    @Override
    public NodeProto getProto() {
        return this.protoType;
    }

    @Override
    public boolean isCellInstance() {
        return this.protoType instanceof Cell;
    }

    public Nodable getNodable(int arrayIndex) {
        if (arrayIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public boolean contains(NodeInst ni, int arrayIndex) {
        return ni == this && arrayIndex == 0;
    }

    @Override
    public NodeInst getNodeInst() {
        return this;
    }

    @Override
    public int getNodableArrayIndex() {
        return 0;
    }

    public PrimitiveNode.Function getFunction() {
        if (this.protoType instanceof Cell) {
            return PrimitiveNode.Function.UNKNOWN;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getPrimitiveFunction(np, this.getTechSpecific());
    }

    public boolean isPrimitiveTransistor() {
        PrimitiveNode.Function func = this.protoType.getFunction();
        return func.isTransistor();
    }

    public boolean isPrimtiveSubstrateNode() {
        if (this.getFunction() != PrimitiveNode.Function.NODE) {
            return false;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        if (np.getNodeLayers().length != 1) {
            return false;
        }
        return np.getNodeLayers()[0].getLayer().getFunction().isSubstrate();
    }

    public boolean isSerpentineTransistor() {
        if (!this.isPrimitiveTransistor()) {
            return false;
        }
        PrimitiveNode pn = (PrimitiveNode)this.getProto();
        return pn.isHoldsOutline() && this.getTrace() != null;
    }

    public PrimitiveNodeSize getNodeInstSize(VarContext context) {
        PrimitiveNodeSize size = this.getPrimitiveDependentNodeSize(context);
        if (size == null) {
            double x = this.getLambdaBaseXSize();
            double y = this.getLambdaBaseYSize();
            size = new PrimitiveNodeSize(new Double(x), new Double(y), true);
        }
        return size;
    }

    public PrimitiveNodeSize getPrimitiveDependentNodeSize(VarContext context) {
        PrimitiveNodeSize size = this.getTransistorSize(context);
        if (size == null) {
            size = this.getResistorSize(context);
        }
        return size;
    }

    private PrimitiveNodeSize getResistorSize(VarContext context) {
        if (!this.getFunction().isResistor()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getResistorSize(this, context);
    }

    public TransistorSize getTransistorSize(VarContext context) {
        if (!this.isPrimitiveTransistor()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSize(this, context);
    }

    public void setPrimitiveNodeSize(double width, double length) {
        if (!(this.isPrimitiveTransistor() || this.getFunction().isFET() || this.getFunction().isResistor())) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        this.checkChanging();
        np.getTechnology().setPrimitiveNodeSize(this, width, length);
    }

    public void setPrimitiveNodeSize(Object width, Object length) {
        Technology tech = this.protoType.getTechnology();
        if (tech != Schematics.tech()) {
            return;
        }
        this.checkChanging();
        Schematics.tech().setPrimitiveNodeSize(this, width, length);
    }

    public double getSerpentineTransistorLength() {
        return this.getD().getSerpentineTransistorLength();
    }

    public void setSerpentineTransistorLength(double length) {
        this.updateVar(TRANSISTOR_LENGTH_KEY, new Double(length));
    }

    public PortInst getTransistorGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorGatePort(this);
    }

    public PortInst getTransistorAltGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorAltGatePort(this);
    }

    public PortInst getTransistorSourcePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSourcePort(this);
    }

    public PortInst getTransistorEmitterPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorEmitterPort(this);
    }

    public PortInst getTransistorBasePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBasePort(this);
    }

    public PortInst getTransistorCollectorPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorCollectorPort(this);
    }

    public PortInst getTransistorBiasPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBiasPort(this);
    }

    public PortInst getTransistorDrainPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorDrainPort(this);
    }

    public int checkAndRepair(boolean repair, List<Geometric> list, ErrorLogger errorLogger) {
        Cell parent;
        int errorCount = 0;
        double width = this.getXSize();
        double height = this.getYSize();
        Cell cell = parent = this.topology != null ? this.topology.cell : null;
        if (this.protoType instanceof Cell) {
            Variable var = this.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            if (var != null) {
                String nccMsg = "Removed extraneous NCC annotations from cell instance " + this.describe(false) + " in " + this.topology.cell;
                if (repair) {
                    this.delVar(var.getKey());
                    nccMsg = nccMsg + " (REPAIRED)";
                }
                System.out.println(nccMsg);
                if (errorLogger != null) {
                    errorLogger.logWarning(nccMsg, this, parent, null, 1);
                }
            }
            return errorCount;
        }
        PrimitiveNode pn = (PrimitiveNode)this.protoType;
        if (pn.getTechnology().cleanUnusedNodesInLibrary(this, list)) {
            if (errorLogger != null) {
                String msg = "Prototype of node " + this.getName() + " is unused";
                if (repair) {
                    Poly poly = new Poly(this.getBounds());
                    errorLogger.logError(msg, poly, parent, 1);
                } else {
                    errorLogger.logError(msg, this, parent, null, 1);
                }
            }
            if (list != null) {
                if (repair) {
                    list.add(this);
                }
                return 1;
            }
        }
        String sizeMsg = null;
        if (this.getTrace() != null) {
            if (pn.isHoldsOutline()) {
                Rectangle2D.Double bounds = new Rectangle2D.Double();
            } else {
                String msg = parent + ", " + this + " has unexpected outline";
                System.out.println(msg);
                if (errorLogger != null) {
                    errorLogger.logError(msg, this, parent, null, 1);
                }
                if (repair) {
                    this.delVar(TRACE);
                }
            }
        }
        if (sizeMsg != null) {
            assert (false);
            sizeMsg = parent + ", " + this + " is " + this.getXSize() + "x" + this.getYSize() + sizeMsg + width + "x" + height;
            if (repair) {
                this.checkChanging();
                sizeMsg = sizeMsg + " (REPAIRED)";
            }
            System.out.println(sizeMsg);
            if (errorLogger != null) {
                errorLogger.logWarning(sizeMsg, this, parent, null, 1);
            }
            if (repair) {
                ERectangle full = pn.getFullRectangle();
                double lambdaX = width - full.getLambdaWidth();
                double lambdaY = height - full.getLambdaHeight();
                this.lowLevelModify(this.d.withSize(EPoint.fromLambda(lambdaX, lambdaY)));
            }
        }
        return errorCount;
    }

    @Override
    public void check() {
        assert (this.isLinked());
        super.check();
        assert (this.getClass() == (this.isCellInstance() && ((Cell)this.getProto()).isIcon() ? IconNodeInst.class : NodeInst.class));
        assert (this.portInsts.length == this.protoType.getNumPorts());
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortInst pi = this.portInsts[i];
            assert (pi.getNodeInst() == this);
            PortProto pp = pi.getPortProto();
            assert (pp == this.protoType.getPort(i));
        }
        if (this.validVisBounds && Job.getDebug()) {
            Rectangle2D.Double chkBounds = new Rectangle2D.Double();
            if (this.d.protoId instanceof CellId) {
                Cell subCell = (Cell)this.getProto();
                ERectangle bounds = subCell.getBounds();
                this.d.orient.rectangleBounds(bounds.getMinX(), bounds.getMinY(), ((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY(), this.d.anchor.getX(), this.d.anchor.getY(), chkBounds);
            } else {
                BoundsBuilder b = new BoundsBuilder(this.getCellBackupUnsafe());
                this.d.computeBounds(b, chkBounds);
            }
            assert (chkBounds.equals(this.visBounds));
        }
    }

    public Name getBasename() {
        return this.protoType instanceof Cell ? ((Cell)this.protoType).getBasename() : this.getFunction().getBasename();
    }

    public void copyStateBits(NodeInst ni) {
        this.setD(this.d.withStateBits(ni.d), true);
    }

    private void setFlag(ImmutableNodeInst.Flag flag, boolean value) {
        this.setD(this.d.withFlag(flag, value), true);
    }

    public void copyStateBitsAndExpandedFlag(NodeInst ni) {
        this.copyStateBits(ni);
        this.setExpanded(ni.isExpanded());
    }

    public void setExpanded(boolean value) {
        if (this.topology != null) {
            this.topology.cell.setExpanded(this.getD().nodeId, value);
        }
    }

    public boolean isExpanded() {
        return this.topology != null && this.topology.cell.isExpanded(this.getD().nodeId);
    }

    public boolean isWiped() {
        if (this.topology == null || !(this.protoType instanceof PrimitiveNode) || !((PrimitiveNode)this.protoType).isArcsWipe()) {
            return false;
        }
        return this.topology.cell.getMemoization().isWiped(this.getD());
    }

    public void setHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, true);
    }

    public void clearHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, false);
    }

    public boolean isHardSelect() {
        return this.d.is(ImmutableNodeInst.HARD_SELECT);
    }

    public void setVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, true);
    }

    public void clearVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, false);
    }

    public boolean isVisInside() {
        return this.d.is(ImmutableNodeInst.VIS_INSIDE);
    }

    public void setLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, true);
    }

    public void clearLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, false);
    }

    public boolean isLocked() {
        return this.d.is(ImmutableNodeInst.LOCKED);
    }

    public void setTechSpecific(int value) {
        this.setD(this.d.withTechSpecific(value), true);
    }

    public int getTechSpecific() {
        return this.d.techBits;
    }

    public Rectangle2D findEssentialBounds() {
        NodeProto np = this.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        Rectangle2D eb = ((Cell)np).findEssentialBounds();
        if (eb == null) {
            return null;
        }
        AffineTransform xForm = this.transformOut();
        Point2D ll = new Point2D.Double(eb.getMinX(), eb.getMinY());
        ll = xForm.transform(ll, null);
        Point2D ur = new Point2D.Double(eb.getMaxX(), eb.getMaxY());
        ur = xForm.transform(ur, null);
        double minX = Math.min(ll.getX(), ur.getX());
        double minY = Math.min(ll.getY(), ur.getY());
        double maxX = Math.max(ll.getX(), ur.getX());
        double maxY = Math.max(ll.getY(), ur.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Serializable p;
        Iterator<Serializable> i;
        boolean found;
        Poly[] noPolyList;
        PrimitiveNode.Function noFunc;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInst no = (NodeInst)obj;
        if (this.getFunction() != no.getFunction()) {
            if (buffer != null) {
                buffer.append("Functions are not the same for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        NodeProto noProtoType = no.getProto();
        NodeProto protoType = this.getProto();
        if (protoType.getClass() != noProtoType.getClass()) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (!this.rotateOut().equals(no.rotateOut())) {
            if (buffer != null) {
                buffer.append("Not the same rotation for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (protoType instanceof Cell) {
            return noProtoType instanceof Cell;
        }
        PrimitiveNode np = (PrimitiveNode)protoType;
        PrimitiveNode noNp = (PrimitiveNode)noProtoType;
        PrimitiveNode.Function function = this.getFunction();
        if (function != (noFunc = no.getFunction())) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "':" + function.getName() + " v/s " + noFunc.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = np.getTechnology().getShapeOfNode(this);
        if (polyList.length != (noPolyList = noNp.getTechnology().getShapeOfNode(no)).length) {
            if (buffer != null) {
                buffer.append("Not same number of geometries in '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        ArrayList<Object> noCheckAgain = new ArrayList<Object>();
        for (int i2 = 0; i2 < polyList.length; ++i2) {
            found = false;
            for (int j = 0; j < noPolyList.length; ++j) {
                if (noCheckAgain.contains(noPolyList[j]) || !polyList[i2].compare(noPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(noPolyList[j]);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding geometry in '" + this.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        Iterator<Serializable> it = this.getPortInsts();
        while (it.hasNext()) {
            found = false;
            PortInst port = it.next();
            i = no.getPortInsts();
            while (i.hasNext()) {
                p = i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            return false;
        }
        noCheckAgain.clear();
        it = this.getExports();
        while (it.hasNext()) {
            Export export = (Export)it.next();
            boolean found2 = false;
            i = no.getExports();
            while (i.hasNext()) {
                p = (Export)i.next();
                if (noCheckAgain.contains(p) || !export.compare(p, buffer)) continue;
                found2 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding export '" + export.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        Iterator<Variable> it1 = this.getVariables();
        Iterator<Variable> it2 = no.getVariables();
        while (it1.hasNext() || it2.hasNext()) {
            Variable param2;
            if (!it1.hasNext() || !it2.hasNext()) {
                if (buffer != null) {
                    buffer.append("Different number of variables found in '" + no.getName() + "'\n");
                }
                return false;
            }
            Variable param1 = it1.next();
            if (param1.compare(param2 = it2.next(), buffer)) continue;
            if (buffer != null) {
                buffer.append("No corresponding parameter '" + param1 + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found3 = false;
            i = no.getVariables();
            while (i.hasNext()) {
                p = (Variable)i.next();
                if (noCheckAgain.contains(p) || !var.compare(p, buffer)) continue;
                found3 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found3) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + var + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionIterator
    implements Iterator<Connection> {
        private final List<ImmutableArcInst> arcs;
        private final BitSet headEnds = new BitSet();
        int i;
        Connection nextConn;

        ConnectionIterator(CellBackup.Memoization m, ImmutableNodeInst d) {
            this.arcs = m.getConnections(this.headEnds, d, null);
            this.findNext();
        }

        ConnectionIterator(CellBackup.Memoization m, ImmutableNodeInst d, PortProtoId portId) {
            this.arcs = m.getConnections(this.headEnds, d, portId);
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextConn != null;
        }

        @Override
        public Connection next() {
            if (this.nextConn == null) {
                throw new NoSuchElementException();
            }
            Connection con = this.nextConn;
            this.findNext();
            return con;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.i < this.arcs.size()) {
                ArcInst ai = NodeInst.this.topology.cell.getArcById(this.arcs.get((int)this.i).arcId);
                if (ai != null) {
                    this.nextConn = this.headEnds.get(this.i) ? ai.getHead() : ai.getTail();
                    ++this.i;
                    return;
                }
                ++this.i;
            }
            this.nextConn = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportIterator
    implements Iterator<Export> {
        private final Iterator<ImmutableExport> it;

        ExportIterator(Iterator<ImmutableExport> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Export next() {
            return NodeInst.this.topology.cell.getExportChron(this.it.next().exportId.chronIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeInstKey
    extends EObjectInputStream.Key<NodeInst> {
        public NodeInstKey() {
        }

        private NodeInstKey(NodeInst ni) {
            super(ni);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, NodeInst ni) throws IOException {
            if (ni.getDatabase() != out.getDatabase() || !ni.isLinked()) {
                throw new NotSerializableException(ni + " not linked");
            }
            out.writeObject(ni.topology.cell);
            out.writeInt(ni.getD().nodeId);
        }

        @Override
        public NodeInst readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int nodeId;
            Cell cell = (Cell)in.readObject();
            NodeInst ni = cell.getNodeById(nodeId = in.readInt());
            if (ni == null) {
                throw new InvalidObjectException("NodeInst from " + cell);
            }
            return ni;
        }
    }

    private static class PortAssociation {
        PortInst portInst;
        Poly poly;
        Point2D pos;
        PortInst assn;

        private PortAssociation() {
        }
    }
}

