/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2_star_en {
    private static final double wellOverhangDiff = 6.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double wirePitch = 7.0;
    private static final double wireWithPolyPitch = 8.0;
    private static final double pmosBot = 8.5;
    private static final double nmosTop = -8.5;
    private static final double inbY = 4.0;
    private static final double inaY = -4.0;
    private static final double pmosPitch = 26.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        int i3;
        TechType tech = stdCell.getTechType();
        Nand2_star_en.error(!threshold.equals("") && !threshold.equals("LT") && !threshold.equals("HT"), "Nand2_star_en: threshold not \"\", \"LT\", or \"HT\": " + threshold);
        String nm = "nand2" + threshold + "en";
        sz = stdCell.roundSize(sz);
        sz = stdCell.checkMinStrength(sz, threshold.equals("LT") ? 1.0 : 0.5, nm);
        int nbSeriesN = 2;
        double spaceAvail = -8.5 - (stdCell.getCellBot() + 6.0);
        double totWid = sz * (double)nbSeriesN * 3.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2_star_en.error(fwN == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = stdCell.getCellTop() - 6.0 - 8.5;
        totWid = sz * 6.0;
        if (threshold.equals("HT")) {
            totWid *= 2.0;
        } else if (threshold.equals("LT")) {
            totWid /= 2.0;
        }
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2_star_en.error(fwP == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(totWid / 10.0, 5.0);
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2_star_en.error(fwW == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double nmosX = inbX + 7.0;
        double nmosY = -8.5 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, nbSeriesN, fwN.gateWid, nand, tech);
        double pmosX = nmosX + 5.0;
        double pmosY = 8.5 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(fwP.nbFolds + 1) / 2];
        for (int nbFoldsP = 0; nbFoldsP < fwP.nbFolds; nbFoldsP += 2) {
            double x = pmosX + (double)(nbFoldsP / 2) * 26.0;
            int nbFolds = Math.min(2, fwP.nbFolds - nbFoldsP);
            FoldedPmos pmos = new FoldedPmos(x, pmosY, nbFolds, 1, fwP.gateWid, nand, tech);
            pmoss[nbFoldsP / 2] = pmos;
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        double rightPdiffX = StdCellParams.getRightDiffX(pmoss);
        double rightNdiffX = StdCellParams.getRightDiffX(nmos);
        double weakX = Math.max(rightPdiffX + 11.0, rightNdiffX + 2.5);
        double weakY = 8.5 + fwW.physWid / 2.0;
        FoldedPmos weak = new FoldedPmos(weakX, weakY, fwW.nbFolds, 1, fwW.gateWid, nand, tech);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        FoldedMos[] allPmoss = new FoldedMos[pmoss.length + 1];
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            allPmoss[i4] = pmoss[i4];
        }
        allPmoss[pmoss.length] = weak;
        stdCell.wireVddGnd(allPmoss, StdCellParams.EVEN, nand);
        FoldedMos[] tmp = new FoldedMos[]{pmoss[pmoss.length - 1], weak};
        stdCell.fillDiffAndSelectNotches(tmp, false);
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, nand);
        inb.connect(nand.findExport("inb"));
        for (i3 = 0; i3 < pmoss.length; ++i3) {
            FoldedMos pmos = pmoss[i3];
            ((TrackRouter)inb).connect(pmos.getGate(0, 'B'), 4.0, tech.getPolyLShapeOffset());
            if (pmos.nbGates() != 2) continue;
            ((TrackRouter)inb).connect(pmos.getGate(1, 'B'), -4.0, tech.getPolyLShapeOffset());
        }
        for (i3 = 0; i3 < nmos.nbGates(); i3 += 2) {
            if (i3 / 2 % 2 == 0) {
                ((TrackRouter)inb).connect(nmos.getGate(i3 + 1, 'T'), 4.0, -tech.getPolyTShapeOffset());
                continue;
            }
            ((TrackRouter)inb).connect(nmos.getGate(i3, 'T'), -4.0, -tech.getPolyTShapeOffset());
        }
        double rightDiffX = StdCellParams.getRightDiffX(weak, weak);
        double inaX = rightDiffX + 7.0;
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        TrackRouterH ina = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nand);
        ina.connect(nand.findExport("ina"));
        for (i2 = 0; i2 < weak.nbGates(); ++i2) {
            ((TrackRouter)ina).connect(weak.getGate(i2, 'B'), 1.5, tech.getPolyLShapeOffset());
        }
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                ((TrackRouter)ina).connect(nmos.getGate(i2, 'T'), -4.0, -tech.getPolyLShapeOffset());
                continue;
            }
            ((TrackRouter)ina).connect(nmos.getGate(i2 + 1, 'T'), 4.0, -tech.getPolyLShapeOffset());
        }
        double outX = inaX + 7.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, nand);
        outHi.connect(nand.findExport("out"));
        for (i = 0; i < pmoss.length; ++i) {
            outHi.connect(pmoss[i].getSrcDrn(1));
        }
        for (i = 1; i < weak.nbSrcDrns(); i += 2) {
            outHi.connect(weak.getSrcDrn(i));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nand);
        outLo.connect(nand.findExport("out"));
        for (int i5 = 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

