/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.SelectObject;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.EditWindowFocusBrowser;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.LayerTab;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.PrintService;
import javax.print.attribute.standard.ColorSupported;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.MutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditWindow
extends JPanel
implements EditWindow_,
WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
HighlightListener,
DatabaseChangeListener {
    private double scale;
    private double scale_;
    private double factorX;
    private double factorY;
    private double scaleRequested;
    private double globalTextScale;
    private String defaultFont;
    private double offx = 0.0;
    private double offy = 0.0;
    private double offxRequested;
    private double offyRequested;
    private Dimension sz;
    private AbstractDrawing drawing;
    private int szHalfWidth;
    private int szHalfHeight;
    private Cell cell;
    private int pageNumber;
    private List<GetInfoText.EditInPlaceListener> inPlaceTextObjects = new ArrayList<GetInfoText.EditInPlaceListener>();
    private boolean inPlaceDisplay;
    private AffineTransform intoCell = new AffineTransform();
    private AffineTransform outofCell = new AffineTransform();
    private List<NodeInst> inPlaceDescent = new ArrayList<NodeInst>();
    volatile boolean repaintRequest;
    private Rectangle2D fullInstantiateBounds;
    private VarContext cellVarContext;
    private WindowFrame wf;
    private JPanel overall;
    private JScrollBar bottomScrollBar;
    private JScrollBar rightScrollBar;
    private boolean showGrid = false;
    private boolean showGridWarning = false;
    private double gridXSpacing;
    private double gridYSpacing;
    private boolean doingAreaDrag = false;
    private Point startDrag = new Point();
    private Point endDrag = new Point();
    private boolean showPopupCloud = false;
    private LayerVisibility lv = LayerVisibility.getLayerVisibility();
    private Highlighter highlighter;
    private Highlighter mouseOverHighlighter;
    private Highlighter rulerHighlighter;
    private RTNode textInCell;
    private EditWindowFocusBrowser viewBrowser;
    private static Object lock = new Object();
    private static RenderJob runningNow = null;
    private static Logger logger = Logger.getLogger("com.sun.electric.tool.user.ui");
    private static String CLASS_NAME = EditWindow.class.getName();
    private Timer pulsatingTimer;
    private boolean dirty;
    private static final int SCROLLBARRESOLUTION = 200;
    private static final BasicStroke selectionLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 3.0f);
    private static final BasicStroke inPlaceMarker = new BasicStroke(2.0f);
    private static EditWindowDropTarget editWindowDropTarget = new EditWindowDropTarget();
    private int lastXPosition;
    private int lastYPosition;
    private static final String RENDER_JOB_CLASS_NAME = CLASS_NAME + ".RenderJob";
    private List<CrossProbe> crossProbeObjects = new ArrayList<CrossProbe>();
    private StringSearch textSearch = new StringSearch();
    private static final double scrollPagePercent = 0.2;
    private boolean ignoreScrollChange = false;
    private static final int scrollRangeMult = 100;

    private EditWindow(Cell cell, WindowFrame wf, Dimension approxSZ) {
        this.cell = cell;
        this.pageNumber = 0;
        this.wf = wf;
        this.setDrawingAlgorithm();
        this.gridXSpacing = User.getDefGridXSpacing();
        this.gridYSpacing = User.getDefGridYSpacing();
        this.inPlaceDisplay = false;
        this.viewBrowser = new EditWindowFocusBrowser(this);
        this.sz = approxSZ;
        if (this.sz == null) {
            this.sz = new Dimension(500, 500);
        }
        this.szHalfWidth = this.sz.width / 2;
        this.szHalfHeight = this.sz.height / 2;
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.scaleRequested = 1.0;
        this.scale = 1.0;
        this.scale_ = (float)(this.scale / 400.0);
        this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
        this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
        this.textInCell = null;
        this.globalTextScale = User.getGlobalTextScale();
        this.defaultFont = User.getDefaultFont();
        this.overall = new JPanel();
        this.overall.setLayout(new GridBagLayout());
        int thumbSize = 10;
        this.bottomScrollBar = new JScrollBar(0, 100, thumbSize, 0, 200 + thumbSize);
        this.bottomScrollBar.setBlockIncrement(40);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.overall.add((Component)this.bottomScrollBar, gbc);
        this.bottomScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.bottomScrollBar.setValue(this.bottomScrollBar.getMaximum() / 2);
        this.rightScrollBar = new JScrollBar(1, 100, thumbSize, 0, 200 + thumbSize);
        this.rightScrollBar.setBlockIncrement(40);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.overall.add((Component)this.rightScrollBar, gbc);
        this.rightScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.rightScrollBar.setValue(this.rightScrollBar.getMaximum() / 2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.overall.add((Component)this, gbc);
        this.setOpaque(true);
        this.setLayout(null);
        new DropTarget(this, 0x40000000, editWindowDropTarget, true);
        this.installHighlighters();
        this.pulsatingTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (User.isErrorHighlightingPulsate()) {
                    for (Highlight h : EditWindow.this.getHighlighter().getHighlights()) {
                        if (!h.isError) continue;
                        EditWindow.super.repaint();
                        return;
                    }
                }
            }
        });
        this.pulsatingTimer.start();
        if (wf != null) {
            UserInterfaceMain.addDatabaseChangeListener(this);
            Highlighter.addHighlightListener(this);
            this.setCell(cell, VarContext.globalContext, null);
        }
    }

    private void setDrawingAlgorithm() {
        this.drawing = AbstractDrawing.createDrawing(this, this.drawing, this.cell);
        LayerTab layerTab = this.getWindowFrame().getLayersTab();
        if (layerTab != null) {
            layerTab.setDisplayAlgorithm(this.drawing.hasOpacity());
        }
    }

    private void installHighlighters() {
        this.rulerHighlighter = null;
        this.mouseOverHighlighter = null;
        this.highlighter = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow oWnd;
            WindowFrame oWf = it.next();
            if (!(oWf.getContent() instanceof EditWindow) || (oWnd = (EditWindow)oWf.getContent()) == this || oWnd.getCell() != this.cell) continue;
            this.highlighter = oWnd.highlighter;
            this.mouseOverHighlighter = oWnd.mouseOverHighlighter;
            this.rulerHighlighter = oWnd.rulerHighlighter;
            break;
        }
        if (this.highlighter == null) {
            this.highlighter = new Highlighter(0, this.wf);
            this.mouseOverHighlighter = new Highlighter(1, this.wf);
            this.rulerHighlighter = new Highlighter(2, this.wf);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    private void uninstallHighlighters() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        boolean used = false;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow oWnd;
            WindowFrame oWf = it.next();
            if (!(oWf.getContent() instanceof EditWindow) || (oWnd = (EditWindow)oWf.getContent()) == this || oWnd.getCell() != this.cell) continue;
            used = true;
            break;
        }
        if (!used) {
            this.highlighter.delete();
            this.mouseOverHighlighter.delete();
            this.rulerHighlighter.delete();
        }
    }

    public static EditWindow CreateElectricDoc(Cell cell, WindowFrame wf, Dimension approxSZ) {
        EditWindow ui = new EditWindow(cell, wf, approxSZ);
        return ui;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        UserInterfaceMain.userCommandIssued();
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mousePressed(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseReleased(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseClicked(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseListener.mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseExited(evt);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseMoved(evt);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseDragged(evt);
    }

    private void showCoordinates(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            Technology tech = wnd.getCell().getTechnology();
            if (User.isShowHierarchicalCursorCoordinates()) {
                String path = null;
                if (this.cellVarContext != VarContext.globalContext) {
                    Point2D.Double ptPath = new Point2D.Double(pt.getX(), pt.getY());
                    boolean validPath = true;
                    boolean first = true;
                    Geometric ni = null;
                    path = "";
                    for (VarContext vc = this.cellVarContext; vc != VarContext.globalContext; vc = vc.pop()) {
                        Nodable no = vc.getNodable();
                        if (!(no instanceof NodeInst)) {
                            validPath = false;
                            break;
                        }
                        ni = (NodeInst)no;
                        path = ni.getParent().getName() + "[" + ((NodeInst)ni).getName() + "]" + (first ? "" : " / ") + path;
                        if (first) {
                            first = false;
                        }
                        AffineTransform trans = ((NodeInst)ni).translateOut(((NodeInst)ni).rotateOut());
                        trans.transform(ptPath, ptPath);
                    }
                    path = validPath ? (ni.getParent().isSchematic() ? "Location is " + ni.getParent() + " / " + path : "Location in " + ni.getParent() + " / " + path + " is (" + TextUtils.formatDistance(((Point2D)ptPath).getX(), tech) + ", " + TextUtils.formatDistance(((Point2D)ptPath).getY(), tech) + ")") : null;
                }
                StatusBar.setHierarchicalCoordinates(path, wnd.wf);
            }
            StatusBar.setCoordinates("(" + TextUtils.formatDistance(pt.getX(), tech) + ", " + TextUtils.formatDistance(pt.getY(), tech) + ")", wnd.wf);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.curMouseWheelListener.mouseWheelMoved(evt);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        UserInterfaceMain.userCommandIssued();
        WindowFrame.curKeyListener.keyPressed(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        WindowFrame.curKeyListener.keyReleased(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        WindowFrame.curKeyListener.keyTyped(evt);
    }

    @Override
    public void highlightChanged(Highlighter which) {
        this.repaint();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public Point getLastMousePosition() {
        return new Point(this.lastXPosition, this.lastYPosition);
    }

    private Cell whichCellInGroup(Cell.CellGroup group) {
        if (this.cell == null) {
            return null;
        }
        Iterator<Cell> it = group.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            View cV = c.getView();
            if (cV == View.DOC || !(cV == View.ICON ? this.cell.getView() == View.SCHEMATIC || this.cell.getView() == View.ICON : cV != View.SCHEMATIC && this.cell.getView() != View.SCHEMATIC && this.cell.getView() != View.ICON)) continue;
            return c;
        }
        return null;
    }

    public void showDraggedBox(Object toDraw, int oldx, int oldy, int rotation) {
        Highlighter highlighter = this.getHighlighter();
        highlighter.clear();
        Point2D drawnLoc = this.screenToDatabase(oldx, oldy);
        EditWindow.gridAlign(drawnLoc);
        NodeProto np = null;
        if (toDraw instanceof Cell.CellGroup) {
            np = this.whichCellInGroup((Cell.CellGroup)toDraw);
        }
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            np = ni.getProto();
        }
        if (toDraw instanceof NodeProto) {
            np = (NodeProto)toDraw;
        }
        int defAngle = 0;
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            defAngle = ni.getAngle();
        }
        if (toDraw instanceof PrimitiveNode) {
            defAngle = User.getNewNodeRotation();
        }
        if (np != null) {
            this.zoomWindowToFitCellInstance(np);
            Poly poly = null;
            Orientation orient = Orientation.fromJava(defAngle, defAngle >= 3600, false);
            if (np instanceof Cell) {
                NodeProto placeCell = np;
                ERectangle cellBounds = ((Cell)placeCell).getBounds();
                poly = new Poly(cellBounds);
                AffineTransform rotate = orient.pureRotate();
                AffineTransform translate = new AffineTransform();
                translate.setToTranslation(drawnLoc.getX(), drawnLoc.getY());
                rotate.preConcatenate(translate);
                poly.transform(rotate);
            } else {
                SizeOffset so = np.getProtoSizeOffset();
                double trueSizeX = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                double trueSizeY = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                double dX = (so.getHighXOffset() - so.getLowXOffset()) / 2.0;
                double dY = (so.getHighYOffset() - so.getLowYOffset()) / 2.0;
                poly = new Poly(drawnLoc.getX() - dX, drawnLoc.getY() - dY, trueSizeX, trueSizeY);
                AffineTransform trans = orient.rotateAbout(drawnLoc.getX(), drawnLoc.getY());
                poly.transform(trans);
            }
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                int last = i - 1;
                if (i == 0) {
                    last = points.length - 1;
                }
                highlighter.addLine(points[last], points[i], this.getCell());
            }
            if (rotation != 0) {
                highlighter.addMessage(this.cell, "Rotated " + rotation, poly.getCenter());
            }
            this.repaint();
        }
        highlighter.finished();
    }

    public void zoomWindowToFitCellInstance(NodeProto np) {
        NodeInst onlyNi;
        Cell parent = this.getCell();
        if (parent == null) {
            return;
        }
        boolean empty = true;
        if (parent.getNumArcs() > 0) {
            empty = false;
        }
        if (parent.getNumNodes() > 1) {
            empty = false;
        } else if (parent.getNumNodes() == 1 && (onlyNi = parent.getNode(0)).getProto() != Generic.tech().cellCenterNode) {
            empty = false;
        }
        if (empty && np instanceof Cell) {
            ERectangle cellBounds = ((Cell)np).getBounds();
            Rectangle2D screenBounds = this.displayableBounds();
            if (((RectangularShape)cellBounds).getWidth() > screenBounds.getWidth() || ((RectangularShape)cellBounds).getHeight() > screenBounds.getHeight()) {
                double scaleX = ((RectangularShape)cellBounds).getWidth() / (screenBounds.getWidth() * 0.9);
                double scaleY = ((RectangularShape)cellBounds).getHeight() / (screenBounds.getHeight() * 0.9);
                double scale = Math.max(scaleX, scaleY);
                this.setScale(this.getScale() / scale);
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.overall;
    }

    @Override
    public Point getScreenLocationOfCorner() {
        return this.overall.getLocationOnScreen();
    }

    public static EditWindow getCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        if (wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        return null;
    }

    public static EditWindow needCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null && wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        System.out.println("There is no current window for this operation");
        return null;
    }

    @Override
    public Cell getCell() {
        return this.cell;
    }

    public void setMultiPageNumber(int pageNumber) {
        if (this.pageNumber == pageNumber) {
            return;
        }
        this.pageNumber = pageNumber;
        this.setWindowTitle();
        this.fillScreen();
    }

    public int getMultiPageNumber() {
        return this.pageNumber;
    }

    public boolean isInPlaceEdit() {
        return this.inPlaceDisplay;
    }

    public Cell getInPlaceEditTopCell() {
        return this.inPlaceDisplay ? this.inPlaceDescent.get(0).getParent() : this.cell;
    }

    public List<NodeInst> getInPlaceEditNodePath() {
        return this.inPlaceDescent;
    }

    private void setInPlaceEditNodePath(WindowFrame.DisplayAttributes da) {
        this.inPlaceDescent = da.inPlaceDescent;
        this.intoCell = da.getIntoCellTransform();
        this.outofCell = da.getOutofCellTransform();
        this.inPlaceDisplay = !this.inPlaceDescent.isEmpty();
    }

    public AffineTransform getInPlaceTransformIn() {
        return this.intoCell;
    }

    public AffineTransform getInPlaceTransformOut() {
        return this.outofCell;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public Highlighter getMouseOverHighlighter() {
        return this.mouseOverHighlighter;
    }

    public Highlighter getRulerHighlighter() {
        return this.rulerHighlighter;
    }

    public RTNode getTextInCell() {
        return this.textInCell;
    }

    public void setTextInCell(RTNode tic) {
        this.textInCell = tic;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes displayAttributes) {
        if (context == null) {
            context = VarContext.globalContext;
        }
        boolean fillTheScreen = false;
        if (displayAttributes == null) {
            displayAttributes = new WindowFrame.DisplayAttributes(this.getScale(), this.getOffset().getX(), this.getOffset().getY(), new ArrayList<NodeInst>());
            fillTheScreen = true;
        }
        this.sz = this.getSize();
        this.szHalfWidth = this.sz.width / 2;
        this.szHalfHeight = this.sz.height / 2;
        this.showCell(cell, context, fillTheScreen, displayAttributes);
    }

    private void showCell(Cell cell, VarContext context, boolean fillTheScreen, WindowFrame.DisplayAttributes displayAttributes) {
        this.wf.saveCurrentCellHistoryState();
        this.uninstallHighlighters();
        this.cell = cell;
        this.textInCell = null;
        this.setInPlaceEditNodePath(displayAttributes);
        this.pageNumber = 0;
        this.cellVarContext = context;
        if (cell != null) {
            Library lib = cell.getLibrary();
            lib.setCurCell(cell);
        }
        this.setDrawingAlgorithm();
        this.installHighlighters();
        this.viewBrowser.clear();
        this.setWindowTitle();
        if (this.wf != null && cell != null && this.wf == WindowFrame.getCurrentWindowFrame(false)) {
            WindowFrame.autoTechnologySwitch(cell, this.wf);
        }
        if (fillTheScreen) {
            this.fillScreen();
        } else {
            this.setScale(displayAttributes.scale);
            this.setOffset(new Point2D.Double(displayAttributes.offX, displayAttributes.offY));
        }
        if (cell != null && User.isCheckCellDates()) {
            cell.checkCellDates();
        }
        this.clearCrossProbeLevels();
        StatusBar.updateStatusBar();
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "", this.pageNumber));
    }

    public static EditWindow findWindow(Cell cell) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || content.getCell() != cell) continue;
            return (EditWindow)content;
        }
        return null;
    }

    public static EditWindow showEditWindowForCell(Cell c, VarContext varC) {
        Iterator<WindowFrame> it2 = WindowFrame.getWindows();
        while (it2.hasNext()) {
            WindowFrame wf = it2.next();
            WindowContent content = wf.getContent();
            if (c != content.getCell() || !(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            if (varC != null && !varC.equals(wnd.getVarContext())) continue;
            WindowFrame.showFrame(wf);
            return wnd;
        }
        WindowFrame wf = WindowFrame.createEditWindow(c);
        EditWindow wnd = (EditWindow)wf.getContent();
        wnd.setCell(c, varC, null);
        return wnd;
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        return this.wf.loadDefaultExplorerTree();
    }

    @Override
    public void finished() {
        this.uninstallHighlighters();
        this.pulsatingTimer.stop();
        UserInterfaceMain.removeDatabaseChangeListener(this);
        Highlighter.removeHighlightListener(this);
    }

    public static int getScrollBarResolution() {
        return 200;
    }

    public JScrollBar getBottomScrollBar() {
        return this.bottomScrollBar;
    }

    public JScrollBar getRightScrollBar() {
        return this.rightScrollBar;
    }

    @Override
    public void repaint() {
        this.dirty = true;
        super.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        if (this.dirty) {
            this.dirty = false;
            this.paint(graphics);
        }
        this.highlighter.showHighlights(this, graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.wf == null) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.cell == null) {
            g.setColor(new Color(User.getColor(User.ColorPrefType.BACKGROUND)));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            String msg = "No cell in this window";
            Font f = new Font(User.getDefaultFont(), 1, 18);
            g.setFont(f);
            g.setColor(new Color(User.getColor(User.ColorPrefType.TEXT)));
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(msg, (this.getWidth() - g.getFontMetrics(f).stringWidth(msg)) / 2, this.getHeight() / 2);
            return;
        }
        logger.entering(CLASS_NAME, "paintComponent", this);
        if (!this.drawing.paintComponent(g, this.lv, this.getSize())) {
            this.fullRepaint();
            g.setColor(new Color(User.getColor(User.ColorPrefType.BACKGROUND)));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            logger.exiting(CLASS_NAME, "paintComponent", "resize and repaint");
            return;
        }
        logger.logp(Level.FINER, CLASS_NAME, "paintComponent", "offscreen is drawn");
        this.sz = this.getSize();
        this.szHalfWidth = this.sz.width / 2;
        this.szHalfHeight = this.sz.height / 2;
        if (this.scale != this.drawing.da.scale || this.offx != this.drawing.da.offX || this.offy != this.drawing.da.offY) {
            this.textInCell = null;
        }
        this.scale = this.drawing.da.scale;
        this.scale_ = (float)(this.scale / 400.0);
        this.offx = this.drawing.da.offX;
        this.offy = this.drawing.da.offY;
        this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
        this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
        this.setScrollPosition();
        Font f = new Font(User.getDefaultFont(), 0, (int)(10.0 * this.globalTextScale));
        g.setFont(f);
        this.showCrossProbeLevels(g);
        if (Job.getDebug()) {
            this.drawCellFrame(g);
            this.rulerHighlighter.showHighlights(this, g);
            this.mouseOverHighlighter.showHighlights(this, g);
            this.highlighter.showHighlights(this, g);
        }
        try {
            this.drawCellFrame(g);
            this.rulerHighlighter.showHighlights(this, g);
            this.mouseOverHighlighter.showHighlights(this, g);
            this.highlighter.showHighlights(this, g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.doingAreaDrag) {
            this.showDragBox(g);
        }
        if (this.showPopupCloud) {
            this.drawPopupCloud(g);
        }
        if (this.inPlaceDisplay) {
            ERectangle bounds = this.cell.getBounds();
            Point i1 = this.databaseToScreen(bounds.getMinX(), bounds.getMinY());
            Point i2 = this.databaseToScreen(bounds.getMinX(), ((RectangularShape)bounds).getMaxY());
            Point i3 = this.databaseToScreen(((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY());
            Point i4 = this.databaseToScreen(((RectangularShape)bounds).getMaxX(), bounds.getMinY());
            if (User.isDimUpperLevelWhenDownInPlace()) {
                Polygon innerPoly = new Polygon();
                innerPoly.addPoint(i1.x, i1.y);
                innerPoly.addPoint(i2.x, i2.y);
                innerPoly.addPoint(i3.x, i3.y);
                innerPoly.addPoint(i4.x, i4.y);
                Area outerArea = new Area(new Rectangle(0, 0, this.sz.width, this.sz.height));
                Area innerArea = new Area(innerPoly);
                outerArea.subtract(innerArea);
                g.setColor(new Color(128, 128, 128, 128));
                g.fill(outerArea);
            }
            g.setStroke(inPlaceMarker);
            g.setColor(new Color(User.getColor(User.ColorPrefType.DOWNINPLACEBORDER)));
            int lX = Math.min(Math.min(i1.x, i2.x), Math.min(i3.x, i4.x));
            int hX = Math.max(Math.max(i1.x, i2.x), Math.max(i3.x, i4.x));
            int lY = Math.min(Math.min(i1.y, i2.y), Math.min(i3.y, i4.y));
            int hY = Math.max(Math.max(i1.y, i2.y), Math.max(i3.y, i4.y));
            g.drawLine(lX - 1, lY - 1, lX - 1, hY + 1);
            g.drawLine(lX - 1, hY + 1, hX + 1, hY + 1);
            g.drawLine(hX + 1, hY + 1, hX + 1, lY - 1);
            g.drawLine(hX + 1, lY - 1, lX - 1, lY - 1);
        }
        logger.logp(Level.FINER, CLASS_NAME, "paintComponent", "overlays are drawn");
        if (this.scale != this.scaleRequested || this.offx != this.offxRequested || this.offy != this.offyRequested || !this.getSize().equals(this.sz)) {
            this.textInCell = null;
            this.fullRepaint();
        }
        logger.exiting(CLASS_NAME, "paintComponent");
    }

    public void addInPlaceTextObject(GetInfoText.EditInPlaceListener tl) {
        this.inPlaceTextObjects.add(tl);
        this.add(tl.getTextComponent());
    }

    public GetInfoText.EditInPlaceListener getInPlaceTextObject() {
        if (this.inPlaceTextObjects.size() == 0) {
            return null;
        }
        return this.inPlaceTextObjects.get(this.inPlaceTextObjects.size() - 1);
    }

    public void removeInPlaceTextObject(GetInfoText.EditInPlaceListener tl) {
        this.inPlaceTextObjects.remove(tl);
        this.remove(tl.getTextComponent());
    }

    public void removeAllInPlaceTextObjects() {
        ArrayList<GetInfoText.EditInPlaceListener> allTextObjects = new ArrayList<GetInfoText.EditInPlaceListener>();
        for (GetInfoText.EditInPlaceListener eip : this.inPlaceTextObjects) {
            allTextObjects.add(eip);
        }
        for (GetInfoText.EditInPlaceListener tl : allTextObjects) {
            tl.closeEditInPlace();
        }
    }

    public static void displayAlgorithmChanged() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.setDrawingAlgorithm();
            wnd.fullRepaint();
        }
    }

    public LayerVisibility getLayerVisibility() {
        return this.lv;
    }

    public void setLayerVisibility(LayerVisibility lv) {
        this.lv = lv;
        if (this.drawing.visibilityChanged()) {
            this.fullRepaint();
        } else {
            this.repaint();
        }
        this.wf.set3DLayerVisibility(lv);
    }

    public static void repaintAllContents() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.fullRepaint();
        }
    }

    public static void setLayerVisibilityAll(LayerVisibility lv) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.setLayerVisibility(lv);
        }
    }

    public static void repaintAll() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaint();
        }
    }

    @Override
    public void fullRepaint() {
        this.repaintContents(null, false);
    }

    @Override
    public void repaintContents(Rectangle2D bounds, boolean fullInstantiate) {
        this.repaintContents(bounds, fullInstantiate, new AbstractDrawing.DrawingPreferences(), UserInterfaceMain.getGraphicsPreferences());
    }

    public void repaintContents(Rectangle2D bounds, boolean fullInstantiate, AbstractDrawing.DrawingPreferences dp, GraphicsPreferences gp) {
        if (this.wf == null) {
            return;
        }
        if (this.cell == null) {
            this.repaint();
            return;
        }
        if (runningNow != null && this.repaintRequest && !fullInstantiate) {
            return;
        }
        logger.entering(CLASS_NAME, "repaintContents", bounds);
        if (fullInstantiate) {
            this.fullInstantiateBounds = bounds.getBounds2D();
            DBMath.transformRect(this.fullInstantiateBounds, this.outofCell);
        }
        EditWindow.invokeRenderJob(this, dp, gp);
        logger.exiting(CLASS_NAME, "repaintContents");
    }

    public static void invokeRenderJob() {
        EditWindow.invokeRenderJob(null, new AbstractDrawing.DrawingPreferences(), UserInterfaceMain.getGraphicsPreferences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeRenderJob(EditWindow wnd, AbstractDrawing.DrawingPreferences dp, GraphicsPreferences gp) {
        logger.entering(CLASS_NAME, "invokeRenderJob", wnd);
        Object object = lock;
        synchronized (object) {
            if (wnd != null) {
                wnd.drawing.abortRendering();
                wnd.repaintRequest = true;
            }
            if (runningNow != null) {
                EditWindow.runningNow.hasTasks = true;
                logger.exiting(CLASS_NAME, "invokeRenderJob running now");
                return;
            }
            runningNow = new RenderJob(gp, dp);
        }
        runningNow.startJob();
        logger.exiting(CLASS_NAME, "invokeRenderJob starting job");
    }

    public void testJogl() {
        this.drawing.testJogl();
    }

    void opacityChanged() {
        this.drawing.opacityChanged();
    }

    public void clearCrossProbeLevels() {
        this.crossProbeObjects.clear();
    }

    public boolean hasCrossProbeData() {
        return this.crossProbeObjects.size() > 0;
    }

    public void addCrossProbeLine(Point2D start, Point2D end, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = true;
        cp.start = start;
        cp.end = end;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    public void addCrossProbeBox(Rectangle2D box, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = false;
        cp.box = box;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    private void showCrossProbeLevels(Graphics g) {
        for (CrossProbe cp : this.crossProbeObjects) {
            Point pE;
            Point pS;
            g.setColor(cp.color);
            if (cp.isLine) {
                pS = this.databaseToScreen(cp.start);
                pE = this.databaseToScreen(cp.end);
                g.drawLine(pS.x, pS.y, pE.x, pE.y);
                continue;
            }
            pS = this.databaseToScreen(cp.box.getMinX(), cp.box.getMinY());
            pE = this.databaseToScreen(cp.box.getMaxX(), cp.box.getMaxY());
            int lX = Math.min(pS.x, pE.x);
            int lY = Math.min(pS.y, pE.y);
            int wid = Math.abs(pS.x - pE.x);
            int hei = Math.abs(pS.y - pE.y);
            g.fillRect(lX, lY, wid, hei);
        }
    }

    public boolean isDoingAreaDrag() {
        return this.doingAreaDrag;
    }

    public void setDoingAreaDrag() {
        this.doingAreaDrag = true;
    }

    public void clearDoingAreaDrag() {
        this.doingAreaDrag = false;
    }

    public Point getStartDrag() {
        return this.startDrag;
    }

    public void setStartDrag(int x, int y) {
        this.startDrag.setLocation(x, y);
    }

    public Point getEndDrag() {
        return this.endDrag;
    }

    public void setEndDrag(int x, int y) {
        this.endDrag.setLocation(x, y);
    }

    private void showDragBox(Graphics g) {
        int lX = (int)Math.min(this.startDrag.getX(), this.endDrag.getX());
        int hX = (int)Math.max(this.startDrag.getX(), this.endDrag.getX());
        int lY = (int)Math.min(this.startDrag.getY(), this.endDrag.getY());
        int hY = (int)Math.max(this.startDrag.getY(), this.endDrag.getY());
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(selectionLine);
        g.setColor(new Color(User.getColor(User.ColorPrefType.HIGHLIGHT)));
        g.drawLine(lX, lY, lX, hY);
        g.drawLine(lX, hY, hX, hY);
        g.drawLine(hX, hY, hX, lY);
        g.drawLine(hX, lY, lX, lY);
    }

    private void drawCellFrame(Graphics g) {
        DisplayedFrame df = new DisplayedFrame(this.cell, g, this);
        df.renderFrame();
    }

    public void setGrid(boolean showG) {
        this.showGrid = showG;
        this.showGridWarning = showG;
        this.fullRepaint();
    }

    @Override
    public boolean isGrid() {
        return this.showGrid;
    }

    public void printGridWarning() {
        if (this.showGridWarning) {
            System.out.println("Toggle grid is on but grid is not drawn due to the resolution");
            this.showGridWarning = false;
        }
    }

    @Override
    public double getGridXSpacing() {
        return this.gridXSpacing;
    }

    public void setGridXSpacing(double spacing) {
        this.gridXSpacing = spacing;
    }

    @Override
    public double getGridYSpacing() {
        return this.gridYSpacing;
    }

    public void setGridYSpacing(double spacing) {
        this.gridYSpacing = spacing;
    }

    public Rectangle2D displayableBounds() {
        Point2D low = this.screenToDatabase(0, 0);
        Point2D high = this.screenToDatabase(this.sz.width - 1, this.sz.height - 1);
        double lowX = Math.min(low.getX(), high.getX());
        double lowY = Math.min(low.getY(), high.getY());
        double sizeX = Math.abs(high.getX() - low.getX());
        double sizeY = Math.abs(high.getY() - low.getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, sizeX, sizeY);
        return bounds;
    }

    private static TextUtils.WhatToSearch get(Set whatToSearch, TextUtils.WhatToSearch what) {
        if (whatToSearch.contains((Object)what)) {
            return what;
        }
        return null;
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, boolean highlightedOnly) {
        this.textSearch.initTextSearch(this.cell, search, caseSensitive, regExp, whatToSearch, codeRestr, unitRestr, highlightedOnly, this);
    }

    private static String repeatChar(char c, int num) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static void printFind(StringsInCell sic) {
        String foundHdr = "Found  " + sic.key + ": ";
        String foundStr = sic.theLine;
        String highlightHdr = EditWindow.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlight = EditWindow.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + "\n" + highlightHdr + highlight);
    }

    @Override
    public boolean findNextText(boolean reverse) {
        return this.textSearch.findNextText(this.cell, this.highlighter, reverse);
    }

    @Override
    public void replaceText(String replace) {
        int pos = this.textSearch.currentFindPosition;
        if (pos < 0 || pos >= this.textSearch.foundInCell.size()) {
            return;
        }
        StringsInCell sic = (StringsInCell)this.textSearch.foundInCell.get(pos);
        if (sic.replaced) {
            return;
        }
        sic.replaced = true;
        new ReplaceTextJob(this, replace);
    }

    @Override
    public void replaceAllText(String replace) {
        for (int i = this.textSearch.foundInCell.size() - 1; i >= 0; --i) {
            StringsInCell sic = (StringsInCell)this.textSearch.foundInCell.get(i);
            if (!sic.replaced) continue;
            this.textSearch.foundInCell.remove(i);
        }
        for (StringsInCell sic : this.textSearch.foundInCell) {
            sic.replaced = true;
        }
        new ReplaceAllTextJob(this, replace);
    }

    private static void printChange(StringsInCell sic, String newString) {
        String foundHdr = "Change " + sic.key + ": ";
        String foundStr = sic.theLine;
        String replaceHdr = "  ->  ";
        String replaceStr = newString;
        String highlightHdr = EditWindow.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlightStr = EditWindow.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + replaceHdr + replaceStr + "\n" + highlightHdr + highlightStr);
    }

    public boolean getShowPopupCloud() {
        return this.showPopupCloud;
    }

    public void setShowPopupCloud(List<String> text, Point2D point) {
        this.showPopupCloud = true;
    }

    public void clearShowPopupCloud() {
        this.showPopupCloud = false;
    }

    private void drawPopupCloud(Graphics2D g) {
    }

    public Dimension getScreenSize() {
        return this.sz;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double getGlobalTextScale() {
        return this.globalTextScale;
    }

    @Override
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setGlobalTextScale(double gts) {
        this.globalTextScale = gts;
    }

    @Override
    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Negative window scale");
        }
        this.scaleRequested = scale;
        this.removeAllInPlaceTextObjects();
    }

    @Override
    public Point2D getOffset() {
        return new Point2D.Double(this.offx, this.offy);
    }

    public Point2D getScheduledOffset() {
        return new Point2D.Double(this.offxRequested, this.offyRequested);
    }

    @Override
    public void setOffset(Point2D off) {
        this.offxRequested = off.getX();
        this.offyRequested = off.getY();
        this.removeAllInPlaceTextObjects();
    }

    private void setScreenBounds(Rectangle2D bounds) {
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (width == 0.0) {
            width = 2.0;
        }
        if (height == 0.0) {
            height = 2.0;
        }
        double scalex = (double)this.sz.width / width * 0.9;
        double scaley = (double)this.sz.height / height * 0.9;
        this.setScale(Math.min(scalex, scaley));
        this.setOffset(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
    }

    @Override
    public Rectangle2D getDisplayedBounds() {
        double width = (double)this.sz.width / this.scale;
        double height = (double)this.sz.height / this.scale;
        return new Rectangle2D.Double(this.offx - width / 2.0, this.offy - height / 2.0, width, height);
    }

    public void setScrollPosition() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditWindow.this.setScrollPositionUnsafe();
                }
            });
        } else {
            this.setScrollPositionUnsafe();
        }
    }

    private void setScrollPositionUnsafe() {
        int max;
        int min;
        int extent;
        int value;
        if (this.bottomScrollBar == null || this.rightScrollBar == null) {
            return;
        }
        this.bottomScrollBar.setEnabled(this.cell != null);
        this.rightScrollBar.setEnabled(this.cell != null);
        if (this.cell == null) {
            return;
        }
        ERectangle cellBounds = this.getInPlaceEditTopCell().getBounds();
        if (cellBounds == null) {
            return;
        }
        Rectangle2D viewBounds = this.displayableBounds();
        this.ignoreScrollChange = true;
        double width = viewBounds.getWidth() < ((RectangularShape)cellBounds).getWidth() ? viewBounds.getWidth() : ((RectangularShape)cellBounds).getWidth();
        double height = viewBounds.getHeight() < ((RectangularShape)cellBounds).getHeight() ? viewBounds.getHeight() : ((RectangularShape)cellBounds).getHeight();
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oX = ((Point2D)dbPt).getX();
        double oY = ((Point2D)dbPt).getY();
        if (!this.bottomScrollBar.getValueIsAdjusting()) {
            value = (int)((oX - 0.5 * width) * 100.0);
            extent = (int)(width * 100.0);
            min = (int)((((RectangularShape)cellBounds).getX() - 0.2 * ((RectangularShape)cellBounds).getWidth()) * 100.0);
            max = (int)((((RectangularShape)cellBounds).getX() + ((RectangularShape)cellBounds).getWidth() + 0.2 * ((RectangularShape)cellBounds).getWidth()) * 100.0);
            this.bottomScrollBar.getModel().setRangeProperties(value, extent, min, max, false);
            this.bottomScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getWidth() * 100.0));
            this.bottomScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getWidth() * 100.0));
        }
        if (!this.rightScrollBar.getValueIsAdjusting()) {
            value = (int)((-oY - 0.5 * height) * 100.0);
            extent = (int)(height * 100.0);
            min = (int)(-(((RectangularShape)cellBounds).getY() + ((RectangularShape)cellBounds).getHeight() + 0.2 * ((RectangularShape)cellBounds).getHeight()) * 100.0);
            max = (int)(-(((RectangularShape)cellBounds).getY() - 0.2 * ((RectangularShape)cellBounds).getHeight()) * 100.0);
            this.rightScrollBar.getModel().setRangeProperties(value, extent, min, max, false);
            this.rightScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getHeight() * 100.0));
            this.rightScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getHeight() * 100.0));
        }
        this.ignoreScrollChange = false;
    }

    @Override
    public void bottomScrollChanged(int value) {
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oY = ((Point2D)dbPt).getY();
        double val = (double)value / 100.0;
        ERectangle cellBounds = this.getInPlaceEditTopCell().getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double width = viewBounds.getWidth() < ((RectangularShape)cellBounds).getWidth() ? viewBounds.getWidth() : ((RectangularShape)cellBounds).getWidth();
        double newoffx = val + 0.5 * width;
        Point2D.Double offset = new Point2D.Double(newoffx, oY);
        this.setOffset(offset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.fullRepaint();
    }

    @Override
    public void rightScrollChanged(int value) {
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oX = ((Point2D)dbPt).getX();
        double val = (double)value / 100.0;
        ERectangle cellBounds = this.getInPlaceEditTopCell().getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double height = viewBounds.getHeight() < ((RectangularShape)cellBounds).getHeight() ? viewBounds.getHeight() : ((RectangularShape)cellBounds).getHeight();
        double newoffy = -(val + 0.5 * height);
        Point2D.Double offset = new Point2D.Double(oX, newoffy);
        this.setOffset(offset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.fullRepaint();
    }

    public void focusScreen(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        if (this.inPlaceDisplay) {
            Point2D.Double llPt = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            Point2D.Double urPt = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
            this.outofCell.transform(llPt, llPt);
            this.outofCell.transform(urPt, urPt);
            double lX = Math.min(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double hX = Math.max(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double lY = Math.min(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            double hY = Math.max(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            bounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        }
        this.setScreenBounds(bounds);
        this.setScrollPosition();
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.fullRepaint();
    }

    @Override
    public Rectangle2D getBoundsInWindow() {
        Rectangle2D cellBounds = this.cell.getBounds();
        Dimension d = new Dimension();
        int frameFactor = Cell.FrameDescription.getCellFrameInfo(this.cell, d);
        Rectangle2D.Double frameBounds = new Rectangle2D.Double(-d.getWidth() / 2.0, -d.getHeight() / 2.0, d.getWidth(), d.getHeight());
        if (frameFactor == 0) {
            cellBounds = frameBounds;
            if (this.cell.isMultiPage()) {
                double offY = (double)this.pageNumber * 1000.0;
                cellBounds.setRect(cellBounds.getMinX(), cellBounds.getMinY() + offY, cellBounds.getWidth(), cellBounds.getHeight());
            }
        } else {
            if (cellBounds.getWidth() == 0.0 && cellBounds.getHeight() == 0.0) {
                int defaultCellSize = 60;
                cellBounds = new Rectangle2D.Double(cellBounds.getCenterX() - (double)(defaultCellSize / 2), cellBounds.getCenterY() - (double)(defaultCellSize / 2), defaultCellSize, defaultCellSize);
            }
            if (this.wf == null || runningNow == null) {
                double oldScale = this.getScale();
                Point2D oldOffset = this.getOffset();
                this.setScreenBounds(cellBounds);
                if (this.scale != this.scaleRequested) {
                    this.textInCell = null;
                }
                this.scale = this.scaleRequested;
                this.scale_ = (float)(this.scale / 400.0);
                this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
                this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
                Rectangle2D relativeTextBounds = this.cell.getRelativeTextBounds(this);
                if (relativeTextBounds != null) {
                    Rectangle2D.Double newCellBounds = new Rectangle2D.Double();
                    Rectangle2D.union(relativeTextBounds, cellBounds, newCellBounds);
                    for (int i = 0; i < 2; ++i) {
                        this.setScreenBounds(newCellBounds);
                        if (this.scale != this.scaleRequested) {
                            this.textInCell = null;
                        }
                        this.scale = this.scaleRequested;
                        this.scale_ = (float)(this.scale / 400.0);
                        this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
                        this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
                        relativeTextBounds = this.cell.getRelativeTextBounds(this);
                        if (relativeTextBounds == null) continue;
                        Rectangle2D.union(relativeTextBounds, cellBounds, newCellBounds);
                    }
                    cellBounds = newCellBounds;
                }
                this.setScale(oldScale);
                this.setOffset(oldOffset);
            }
            if (frameFactor == 1) {
                Rectangle2D.union(frameBounds, cellBounds, frameBounds);
                cellBounds = frameBounds;
            }
        }
        return cellBounds;
    }

    @Override
    public void addElectricObject(ElectricObject eObj, Cell cell) {
        this.highlighter.addElectricObject(eObj, cell);
    }

    @Override
    public Rectangle2D getHighlightedArea() {
        return this.highlighter.getHighlightedArea(this);
    }

    @Override
    public void addHighlightArea(Rectangle2D rect, Cell cell) {
        this.highlighter.addArea(rect, cell);
    }

    @Override
    public void addHighlightLine(Point2D pt1, Point2D pt2, Cell cell, boolean thick, boolean isError) {
        this.highlighter.addLine(pt1, pt2, cell, thick, isError);
    }

    @Override
    public void addHighlightMessage(Cell cell, String message, Point2D loc) {
        this.highlighter.addMessage(cell, message, loc);
    }

    @Override
    public void addHighlightText(ElectricObject eObj, Cell cell, Variable.Key varKey) {
        this.highlighter.addText(eObj, cell, varKey);
    }

    @Override
    public ElectricObject getOneElectricObject(Class clz) {
        return this.highlighter.getOneElectricObject(clz);
    }

    @Override
    public List<Geometric> getHighlightedEObjs(boolean wantNodes, boolean wantArcs) {
        return this.highlighter.getHighlightedEObjs(wantNodes, wantArcs);
    }

    @Override
    public Set<Network> getHighlightedNetworks() {
        return this.highlighter.getHighlightedNetworks();
    }

    @Override
    public Point2D getHighlightOffset() {
        return this.highlighter.getHighlightOffset();
    }

    @Override
    public void setHighlightOffset(int dX, int dY) {
        this.highlighter.setHighlightOffset(dX, dY);
    }

    @Override
    public List<Highlight> saveHighlightList() {
        ArrayList<Highlight> saveList = new ArrayList<Highlight>();
        for (Highlight h : this.highlighter.getHighlights()) {
            saveList.add(h);
        }
        return saveList;
    }

    @Override
    public void restoreHighlightList(List<Highlight> list) {
        this.highlighter.setHighlightListGeneral(list);
    }

    @Override
    public void clearHighlighting() {
        this.highlighter.clear();
    }

    @Override
    public void finishedHighlighting() {
        this.highlighter.finished();
    }

    @Override
    public void fillScreen() {
        if (this.cell != null && !this.cell.getView().isTextView()) {
            Rectangle2D cellBounds = this.getBoundsInWindow();
            this.focusScreen(cellBounds);
            return;
        }
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.repaint();
    }

    @Override
    public void zoomOutContents() {
        double scale = this.getScale();
        this.setScale(scale / 2.0);
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.fullRepaint();
    }

    @Override
    public void zoomInContents() {
        double scale = this.getScale();
        this.setScale(scale * 2.0);
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.fullRepaint();
    }

    @Override
    public void focusOnHighlighted() {
        Rectangle2D bounds = this.highlighter.getHighlightedArea(this);
        this.focusScreen(bounds);
    }

    public EditWindowFocusBrowser getSavedFocusBrowser() {
        return this.viewBrowser;
    }

    @Override
    public VarContext getVarContext() {
        return this.cellVarContext;
    }

    public void downHierarchy(boolean keepFocus, boolean newWindow, boolean inPlace) {
        Export schExport;
        boolean promptUser;
        Highlight h = this.highlighter.getOneHighlight();
        if (h == null) {
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        NodeInst ni = null;
        PortInst pi = null;
        if (eobj instanceof NodeInst) {
            ni = (NodeInst)eobj;
        }
        if (eobj instanceof PortInst) {
            pi = (PortInst)eobj;
            ni = pi.getNodeInst();
        }
        if (ni == null) {
            System.out.println("Must select a Node to descend into");
            return;
        }
        if (!ni.isCellInstance()) {
            System.out.println("Can only descend into cell instances");
            return;
        }
        Cell cell = (Cell)ni.getProto();
        Cell schCell = cell.getEquivalent();
        if (this.cell == schCell) {
            schCell = cell;
        }
        if (schCell == null) {
            schCell = cell;
        }
        if (inPlace) {
            schCell = cell;
        }
        double offX = this.offx;
        double offY = this.offy;
        if (keepFocus) {
            offX -= ni.getAnchorCenterX();
            offY -= ni.getAnchorCenterY();
        }
        ArrayList<NodeInst> newInPlaceDescent = new ArrayList<NodeInst>();
        if (inPlace) {
            newInPlaceDescent.addAll(this.inPlaceDescent);
            newInPlaceDescent.add(ni);
        }
        WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(this.scale, offX, offY, newInPlaceDescent);
        Nodable desiredNO = null;
        ArrayList<Nodable> possibleNodables = new ArrayList<Nodable>();
        Netlist nl = ni.getParent().getNetlist();
        if (nl == null) {
            System.out.println("Netlist is not ready");
            return;
        }
        Iterator<Nodable> it = nl.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getNodeInst() != ni) continue;
            possibleNodables.add(no);
        }
        if (possibleNodables.size() > 1 && (promptUser = EditWindow.isArrayedContextMatter(desiredNO = (Nodable)possibleNodables.get(0)))) {
            Object[] manyOptions = new String[possibleNodables.size()];
            int i = 0;
            for (Nodable no : possibleNodables) {
                manyOptions[i++] = no.getName();
            }
            String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Descend into which node?", "Choose a Node", 3, null, manyOptions, manyOptions[0]);
            if (chosen == null) {
                return;
            }
            for (Nodable no : possibleNodables) {
                if (!no.getName().equals(chosen)) continue;
                desiredNO = no;
                break;
            }
        }
        boolean redisplay = true;
        if (inPlace) {
            redisplay = false;
        }
        if (keepFocus) {
            redisplay = false;
        }
        EditWindow newWND = this;
        if (newWindow) {
            WindowFrame newWF = WindowFrame.createEditWindow(schCell);
            newWND = (EditWindow)newWF.getContent();
        } else {
            SelectObject.selectObjectDialog(schCell, true);
        }
        VarContext vc = desiredNO != null ? this.cellVarContext.push(desiredNO) : this.cellVarContext.push(ni);
        newWND.showCell(schCell, vc, redisplay, da);
        newWND.getWindowFrame().addToHistory(schCell, vc, da);
        if (!redisplay) {
            this.fullRepaint();
        }
        EditWindow.clearSubCellCache();
        if (pi != null && (schExport = schCell.findExport(pi.getPortProto().getName())) != null) {
            PortInst origPort = schExport.getOriginalPort();
            newWND.highlighter.addElectricObject(origPort, schCell);
            newWND.highlighter.finished();
        }
    }

    public static boolean isArrayedContextMatter(Nodable no) {
        if (User.isPromptForIndexWhenDescending()) {
            return true;
        }
        Iterator<Object> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof WaveformWindow)) continue;
            return true;
        }
        it = no.getDefinedParameters();
        while (it.hasNext()) {
            String str;
            Variable var = (Variable)it.next();
            Object obj = var.getObject();
            if (!(obj instanceof CodeExpression) || !(str = obj.toString()).matches(".*LE\\.getdrive.*")) continue;
            return true;
        }
        return false;
    }

    public void upHierarchy(boolean keepFocus) {
        if (this.cell == null) {
            return;
        }
        Cell oldCell = this.cell;
        if (this.inPlaceDisplay) {
            keepFocus = true;
        }
        Export selectedExport = null;
        Set<Network> nets = this.highlighter.getHighlightedNetworks();
        for (Network net : nets) {
            Iterator<Export> eIt = net.getExports();
            if (eIt.hasNext()) {
                Export e;
                selectedExport = e = eIt.next();
            }
            if (selectedExport == null) continue;
            break;
        }
        try {
            NodeInst ni;
            Iterator<NodeInst> it;
            Cell schCell;
            Cell parent;
            Nodable no = this.cellVarContext.getNodable();
            if (no != null && no.getNodeInst().isLinked()) {
                VarContext context;
                int historyIndex;
                NodeInst ni2 = no.getNodeInst();
                if (selectedExport != null && selectedExport.getParent() != ni2.getProto()) {
                    selectedExport = ni2.isCellInstance() && selectedExport.getParent() == ((Cell)ni2.getProto()).getEquivalent() ? selectedExport.getEquivalentPort((Cell)ni2.getProto()) : null;
                }
                if ((historyIndex = this.wf.findCellHistoryIndex(parent = no.getParent(), context = this.cellVarContext.pop())) >= 0) {
                    WindowFrame.CellHistory foundHistory = this.wf.getCellHistoryList().get(historyIndex);
                    foundHistory.setContext(context);
                    if (selectedExport != null) {
                        foundHistory.setSelPort(ni2.findPortInstFromProto(selectedExport));
                    }
                    if (keepFocus) {
                        double newX = this.offx;
                        double newY = this.offy;
                        if (!this.inPlaceDisplay) {
                            Point2D.Double curCtr = new Point2D.Double(this.offx, this.offy);
                            AffineTransform up = ni2.rotateOut(no.getNodeInst().translateOut());
                            up.transform(curCtr, curCtr);
                            newX = ((Point2D)curCtr).getX();
                            newY = ((Point2D)curCtr).getY();
                        }
                        List<NodeInst> oldInPlaceDescent = foundHistory.getDisplayAttributes().inPlaceDescent;
                        foundHistory.setDisplayAttributes(new WindowFrame.DisplayAttributes(this.scale, newX, newY, oldInPlaceDescent));
                    }
                    this.wf.setCellByHistory(historyIndex);
                } else {
                    ArrayList<NodeInst> newInPlaceDescent = new ArrayList<NodeInst>(this.inPlaceDescent);
                    if (!newInPlaceDescent.isEmpty()) {
                        newInPlaceDescent.remove(newInPlaceDescent.size() - 1);
                    }
                    double newX = this.offx;
                    double newY = this.offy;
                    if (keepFocus) {
                        Point2D.Double curCtr = new Point2D.Double(this.offx, this.offy);
                        AffineTransform up = ni2.rotateOut(ni2.translateOut());
                        up.transform(curCtr, curCtr);
                        newX = ((Point2D)curCtr).getX();
                        newY = ((Point2D)curCtr).getY();
                    }
                    WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(this.scale, newX, newY, newInPlaceDescent);
                    this.showCell(parent, context, true, da);
                    this.wf.addToHistory(parent, context, da);
                    PortInst pi = null;
                    if (selectedExport != null) {
                        pi = ni2.findPortInstFromProto(selectedExport);
                    }
                    if (pi != null) {
                        this.highlighter.addElectricObject(pi, parent);
                    } else {
                        this.highlighter.addElectricObject(ni2, parent);
                    }
                }
                EditWindow.clearSubCellCache();
                SelectObject.selectObjectDialog(parent, true);
                return;
            }
            if (this.cell.isIcon() && (schCell = this.cell.getEquivalent()) != null) {
                WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(this.getScale(), this.getOffset().getX(), this.getOffset().getY(), new ArrayList<NodeInst>());
                this.wf.addToHistory(schCell, VarContext.globalContext, da);
                this.setCell(schCell, VarContext.globalContext, null);
                SelectObject.selectObjectDialog(schCell, true);
                return;
            }
            HashSet<Cell> found = new HashSet<Cell>();
            Iterator<NodeInst> it2 = this.cell.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni3 = it2.next();
                Cell parent2 = ni3.getParent();
                if (parent2.getLibrary().isHidden()) continue;
                found.add(parent2);
            }
            if (this.cell.isSchematic()) {
                Iterator<Cell> cIt = this.cell.getCellGroup().getCells();
                while (cIt.hasNext()) {
                    Cell iconView = cIt.next();
                    if (iconView.getView() != View.ICON) continue;
                    it = iconView.getInstancesOf();
                    while (it.hasNext()) {
                        Cell parent3;
                        ni = it.next();
                        if (ni.isIconOfParent() || (parent3 = ni.getParent()).getLibrary().isHidden()) continue;
                        found.add(parent3);
                    }
                }
            }
            if (found.size() == 0) {
                System.out.println("Not in any cells");
            } else if (found.size() == 1) {
                parent = (Cell)found.iterator().next();
                NodeInst theOne = null;
                it = parent.getNodes();
                while (it.hasNext()) {
                    Cell nodeCell;
                    ni = it.next();
                    if (!ni.isCellInstance() || (nodeCell = (Cell)ni.getProto()) != oldCell && !nodeCell.isIconOf(oldCell)) continue;
                    theOne = ni;
                    break;
                }
                double newX = this.offx;
                double newY = this.offy;
                if (keepFocus) {
                    Point2D.Double curCtr = new Point2D.Double(this.offx, this.offy);
                    AffineTransform up = theOne.rotateOut(theOne.translateOut());
                    up.transform(curCtr, curCtr);
                    newX = ((Point2D)curCtr).getX();
                    newY = ((Point2D)curCtr).getY();
                }
                WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(this.getScale(), newX, newY, new ArrayList<NodeInst>());
                this.wf.addToHistory(parent, VarContext.globalContext, da);
                this.setCell(parent, VarContext.globalContext, da);
                if (!keepFocus) {
                    this.fillScreen();
                }
                if (theOne != null) {
                    if (selectedExport != null) {
                        this.highlighter.addElectricObject(theOne.findPortInstFromProto(selectedExport), parent);
                    } else {
                        this.highlighter.addElectricObject(theOne, parent);
                    }
                    this.highlighter.finished();
                }
                SelectObject.selectObjectDialog(parent, true);
            } else {
                JPopupMenu parents = new JPopupMenu("parents");
                for (Cell parent2 : found) {
                    String cellName = parent2.describe(false);
                    JMenuItem menuItem = new JMenuItem(cellName);
                    menuItem.addActionListener(new UpHierarchyPopupListener(keepFocus));
                    parents.add(menuItem);
                }
                parents.show(this.overall, 0, 0);
            }
        }
        catch (NullPointerException e) {
            ActivityLogger.logException(e);
        }
    }

    public static void clearSubCellCache() {
        AbstractDrawing.clearSubCellCache(true);
    }

    private static void endBatch(AbstractDrawing.DrawingPreferences dp, GraphicsPreferences gp) {
        HashSet<CellId> topCells = new HashSet<CellId>();
        Iterator<WindowFrame> wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (winCell = content.getCell()) == null || !winCell.isLinked()) continue;
            topCells.add(winCell.getId());
        }
        Set<CellId> changedVisibility = VectorCache.theCache.forceRedrawAfterChange(topCells);
        for (CellId cellId : changedVisibility) {
            Cell cell = VectorCache.theCache.database.getCell(cellId);
            EditWindow.forceRedraw(cell);
        }
        Iterator<WindowFrame> wit2 = WindowFrame.getWindows();
        while (wit2.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit2.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (winCell = content.getCell()) == null) continue;
            EditWindow wnd = (EditWindow)content;
            if (!changedVisibility.contains(winCell.getId())) continue;
            wnd.repaintContents(null, false, dp, gp);
        }
    }

    public static void expansionChanged(Cell cell) {
        if (User.getDisplayAlgorithm() != 0) {
            return;
        }
        HashSet<Cell> marked = new HashSet<Cell>();
        EditWindow.markCellForRedrawRecursively(cell, marked);
        Iterator<WindowFrame> wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || !marked.contains(winCell = content.getCell())) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.fullRepaint();
        }
    }

    private static void markCellForRedrawRecursively(Cell cell, Set<Cell> marked) {
        if (marked.contains(cell)) {
            return;
        }
        marked.add(cell);
        Iterator<NodeInst> it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isExpanded()) continue;
            EditWindow.markCellForRedrawRecursively(ni.getParent(), marked);
        }
    }

    private static void forceRedraw(Cell cell) {
        AbstractDrawing.forceRedraw(cell);
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = (double)(screenX - this.szHalfWidth) / this.scale + this.offx;
        double dbY = (double)(this.szHalfHeight - screenY) / this.scale + this.offy;
        Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
        if (this.inPlaceDisplay) {
            this.intoCell.transform(dbPt, dbPt);
        }
        return dbPt;
    }

    public Rectangle2D screenToDatabase(Rectangle2D screenRect) {
        Point2D anchor = this.screenToDatabase((int)screenRect.getX(), (int)screenRect.getY());
        Point2D size = this.deltaScreenToDatabase((int)screenRect.getWidth(), (int)screenRect.getHeight());
        return new Rectangle2D.Double(anchor.getX(), anchor.getY() + size.getY(), size.getX(), -size.getY());
    }

    public Point2D deltaScreenToDatabase(int screenDX, int screenDY) {
        Point2D origin = this.screenToDatabase(0, 0);
        Point2D pt = this.screenToDatabase(screenDX, screenDY);
        return new Point2D.Double(pt.getX() - origin.getX(), pt.getY() - origin.getY());
    }

    public void databaseToScreen(double dbX, double dbY, Point result) {
        if (this.inPlaceDisplay) {
            Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
            this.outofCell.transform(dbPt, dbPt);
            dbX = ((Point2D)dbPt).getX();
            dbY = ((Point2D)dbPt).getY();
        }
        double scrX = (double)this.szHalfWidth + (dbX - this.offx) * this.scale;
        double scrY = (double)this.szHalfHeight - (dbY - this.offy) * this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    @Override
    public Point databaseToScreen(double dbX, double dbY) {
        Point result = new Point();
        this.databaseToScreen(dbX, dbY, result);
        return result;
    }

    public Point databaseToScreen(Point2D db) {
        return this.databaseToScreen(db.getX(), db.getY());
    }

    public Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.databaseToScreen(db.getMinX(), db.getMinY());
        Point urPt = this.databaseToScreen(db.getMaxX(), db.getMaxY());
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    public Point deltaDatabaseToScreen(double dbDX, double dbDY) {
        Point origin = this.databaseToScreen(0.0, 0.0);
        Point pt = this.databaseToScreen(dbDX, dbDY);
        return new Point(pt.x - origin.x, pt.y - origin.y);
    }

    public void gridToScreen(int dbX, int dbY, Point result) {
        double scrX = ((double)dbX - this.factorX) * this.scale_;
        double scrY = (this.factorY - (double)dbY) * this.scale_;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    public static void gridAlign(Point2D pt) {
        DBMath.gridAlign(pt, User.getAlignmentToGrid());
    }

    public static void gridAlignSize(Point2D pt, int direction) {
        DBMath.gridAlign(pt, User.getAlignmentToGrid(), direction);
    }

    public double getTextUnitSize(double pointSize) {
        return pointSize / this.scale;
    }

    public double getTextScreenSize(double dbSize) {
        return dbSize * this.scale;
    }

    public static int getDefaultFontSize() {
        return TextDescriptor.getDefaultFontSize();
    }

    public Font getFont(TextDescriptor descript) {
        return descript != null ? descript.getFont(this, 5) : TextDescriptor.getDefaultFont(this);
    }

    public double getFontHeight(TextDescriptor descript) {
        double size = EditWindow.getDefaultFontSize();
        if (descript != null) {
            size = descript.getTrueSize(this);
        }
        return size;
    }

    public GlyphVector getGlyphs(String text, Font font) {
        return TextDescriptor.getGlyphs(text, font);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (this.cell != null && e.objectChanged(this.cell)) {
            this.setWindowTitle();
        }
        if (this.cell != null && !this.cell.isLinked()) {
            this.showCell(null, VarContext.globalContext, true, null);
            this.wf.cellHistoryGoBack();
        }
        this.textInCell = null;
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        BufferedImage img = this.getPrintImage(ep);
        PNG.writeImage(img, filePath);
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        int scaleFactor = ep.getDesiredDPI() / 72;
        if (scaleFactor > 2) {
            scaleFactor = 2;
        } else if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        int pageWid = (int)pageFormat.getImageableWidth() * scaleFactor;
        int pageHei = (int)pageFormat.getImageableHeight() * scaleFactor;
        this.setSize(pageWid, pageHei);
        this.validate();
        this.repaint();
        return true;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        Graphics2D g2d;
        if (this.getCell() == null) {
            return null;
        }
        int scaleFactor = ep.getDesiredDPI() / 72;
        if (scaleFactor > 2) {
            scaleFactor = 2;
        } else if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        int wid = (int)ep.getPageFormat().getImageableWidth() * scaleFactor;
        int hei = (int)ep.getPageFormat().getImageableHeight() * scaleFactor;
        BufferedImage img = ep.getBufferedImage();
        if (img == null) {
            PixelDrawing offscreen = new PixelDrawing(new Dimension(wid, hei));
            offscreen.setWindow(ep.getWindow());
            PrinterJob pj = ep.getPrintJob();
            if (pj == null) {
                System.out.println("Can't get PrintJob in getPrintImage()");
                return null;
            }
            PrintService ps = pj.getPrintService();
            if (ps == null) {
                System.out.println("Can't get PrintService in getPrintImage()");
                return null;
            }
            ColorSupported cs = ps.getAttribute(ColorSupported.class);
            int printMode = 1;
            if (cs == null || cs.getValue() == 0) {
                printMode = 2;
            }
            offscreen.setPrintingMode(printMode);
            offscreen.setBackgroundColor(Color.WHITE);
            Rectangle2D cellBounds = ep.getRenderArea();
            if (cellBounds == null) {
                cellBounds = this.getBoundsInWindow();
            }
            cellBounds = new Rectangle2D.Double(cellBounds.getMinX() - 1.0, cellBounds.getMinY() - 1.0, cellBounds.getWidth() + 2.0, cellBounds.getHeight() + 2.0);
            double width = cellBounds.getWidth();
            double height = cellBounds.getHeight();
            if (width == 0.0) {
                width = 2.0;
            }
            if (height == 0.0) {
                height = 2.0;
            }
            double scalex = (double)wid / width;
            double scaley = (double)hei / height;
            double scale = Math.min(scalex, scaley);
            EPoint offset = new EPoint(cellBounds.getCenterX(), cellBounds.getCenterY());
            offscreen.printImage(scale, offset, this.getCell(), this.getVarContext(), ep);
            img = offscreen.getBufferedImage();
            ep.setBufferedImage(img);
            offscreen.setPrintingMode(0);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) != null) {
            AffineTransform saveAT = g2d.getTransform();
            int ix = (int)ep.getPageFormat().getImageableX() * scaleFactor;
            int iy = (int)ep.getPageFormat().getImageableY() * scaleFactor;
            g2d.scale(1.0 / (double)scaleFactor, 1.0 / (double)scaleFactor);
            g2d.drawImage((Image)img, ix, iy, null);
            Point2D saveOffset = this.getOffset();
            double saveScale = this.scale;
            int saveHalfWid = this.szHalfWidth;
            int saveHalfHei = this.szHalfHeight;
            Rectangle2D cellBounds = this.getBoundsInWindow();
            double width = cellBounds.getWidth();
            double height = cellBounds.getHeight();
            if (width == 0.0) {
                width = 2.0;
            }
            if (height == 0.0) {
                height = 2.0;
            }
            this.scale = this.scaleRequested = Math.min((double)wid / width, (double)hei / height);
            this.scale_ = (float)(this.scale / 400.0);
            this.offyRequested = 0.0;
            this.offxRequested = 0.0;
            this.offy = 0.0;
            this.offx = 0.0;
            this.szHalfWidth = ix + wid / 2;
            this.szHalfHeight = iy + hei / 2;
            this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
            this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
            g2d.setColor(Color.BLACK);
            this.drawCellFrame(g2d);
            this.scale = this.scaleRequested = saveScale;
            this.scale_ = (float)(this.scale / 400.0);
            this.szHalfWidth = saveHalfWid;
            this.szHalfHeight = saveHalfHei;
            this.offx = this.offxRequested = saveOffset.getX();
            this.offy = this.offyRequested = saveOffset.getY();
            this.factorX = (float)(this.offx * 400.0 - (double)this.szHalfWidth / this.scale_);
            this.factorY = (float)(this.offy * 400.0 + (double)this.szHalfHeight / this.scale_);
            g2d.setTransform(saveAT);
        }
        return img;
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double panningAmount;
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        Dimension dim = this.getSize();
        double value = direction == 0 ? (double)dim.width : (double)dim.height;
        int mult = (int)(value * (panningAmount = panningAmounts[User.getPanningDistance()]) / this.getScale());
        if (mult == 0) {
            mult = 1;
        }
        Point2D wndOffset = this.getOffset();
        Point2D.Double newOffset = direction == 0 ? new Point2D.Double(wndOffset.getX() - (double)(mult * ticks), wndOffset.getY()) : new Point2D.Double(wndOffset.getX(), wndOffset.getY() - (double)(mult * ticks));
        this.setOffset(newOffset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.fullRepaint();
    }

    @Override
    public void centerCursor() {
        Point pt = this.getLastMousePosition();
        Point2D center = this.screenToDatabase(pt.x, pt.y);
        this.setOffset(center);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.fullRepaint();
    }

    private class UpHierarchyPopupListener
    implements ActionListener {
        private boolean keepFocus;

        UpHierarchyPopupListener(boolean k) {
            this.keepFocus = k;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            Cell cell = (Cell)Cell.findNodeProto(source.getText());
            if (cell == null) {
                return;
            }
            Cell currentCell = EditWindow.this.getCell();
            NodeInst theOne = null;
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell nodeCell = (Cell)ni.getProto();
                if (nodeCell == currentCell) {
                    theOne = ni;
                    break;
                }
                if (!nodeCell.isIconOf(currentCell)) continue;
                theOne = ni;
                break;
            }
            double newX = EditWindow.this.offx;
            double newY = EditWindow.this.offy;
            if (this.keepFocus) {
                Point2D.Double curCtr = new Point2D.Double(EditWindow.this.offx, EditWindow.this.offy);
                AffineTransform up = theOne.rotateOut(theOne.translateOut());
                up.transform(curCtr, curCtr);
                newX = ((Point2D)curCtr).getX();
                newY = ((Point2D)curCtr).getY();
            }
            WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(EditWindow.this.getScale(), newX, newY, new ArrayList<NodeInst>());
            EditWindow.this.wf.addToHistory(cell, VarContext.globalContext, da);
            EditWindow.this.setCell(cell, VarContext.globalContext, da);
            if (!this.keepFocus) {
                EditWindow.this.fillScreen();
            }
            EditWindow.this.highlighter.clear();
            if (theOne != null) {
                EditWindow.this.highlighter.addElectricObject(theOne, cell);
            }
            EditWindow.this.highlighter.finished();
        }
    }

    private static class ReplaceAllTextJob
    extends Job {
        private StringSearch search;
        private String replace;
        private Cell cell;

        public ReplaceAllTextJob(EditWindow wnd, String replace) {
            super("Replace All Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.search = wnd.textSearch;
            this.replace = replace;
            this.cell = wnd.cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.search.replaceAllText(this.replace, this.cell);
            this.fieldVariableChanged("search");
            return true;
        }
    }

    private static class ReplaceTextJob
    extends Job {
        private String replace;
        private Cell cell;
        private StringSearch search;

        private ReplaceTextJob(EditWindow wnd, String replace) {
            super("Replace Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.search = wnd.textSearch;
            this.cell = wnd.cell;
            this.replace = replace;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.search.changeOneText(this.search.currentFindPosition, this.replace, this.cell);
            this.fieldVariableChanged("search");
            return true;
        }
    }

    private static class StringsInCell
    implements Serializable {
        final Object object;
        final Variable.Key key;
        String theLine;
        final int lineInVariable;
        int startPosition;
        int endPosition;
        final String regExpSearch;
        boolean replaced;

        StringsInCell(Object object, Variable.Key key, int lineInVariable, String theLine, int startPosition, int endPosition, String regExpSearch) {
            this.object = object;
            assert (key != null);
            this.key = key;
            this.lineInVariable = lineInVariable;
            this.theLine = theLine;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.regExpSearch = regExpSearch;
            this.replaced = false;
        }

        public String toString() {
            return "StringsInCell obj=" + this.object + " var=" + this.key + " line=" + this.lineInVariable + " start=" + this.startPosition + " end=" + this.endPosition + " msg=" + this.theLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSearch
    implements Serializable {
        private List<StringsInCell> foundInCell;
        private int currentFindPosition;

        private StringSearch() {
        }

        private static Pattern getPattern(String search, boolean caseSensitive) {
            int flags = caseSensitive ? 0 : 66;
            Pattern p = null;
            try {
                p = Pattern.compile(search, flags);
            }
            catch (Exception e) {
                System.out.println("Error in regular expression '" + search + "'");
                System.out.println(e.getMessage());
            }
            return p;
        }

        private void searchTextNodes(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, Pattern pattern, Set<Geometric> examineThis) {
            boolean doTemp = whatToSearch.contains((Object)TextUtils.WhatToSearch.TEMP_NAMES);
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.NODE_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.NODE_VAR);
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (examineThis != null && !examineThis.contains(ni)) continue;
                if (what != null) {
                    Name name = ni.getNameKey();
                    if (doTemp || !name.isTempname()) {
                        this.findAllMatches(ni, NodeInst.NODE_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
                    }
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(ni, search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
            }
        }

        private void searchTextArcs(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, Pattern pattern, Set<Geometric> examineThis) {
            boolean doTemp = whatToSearch.contains((Object)TextUtils.WhatToSearch.TEMP_NAMES);
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.ARC_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.ARC_VAR);
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (examineThis != null && !examineThis.contains(ai)) continue;
                if (what != null) {
                    Name name = ai.getNameKey();
                    if (doTemp || !name.isTempname()) {
                        this.findAllMatches(ai, ArcInst.ARC_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
                    }
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(ai, search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
            }
        }

        private void searchTextExports(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, Pattern pattern, Set<Geometric> examineThis) {
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.EXPORT_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.EXPORT_VAR);
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export pp = it.next();
                if (examineThis != null && !examineThis.contains(pp.getOriginalPort().getNodeInst())) continue;
                if (what != null) {
                    Name name = pp.getNameKey();
                    this.findAllMatches(pp, Export.EXPORT_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(pp, search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
            }
        }

        private void searchTextCellVars(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, Pattern pattern, Rectangle2D highBounds) {
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.CELL_VAR);
            if (whatVar != null) {
                Iterator<Variable> it = cell.getParametersAndVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!var.isDisplay() || highBounds != null && (var.getXOff() < highBounds.getMinX() || var.getXOff() > highBounds.getMaxX() || var.getYOff() < highBounds.getMinY() || var.getYOff() > highBounds.getMaxY())) continue;
                    this.findAllMatches(cell, var.getKey(), -1, var.getPureValue(-1), search, caseSensitive, regExp, pattern, codeRestr, unitRestr);
                }
            }
        }

        private void changeOneText(int index, String rep, Cell cell) {
            String newString;
            if (index < 0 || index >= this.foundInCell.size()) {
                return;
            }
            StringsInCell sic = this.foundInCell.get(index);
            String oldString = sic.theLine;
            if (sic.regExpSearch != null) {
                Pattern p = Pattern.compile(sic.regExpSearch);
                Matcher m = p.matcher(oldString);
                boolean found = m.find(sic.startPosition);
                Job.error(!found, "regExp find before replace failed");
                try {
                    StringBuffer ns = new StringBuffer();
                    m.appendReplacement(ns, rep);
                    m.appendTail(ns);
                    newString = ns.toString();
                }
                catch (Exception e) {
                    System.out.println("Regular expression replace failed");
                    newString = oldString;
                }
            } else {
                newString = oldString.substring(0, sic.startPosition) + rep + oldString.substring(sic.endPosition);
            }
            EditWindow.printChange(sic, newString);
            if (sic.object == null) {
                if (cell.isParam(sic.key)) {
                    cell.getCellGroup().updateParamText((Variable.AttrKey)sic.key, newString);
                } else {
                    cell.updateVarText(sic.key, newString);
                }
            } else if (sic.key == NodeInst.NODE_NAME) {
                NodeInst ni = (NodeInst)sic.object;
                ni.setName(newString);
            } else if (sic.key == ArcInst.ARC_NAME) {
                ArcInst ai = (ArcInst)sic.object;
                ai.setName(newString);
            } else if (sic.key == Export.EXPORT_NAME) {
                Export pp = (Export)sic.object;
                pp.rename(newString);
            } else {
                ElectricObject base = (ElectricObject)sic.object;
                Variable var = base.getParameterOrVariable(sic.key);
                Object obj = var.getObject();
                if (obj instanceof String || obj instanceof CodeExpression) {
                    base.updateVarText(sic.key, newString);
                } else if (obj instanceof String[]) {
                    String[] oldLines = (String[])obj;
                    String[] newLines = new String[oldLines.length];
                    for (int i = 0; i < oldLines.length; ++i) {
                        newLines[i] = i == sic.lineInVariable ? newString : oldLines[i];
                    }
                    base.updateVar(sic.key, newLines);
                }
            }
            int delta = newString.length() - oldString.length();
            for (StringsInCell oSIC : this.foundInCell) {
                if (oSIC == sic || oSIC.object != sic.object || oSIC.key != sic.key || oSIC.lineInVariable != sic.lineInVariable) continue;
                oSIC.theLine = newString;
                if (oSIC.startPosition <= sic.startPosition) continue;
                oSIC.startPosition += delta;
                oSIC.endPosition += delta;
            }
        }

        private void replaceAllText(String replace, Cell cell) {
            if (this.foundInCell.size() == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                for (int i = 0; i < this.foundInCell.size(); ++i) {
                    this.changeOneText(i, replace, cell);
                }
                System.out.println("Replaced " + this.foundInCell.size() + " times");
            }
        }

        public void initTextSearch(Cell cell, String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, boolean highlightedOnly, EditWindow wnd) {
            this.foundInCell = new ArrayList<StringsInCell>();
            if (cell == null) {
                System.out.println("No current Cell");
                return;
            }
            Pattern pattern = null;
            if (regExp && (pattern = StringSearch.getPattern(search, caseSensitive)) == null) {
                return;
            }
            HashSet<Geometric> examineThis = null;
            Rectangle2D highBounds = null;
            if (highlightedOnly) {
                examineThis = new HashSet<Geometric>();
                List<Geometric> highs = wnd.getHighlightedEObjs(true, true);
                highBounds = wnd.getHighlightedArea();
                for (Geometric g : highs) {
                    examineThis.add(g);
                }
                Rectangle2D selection = wnd.getHighlightedArea();
                if (selection != null) {
                    List<Highlight> inArea = Highlighter.findAllInArea(wnd.getHighlighter(), cell, false, false, false, true, true, selection, wnd);
                    for (Highlight h : inArea) {
                        ElectricObject eo = h.getElectricObject();
                        if (eo instanceof PortInst) {
                            eo = ((PortInst)eo).getNodeInst();
                        }
                        if (!(eo instanceof Geometric)) continue;
                        examineThis.add((Geometric)eo);
                    }
                }
            }
            this.searchTextNodes(cell, search, caseSensitive, regExp, whatToSearch, codeRestr, unitRestr, pattern, examineThis);
            this.searchTextArcs(cell, search, caseSensitive, regExp, whatToSearch, codeRestr, unitRestr, pattern, examineThis);
            this.searchTextExports(cell, search, caseSensitive, regExp, whatToSearch, codeRestr, unitRestr, pattern, examineThis);
            this.searchTextCellVars(cell, search, caseSensitive, regExp, whatToSearch, codeRestr, unitRestr, pattern, highBounds);
            if (this.foundInCell.size() == 0) {
                System.out.println("Nothing found");
            }
            this.currentFindPosition = -1;
        }

        private boolean findNextText(Cell cell, Highlighter highlighter, boolean reverse) {
            int curPos = this.currentFindPosition;
            this.currentFindPosition = -1;
            for (int i = 0; i < this.foundInCell.size(); ++i) {
                if (reverse) {
                    if (--curPos < 0) {
                        curPos = this.foundInCell.size() - 1;
                    }
                } else if (++curPos >= this.foundInCell.size()) {
                    curPos = 0;
                }
                if (this.foundInCell.get((int)curPos).replaced) continue;
                this.currentFindPosition = curPos;
                break;
            }
            if (this.currentFindPosition < 0) {
                return false;
            }
            StringsInCell sic = this.foundInCell.get(this.currentFindPosition);
            highlighter.clear();
            EditWindow.printFind(sic);
            if (sic.object == null) {
                highlighter.addText(cell, cell, sic.key);
            } else {
                ElectricObject eObj = (ElectricObject)sic.object;
                Variable.Key key = sic.key;
                if (key == null) {
                    if (eObj instanceof Export) {
                        key = Export.EXPORT_NAME;
                    } else if (eObj instanceof ArcInst) {
                        key = ArcInst.ARC_NAME;
                    } else if (eObj instanceof NodeInst) {
                        key = NodeInst.NODE_NAME;
                    }
                    assert (key != null);
                }
                highlighter.addText(eObj, cell, key);
            }
            highlighter.finished();
            return true;
        }

        private void findAllMatches(ElectricObject object, Variable.Key key, int lineInVariable, String theLine, String search, boolean caseSensitive, boolean regExp, Pattern p, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr) {
            Variable var;
            if ((codeRestr != null || unitRestr != null) && (var = object.getVar(key)) != null) {
                if (codeRestr != null && var.getCode() != codeRestr) {
                    return;
                }
                if (unitRestr != null && var.getUnit() != unitRestr) {
                    return;
                }
            }
            Matcher m = p != null ? p.matcher(theLine) : null;
            int startPos = 0;
            while (true) {
                int endPos;
                if (regExp) {
                    boolean found = m.find();
                    if (!found) break;
                    startPos = m.start();
                    endPos = m.end();
                } else {
                    if ((startPos = TextUtils.findStringInString(theLine, search, startPos, caseSensitive, false)) < 0) break;
                    endPos = startPos + search.length();
                }
                String regExpSearch = regExp ? search : null;
                this.foundInCell.add(new StringsInCell(object instanceof Cell ? null : object, key, lineInVariable, theLine, startPos, endPos, regExpSearch));
                startPos = endPos;
            }
        }

        private void addVariableTextToList(ElectricObject eObj, String search, boolean caseSensitive, boolean regExp, Pattern p, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr) {
            Iterator<Variable> it = eObj.getParametersAndVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (!var.isDisplay()) continue;
                Object obj = var.getObject();
                if (obj instanceof String || obj instanceof CodeExpression) {
                    this.findAllMatches(eObj, var.getKey(), -1, obj.toString(), search, caseSensitive, regExp, p, codeRestr, unitRestr);
                    continue;
                }
                if (!(obj instanceof String[])) continue;
                String[] strings = (String[])obj;
                for (int i = 0; i < strings.length; ++i) {
                    this.findAllMatches(eObj, var.getKey(), i, strings[i], search, caseSensitive, regExp, p, codeRestr, unitRestr);
                }
            }
        }
    }

    private static class DisplayedFrame
    extends Cell.FrameDescription {
        private Graphics g;
        private EditWindow wnd;
        private Color lineColor;
        private Color textColor;

        public DisplayedFrame(Cell cell, Graphics g, EditWindow wnd) {
            super(cell, wnd.pageNumber);
            this.g = g;
            this.wnd = wnd;
            this.lineColor = new Color(User.getColor(User.ColorPrefType.INSTANCE));
            this.textColor = new Color(User.getColor(User.ColorPrefType.TEXT));
        }

        public void showFrameLine(Point2D from, Point2D to) {
            this.g.setColor(this.lineColor);
            Point f = this.wnd.databaseToScreen(from);
            Point t = this.wnd.databaseToScreen(to);
            this.g.drawLine(f.x, f.y, t.x, t.y);
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
            Point sizeVector = this.wnd.deltaDatabaseToScreen(size, size);
            int initialHeight = (int)Math.abs(((Point2D)sizeVector).getY());
            Font font = new Font(User.getDefaultFont(), 0, initialHeight);
            this.g.setFont(font);
            this.g.setColor(this.textColor);
            FontRenderContext frc = new FontRenderContext(null, true, true);
            GlyphVector gv = font.createGlyphVector(frc, string);
            LineMetrics lm = font.getLineMetrics(string, frc);
            Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
            double width = rect.width;
            double height = lm.getHeight();
            Point2D databaseSize = this.wnd.deltaScreenToDatabase((int)width, (int)height);
            double dbWidth = Math.abs(databaseSize.getX());
            double dbHeight = Math.abs(databaseSize.getY());
            if (maxWid > 0.0 && maxHei > 0.0 && (dbWidth > maxWid || dbHeight > maxHei)) {
                double scale = Math.min(maxWid / dbWidth, maxHei / dbHeight);
                font = new Font(User.getDefaultFont(), 0, (int)((double)initialHeight * scale));
                if (font != null) {
                    gv = font.createGlyphVector(frc, string);
                    lm = font.getLineMetrics(string, frc);
                    rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
                    width = rect.width;
                    height = lm.getHeight();
                }
            }
            Graphics2D g2 = (Graphics2D)this.g;
            Point p = this.wnd.databaseToScreen(ctr);
            g2.drawGlyphVector(gv, (float)((double)p.x - width / 2.0), (float)((double)p.y + height / 2.0 - (double)lm.getDescent()));
        }
    }

    private static class CrossProbe {
        boolean isLine;
        Point2D start;
        Point2D end;
        Rectangle2D box;
        Color color;

        private CrossProbe() {
        }
    }

    private static class RenderJob
    extends Job {
        private static Snapshot oldSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
        volatile boolean hasTasks;
        private GraphicsPreferences gp;
        private AbstractDrawing.DrawingPreferences dp;

        protected RenderJob(GraphicsPreferences gp, AbstractDrawing.DrawingPreferences dp) {
            super("Display", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.gp = gp;
            this.dp = dp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doIt() throws JobException {
            RenderJob j2;
            logger.entering(RENDER_JOB_CLASS_NAME, "doIt");
            try {
                while (true) {
                    this.hasTasks = false;
                    Snapshot snapshot = EDatabase.clientDatabase().backup();
                    if (snapshot != oldSnapshot) {
                        EditWindow.endBatch(this.dp, this.gp);
                        oldSnapshot = snapshot;
                    }
                    EditWindow wnd = null;
                    Iterator<WindowFrame> it = WindowFrame.getWindows();
                    while (it.hasNext()) {
                        WindowFrame wf = it.next();
                        WindowContent wc = wf.getContent();
                        if (!(wc instanceof EditWindow) || !((EditWindow)wc).repaintRequest) continue;
                        wnd = (EditWindow)wc;
                        break;
                    }
                    if (wnd == null) break;
                    wnd.repaintRequest = false;
                    this.render(wnd);
                }
                Object var7_6 = null;
                j2 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                RenderJob j2 = null;
                Object object = lock;
                synchronized (object) {
                    if (this.hasTasks) {
                        j2 = new RenderJob(this.gp, this.dp);
                        runningNow = j2;
                    } else {
                        runningNow = null;
                    }
                }
                if (j2 != null) {
                    assert (j2 == runningNow);
                    j2.startJob();
                }
                throw throwable;
            }
            Object object = lock;
            synchronized (object) {
                if (this.hasTasks) {
                    j2 = new RenderJob(this.gp, this.dp);
                    runningNow = j2;
                } else {
                    runningNow = null;
                }
            }
            if (j2 != null) {
                assert (j2 == runningNow);
                j2.startJob();
            }
            logger.exiting(RENDER_JOB_CLASS_NAME, "doIt");
            return true;
        }

        private void render(EditWindow wnd) throws JobException {
            logger.entering(RENDER_JOB_CLASS_NAME, "render");
            Rectangle2D bounds = null;
            boolean fullInstantiate = false;
            if (wnd.fullInstantiateBounds != null) {
                fullInstantiate = true;
                bounds = wnd.fullInstantiateBounds;
                wnd.fullInstantiateBounds = null;
            } else if (bounds == null) {
                bounds = User.getChangedInWindow(wnd);
            }
            if (bounds != null) {
                User.clearChangedInWindow(wnd);
            }
            WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes(wnd.scaleRequested, wnd.offxRequested, wnd.offyRequested, wnd.inPlaceDescent);
            wnd.drawing.render(wnd.getSize(), da, this.gp, this.dp, fullInstantiate, bounds);
            wnd.repaint();
            logger.exiting(RENDER_JOB_CLASS_NAME, "render");
        }
    }

    private static class ScrollAdjustmentListener
    implements AdjustmentListener {
        EditWindow wnd;

        ScrollAdjustmentListener(EditWindow wnd) {
            this.wnd = wnd;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == this.wnd.getBottomScrollBar() && this.wnd.getCell() != null) {
                this.wnd.bottomScrollChanged(e.getValue());
            }
            if (e.getSource() == this.wnd.getRightScrollBar() && this.wnd.getCell() != null) {
                this.wnd.rightScrollChanged(e.getValue());
            }
        }
    }

    private static class EditWindowDropTarget
    implements DropTargetListener {
        private EditWindowDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        public void dragOver(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        private Object getDraggedObject(DataFlavor[] flavors) {
            if (flavors.length > 0 && flavors[0] instanceof NodeProtoDataFlavor) {
                NodeProtoDataFlavor npdf = (NodeProtoDataFlavor)flavors[0];
                Object obj = npdf.getFlavorObject();
                return obj;
            }
            return null;
        }

        private void dragAction(DropTargetDragEvent e) {
            Object obj = this.getDraggedObject(e.getCurrentDataFlavors());
            if (obj != null) {
                int action = e.getDropAction();
                e.acceptDrag(action);
                DropTarget dt = (DropTarget)e.getSource();
                if (dt.getComponent() instanceof JPanel) {
                    EditWindow wnd = (EditWindow)dt.getComponent();
                    wnd.showDraggedBox(obj, e.getLocation().x, e.getLocation().y, 0);
                }
                return;
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            String str;
            dtde.acceptDrop(0x40000000);
            Object obj = this.getDraggedObject(dtde.getCurrentDataFlavors());
            if (obj == null) {
                dtde.dropComplete(false);
                return;
            }
            DropTarget dt = (DropTarget)dtde.getSource();
            if (!(dt.getComponent() instanceof JPanel)) {
                dtde.dropComplete(false);
                return;
            }
            EditWindow wnd = (EditWindow)dt.getComponent();
            Point2D where = wnd.screenToDatabase(dtde.getLocation().x, dtde.getLocation().y);
            EditWindow.gridAlign(where);
            wnd.getHighlighter().clear();
            NodeInst ni = null;
            NodeProto np = null;
            int defAngle = 0;
            if (obj instanceof Cell.CellGroup) {
                np = wnd.whichCellInGroup((Cell.CellGroup)obj);
            } else if (obj instanceof NodeProto) {
                np = (NodeProto)obj;
                if (np instanceof PrimitiveNode) {
                    defAngle = User.getNewNodeRotation();
                }
            } else if (obj instanceof NodeInst) {
                ni = (NodeInst)obj;
                np = ni.getProto();
            } else if (obj instanceof Cell.CellGroup) {
                Cell.CellGroup gp = (Cell.CellGroup)obj;
                View view = wnd.getCell().getView();
                if (view == View.SCHEMATIC) {
                    view = View.ICON;
                }
                Iterator<Cell> itG = gp.getCells();
                while (itG.hasNext()) {
                    Cell c = itG.next();
                    if (c.getView() != view) continue;
                    np = c;
                    break;
                }
                if (np == null) {
                    System.out.println("No " + view + " type found in the dragged group '" + gp.getName() + "'");
                }
            } else if (obj instanceof String && (str = (String)obj).startsWith("LOADCELL ")) {
                String cellName = str.substring(9);
                np = Cell.findNodeProto(cellName);
            }
            if (np != null) {
                new PaletteFrame.PlaceNewNode("Create Node", np, ni, defAngle, where, wnd.getCell(), null, false);
            }
        }
    }

    public static class NodeProtoTransferable
    implements Transferable {
        private Cell cell;
        private Cell.CellGroup group;
        private NodeProtoDataFlavor df;

        public NodeProtoTransferable(Object obj, ExplorerTree tree) {
            if (obj instanceof Cell) {
                this.cell = (Cell)obj;
                this.group = this.cell.getCellGroup();
            } else if (obj instanceof Cell.CellGroup) {
                this.group = (Cell.CellGroup)obj;
            }
            this.df = new NodeProtoDataFlavor(this.cell, this.group, tree);
        }

        public boolean isValid() {
            return this.group != null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] it = new DataFlavor[]{this.df};
            return it;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == this.df;
        }

        public Object getTransferData(DataFlavor flavor) {
            if (flavor != this.df) {
                return null;
            }
            if (this.cell != null) {
                return this.cell;
            }
            return this.group;
        }
    }

    public static class NodeProtoDataFlavor
    extends DataFlavor {
        private Cell cell;
        private Cell.CellGroup group;
        private ExplorerTree originalTree;

        NodeProtoDataFlavor(Cell cell, Cell.CellGroup group, ExplorerTree originalTree) {
            super(NodeProto.class, "electric/instance");
            this.cell = cell;
            this.group = group;
            this.originalTree = originalTree;
        }

        public Object getFlavorObject() {
            if (this.cell != null) {
                return this.cell;
            }
            return this.group;
        }

        public ExplorerTree getOriginalTree() {
            return this.originalTree;
        }
    }
}

