/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.ToolSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    private static final ThreadLocal<Environment> threadEnvironment = new ThreadLocal();
    public final Setting.RootGroup toolSettings;
    public final TechPool techPool;
    private final HashMap<Setting, Object> rawSettingValues;
    public final Map<Setting, Object> settingValues;

    public Environment(IdManager idManager) {
        this(Setting.RootGroup.newEmptyGroup(), idManager.getInitialTechPool(), new HashMap<Setting, Object>());
    }

    private Environment(Setting.RootGroup toolSettings, TechPool techPool, HashMap<Setting, Object> rawSettingValues) {
        this.toolSettings = toolSettings;
        this.techPool = techPool;
        this.rawSettingValues = rawSettingValues;
        this.settingValues = Collections.unmodifiableMap(rawSettingValues);
        this.check();
    }

    public static Environment getThreadEnvironment() {
        return threadEnvironment.get();
    }

    public static Environment setThreadEnvironment(Environment environment) {
        Environment oldEnvironment = threadEnvironment.get();
        threadEnvironment.set(environment);
        return oldEnvironment;
    }

    public Map<Setting, Object> getSettings() {
        return this.settingValues;
    }

    public Object getValue(Setting setting) {
        return this.rawSettingValues.get(setting);
    }

    public void activate() {
        Environment.setThreadEnvironment(this);
    }

    public boolean isActive() {
        for (Map.Entry<Setting, Object> e : this.settingValues.entrySet()) {
            Setting setting = e.getKey();
            Object value2 = e.getValue();
            if (setting.getValue() == value2) continue;
            return false;
        }
        return true;
    }

    private Environment with(Setting.RootGroup toolSettings, TechPool techPool, Map<Setting, Object> settingValues) {
        if (this.techPool == techPool && this.toolSettings == toolSettings && ((Object)this.settingValues).equals(settingValues)) {
            return this;
        }
        HashMap<Setting, Object> rawSettingValues = new HashMap<Setting, Object>(settingValues);
        return new Environment(toolSettings, techPool, rawSettingValues);
    }

    public Environment withToolSettings(Setting.RootGroup toolSettings) {
        HashMap<Setting, Object> newSettingValues = new HashMap<Setting, Object>(this.settingValues);
        for (Setting setting : this.toolSettings.getSettings()) {
            newSettingValues.remove(setting);
        }
        for (Setting setting : toolSettings.getSettings()) {
            newSettingValues.put(setting, setting.getFactoryValue());
        }
        return this.with(toolSettings, this.techPool, newSettingValues);
    }

    public Environment addTech(Technology tech) {
        if (this.techPool.getTech(tech.getId()) != null) {
            throw new IllegalArgumentException();
        }
        TechPool newTechPool = this.techPool.withTech(tech);
        HashMap<Setting, Object> newSettingValues = new HashMap<Setting, Object>(this.settingValues);
        for (Setting setting : tech.getProjectSettings().getSettings()) {
            newSettingValues.put(setting, setting.getFactoryValue());
        }
        for (Map.Entry entry : tech.getParamValues().entrySet()) {
            TechFactory.Param param2 = (TechFactory.Param)entry.getKey();
            newSettingValues.put(tech.getSetting(param2), entry.getValue());
        }
        return this.with(this.toolSettings, newTechPool, newSettingValues);
    }

    public Environment withSettingChanges(Setting.SettingChangeBatch changeBatch) {
        Map<TechFactory.Param, Object> techParams = this.techPool.getTechParams();
        for (Map.Entry<TechFactory.Param, Object> e : techParams.entrySet()) {
            TechFactory.Param param2 = e.getKey();
            Object oldValue = e.getValue();
            String string2 = param2.xmlPath;
            if (!changeBatch.changesForSettings.containsKey(string2)) continue;
            Object newValue = changeBatch.changesForSettings.get(string2);
            if (newValue == null) {
                newValue = param2.factoryValue;
            }
            if (newValue.equals(oldValue) || newValue.getClass() != oldValue.getClass()) continue;
            techParams.put(param2, newValue);
        }
        TechPool newTechPool = this.techPool.withTechParams(techParams);
        String softTechnologies = (String)changeBatch.changesForSettings.get(ToolSettings.getSoftTechnologiesSetting().getXmlPath());
        if (softTechnologies != null) {
            newTechPool = newTechPool.withSoftTechnologies(softTechnologies);
        }
        HashMap<String, Object> valuesByXmlPath = new HashMap<String, Object>();
        for (Map.Entry<Setting, Object> entry : this.settingValues.entrySet()) {
            Setting oldSetting = entry.getKey();
            String xmlPath = oldSetting.getXmlPath();
            Object value2 = entry.getValue();
            if (changeBatch.changesForSettings.containsKey(xmlPath)) {
                value2 = changeBatch.changesForSettings.get(xmlPath);
            }
            valuesByXmlPath.put(xmlPath, value2);
        }
        for (Map.Entry<Object, Object> entry : newTechPool.getTechParams().entrySet()) {
            TechFactory.Param param3 = (TechFactory.Param)entry.getKey();
            valuesByXmlPath.put(param3.xmlPath, entry.getValue());
        }
        HashMap<Setting, Object> newSettingValues = new HashMap<Setting, Object>();
        for (Setting setting : this.toolSettings.getSettings()) {
            Object value3 = valuesByXmlPath.get(setting.getXmlPath());
            Object factoryValue = setting.getFactoryValue();
            if (value3 == null || value3.getClass() != factoryValue.getClass() || value3.equals(factoryValue)) {
                value3 = factoryValue;
            }
            newSettingValues.put(setting, value3);
        }
        for (Technology tech : newTechPool.values()) {
            for (Setting setting : tech.getProjectSettings().getSettings()) {
                Object value4 = valuesByXmlPath.get(setting.getXmlPath());
                Object factoryValue = setting.getFactoryValue();
                if (value4 == null || value4.getClass() != factoryValue.getClass() || value4.equals(factoryValue)) {
                    value4 = factoryValue;
                }
                newSettingValues.put(setting, value4);
            }
        }
        return this.with(this.toolSettings, newTechPool, newSettingValues);
    }

    public Environment deepClone() {
        TechPool newTechPool = this.techPool.deepClone();
        HashMap<String, Setting> oldSettingsByXmlPath = new HashMap<String, Setting>();
        for (Setting setting : this.toolSettings.getSettings()) {
            oldSettingsByXmlPath.put(setting.getXmlPath(), setting);
        }
        for (Technology tech : this.techPool.values()) {
            for (Setting setting : tech.getProjectSettings().getSettings()) {
                oldSettingsByXmlPath.put(setting.getXmlPath(), setting);
            }
        }
        HashMap<Setting, Object> newSettingValues = new HashMap<Setting, Object>();
        for (Setting setting : this.toolSettings.getSettings()) {
            newSettingValues.put(setting, this.settingValues.get(setting));
        }
        for (Technology tech : this.techPool.values()) {
            for (Setting setting : tech.getProjectSettings().getSettings()) {
                Object oldSetting = oldSettingsByXmlPath.get(setting.getXmlPath());
                Object value2 = this.settingValues.get(oldSetting);
                Object factoryValue = setting.getFactoryValue();
                if (value2 == null || value2.getClass() != factoryValue.getClass()) {
                    value2 = factoryValue;
                }
                newSettingValues.put(setting, value2);
            }
        }
        return new Environment(this.toolSettings, newTechPool, newSettingValues);
    }

    public void saveToPreferences() {
        this.saveToPreferences(Pref.getPrefRoot());
    }

    public void saveToPreferences(Preferences prefs) {
        for (Map.Entry<Setting, Object> e : this.getSettings().entrySet()) {
            Setting setting = e.getKey();
            setting.saveToPreferences(prefs, e.getValue());
        }
        Pref.flushAll();
    }

    public void writeDiff(IdWriter writer, Environment old) throws IOException {
        boolean changed = this != old;
        writer.writeBoolean(changed);
        if (!changed) {
            return;
        }
        boolean techPoolChanged = this.techPool != old.techPool;
        writer.writeBoolean(techPoolChanged);
        if (techPoolChanged) {
            this.techPool.writeDiff(writer, old.techPool);
        }
        boolean toolSettingsChanged = this.toolSettings != old.toolSettings;
        writer.writeBoolean(toolSettingsChanged);
        if (toolSettingsChanged) {
            this.toolSettings.write(writer);
        }
        for (Map.Entry<Setting, Object> e : this.settingValues.entrySet()) {
            Setting setting = e.getKey();
            Object value2 = e.getValue();
            Object oldValue = old.settingValues.get(setting);
            if (oldValue == null) {
                oldValue = setting.getFactoryValue();
            }
            if (value2.equals(oldValue)) continue;
            writer.writeString(setting.getXmlPath());
            Variable.writeObject(writer, value2);
        }
        writer.writeString("");
    }

    public static Environment readEnvironment(IdReader reader, Environment old) throws IOException {
        String xmlPath;
        boolean changed = reader.readBoolean();
        if (!changed) {
            return old;
        }
        TechPool techPool = old.techPool;
        boolean techPoolChanged = reader.readBoolean();
        if (techPoolChanged) {
            techPool = TechPool.read(reader, old.techPool);
        }
        Setting.RootGroup toolSettings = old.toolSettings;
        boolean toolSettingsChanged = reader.readBoolean();
        if (toolSettingsChanged) {
            toolSettings = Setting.read(reader);
        }
        HashMap<String, Setting> settingsByXmlPath = new HashMap<String, Setting>();
        for (Setting setting : toolSettings.getSettings()) {
            settingsByXmlPath.put(setting.getXmlPath(), setting);
        }
        for (Technology tech : techPool.values()) {
            for (Setting setting : tech.getProjectSettings().getSettings()) {
                settingsByXmlPath.put(setting.getXmlPath(), setting);
            }
        }
        HashMap<Setting, Object> settingValues = new HashMap<Setting, Object>();
        for (Setting setting : settingsByXmlPath.values()) {
            Object value2 = old.settingValues.get(setting);
            if (value2 == null) {
                value2 = setting.getFactoryValue();
            }
            settingValues.put(setting, value2);
        }
        while ((xmlPath = reader.readString()).length() != 0) {
            Setting setting;
            Object value3 = Variable.readObject(reader);
            setting = (Setting)settingsByXmlPath.get(xmlPath);
            settingValues.put(setting, value3);
        }
        return new Environment(toolSettings, techPool, settingValues);
    }

    public void check() {
        if (!this.toolSettings.isLocked()) {
            throw new IllegalArgumentException("Tool Settings are not locked");
        }
        for (Map.Entry<Setting, Object> e : this.settingValues.entrySet()) {
            Setting setting = e.getKey();
            Object value2 = e.getValue();
            if (value2.getClass() == setting.getFactoryValue().getClass()) continue;
            throw new IllegalArgumentException("Setting " + setting.getXmlPath() + " has bad value " + value2);
        }
        HashMap<String, Object> xmlPaths = new HashMap<String, Object>();
        Environment.checkSettings(this.toolSettings, this.settingValues, xmlPaths);
        for (Technology technology : this.techPool.values()) {
            Setting.RootGroup techSettings = technology.getProjectSettingsRoot();
            Environment.checkSettings(techSettings, this.settingValues, xmlPaths);
        }
        if (xmlPaths.size() != this.settingValues.size()) {
            throw new IllegalArgumentException("Setting count");
        }
        for (Map.Entry entry : this.techPool.getTechParams().entrySet()) {
            TechFactory.Param param2 = (TechFactory.Param)entry.getKey();
            Object value3 = xmlPaths.get(param2.xmlPath);
            if (value3.equals(entry.getValue())) continue;
            throw new IllegalArgumentException("TechParam mismatch");
        }
    }

    private static void checkSettings(Setting.RootGroup settings, Map<Setting, Object> settingValues, HashMap<String, Object> xmlPaths) {
        for (Setting setting : settings.getSettings()) {
            String xmlPath = setting.getXmlPath();
            if (xmlPath.length() == 0) {
                throw new IllegalArgumentException("Empty xmlPath");
            }
            Object value2 = settingValues.get(setting);
            if (value2.getClass() != setting.getFactoryValue().getClass()) {
                throw new IllegalArgumentException("Type mismatch " + setting);
            }
            Object oldValue = xmlPaths.put(xmlPath, value2);
            if (oldValue == null) continue;
            throw new IllegalArgumentException("Dupilcate xmlPath " + xmlPath);
        }
    }
}

