/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.math.Orientation;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Comparable<Block> {
    Orientation o;
    private double width;
    private double height;
    private double halfWidth;
    private double halfHeight;
    private double xPos;
    private double yPos;
    int number = -1;

    public Block() {
    }

    public Block(Block b) {
        this.xPos = b.xPos;
        this.yPos = b.yPos;
        this.width = b.width;
        this.height = b.height;
        this.halfWidth = b.halfWidth;
        this.halfHeight = b.halfHeight;
        this.o = b.o;
        this.number = b.number;
    }

    public Block(double x, double y, double w, double h) {
        this.width = w;
        this.halfWidth = this.width / 2.0;
        this.height = h;
        this.halfHeight = this.height / 2.0;
        this.xPos = x;
        this.yPos = y;
        this.o = Orientation.IDENT;
    }

    public Block(double x, double y, double w, double h, Orientation o, int number2) {
        this.width = w;
        this.halfWidth = this.width / 2.0;
        this.height = h;
        this.halfHeight = this.height / 2.0;
        this.xPos = x;
        this.yPos = y;
        this.o = o;
        this.number = number2;
    }

    public void valuesFrom(PlacementFrame.PlacementNode n) {
        this.xPos = n.getPlacementX();
        this.yPos = n.getPlacementY();
        this.width = n.getWidth();
        this.halfWidth = this.width / 2.0;
        this.height = n.getHeight();
        this.halfHeight = this.height / 2.0;
        this.o = n.getPlacementOrientation();
    }

    @Override
    public int compareTo(Block other) {
        if (this.getNr() < other.getNr()) {
            return -1;
        }
        if (this.getNr() > other.getNr()) {
            return 1;
        }
        return 0;
    }

    public int getNr() {
        return this.number;
    }

    public Orientation getOrientation() {
        return this.o;
    }

    public void setOrientation(Orientation o) {
        this.o = o;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.xPos;
    }

    public double getY() {
        return this.yPos;
    }

    public double getLeft() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.xPos - this.halfHeight;
        }
        return this.xPos - this.halfWidth;
    }

    public double getTop() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.yPos + this.halfWidth;
        }
        return this.yPos + this.halfHeight;
    }

    public double getRight() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.xPos + this.halfHeight;
        }
        return this.xPos + this.halfWidth;
    }

    public double getBottom() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.yPos - this.halfWidth;
        }
        return this.yPos - this.halfHeight;
    }

    public boolean intersects(Block other) {
        return other.getLeft() < this.getRight() && other.getRight() > this.getLeft() && other.getTop() > this.getBottom() && other.getBottom() < this.getTop();
    }

    public double intersectionArea(Block other) {
        if (this.intersects(other)) {
            double left = Math.max(this.getLeft(), other.getLeft());
            double top = Math.min(this.getTop(), other.getTop());
            double right = Math.min(this.getRight(), other.getRight());
            double bottom = Math.max(this.getBottom(), other.getBottom());
            return (top - bottom) * (right - left);
        }
        return 0.0;
    }

    public void setPos(double x, double y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void disturb(double avgW, Random rand) {
        this.xPos += 1.0 * avgW * rand.nextGaussian();
        this.yPos += 1.0 * avgW * rand.nextGaussian();
    }

    public void disturbToCenter(double avgW, Random rand) {
        this.xPos = this.xPos *= rand.nextDouble();
        this.yPos = this.yPos *= rand.nextDouble();
    }

    public void disturbOrientation(Random rand) {
        switch (rand.nextInt(16)) {
            case 0: {
                this.o = Orientation.IDENT;
                break;
            }
            case 1: {
                this.o = Orientation.R;
                break;
            }
            case 2: {
                this.o = Orientation.RR;
                break;
            }
            case 3: {
                this.o = Orientation.RRR;
                break;
            }
            case 4: {
                this.o = Orientation.X;
                break;
            }
            case 5: {
                this.o = Orientation.XR;
                break;
            }
            case 6: {
                this.o = Orientation.XRR;
                break;
            }
            case 7: {
                this.o = Orientation.XRRR;
                break;
            }
            case 8: {
                this.o = Orientation.Y;
                break;
            }
            case 9: {
                this.o = Orientation.YR;
                break;
            }
            case 10: {
                this.o = Orientation.YRR;
                break;
            }
            case 11: {
                this.o = Orientation.YRRR;
                break;
            }
            case 12: {
                this.o = Orientation.XY;
                break;
            }
            case 13: {
                this.o = Orientation.XYR;
                break;
            }
            case 14: {
                this.o = Orientation.XYRR;
                break;
            }
            case 15: {
                this.o = Orientation.XYRRR;
            }
        }
    }
}

