/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.goal;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarOpenListBase;

public class SimpleGoal
implements AStarGoalBase<AStarNode> {
    private static final int BEND_PENALTY = 1;
    private AStarOpenListBase<AStarNode> openList;
    private AStarNode goalNode;
    private int maxRevolutions = 0;

    @Override
    public void setGoalNode(AStarNode goal) {
        this.goalNode = goal;
    }

    private int distance(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        return Math.abs(startX - endX) + Math.abs(startY - endY);
    }

    @Override
    public int distanceToGoal(int startX, int startY, int startZ) {
        return this.distance(startX, startY, startZ, this.goalNode.getX(), this.goalNode.getY(), this.goalNode.getZ());
    }

    @Override
    public int getNodeCost(AStarNode from2, int endX, int endY, int endZ) {
        int bendPenalty = 0;
        if (from2.origin != null && (((AStarNode)from2.origin).getX() == from2.getX() && endX != from2.getX() || ((AStarNode)from2.origin).getY() == from2.getY() && endY != from2.getY())) {
            bendPenalty = 1;
        }
        return this.distance(from2.getX(), from2.getY(), from2.getZ(), endX, endY, endZ) + bendPenalty;
    }

    @Override
    public boolean isPathFinished(AStarNode currentNode) {
        return this.goalNode.equals(currentNode);
    }

    @Override
    public void setNodeStorage(AStarOpenListBase<AStarNode> openList) {
        this.openList = openList;
    }

    @Override
    public void setMaximumRevolutions(int maximum) {
        this.maxRevolutions = maximum;
    }

    @Override
    public boolean shouldGiveUp(int currentRevolutions) {
        if (this.maxRevolutions > 0 && currentRevolutions >= this.maxRevolutions) {
            return true;
        }
        return this.openList.isOpenListEmpty();
    }
}

