/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.flag.FlagAnnotations;

public class AddFlagAnnotationJob
extends Job {
    static final long serialVersionUID = 0L;
    private transient EditWindow_ wnd;
    private Cell cell;
    private String newAnnotation;

    private AddFlagAnnotationJob(EditWindow_ wnd, Cell cell, String annotation) {
        super("Make Flag Annotation", NetworkTool.getNetworkTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.wnd = wnd;
        this.cell = cell;
        this.newAnnotation = annotation;
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        EditingPreferences ep = this.getEditingPreferences();
        Variable plaidVar = this.cell.getVar(FlagAnnotations.FLAG_ANNOTATION_KEY);
        if (plaidVar == null) {
            String[] initial = new String[]{this.newAnnotation};
            TextDescriptor td = ep.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            plaidVar = this.cell.newVar(FlagAnnotations.FLAG_ANNOTATION_KEY, (Object)initial, td);
            if (plaidVar == null) {
                return true;
            }
        } else {
            String[] oldObj = plaidVar.getObject();
            if (oldObj instanceof String) {
                oldObj = new String[]{(String)oldObj};
            }
            AddFlagAnnotationJob.error(!(oldObj instanceof String[]), "PLAID annotation not String[]");
            String[] oldVal = oldObj;
            TextDescriptor td = plaidVar.getTextDescriptor();
            int newLen = oldVal.length + 1;
            String[] newVal = new String[newLen];
            for (int i = 0; i < newLen - 1; ++i) {
                newVal[i] = oldVal[i];
            }
            newVal[newLen - 1] = this.newAnnotation;
            plaidVar = this.cell.newVar(FlagAnnotations.FLAG_ANNOTATION_KEY, (Object)newVal, td);
        }
        return true;
    }

    @Override
    public void terminateOK() {
        this.wnd.clearHighlighting();
        this.wnd.addHighlightText(this.cell, this.cell, FlagAnnotations.FLAG_ANNOTATION_KEY);
        this.wnd.finishedHighlighting();
    }

    public static void makeCellAnnotation(String newAnnotation) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        new AddFlagAnnotationJob(wnd, cell, newAnnotation);
    }
}

