/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import java.math.BigInteger;
import java.util.Map;

public class Vec4BitExtract<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> index;
    public final Svex<N> x;

    private Vec4BitExtract(Svex<N> index, Svex<N> x) {
        super(FUNCTION, index, x);
        this.index = index;
        this.x = x;
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        int iv;
        Vec4 ival;
        if (this.index instanceof SvexQuote && (ival = ((SvexQuote)this.index).val).isVec2() && (iv = ((Vec2)ival).getVal().intValueExact()) >= 0) {
            SvexCall<N> svexRsh = sm.newCall(Vec4Rsh.FUNCTION, this.index, this.x.lhsPreproc(sm));
            return sm.newCall(Vec4Concat.FUNCTION, SvexQuote.valueOf(1), svexRsh, SvexQuote.valueOf(0));
        }
        return super.lhsPreproc(sm);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_BITSEL, 2, "4vec-bit-extract");
        }

        public <N extends SvarName> Vec4BitExtract<N> build(Svex<N>[] args) {
            return new Vec4BitExtract<N>(args[0], args[1]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            int indv;
            Vec4 index = args[0];
            Vec4 x = args[1];
            if (index.isVec2() && (indv = ((Vec2)index).getVal().intValueExact()) >= 0) {
                if (x.isVec2()) {
                    BigInteger xv = ((Vec2)x).getVal();
                    return xv.testBit(indv) ? Vec2.ONE : Vec2.ZERO;
                }
                return x.getUpper().testBit(indv) ? (x.getLower().testBit(indv) ? Vec2.ONE : Vec4.X1) : (x.getLower().testBit(indv) ? Vec2.Z1 : Vec2.ZERO);
            }
            return Vec4.X1;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            Svex<N> index = args[0];
            Vec4 indexVal = index.xeval(xevalMemoize);
            BigInteger nMask = this.v4maskAllOrNone(mask);
            if (!indexVal.isVec2()) {
                return new BigInteger[]{nMask, nMask};
            }
            int indexV = ((Vec2)indexVal).getVal().intValueExact();
            if (indexV >= 0 && mask.testBit(0)) {
                return new BigInteger[]{nMask, BigInteger.ONE.shiftLeft(indexV)};
            }
            return new BigInteger[]{nMask, BigInteger.ZERO};
        }
    }
}

