/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.List;

public class CurveListener
implements WindowFrame.ElectricEventListener {
    private ArcInst curveAI;
    private WindowFrame.ElectricEventListener oldListener;
    private boolean through;

    private CurveListener() {
    }

    public static void setCurvature(boolean through) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        if (geomList == null) {
            return;
        }
        if (geomList.size() != 1) {
            System.out.println("Select just one arc to setting curvature");
            return;
        }
        Geometric geom = geomList.get(0);
        if (!(geom instanceof ArcInst)) {
            System.out.println("Select an arc before setting curvature");
            return;
        }
        WindowFrame.ElectricEventListener newListener = null;
        WindowFrame.ElectricEventListener oldListener = WindowFrame.getListener();
        System.out.println("Click to adjust curvature");
        newListener = oldListener;
        if (newListener == null || !(newListener instanceof CurveListener)) {
            newListener = new CurveListener();
            WindowFrame.setListener(newListener);
        }
        ((CurveListener)newListener).curveAI = (ArcInst)geom;
        ((CurveListener)newListener).oldListener = oldListener;
        ((CurveListener)newListener).through = through;
    }

    public static void removeCurvature() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        if (geomList == null) {
            return;
        }
        if (geomList.size() != 1) {
            System.out.println("Select just one arc to remove curvature");
            return;
        }
        Geometric geom = geomList.get(0);
        if (!(geom instanceof ArcInst)) {
            System.out.println("Select an arc before removing curvature");
            return;
        }
        new SetArcCurvature((ArcInst)geom, 0L);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        WindowFrame.setListener(this.oldListener);
        EditWindow wnd = (EditWindow)evt.getSource();
        this.showHighlight(null, wnd);
        Point2D dbPt = wnd.screenToDatabase(evt.getX(), evt.getY());
        double lambdaCurvature = this.through ? this.curveArcThroughPoint(this.curveAI, dbPt.getX(), dbPt.getY()) : this.curveArcAboutPoint(this.curveAI, dbPt.getX(), dbPt.getY());
        new SetArcCurvature(this.curveAI, DBMath.lambdaToGrid(lambdaCurvature));
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 27) {
            WindowFrame.setListener(this.oldListener);
            this.showHighlight(null, wnd);
            System.out.println("Aborted");
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
    }

    private void showHighlight(MouseEvent evt, EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        if (evt != null) {
            Point2D dbPt = wnd.screenToDatabase(evt.getX(), evt.getY());
            double lambdaCurvature = this.through ? this.curveArcThroughPoint(this.curveAI, dbPt.getX(), dbPt.getY()) : this.curveArcAboutPoint(this.curveAI, dbPt.getX(), dbPt.getY());
            Poly curvedPoly = this.curveAI.curvedArcLambdaOutline(Poly.Type.CLOSED, this.curveAI.getGridBaseWidth(), DBMath.lambdaToGrid(lambdaCurvature));
            if (curvedPoly != null) {
                highlighter.addPoly(curvedPoly, this.curveAI.getParent(), null);
            }
        }
        highlighter.finished();
        wnd.repaint();
    }

    private double curveArcAboutPoint(ArcInst ai, double xcur, double ycur) {
        double acy;
        double acx;
        EPoint r0 = ai.getHeadLocation();
        EPoint r1 = ai.getTailLocation();
        int ang = ai.getDefinedAngle();
        Point2D ip = GenMath.intersect(new Point2D.Double(xcur, ycur), ang, new Point2D.Double(acx = (((Point2D)r0).getX() + ((Point2D)r1).getX()) / 2.0, acy = (((Point2D)r0).getY() + ((Point2D)r1).getY()) / 2.0), (ang + 900) % 3600);
        double r = ((Point2D)r0).distance(ip);
        Point2D[] pts = DBMath.findCenters(r, r0, r1);
        if (pts != null && Math.abs(pts[0].getX() - ip.getX()) + Math.abs(pts[0].getY() - ip.getY()) < Math.abs(pts[1].getX() - ip.getX()) + Math.abs(pts[1].getY() - ip.getY())) {
            r = -r;
        }
        return r;
    }

    private double curveArcThroughPoint(ArcInst ai, double xcur, double ycur) {
        double rcy;
        Point2D.Double rc;
        double r;
        Point2D[] pts;
        EPoint r0 = ai.getHeadLocation();
        EPoint r1 = ai.getTailLocation();
        double r0x = ((Point2D)r0).getX();
        double r0y = ((Point2D)r0).getY();
        double r1x = ((Point2D)r1).getX();
        double r1y = ((Point2D)r1).getY();
        double r2x = xcur;
        double r2y = ycur;
        double r02x = r2x - r0x;
        double r02y = r2y - r0y;
        double rpx = r0y - r1y;
        double rpy = r1x - r0x;
        double u = r02x;
        double v = r02y;
        double t = (u *= r2x - r1x) + (v *= r2y - r1y);
        u = r02x;
        v = r02y;
        double rcx = r0x + (r1x - r0x) / 2.0 + (t /= ((u *= rpx) + (v *= rpy)) * 2.0) * rpx;
        if ((pts = DBMath.findCenters(r = ((Point2D)r0).distance(rc = new Point2D.Double(rcx, rcy = r0y + (r1y - r0y) / 2.0 + t * rpy)), r0, r1)) != null) {
            if (Math.abs(pts[0].getX() - rcx) + Math.abs(pts[0].getY() - rcy) < Math.abs(pts[1].getX() - rcx) + Math.abs(pts[1].getY() - rcy)) {
                r = -r;
            }
        } else {
            rcx = r0x + (r1x - r0x) / 2.0;
            rcy = r0y + (r1y - r0y) / 2.0;
            r = ((Point2D)r0).distance(rc) + 1.0;
        }
        return r;
    }

    private static class SetArcCurvature
    extends Job {
        private ArcInst curveAI;
        private long gridCurvature;

        protected SetArcCurvature(ArcInst curveAI, long gridCurvature) {
            super("Set arc curvature", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curveAI = curveAI;
            this.gridCurvature = gridCurvature;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.curveAI.getParent(), null, true, false, true) != 0) {
                return false;
            }
            if (this.gridCurvature == 0L) {
                if (this.curveAI.getVar(ImmutableArcInst.ARC_RADIUS) != null) {
                    this.curveAI.delVar(ImmutableArcInst.ARC_RADIUS);
                }
            } else {
                this.curveAI.newVar(ImmutableArcInst.ARC_RADIUS, (Object)DBMath.gridToLambda(this.gridCurvature), ep);
            }
            this.curveAI.modify(0.0, 0.0, 0.0, 0.0);
            return true;
        }
    }
}

